/*
 * Definitions for libfsapfs
 *
 * Copyright (C) 2018-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSAPFS_DEFINITIONS_H )
#define _LIBFSAPFS_DEFINITIONS_H

#include <libfsapfs/types.h>

#define LIBFSAPFS_VERSION			20240429

/* The version string
 */
#define LIBFSAPFS_VERSION_STRING		"20240429"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBFSAPFS_ACCESS_FLAGS
{
	LIBFSAPFS_ACCESS_FLAG_READ		= 0x01,
/* Reserved: not supported yet */
	LIBFSAPFS_ACCESS_FLAG_WRITE		= 0x02
};

/* The file access macros
 */
#define LIBFSAPFS_OPEN_READ			( LIBFSAPFS_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBFSAPFS_OPEN_WRITE			( LIBFSAPFS_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBFSAPFS_OPEN_READ_WRITE		( LIBFSAPFS_ACCESS_FLAG_READ | LIBFSAPFS_ACCESS_FLAG_WRITE )

/* The path segment separator
 */
#define LIBFSAPFS_SEPARATOR			'/'

/* The file types
 */
enum LIBFSAPFS_FILE_TYPES
{
	LIBFSAPFS_FILE_TYPE_FIFO		= 0x1000,
	LIBFSAPFS_FILE_TYPE_CHARACTER_DEVICE	= 0x2000,
	LIBFSAPFS_FILE_TYPE_DIRECTORY		= 0x4000,
	LIBFSAPFS_FILE_TYPE_BLOCK_DEVICE	= 0x6000,
	LIBFSAPFS_FILE_TYPE_REGULAR_FILE	= 0x8000,
	LIBFSAPFS_FILE_TYPE_SYMBOLIC_LINK	= 0xa000,
	LIBFSAPFS_FILE_TYPE_SOCKET		= 0xc000
};

#endif /* !defined( _LIBFSAPFS_DEFINITIONS_H ) */

