#if   !defined(__STRING_HPP)
#define  __STRING_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

//
// This is a temporary until String gets analyzed and designed with
// the ability to factory create a string with certain properties 
// (UTF-8 vs. UCS-2 vs UCS-4, etc)
//

#include <string>

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{
   DEFINE_CLASS(String);

   class String : public AbstractString, public std::string
   {
   
   public:
   
               String( void )
               :
                  std::string()
               {

               }
               String( CharCptr aPtr )
               :
                  std::string((const Char *)aPtr)
               {

               }

      virtual  ~String( void )
      {
         ;  // do nothing
      }

   protected:
   
   private:
   
   };

}

#endif // #if !defined(__STRING_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/

