/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.sql.Time;
import java.util.TimeZone;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeTest
extends TestCase {
    static long TIME_TEST1 = 38720000L;
    static long TIME_TEST2 = 80279000L;
    static long TIME_TEST3 = -38720000L;
    static String STRING_TEST1 = "10:45:20";
    static String STRING_TEST2 = "22:17:59";
    static String STRING_TEST3 = "13:14:40";
    static String STRING_INVALID1 = "ABCDEFGHI";
    static String STRING_INVALID2 = "233104";
    static String STRING_INVALID3 = "21-43-48";
    static String STRING_OUTRANGE = "35:99:66";
    static long[] TIME_ARRAY = new long[]{TIME_TEST1, TIME_TEST2, TIME_TEST3};
    static String[] STRING_GMT_ARRAY = new String[]{STRING_TEST1, STRING_TEST2, STRING_TEST3};
    static String[] STRING_LA_ARRAY = new String[]{"02:45:20", "14:17:59", "05:14:40"};
    static String[] STRING_JP_ARRAY = new String[]{"19:45:20", "07:17:59", "22:14:40"};
    static String[] INVALID_STRINGS = new String[]{STRING_INVALID1, STRING_INVALID2, STRING_INVALID3};
    static String TZ_LONDON = "GMT";
    static String TZ_PACIFIC = "America/Los_Angeles";
    static String TZ_JAPAN = "Asia/Tokyo";
    static String[] TIMEZONES = new String[]{TZ_LONDON, TZ_PACIFIC, TZ_JAPAN};
    static String[][] STRING_ARRAYS = new String[][]{STRING_GMT_ARRAY, STRING_LA_ARRAY, STRING_JP_ARRAY};

    public void testTimeintintint() {
        Time theTime = new Time(10, 45, 20);
        TimeTest.assertNotNull((Object)theTime);
    }

    public void testTime() {
        Time theTime = new Time(TIME_TEST1);
        TimeTest.assertNotNull((Object)theTime);
    }

    public void testToString() {
        int i = 0;
        while (i < TIME_ARRAY.length) {
            this.testToString(TIMEZONES[i], TIME_ARRAY, STRING_ARRAYS[i]);
            ++i;
        }
    }

    private void testToString(String timeZone, long[] theTimes, String[] theTimeStrings) {
        TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
        int i = 0;
        while (i < theTimes.length) {
            Time theTime = new Time(theTimes[i]);
            String JDBCString = theTime.toString();
            TimeTest.assertEquals((String)theTimeStrings[i], (String)JDBCString);
            ++i;
        }
    }

    public void testValueOfString() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Time[] theReturns = new Time[]{new Time(38720000L), new Time(80279000L), new Time(47680000L)};
        String[] validTime = new String[]{"10:45:20", "22:17:59", "13:14:40"};
        String[] stringArray = new String[4];
        stringArray[1] = "ABCDEFGHI";
        stringArray[2] = "233104";
        stringArray[3] = "21-43-48";
        String[] invalidTime = stringArray;
        int i = 0;
        while (i < validTime.length) {
            Time theReturn = Time.valueOf(validTime[i]);
            TimeTest.assertEquals((Object)theReturns[i], (Object)theReturn);
            ++i;
        }
        String[] stringArray2 = invalidTime;
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            String element = stringArray2[n];
            try {
                Time.valueOf(element);
                TimeTest.fail((String)"Should throw IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testSetTime() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Time theTime = new Time(TIME_TEST1);
        TimeTest.assertEquals((String)STRING_TEST1, (String)theTime.toString());
        theTime.setTime(TIME_TEST2);
        TimeTest.assertEquals((String)STRING_TEST2, (String)theTime.toString());
    }

    public void testSetDate() {
        Time theTime = new Time(TIME_TEST1);
        try {
            theTime.setDate(10);
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetMonth() {
        Time theTime = new Time(TIME_TEST1);
        try {
            theTime.setMonth(2);
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetYear() {
        Time theTime = new Time(TIME_TEST1);
        try {
            theTime.setYear(99);
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDate() {
        Time theTime = new Time(TIME_TEST1);
        try {
            theTime.getDate();
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDay() {
        Time theTime = new Time(TIME_TEST1);
        try {
            theTime.getDay();
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetMonth() {
        Time theTime = new Time(TIME_TEST1);
        try {
            theTime.getMonth();
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetYear() {
        Time theTime = new Time(TIME_TEST1);
        try {
            theTime.getYear();
            TimeTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_valueOf_IllegalArgumentException() {
        try {
            Time.valueOf("15:43:12:34");
            TimeTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Time.valueOf(":10:07:01");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf("::01");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf("11::");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf(":01:");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf(":10:w2:01");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf("07:w2:");
            TimeTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Time.valueOf("17:w2:w2");
            TimeTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Time.valueOf("16::01");
            TimeTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

