/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.serial.SerialClobTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SerialClobTest
extends TestCase {
    public void testSerialClob$C() throws Exception {
        SerialClob serialClob = new SerialClob(new char[8]);
        SerialClobTest.assertEquals((long)8L, (long)serialClob.length());
        try {
            new SerialClob(null);
            SerialClobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSerialClobLClob() throws Exception {
        MockSerialClob mockSerialClob = new MockSerialClob();
        mockSerialClob.characterStreamReader = new CharArrayReader(mockSerialClob.buf);
        mockSerialClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        SerialClob serialClob = new SerialClob((Clob)mockSerialClob);
        SerialClobTest.assertEquals((long)mockSerialClob.buf.length, (long)serialClob.length());
        mockSerialClob.characterStreamReader = null;
        mockSerialClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        mockSerialClob.characterStreamReader = new CharArrayReader(new char[]{'\u0001'});
        mockSerialClob.asciiInputStream = null;
        mockSerialClob.characterStreamReader = new MockAbnormalReader();
        mockSerialClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        try {
            new SerialClob((Clob)mockSerialClob);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            new SerialClob(null);
            SerialClobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testLength() {
    }

    public void testGetAsciiStream() throws Exception {
        MockSerialClob mockSerialClob = new MockSerialClob();
        mockSerialClob.characterStreamReader = new CharArrayReader(mockSerialClob.buf);
        mockSerialClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        SerialClob serialClob = new SerialClob((Clob)mockSerialClob);
        InputStream inputStream = serialClob.getAsciiStream();
        SerialClobTest.assertTrue((boolean)mockSerialClob.isGetAsciiStreamInvoked);
        SerialClobTest.assertEquals((Object)mockSerialClob.asciiInputStream, (Object)inputStream);
        try {
            serialClob = new SerialClob("helloo".toCharArray());
            serialClob.getAsciiStream();
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testGetCharacterStream() throws Exception {
        char[] cArray = "helloo".toCharArray();
        SerialClob serialClob = new SerialClob(cArray);
        Reader reader = serialClob.getCharacterStream();
        char[] cArray2 = new char[cArray.length];
        int n = reader.read(cArray2);
        SerialClobTest.assertEquals((int)cArray.length, (int)n);
        SerialClobTest.assertTrue((boolean)Arrays.equals(cArray, cArray2));
        SerialClobTest.assertFalse((boolean)reader.ready());
        MockSerialClob mockSerialClob = new MockSerialClob();
        mockSerialClob.characterStreamReader = new CharArrayReader(mockSerialClob.buf);
        mockSerialClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        mockSerialClob.asciiOutputStream = new ByteArrayOutputStream();
        serialClob = new SerialClob((Clob)mockSerialClob);
        reader = serialClob.getCharacterStream();
        cArray2 = new char[mockSerialClob.buf.length];
        n = reader.read(cArray2);
        SerialClobTest.assertEquals((int)mockSerialClob.buf.length, (int)n);
        SerialClobTest.assertTrue((boolean)Arrays.equals(mockSerialClob.buf, cArray2));
        SerialClobTest.assertFalse((boolean)reader.ready());
    }

    public void testGetSubString() throws Exception {
        SerialClob serialClob = new SerialClob("hello".toCharArray());
        String string = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((String)"hello", (String)string);
        string = serialClob.getSubString(2L, 3);
        SerialClobTest.assertEquals((String)"ell", (String)string);
        try {
            string = serialClob.getSubString(0L, 6);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            string = serialClob.getSubString(7L, 1);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            string = serialClob.getSubString(1L, 7);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            string = serialClob.getSubString(1L, -2);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            string = serialClob.getSubString(3L, 4);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        LongLengthClob longLengthClob = new LongLengthClob(null);
        serialClob = new SerialClob((Clob)longLengthClob);
        try {
            serialClob.getSubString(1L, 3);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testPositionLClobJ() throws Exception {
        SerialClob serialClob = new SerialClob("helloo".toCharArray());
        SerialClob serialClob2 = new SerialClob("llo".toCharArray());
        long l = serialClob.position(serialClob2, 1L);
        SerialClobTest.assertEquals((long)3L, (long)l);
        l = serialClob.position(serialClob2, 3L);
        SerialClobTest.assertEquals((long)3L, (long)l);
        serialClob2 = new SerialClob("o".toCharArray());
        l = serialClob.position(serialClob2, 6L);
        SerialClobTest.assertEquals((long)6L, (long)l);
        serialClob2 = new SerialClob("ooooooo".toCharArray());
        l = serialClob.position(serialClob2, 1L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
        serialClob2 = new SerialClob("llo".toCharArray());
        l = serialClob.position(serialClob2, 4L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
        l = serialClob.position(serialClob2, 0L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
        l = serialClob.position(serialClob2, -1L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
        l = serialClob.position(serialClob2, 10L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
    }

    public void testPositionLStringJ() throws Exception {
        SerialClob serialClob = new SerialClob("helloo".toCharArray());
        long l = serialClob.position("llo", 1L);
        SerialClobTest.assertEquals((long)3L, (long)l);
        l = serialClob.position("llo", 3L);
        SerialClobTest.assertEquals((long)3L, (long)l);
        l = serialClob.position("o", 6L);
        SerialClobTest.assertEquals((long)6L, (long)l);
        l = serialClob.position("ooooooo", 1L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
        l = serialClob.position("llo", 4L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
        l = serialClob.position("llo", 0L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
        l = serialClob.position("llo", -1L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
        l = serialClob.position("llo", 10L);
        SerialClobTest.assertEquals((long)-1L, (long)l);
    }

    public void testSetAsciiStream() throws Exception {
        MockSerialClob mockSerialClob = new MockSerialClob();
        mockSerialClob.characterStreamReader = new CharArrayReader(mockSerialClob.buf);
        mockSerialClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        SerialClob serialClob = new SerialClob((Clob)mockSerialClob);
        OutputStream outputStream = null;
        try {
            outputStream = serialClob.setAsciiStream(1L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        mockSerialClob.asciiOutputStream = new ByteArrayOutputStream();
        outputStream = serialClob.setAsciiStream(1L);
        SerialClobTest.assertNotNull((Object)outputStream);
        SerialClobTest.assertTrue((boolean)mockSerialClob.isSetAsciiStreamInvoked);
        SerialClobTest.assertEquals((Object)mockSerialClob.asciiOutputStream, (Object)outputStream);
        try {
            serialClob = new SerialClob("helloo".toCharArray());
            serialClob.setAsciiStream(1L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetCharacterStream() throws Exception {
        MockSerialClob mockSerialClob = new MockSerialClob();
        mockSerialClob.characterStreamReader = new CharArrayReader(mockSerialClob.buf);
        mockSerialClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        mockSerialClob.characterStreamWriter = new CharArrayWriter();
        SerialClob serialClob = new SerialClob((Clob)mockSerialClob);
        Writer writer = serialClob.setCharacterStream(1L);
        SerialClobTest.assertTrue((boolean)mockSerialClob.isSetCharacterStreamInvoked);
        SerialClobTest.assertEquals((Object)mockSerialClob.characterStreamWriter, (Object)writer);
        try {
            serialClob = new SerialClob("helloo".toCharArray());
            serialClob.setCharacterStream(1L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetStringJLString() throws Exception {
        String string = "hello";
        char[] cArray = string.toCharArray();
        SerialClob serialClob = new SerialClob(cArray);
        int n = serialClob.setString(1L, "olleh");
        String string2 = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((String)"olleh", (String)string2);
        SerialClobTest.assertEquals((int)5, (int)n);
        n = serialClob.setString(2L, "mm");
        string2 = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((String)"ommeh", (String)string2);
        SerialClobTest.assertEquals((int)2, (int)n);
        try {
            serialClob.setString(-1L, "hello");
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(6L, "hello");
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(2L, "hello");
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetStringJLStringII() throws Exception {
        SerialClob serialClob = new SerialClob("hello".toCharArray());
        int n = serialClob.setString(1L, "olleh", 0, 5);
        String string = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((String)"olleh", (String)string);
        SerialClobTest.assertEquals((int)5, (int)n);
        n = serialClob.setString(2L, "mmnn", 1, 2);
        string = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((int)2, (int)n);
        SerialClobTest.assertEquals((String)"omneh", (String)string);
        try {
            serialClob.setString(-1L, "hello", 0, 5);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(6L, "hello", 0, 5);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(1L, "hello", 0, 6);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(2L, "hello", 0, 5);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(1L, "hello", -1, 5);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testTruncate() throws Exception {
        SerialClob serialClob = new SerialClob("hello".toCharArray());
        serialClob.truncate(3L);
        SerialClobTest.assertEquals((long)3L, (long)serialClob.length());
        String string = serialClob.getSubString(1L, 3);
        SerialClobTest.assertEquals((String)"hel", (String)string);
        serialClob.truncate(0L);
        SerialClobTest.assertEquals((long)0L, (long)serialClob.length());
        serialClob = new SerialClob("hello".toCharArray());
        try {
            serialClob.truncate(10L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.truncate(-1L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }
}

