/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

public class TransportMgr {
    public static int sendReceiveUDP(String server, int serverPort, byte[] outBuf, int outBufLen, byte[] inBuf, int inBufLen, int timeout) throws DomainProtocolException, SocketTimeoutException, SecurityException {
        byte[] srvAddrArr = null;
        InetAddress srvAddr = null;
        DatagramSocket dSocket = null;
        DatagramPacket inPacket = null;
        DatagramPacket outPacket = null;
        try {
            srvAddrArr = ProviderMgr.parseIpStr(server);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DomainProtocolException(Messages.getString("jndi.40"));
        }
        try {
            try {
                dSocket = new DatagramSocket();
                srvAddr = InetAddress.getByAddress(srvAddrArr);
                dSocket.connect(srvAddr, serverPort);
                outPacket = new DatagramPacket(outBuf, outBufLen, srvAddr, serverPort);
                dSocket.setSoTimeout(timeout);
                dSocket.send(outPacket);
                inPacket = new DatagramPacket(inBuf, inBufLen, srvAddr, serverPort);
                dSocket.receive(inPacket);
            }
            catch (IllegalStateException e) {
                throw new DomainProtocolException(Messages.getString("jndi.41"), e);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                throw new DomainProtocolException(Messages.getString("jndi.41"), e);
            }
        }
        finally {
            if (dSocket != null) {
                dSocket.close();
            }
        }
        if (inPacket != null) {
            return inPacket.getLength();
        }
        throw new DomainProtocolException(Messages.getString("jndi.42"));
    }

    public static int sendReceiveTCP(String server, int serverPort, byte[] outBuf, int outBufLen, byte[] inBuf, int inBufLen, int timeout) throws DomainProtocolException, SocketTimeoutException, SecurityException {
        byte[] srvAddrArr = null;
        InetAddress srvAddr = null;
        Socket socket = null;
        InputStream iStream = null;
        BufferedOutputStream oStream = null;
        byte[] tmpArr = new byte[2];
        int actualLen = -1;
        try {
            srvAddrArr = ProviderMgr.parseIpStr(server);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DomainProtocolException(Messages.getString("jndi.40"));
        }
        try {
            try {
                srvAddr = InetAddress.getByAddress(srvAddrArr);
                socket = new Socket(srvAddr, serverPort);
                socket.setSoTimeout(timeout);
                oStream = new BufferedOutputStream(socket.getOutputStream());
                ProviderMgr.write16Int(outBufLen, tmpArr, 0);
                oStream.write(tmpArr, 0, 2);
                oStream.write(outBuf, 0, outBufLen);
                oStream.flush();
                iStream = socket.getInputStream();
                iStream.read(tmpArr, 0, 2);
                int inLen = ProviderMgr.parse16Int(tmpArr, 0);
                if (inLen > inBufLen) {
                    throw new DomainProtocolException(Messages.getString("jndi.43"));
                }
                actualLen = iStream.read(inBuf, 0, inLen);
                if (actualLen != inLen) {
                    throw new DomainProtocolException(Messages.getString("jndi.44"));
                }
            }
            catch (IllegalStateException e) {
                throw new DomainProtocolException(Messages.getString("jndi.41"), e);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                throw new DomainProtocolException(Messages.getString("jndi.41"), e);
            }
        }
        catch (Throwable throwable) {
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return actualLen;
    }

    public static InetAddress getIPByName_OS(String hostname) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException unknownHostException) {}
        return addr;
    }
}

