CREATE SCHEMA genetic_code;
SET search_path = genetic_code,public,pg_catalog;

CREATE TABLE gencode (
        gencode_id      BIGINT PRIMARY KEY NOT NULL,
        organismstr     VARCHAR(512) NOT NULL
);

CREATE TABLE gencode_codon_aa (
        gencode_id      BIGINT NOT NULL REFERENCES gencode(gencode_id),
        codon           CHAR(3) NOT NULL,
        aa              CHAR(1) NOT NULL,
        CONSTRAINT gencode_codon_unique UNIQUE( gencode_id, codon )
);
CREATE INDEX gencode_codon_aa_i1 ON gencode_codon_aa(gencode_id,codon,aa);

CREATE TABLE gencode_startcodon (
        gencode_id      BIGINT NOT NULL REFERENCES gencode(gencode_id),
        codon           CHAR(3),
        CONSTRAINT gencode_startcodon_unique UNIQUE( gencode_id, codon )
);
SET search_path = public,pg_catalog;
