#!/usr/bin/env python

import psycopg2
import os
import time
import random
import math
import pprint
import sys
import unittest
import string

class DBManager():
    def __init__(self, dbname, user, password, host):
        self.dbname = dbname
        self.user = user
        self.password = password
        self.host = host
        self.pp = pprint.PrettyPrinter(indent=4)

    def connect(self):
        self.conn = psycopg2.connect("dbname=%s user=%s password=%s host=%s" % (self.dbname, self.user, self.password, self.host))
        self.curs = self.conn.cursor()
        print "connected"
        
    def close(self):
        self.conn.close()

    def test01(self):
        self.curs.execute("SELECT id, id_parent, mac FROM nodes WHERE nodetype='1';")
        res = self.curs.fetchall()
        duplicates = {}
        for r in res:
            mac = string.lower(r[2])
            dup = duplicates.get(mac)
            if dup:
                duplicates[mac].append(r)
            else:
                duplicates[mac] = [r]
    
        # Search for duplicates
        real_dup = {}
        for m,r in duplicates.items():
            if len(r) > 1:
                real_dup[m] = r

        self.pp.pprint(real_dup)


if __name__=="__main__":

    from optparse import OptionParser
    p = OptionParser()
    p.add_option("-d", dest="dbname", help="Database name")
    p.add_option("-u", dest="dbuser", help="Username")
    p.add_option("-p", dest="dbpass", help="Password")
    p.add_option("-l", dest="host", help="Hostname")
    
    (o, args) = p.parse_args()
    if o.dbname is None or o.dbuser is None or o.dbpass is None or o.host is None:
        p.print_help()
        sys.exit(1)

    t = DBManager(o.dbname, o.dbuser, o.dbpass, o.host)
    t.connect()
    t.test01()
    t.close()
    
    
    
