<?php
/////////////////////////////////////////
// File Name : Print_Table.php
// Creation Date : July 2007
// Description : This is one of the options a user may select to print the informations
//		   This will print all the information the valid nodes only in a table
//
// Modifications : -
//
/////////////////////////////////////////

include_once "functions/getNodeFullPath.php";

$config_info = $_SESSION['configInfo'];
$hardware_info = $_SESSION['hardwareInfo'];
$network_info = $_SESSION['networkInfo'];
$valid_nodes = $_SESSION['valid_nodes'];

echo "<table border='1' style='empty-cells : show;'>";
	echo "<tr><td rowspan=2>".getMessage('stats_node')."</td>";
	echo "<td rowspan=2>".getMessage('stats_path')."</td>";
		if( count( $config_info ) > 0 ){	echo "<td colspan='".count( $config_info )."'>".getMessage('stats_configuration')."</td>";	}
		if( count( $hardware_info ) > 0 ){	echo "<td colspan='".count( $hardware_info )."'>".getMessage('stats_hardware')."</td>";	}
		if( count( $network_info ) > 0 ){	echo "<td colspan='".count( $network_info )."'>".getMessage('stats_network')."</td>";	}
	echo "</tr>";
	echo "<tr>";
	foreach( $config_info as $nom_config ){
		echo "<td>".$nom_config."</td>";
	}
	foreach( $hardware_info as $nom_hardware ){
		echo "<td>".$nom_hardware."</td>";
	}
	foreach( $network_info as $nom_network ){
		echo "<td>".$nom_network."</td>";
	}
	echo "</tr>";
	foreach( $tree as $node ){
		$node_path = getNodeFullPath( $node );
		if( in_array( $node_path."/".$node->toString(), $valid_nodes ) ){
			$config_info = $node->attributes[ "config" ];
			$hardware_info = $node->attributes[ "hardware" ];
			$network_info = $node->attributes[ "network" ];
			echo "<tr>";			
				echo "<td title=''>".$node->toString()."</td>";
				echo "<td title=''>".$node_path."</td>";
				foreach( $config_info as $config ){
						echo "<td>".$config."</td>";
				}
				foreach( $hardware_info as $hardware ){
						echo "<td>".$hardware."</td>";
				}
				foreach( $network_info as $network ){
						echo "<td>".$network."</td>";
				}
			echo "</tr>";
		}
	}
echo "</table>";
?>