<?php
/////////////////////////////////////////////////////////////////////////
// File Name : Condition_Chooser.php
// Creation Date : July 2006
// Description : A 'True Condition' is a condition that MUST be met for the node' information to be printed at the end.
//		   A 'False Condition' MUST _NOT_ be met.
//
// Modifications : -
//
/////////////////////////////////////////////////////////////////////////

	include "header.php";
	
	include "functions/add_new_condition_value.php";
	include "functions/add_new_condition.php";
	
	include "functions/isConf.php";
	include "functions/isList.php";
	include "functions/isMat.php";
	include "functions/isYesNo.php";

	include "functions/returnCategory.php";
	include "functions/returnList.php";
	include "functions/returnType.php";
	include "functions/returnID.php";
	include "functions/conditionIsSelected.php";
	
	$conditions = $_SESSION['conditions'];

	// Add a new Condition
	if( isset( $_POST['addCond'] ) ){
		add_new_condition( $_POST['addCond'] );
	}

	// Add a value to a Condition
	if( isset( $_POST['addVal'] ) && isset( $_POST['condition'] ) && isset( $_POST['scallable'] ) && $_POST['addVal'] <> ""  && isset( $_POST['condition'] ) <> "" ){
		add_new_condition_value( $_POST['addVal'], $_POST['scallable'], $_POST['condition'] );
	}
	
	// Remove a Condition
	if( isset( $_GET['delCond'] ) ){
		$id_cond = $_GET['delCond'];
		$tmpTab = array();
		foreach( $conditions as $condition ){
			if( $id_cond <> $condition->name ){
				$tmpTab[$condition->name] = $condition;
			}
		}
		$conditions = $tmpTab;
	}

	// Remove a value from a condition
	if( isset( $_GET['delVal'] ) && isset( $_GET['condition'] ) ){
		$condition = $_GET['condition'];
		$value = $_GET['delVal'];
		$condition_value = $conditions[$condition]->value;
		$condition_comp = $conditions[$condition]->comparator;
		$valueTab = array();
		$compTab = array();
		for( $i = 0; $i < count( $condition_value ); $i++ ){
			if( $value <> $i ){
				$valueTab[] = $condition_value[ $i ];
				$compTab[] = $condition_comp[ $i ];
			}
		}
		$conditions[$condition]->value = $valueTab;
		$conditions[$condition]->comparator = $compTab;
	}
	
	unset( $_GET );
	unset( $_POST );

	// Fetch all the values on the DB
	$queryconf="SELECT name	FROM attributesdef GROUP BY	name ORDER BY name";
	$resultconf	= pg_query($queryconf) or die('Échec requête : ' . pg_last_error());
	$querymat="SELECT hwkey	FROM computershw GROUP BY hwkey	ORDER BY hwkey";
	$resultmat = pg_query($querymat) or	die('Échec requête : ' . pg_last_error());
	$queryres="SELECT *	FROM status	WHERE id=1";
	$resultres = pg_query($queryres) or	die('Échec requête : ' . pg_last_error());

	echo "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN' 'http://www.w3.org/TR/html4/loose.dtd'>";
	echo "<HTML>";
	echo "<HEAD>";
		echo "<TITLE>Step 3</TITLE>";
		echo "<META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=UTF-8'>";
		echo "<link rel='stylesheet' type='text/css' href='style.css'>";
	echo "</HEAD>";
	echo "<BODY>";		
		echo getMessage('stats_true_conditions');

		// Print the drop-down box with all those values
		echo "<form method='post' action='".$shown_page."?step=3'>\n";
			echo "<select name='addCond'>\n";
				echo "<optgroup label='".getMessage('stats_configuration')."'>\n";
				while( $line = pg_fetch_array( $resultconf ) ){
					if( !conditionIsSelected( $line[0] ) ){
						echo "<option>".$line[0]."</option>\n";
					}
				}
				echo "</optgroup>";
				echo "<optgroup label='".getMessage('stats_hardware')."'>\n";
				while( $line = pg_fetch_array( $resultmat ) ){
					if( !conditionIsSelected( $line[0] ) ){
						echo "<option>".$line[0]."</option>\n";
					}
				}
				echo "</optgroup>";
				echo "<optgroup label='".getMessage('stats_network')."'>\n";
				for	( $j = 1; $j < pg_num_fields($resultres); $j++ ){
					if( !conditionIsSelected( pg_field_name( $resultres, $j ) ) ){
						echo "<option>".pg_field_name( $resultres, $j )."</option>\n";
					}
				}
				echo "</optgroup>";
			echo "</select>\n";
			echo "<input type=submit value='";
				echo getMessage("stats_add_cond");
			echo "'></input>\n";
		echo "</form>";

		// Print all the Conditions
		$first_condition = true;
		if (is_array($conditions)) {
		foreach( $conditions as $condition ){
			$condition_name = $condition->name;
			$options = array();
			if( $first_condition ){
				$first_condition = false;
			} else {
				echo "<div class='and-or-MSG'>".getMessage('stats_and')."</div>";
			}
			echo "<fieldset style='-moz-border-radius:15px; background-color:#eeeeee;'>";
				echo "<legend align=top>";
					echo $condition_name."&nbsp;";
					echo "<a href='".$shown_page."?step=3&delCond=".$condition_name."'>";
						echo "<img border=0 src='images/delete.gif' />";
					echo "</a>";
				echo "</legend>";

				// Print the form elements to change the Condition's value
				echo "<form method='post' action='".$shown_page."?step=3'>";
					echo "<SELECT name='scallable'>\n";
						echo "<OPTION value='='>";
							echo getMessage('stats_equals');
						echo "</OPTION>\n";
						echo "<OPTION value='!='>";
							echo getMessage('stats_unequals');
						echo "</OPTION>\n";
						echo "<OPTION value='>'>";
							echo getMessage('stats_greater');
						echo "</OPTION>\n";
						echo "<OPTION value='<'>";
							echo getMessage('stats_lower');
						echo "</OPTION>\n";
						echo "<OPTION value='<='>";
							echo getMessage('stats_lower_equals');
						echo "</OPTION>\n";
						echo "<OPTION value='>='>";
							echo getMessage('stats_greater_equals');
						echo "</OPTION>\n";
					echo "</SELECT>\n";
					if( $condition->type == 0 ){
						echo "<input type=text name='addVal' />";
					} else {
						echo "<SELECT name='addVal'>\n";
						if( $condition->type == 2 ){
							$options = returnList( $condition->id );
						} else {
							$options['Y'] = getMessage('stats_yes');
							$options['N'] = getMessage('stats_no');
						}
						for( $j = 0; $j < count( $options ); $j++ ){
							$keys = array_keys( $options );
							$values = array_values( $options );
							if( !in_array( $keys[$j], $condition->value ) ){
								echo "<OPTION value='".$keys[$j]."'>".$values[$j]."</OPTION>\n";
							}
						}
						echo "</SELECT>\n";
					}
					echo "<input type=hidden name='condition' value='".$condition_name."'>";
					echo "<input type=submit value='";
						echo getMessage("stats_add_value");
					echo "' />";
				echo "</form>";

				// Print the values of the conditions
				if( $condition->value <> array() && $condition->value <> "" ){
					echo "<p>".getMessage('stats_selected_value')."</p>";
					for( $j = 0; $j < count( $condition->value ); $j++ ){
						if( $j > 0 ){
							echo "<div class='and-or-MSG'>".getMessage('stats_or')."</div>";
						}
						$value = $condition->value[$j];
						$comparator = $condition->comparator[$j];
						if( $value == "Y" ){
							$value = getMessage('stats_yes');
						}else if( $value == "N" ){
							$value = getMessage('stats_no');
						}
						echo $condition_name."&nbsp;".$comparator."&nbsp;".$value."&nbsp;";
						echo "<a href='".$shown_page."?step=3&condition=".$condition_name."&delVal=".$j."'>";
							echo "<img border=0 style='position:relative; left:30;' src='images/delete.gif' />";
						echo "</a>";
					}
				}
			echo "</fieldset>";
		}
		}
		$_SESSION['conditions'] = $conditions;
	echo "</BODY>";
echo "</HTML>";
?>
