<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'NodesBrowser.php';
	require_once 'AttributesManager.php';
	require_once 'LTSParser.php';
	require_once 'Permissions.php';
	require_once 'HWGroupManager.php';

	/**
	*  Loader for configuration module
	*
	*  Author: Nicolas Dufresne
	*/
	switch ($module_action) {
		case 'build':
			$nb = new NodesBrowser();
			$perm = $nb->getPermissions();
			$am = new AttributesManager($nb->getNode(),array("ltsp","mille","custom"),array(NODE_TYPE,COMPUTER_TYPE,HWGROUP_TYPE),$perm);
			$node = $nb->getNode();
			if($node->nodetype == HWGROUP_TYPE && $perm->canWriteNode()==1){
				$hw = new HWGroupManager($nb->getNode());
			}

			$ltsParser = new LTSParser($nb->getNode());
			break;
		case 'print':
			$nb->printView();
			$am->printView();
			$node = $nb->getNode();
			$perm = $nb->getPermissions();
			if($node->nodetype == HWGROUP_TYPE && $perm->canWriteNode()==1){
				$hw->printView();
			}
			$ltsParser->printView();
			break;
	}
?>
