<?php
/*
# Copyright 2004, Commission scolaire de Laval, Stephane Bond
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'dbFunctions.php';
	require_once 'Node.php';
	
	/**
	*
	* Find all nodes relating a users and his groups 
	* 
	* @package MILLE-CONFIGURATOR
	*/
	class EntityNodeFinder {

		/**
		* username to find
		* @access private
		* @var string
		*/
		var $username;
		/**
		* groups to find
		* @access private
		* @var array
		*/
		var $groups;
		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $lastError;
		/**
		* Nodes ids
		* @access private
		* @var string
		*/
		var $nodesIds;
		
		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $isError;

		/**
		* The constructor of a SubnetNodeFinder
		*
		* Initialised in by :
		* <ul>
		* <li> IP of the computer
		* </ul>
		* 
		* Example of valid initialisation :
		*
		* <code>
		*   $username = "user1";
		*   $groups = array();
		*   $finder=new EntityNodeFinder($username, $groups);
		* </code>
		*
		* @access public
		*/
		function EntityNodeFinder($username,$groups) {
			$this->notFound = false;
			$this->username = $username;
			$this->groups = $groups;
			
			// Build WHERE statement
			$where="";
			if (!empty($username)) {
				$where .= "(nodetype=" . USER_TYPE . " AND reference=" . qstr($username) . ") ";
			}
			foreach ($groups as $g) {
				if (!empty($where))
					$where .= " OR ";
				$where .= "(nodetype=" . GROUP_TYPE . " AND reference=" . qstr($g) . ") ";
			}
			
			// Execute query
			$result=$this->getFromDB("id",$where,"nodes",true,true);
			if (!is_array($result) && !is_null($result)) {
				$this->lastError = getMessage('db_error') . $result;
				return NULL;
			}
			if (is_null($result)) {
				$this->lastError = "";
				return NULL;
			}
			// Set the result
			foreach ($result as $r) {
				$this->nodesIds[] = $r["id"];
			}
		}
		
		/**
		* Return true if not found
		*
		* @access public
		* @return int
		*/
		function notFound() {
			return $this->notFound;
		}
		
		/**
		* Get the nodes found
		*
		* @access public
		* @return int
		*/
		function getNodesIds() {
			return $this->nodesIds;
		}

		/**
		* Return yes if the object exists
		* To be used just after the construction
		*
		* @access public
		* @return float
		*/
		function isError() {
			return $this->isError;
		}

		/**
		* Get the last error
		*
		* @access public
		* @return float
		*/
		function lastError() {
			return $this->lastError;
		}
		
		/**
		* GetFromDB
		*
		* @access private
		* @return array
		*/
		function getFromDB($column,$where,$from="nodes",$isFatal=true,$multiple = false) {
			$query='SELECT '.$column.' FROM '.$from.' WHERE '.$where;
			if ($multiple) {
				$result = select($query.";");
			}
			else {
				$result = singleResultSelect($query);
			}
			if (!$result) {	
				$this->lastError = getMessage('not_found').$query; 
				$this->notFound = true; 
				if ($isFatal) 
					$this->isError = true; return NULL; 
			}
			elseif (!is_array($result)) { 
				$this->lastError = getMessage('db_error').$result." : ".$query; 
				if ($isFatal) $this->isError = true; return NULL;
			}
			return $result;
		}
		
	}
?>
