## Lintian SSG

- [x] Some descriptions contain manpage link syntax to non-numeric only sections,
  e.g. deb-systemd-invoke(1p) in "skip-systemd-native-flag-missing-pre-depends"

## Lintian Tag sources

Some tag descriptions are indented with more than 1 space, which does not seem to be supported by Lintian:

- [ ] obsolete-crypt-alias
- [ ] obsolete-des-encryption

Some tag descriptions contain invalid Markdown[^md]:

- [ ] empty-rust-library-declares-provides: unordered list should not be indented
- [ ] groff-message: contains `<code></code>` tags in indented code block
- [ ] pipe-symbol-used-as-license-disjunction: vertical bar HTML entity misses the final `;`
- [ ] relative-library-search-path: `<code></code>` tags in indented code block + missing blank line before code block
- [ ] whitespace-after-continuation-character: the `\` char should be replaced by `&bsol;` or `\\`

Some literal blocks should probably be indented:

- [ ] homepage-for-bioconductor-package-not-canonical
- [ ] homepage-github-url-ends-with-dot-git
- [ ] homepage-gitlab-url-ends-with-dot-git
- [ ] homepage-salsa-url-ends-with-dot-git
- [ ] unicode-trojan

Some links should be in See also: section:

- [ ] uses-deprecated-python-stdlib
- [ ] team/pkg-perl/testsuite/autopkgtest-needs-use-name
- [ ] team/pkg-perl/testsuite/no-team-tests
- [ ] team/pkg-perl/testsuite/no-testsuite-header
- [ ] team/pkg-perl/xs-abi/legacy-vendorarch-directory

Some links are dead:

```console
$ linkchecker -F csv https://lintian.club1.fr/ --check-extern --ignore-url="https://(udd|salsa)\.debian\.org"
$ grep -v '^#' linkchecker-out.csv | awk -F';' '{ printf "%s\n --> %s\n", $2, $1 }'
parentname
 --> urlname
https://lintian.club1.fr/manual/index.html
 --> https://lintian.debian.org
https://lintian.club1.fr/tags/alien-tag.html
 --> https://lintian.debian.org/manual/index.html#format-of-override-files
https://lintian.club1.fr/tags/binary-file-built-without-LFS-support.html
 --> https://manpages.debian.org/open64(2)
https://lintian.club1.fr/tags/debian-pyversions-is-obsolete.html
 --> https://www.debian.org/doc/packaging-manuals/python-policy/ch-module_packages.html#s-specifying_versions
https://lintian.club1.fr/tags/desktop-contains-deprecated-key.html
 --> https://specifications.freedesktop.org/desktop-entry-spec/latest/apc.html
https://lintian.club1.fr/tags/desktop-entry-contains-unknown-key.html
 --> https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html
https://lintian.club1.fr/tags/desktop-entry-file-has-crs.html
 --> https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s03.html
https://lintian.club1.fr/tags/desktop-entry-uses-reserved-category.html
 --> https://specifications.freedesktop.org/menu-spec/latest/apas03.html
https://lintian.club1.fr/tags/file-in-root-and-usr.html
 --> https://anonscm.debian.org/cgit/users/md/usrmerge.git/plain/debian/README.Debian
https://lintian.club1.fr/tags/maintainer-script-has-invalid-update-inetd-options.html
 --> https://manpages.debian.org/update-inetd(1)
https://lintian.club1.fr/tags/missing-built-using-field-for-golang-package.html
 --> https://manpages.debian.org/dh-golang(1)
https://lintian.club1.fr/tags/multi-arch-same-package-calls-pycompile.html
 --> https://manpages.debian.org/cgi-bin/man.cgi?query=pycompile&sektion=1
False
 --> Redirected to `https://dyn.manpages.debian.org/pycompile'."
https://lintian.club1.fr/tags/missing-xs-go-import-path-for-golang-package.html
 --> https://go-team.pages.debian.net/ci.html.
https://lintian.club1.fr/tags/override_dh_auto_test-does-not-check-DEB_BUILD_OPTIONS.html
 --> https://manpages.debian.org/debhelper(1)
https://lintian.club1.fr/tags/package-does-not-use-debhelper-or-cdbs.html
 --> https://build-common.alioth.debian.org/
https://lintian.club1.fr/tags/package-contains-thumbnails-dir.html
 --> https://specifications.freedesktop.org/thumbnail-spec/thumbnail-spec-latest.html
https://lintian.club1.fr/tags/package-uses-deprecated-dpatch-patch-system.html
 --> https://manpages.debian.org/cgi-bin/man.cgi?query=dpatch&sektion=1
False
 --> Redirected to `https://dyn.manpages.debian.org/dpatch'."
https://lintian.club1.fr/tags/undocumented-manual-page.html
 --> https://manpages.debian.org/undocumented(7)
```

[^md]: [Lintian User's Manual](https://lintian.club1.fr/manual/index.html#check-description-file)
states that: "The description is in the standard Markdown format."
