#include "null_rr.h"

using namespace System::Text;

namespace ADNS {

	NULL_RR::NULL_RR()
	{
		rr_type = RR_TYPE::NULL;
		rr_class = RR_CLASS::IN;
		Data = gcnew array<Byte>(1);
		Data[0] = 0;
		UpdateRdata();
	}

	Void NULL_RR::SetData(array<Byte>^ dn)
	{
		if (dn)
		{
			Data->Resize(Data,dn->Length);
			dn->CopyTo(Data,0);
			UpdateRdata();
		}
		return;
	}

	array<Byte>^ NULL_RR::GetData()
	{
		array<Byte>^ output = gcnew array<Byte>(Data->Length);
		Data->CopyTo(output,0);

		return output;
	}

	String^ NULL_RR::Print()
	{
		ASCIIEncoding^ ae = gcnew ASCIIEncoding();

		String^ output;
		output = PrintHeader();
		output += ae->GetString(Data);

		return output;
	}

	Void NULL_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(Data->Length);
		else
			rdata->Resize(rdata,Data->Length);

		Data->CopyTo(rdata,0);

		return;
	}

	NULL_RR^ NULL_RR::Clone()
	{
		NULL_RR^ newrr = gcnew NULL_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->Data = gcnew array<Byte>(Data->Length);
		Data->CopyTo(newrr->Data,0);
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ NULL_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		NULL_RR^ nullout;
		array<Byte>^ tmparray;

		nullout = gcnew NULL_RR();
		nullout->owner = gcnew DOMAIN_NAME(domainname);
		nullout->rr_class = (RR_CLASS) rr_class;
		nullout->ttl = ttl;
		tmparray = gcnew array<Byte>(rdata_len);
		packet->Copy(packet,rdata_start,tmparray,0,rdata_len);
		nullout->SetData(tmparray);
		return nullout;
	}

	String^ NULL_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<NULL_RR^>(rec)->Print();
	}

	ResourceRecord^ NULL_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<NULL_RR^>(rec)->Clone();
	}

}