/+
REQUIRED_ARGS: -o- -HC

TEST_OUTPUT:
---
// Automatically generated by Digital Mars D Compiler

#pragma once

#include <assert.h>
#include <stddef.h>
#include <stdint.h>
#include <math.h>

#ifdef CUSTOM_D_ARRAY_TYPE
#define _d_dynamicArray CUSTOM_D_ARRAY_TYPE
#else
/// Represents a D [] array
template<typename T>
struct _d_dynamicArray final
{
    size_t length;
    T *ptr;

    _d_dynamicArray() : length(0), ptr(NULL) { }

    _d_dynamicArray(size_t length_in, T *ptr_in)
        : length(length_in), ptr(ptr_in) { }

    T& operator[](const size_t idx) {
        assert(idx < length);
        return ptr[idx];
    }

    const T& operator[](const size_t idx) const {
        assert(idx < length);
        return ptr[idx];
    }
};
#endif

union U1
{
    int32_t a;
    double d;
};

union U2
{
    double d;
    char* ptr;
};

struct S final
{
    int32_t i;
    U1 u1;
    U2 u2;
    S() :
        i(),
        u1(),
        u2()
    {
    }
    S(int32_t i, U1 u1 = U1(0), U2 u2 = U2(NAN)) :
        i(i),
        u1(u1),
        u2(u2)
        {}
};
---
+/

extern (C++):

union U1
{
	int a;
	double d;
}

union U2
{
	double d;
	char* ptr;
}

struct S
{
	int i;
	U1 u1;
	U2 u2;
}
