/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcmaps_voms_gsi_utils.h
    \brief  API for the utilities for the LCMAPS voms plugin
    \author Martijn Steenbakkers for the EU DataGrid.

    This header contains the declarations of the LCMAPS GSI utility functions:
    -# lcmaps_cred_to_x509():
    -# lcmaps_cred_to_x509_chain():
*/

#ifndef LCMAPS_VOMS_GSI_UTILS_H
#define LCMAPS_VOMS_GSI_UTILS_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include <openssl/x509.h>
#include <gssapi.h>


/******************************************************************************
 *                 Module definition
 *****************************************************************************/

/******************************************************************************
Function:       lcmaps_cred_to_x509()
Description:    Return the pointer to X509 structure from gss credential
Parameters:
                cred: globus credential
Returns:        pointer to X509 struct or NULL
******************************************************************************/
extern X509 * lcmaps_cred_to_x509(
        gss_cred_id_t cred
);


/******************************************************************************
Function:       lcmaps_cred_to_x509_chain()
Description:    Return the pointer to X509 chain from gss credential
Parameters:
                cred: globus credential
Returns:        pointer to X509 chain or NULL
******************************************************************************/
extern STACK_OF(X509) * lcmaps_cred_to_x509_chain(
        gss_cred_id_t cred
);

#endif /* LCMAPS_VOMS_GSI_UTILS_H */
