#!/bin/sh

test_description="simple tests for cfftot1 - part of LCDF Typetools"

. /usr/share/sharness/sharness.sh

CFF=/usr/share/fonts/opentype/font-awesome/FontAwesome.otf
TTF=/usr/share/fonts/truetype/noto/NotoSans-Regular.ttf

test_expect_success "cfftot1 version" "
    cfftot1 --version >stdout 2>stderr >&2 &&
    grep -x 'cfftot1 (LCDF typetools) [0-9.]\+' stdout
    test_must_be_empty stderr
#    test_must_fail test -s stderr && cat stderr >&2
"

test_expect_success "cfftot1 help" "
    cfftot1 --help >stdout 2>stderr &&
    grep -Fx 'Usage: cfftot1 [OPTIONS] [FONTFILE [OUTPUTFILE]]' stdout
    test_must_be_empty stderr
    test_must_fail test -s stderr && cat stderr >&2
"

test_expect_success "cfftot1 extract OpenType/CFF" "
    cfftot1 --name FontAwesome --output /dev/null -- $CFF 2>stderr
    test_must_be_empty stderr
    test_must_fail test -s stderr && cat stderr >&2
"

test_expect_success "cfftot1 fail extract bogus name" "
    test_expect_code 1 cfftot1 --name FooBar --output /dev/null -- $CFF 2>stderr
    test_must_fail test -s stderr && cat stderr >&2
"

test_expect_success "cfftot1 fail extract OpenType/TTF" "
    test_expect_code 1 cfftot1 --name Foo --output /dev/null -- $TTF 2>stderr
    test_must_fail test -s stderr && cat stderr >&2
"

test_done
