package latexDraw.ui.dialog;

import java.awt.*;
import java.awt.event.ActionEvent;

import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

import latexDraw.figures.Figure;
import latexDraw.figures.Grid;
import latexDraw.figures.GridShape;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.psTricks.PSTricksConstants;
import latexDraw.ui.DrawPanel;
import latexDraw.ui.components.ButtonIcon;
import latexDraw.ui.components.ColorButton;
import latexDraw.util.LaTeXDrawResources;


/** 
 * This class defines the frame which allows to modify a grid<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ParametersGridFrame extends AbstractGridShapeFrame
{
	private static final long serialVersionUID = 1L;
	
	/** Allows to change the colour of the sub-grid */
	protected ColorButton subGridColorButton;
	
	/** Allows to change the size of the label */
	protected JSpinner labelSize;
	
	/** Allows to change the attribute Grid.subGridDiv */
	protected JSpinner subGridDiv;
	
	/** Allows to change the attribute Grid.subGridWidth */
	protected JSpinner subGridWidth;
	
	/** Allows to change the attribute Grid.gridWidth */
	protected JSpinner gridWidth;
	
	/** Allows to change the colour of the labels */
	protected ColorButton labelsColorButton;	
	
	/** Allows to change the attribute Grid.gridDots */
	protected JSpinner gridDots;
	
	/** Allows to change the attribute Grid.subGridDots */
	protected JSpinner subGridDots;
	
	/** Allows to know if we must draw the labels */
	protected JCheckBox drawLabel;

	/** Allows to change the attribute Grid.unit */
	protected JSpinner unit;
	
	
	/** The label of the unit item */
	public static final String LABEL_UNIT = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.3"); //$NON-NLS-1$
	
	/** The label of the drawLabel checkbox */
	public static final String LABEL_DRAWLABELS = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.15"); //$NON-NLS-1$

	/** The label of the subGridDots item */
	public static final String LABEL_SUBGRIDDOTS = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.4"); //$NON-NLS-1$
	
	/** The label of the gridDots item */
	public static final String LABEL_GRIDDOTS = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.5"); //$NON-NLS-1$
	
	/** The label of the gridWidth item */
	public static final String LABEL_GRIDWIDTH = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.6"); //$NON-NLS-1$
	
	/** The label of the subGridWidth item */
	public static final String LABEL_SUBGRIDWIDTH = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.7"); //$NON-NLS-1$
	
	/** The label of the subGridDiv item */
	public static final String LABEL_SUBGRIDDIV = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.8"); //$NON-NLS-1$
	
	/** The label of the X position item */
	public static final String LABEL_LABEL_SIZE = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.9"); //$NON-NLS-1$
	
	/** The label of the subGridcolorutton item */
	public static final String LABEL_SUBGRIDCOLOR = LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.10"); //$NON-NLS-1$
	

	
	/**
	 * The constructor by default
	 * @param d The drawPanel
	 */
	public ParametersGridFrame(Frame parent, DrawPanel d, boolean attachToMainFrame)
	{
		super(parent, d, attachToMainFrame);
		
		try
		{
	  		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		GridBagConstraints constraint = new GridBagConstraints();
	    	constraint.gridx = 0;
	     	constraint.gridy = 0;
	     	constraint.gridwidth = 1;
	     	constraint.gridheight = 1;
	     	constraint.weightx = 0.1;
	     	constraint.weighty = 0.1;
	     	constraint.fill = GridBagConstraints.NONE;
	     	constraint.anchor = GridBagConstraints.WEST;

	  		JTabbedPane tabbedPane = new JTabbedPane();
	  		JPanel pButton  = createButtonsPanel(this);
	  		JPanel pGeneral = new JPanel();
	  		pGeneral.setLayout(new BoxLayout(pGeneral, BoxLayout.Y_AXIS));
	     	pGeneral.add(createPositionPanel(true));
	     	
	     	JPanel pOther = new JPanel();
	     	pOther.setLayout(new BoxLayout(pOther, BoxLayout.Y_AXIS));
	     	JPanel other = new JPanel(new GridBagLayout());
	     	JPanel pLabels = new JPanel(new GridBagLayout());
	     	
	     	constraint.gridx=0;
	     	constraint.gridy=0;
	     	other.add(new JLabel(LABEL_GRIDWIDTH), constraint);
	     	
	     	SpinnerModel model = new SpinnerNumberModel(1, 0.1, 1000, 0.5);
	     	gridWidth = new JSpinner(model);
	     	gridWidth.setEditor(new JSpinner.NumberEditor(gridWidth, "0.00"));//$NON-NLS-1$
	     	gridWidth.addChangeListener(this);
	     	gridWidth.setName(LABEL_GRIDWIDTH);
	     	constraint.gridx++;
	     	other.add(gridWidth, constraint);	  
	     	
	     	bordersButton = new ColorButton(LaTeXDrawLang.getDialogFrameString("PreferencesFrame.grid"),new ButtonIcon(Figure.DEFAULT_BORDERS_COL)); //$NON-NLS-1$
	     	bordersButton.setActionCommand(LaTeXDrawResources.LABEL_COLOR_BUTTON);
	     	bordersButton.addActionListener(this);
	     	constraint.gridx = 0;	constraint.gridy++;
	     	other.add(bordersButton, constraint);
	     	
	     	subGridColorButton = new ColorButton(LABEL_SUBGRIDCOLOR, new ButtonIcon(PSTricksConstants.DEFAULT_SUB_GRID_COLOR));
	     	subGridColorButton.setActionCommand(LABEL_SUBGRIDCOLOR);
	     	subGridColorButton.addActionListener(this);
	     	constraint.gridx++;
	     	other.add(subGridColorButton, constraint);
	     	
	     	constraint.gridy++;	constraint.gridx = 0;
	     	other.add(new JLabel(LABEL_GRIDDOTS), constraint);
	     	
	     	model = new SpinnerNumberModel(0,0,10000,1);
	     	gridDots = new JSpinner(model);
	     	gridDots.setEditor(new JSpinner.NumberEditor(gridDots, "0"));//$NON-NLS-1$
	     	gridDots.addChangeListener(this);
	     	gridDots.setName(LABEL_GRIDDOTS);
	     	constraint.gridx++;
	     	other.add(gridDots, constraint);	  	    

	     	constraint.gridx++;
	     	other.add(new JLabel(LABEL_UNIT), constraint);
	     	
	     	model = new SpinnerNumberModel(1,0.0001,100,0.1);
	     	unit = new JSpinner(model);
	     	unit.setEditor(new JSpinner.NumberEditor(unit, "0.000"));//$NON-NLS-1$
	     	unit.addChangeListener(this);
	     	unit.setName(LABEL_UNIT);
	     	constraint.gridx++;
	     	other.add(unit, constraint);	  	
	     	
	     	constraint.gridy++; constraint.gridx = 0;
	     	other.add(new JLabel(LABEL_SUBGRIDDIV), constraint);
	     	
	     	model = new SpinnerNumberModel(1,1,100,1);
	     	subGridDiv = new JSpinner(model);
	     	subGridDiv.setEditor(new JSpinner.NumberEditor(subGridDiv, "0"));//$NON-NLS-1$
	     	subGridDiv.addChangeListener(this);
	     	subGridDiv.setName(LABEL_SUBGRIDDIV);
	     	constraint.gridx++;
	     	other.add(subGridDiv, constraint);	  
	     	
	     	constraint.gridx++;
	     	other.add(new JLabel(LABEL_SUBGRIDWIDTH), constraint);
	     	
	     	model = new SpinnerNumberModel(1, 0.1, 100, 0.5);
	     	subGridWidth = new JSpinner(model);
	     	subGridWidth.setEditor(new JSpinner.NumberEditor(subGridWidth, "0.00"));//$NON-NLS-1$
	     	subGridWidth.addChangeListener(this);
	     	subGridWidth.setName(LABEL_SUBGRIDWIDTH);
	     	constraint.gridx++;
	     	other.add(subGridWidth, constraint);	  	     	
	     	
	     	constraint.gridx=0; constraint.gridy++;
	     	other.add(new JLabel(LABEL_SUBGRIDDOTS), constraint);
	     	
	     	model = new SpinnerNumberModel(0, 0, 10000, 1);
	     	subGridDots = new JSpinner(model);
	     	subGridDots.setEditor(new JSpinner.NumberEditor(subGridDots, "0"));//$NON-NLS-1$
	     	subGridDots.addChangeListener(this);
	     	subGridDots.setName(LABEL_SUBGRIDDOTS);
	     	constraint.gridx++;
	     	other.add(subGridDots, constraint);	
	     	
	     	constraint.gridx=0;
	     	constraint.gridy=0;
	     	pLabels.add(new JLabel(LABEL_LABEL_SIZE), constraint);
	     	
	     	model = new SpinnerNumberModel(Grid.MIN_LABELS_SIZE, Grid.MIN_LABELS_SIZE, 100, 1);
	     	labelSize = new JSpinner(model);
	     	labelSize.setEditor(new JSpinner.NumberEditor(labelSize, "0"));//$NON-NLS-1$
	     	labelSize.addChangeListener(this);
	     	labelSize.setName(LABEL_LABEL_SIZE);
	     	constraint.gridx++;
	     	pLabels.add(labelSize, constraint);	 
	     	
	     	labelsColorButton = new ColorButton(LABEL_LABELSCOLOR, new ButtonIcon(PSTricksConstants.DEFAULT_LABELGRIDCOLOR));
	     	labelsColorButton.setActionCommand(LABEL_LABELSCOLOR);
	     	labelsColorButton.addActionListener(this);
	     	constraint.gridx++;
	     	pLabels.add(labelsColorButton, constraint);
	     	
	     	drawLabel = new JCheckBox(LABEL_DRAWLABELS, Grid.DEFAULT_LABELSSIZE>0);
	     	drawLabel.setActionCommand(LABEL_DRAWLABELS);
	     	drawLabel.setName(LABEL_DRAWLABELS);
	     	drawLabel.addActionListener(this);
	     	constraint.gridwidth = 1;
	     	constraint.gridx = 0;	constraint.gridy++;
	     	pLabels.add(drawLabel, constraint);
	     	
	     	constraint.gridx = 0;	constraint.gridy++;
	     	invertXLabelsCB = new JCheckBox(LABEL_ISXLABEL);
	     	invertXLabelsCB.setText(LABEL_ISXLABEL);
	     	invertXLabelsCB.setSelected(GridShape.DEFAULT_ISYLABELWEST);
	     	invertXLabelsCB.setActionCommand(LABEL_ISXLABEL);
	     	invertXLabelsCB.addActionListener(this);
	     	pLabels.add(invertXLabelsCB, constraint);
	     	
	     	constraint.gridx+=2;
	     	invertYLabelsCB = new JCheckBox(LABEL_ISYLABEL);
	     	invertYLabelsCB.setText(LABEL_ISYLABEL);
	     	invertYLabelsCB.setSelected(GridShape.DEFAULT_ISXLABELSOUTH);
	     	invertYLabelsCB.addActionListener(this);
	     	invertYLabelsCB.setActionCommand(LABEL_ISYLABEL);
	     	pLabels.add(invertYLabelsCB, constraint);
	     	other.setBorder(new CompoundBorder(new TitledBorder(null, LaTeXDrawLang.getString1_7("ParametersGridFrame.0"),  //$NON-NLS-1$
					  					TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
	     	pLabels.setBorder(new CompoundBorder(new TitledBorder(null, LaTeXDrawLang.getString1_8("ParametersAxeFrame.12"),   //$NON-NLS-1$
	     								TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
	     	pOther.add(other);
	     	pOther.add(pLabels);
			
	     	tabbedPane.addTab(TITLE_TABBED_PANE_GENERAL, pGeneral);
	     	tabbedPane.addTab(TITLE_TABBED_PANE_OTHERS, pOther);
	     	BoxLayout bl = new BoxLayout(getContentPane(), BoxLayout.Y_AXIS);
	     	getContentPane().setLayout(bl);
	     	getContentPane().add(glimpsePanelZoom);
	     	getContentPane().add(tabbedPane);
			getContentPane().add(pButton);
	  		pack();
	  		setLocation(dim.width/2-getWidth()/2, dim.height/2-getHeight()/2);
			setVisible(false);

		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}

	
	
	
	@Override
	public void setVisible(boolean visible, Figure selected, boolean deleteOnCancel, boolean isFramedBox) 
	{
		try
		{
			if(!(selected instanceof Grid))
				throw new ClassCastException();

			super.setVisible(visible, selected, deleteOnCancel, isFramedBox);
		}
		catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}	
	}
	
	
	
	
	@Override
	public void actionPerformed(ActionEvent e) 
	{
		try
		{
			Object o = e.getSource();
			Grid g = (Grid)glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JCheckBox)
			{
				String label = ((JCheckBox)o).getActionCommand();
				
				if(label.equals(LABEL_DRAWLABELS))
				{
					boolean mustBeDrawn = drawLabel.isSelected();
					
					labelsColorButton.setEnabled(mustBeDrawn);
					labelSize.setEnabled(mustBeDrawn);
					
					if(!mustBeDrawn)
						g.setGridLabelsSize(0);
					else  
						g.setGridLabelsSize(Integer.valueOf(labelSize.getValue().toString()).intValue());
						
					setModified(true);
					glimpsePanel.repaint();
					return;
				}
			}
			
			if(o instanceof JButton)
			{
				String label = ((JButton)o).getActionCommand();
				
				if(label==null)
					return ;
				
				if(label.equals(LABEL_LABELSCOLOR))
				{
					Color c = JColorChooser.showDialog((Component) e.getSource(), 
							LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.17"),  //$NON-NLS-1$
							((ColorButton)o).getColor());
						
					if(c!=null)
					{
						setModified(true);
						((ColorButton)o).setColor(c);
						g.setGridLabelsColor(c);
						glimpsePanel.repaint();
					}
					return ;
				}
				
				if(label.equals(LABEL_SUBGRIDCOLOR))
				{
					Color c = JColorChooser.showDialog((Component) e.getSource(), 
							LaTeXDrawLang.getDialogFrameString("ParametersGridFrame.18"),  //$NON-NLS-1$
							((ColorButton)o).getColor());
						
					if(c!=null)
					{
						setModified(true);
						((ColorButton)o).setColor(c);
						g.setSubGridColor(c);
						glimpsePanel.repaint();
					}
					return ;
				}	
			}
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.actionPerformed(e);
	}
	
	
	
	
	
	@Override
	public void stateChanged(ChangeEvent e) 
	{
		try
		{
			Object o = e.getSource();
			Grid g = (Grid)glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JSpinner)
			{
				String name = ((JSpinner)o).getName();
				
				if(name.equals(LABEL_GRIDDOTS))
				{
					setModified(true);
					g.setGridDots(Integer.valueOf(gridDots.getValue().toString()).intValue());
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_UNIT))
				{
					setModified(true);
					g.setUnit(Float.valueOf(unit.getValue().toString()).doubleValue());
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_SUBGRIDDOTS))
				{
					setModified(true);
					g.setSubGridDots(Integer.valueOf(subGridDots.getValue().toString()).intValue());
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_SUBGRIDDIV))
				{
					setModified(true);
					g.setSubGridDiv(Integer.valueOf(subGridDiv.getValue().toString()).intValue());
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_LABEL_SIZE))
				{
					setModified(true);
					g.setGridLabelsSize(Integer.valueOf(labelSize.getValue().toString()).intValue());
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}

				if(name.equals(LABEL_GRIDWIDTH))
				{
					setModified(true);
					g.setGridWidth(Float.valueOf(gridWidth.getValue().toString()).floatValue());
					g.updateBorders(null);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_SUBGRIDWIDTH))
				{
					setModified(true);
					g.setSubGridWidth(Float.valueOf(subGridWidth.getValue().toString()).floatValue());
					glimpsePanel.repaint();
					return ;
				}
			}
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.stateChanged(e);
	}
	
	

	@Override
	public void saveParameters()
	{
		super.saveParameters();
		
		Grid g = (Grid)figure;

		g.setUnit(Float.valueOf(unit.getValue().toString()).doubleValue());
		g.setGridDots(Integer.valueOf(gridDots.getValue().toString()).intValue());
		g.setSubGridDots(Integer.valueOf(subGridDots.getValue().toString()).intValue());
		g.setSubGridDiv(Integer.valueOf(subGridDiv.getValue().toString()).intValue());
		g.setGridLabelsColor(labelsColorButton.getColor());
		if(drawLabel.isSelected())
			g.setGridLabelsSize(Integer.valueOf(labelSize.getValue().toString()).intValue());
		else g.setGridLabelsSize(0);
		g.setGridWidth(Float.valueOf(gridWidth.getValue().toString()).floatValue());
		g.setSubGridWidth(Float.valueOf(subGridWidth.getValue().toString()).floatValue());
		g.setSubGridColor(subGridColorButton.getColor());
		g.updateFonts();
		g.updateBorders(g.getFontMetrics());

		drawPanel.getFrameParent().setExportAsMenu(true);
		drawPanel.getDraw().updateBorders();
		drawPanel.updateDraw(true);
	}
	

	
	@Override
	public void setFigureFrameField()
	{
		super.setFigureFrameField();
		
		Grid g = (Grid)figure;
		
		subGridColorButton.setColor(g.getSubGridColor());
		labelsColorButton.setColor(g.getGridLabelsColor());
		subGridDiv.setValue(g.getSubGridDiv());
		subGridDots.setValue(g.getSubGridDots());
		subGridWidth.setValue((double)g.getSubGridWidth());
		gridWidth.setValue((double)g.getGridWidth());
		gridDots.setValue(g.getGridDots());
		unit.setValue(g.getUnit());
		if(g.getGridLabelsSize()>0)
			labelSize.setValue(g.getGridLabelsSize());
	}



	@Override
	public void setDefaultsValues()
	{
		super.setDefaultsValues();
		
		Grid g = (Grid)glimpsePanel.glimpseFigure;
		unit.setValue(PSTricksConstants.DEFAULT_UNIT);
		subGridColorButton.setColor(PSTricksConstants.DEFAULT_SUB_GRID_COLOR);
		labelsColorButton.setColor(PSTricksConstants.DEFAULT_LABELGRIDCOLOR);
		g.setSubGridColor(PSTricksConstants.DEFAULT_SUB_GRID_COLOR);
		g.setGridLabelsColor(PSTricksConstants.DEFAULT_LABELGRIDCOLOR);
		subGridDiv.setValue(PSTricksConstants.DEFAULT_SUBGRIDDIV);
		subGridDots.setValue(PSTricksConstants.DEFAULT_SUBGRIDDOTS);
		subGridWidth.setValue(PSTricksConstants.DEFAULT_SUB_GRID_WIDTH);
		gridWidth.setValue(PSTricksConstants.DEFAULT_GRID_WIDTH);
		gridDots.setValue(PSTricksConstants.DEFAULT_GRIDDOTS);
		labelSize.setValue(Grid.DEFAULT_LABELSSIZE);
		drawLabel.setSelected(true);
		g.setGridLabelsSize(Grid.DEFAULT_LABELSSIZE);
		labelSize.setEnabled(drawLabel.isSelected());
		
		glimpsePanel.repaint();
	}
}
