/***********************************************************************
 *                                                                      *
 *               This software is part of the ast package               *
 *          Copyright (c) 1999-2011 AT&T Intellectual Property          *
 *                      and is licensed under the                       *
 *                 Eclipse Public License, Version 1.0                  *
 *                    by AT&T Intellectual Property                     *
 *                                                                      *
 *                A copy of the License is available at                 *
 *          http://www.eclipse.org/org/documents/epl-v10.html           *
 *         (with md5 checksum b35adb5213ca9657e911e9befb180842)         *
 *                                                                      *
 *              Information and Software Systems Research               *
 *                            AT&T Research                             *
 *                           Florham Park NJ                            *
 *                                                                      *
 *               Glenn Fowler <glenn.s.fowler@gmail.com>                *
 *                                                                      *
 ***********************************************************************/
#include "config_ast.h"  // IWYU pragma: keep

#include <string.h>

#include "sfio.h"
#include "terror.h"

tmain() {
    UNUSED(argc);
    UNUSED(argv);
    char buf[1024], *s;
    Sfio_t *f;

    f = sfnew(NULL, NULL, (size_t)SF_UNBOUND, -1, SF_WRITE | SF_STRING);
    sfsetbuf(sfstdout, buf, sizeof(buf));
    sfsetbuf(sfstderr, buf, sizeof(buf));
    sfset(sfstdout, SF_SHARE, 0);
    sfset(sfstderr, SF_SHARE, 0);

    if (!sfpool(sfstdout, f, SF_SHARE) || !sfpool(sfstderr, f, SF_SHARE)) terror("Pooling");

    if (sfputr(sfstdout, "01234", -1) != 5) terror("Writing to stderr");
    if (sfputr(sfstderr, "56789", -1) != 5) terror("Writing to stdout");

    if (sfputc(f, '\0') < 0) terror("Writing to string stream");

    sfseek(f, (Sfoff_t)0, 0);
    if (!(s = sfreserve(f, SF_UNBOUND, 1))) terror("Peeking");
    sfwrite(f, s, 0);
    if (strcmp(s, "0123456789") != 0) terror("Data is wrong");

    texit(0);
}
