/***************************************************************************
                 old_richtextparser.h - old MSN and MSN Plus parser
                             -------------------
    begin                : April 30, 2008
    copyright            : (C) 2008 by Valerio Pilo
    email                : valerio@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OLD_RICHTEXTPARSER_H
#define OLD_RICHTEXTPARSER_H

#include "../src/emoticon.h"

#include <QStringList>
#include <QHash>


#define OLD_MSN_PLUS_STRINGCACHESIZE     100


// Forward declarations
class EmoticonManager;



/**
 * String types available when dealing with formatting
 *
 * Use one of these flags to obtain a string parsed the way you need it
 */
enum OldFormattingMode
{
    OLD_STRING_ORIGINAL             = 0 /// Unchanged string
  , OLD_STRING_CLEANED                  /// All formatting tags removed
  , OLD_STRING_CLEANED_ESCAPED          /// Same as STRING_CLEANED, but html-escaped
  , OLD_STRING_FORMATTED                /// All formatting tags translated to HTML
  , OLD_STRING_CHAT_SETTING             /// Tags parsed or removed depending on the user's chat window formatting option
  , OLD_STRING_CHAT_SETTING_ESCAPED     /// Same as STRING_CHAT_SETTING, but html-escaped if the option is off
  , OLD_STRING_LIST_SETTING             /// Tags parsed or removed depending on the user's contact list formatting option
  , OLD_STRING_LIST_SETTING_ESCAPED     /// Same as STRING_LIST_SETTING, but html-escaped if the option is off
};



/**
 * @brief Implements features from the MSN Plus extension to KMess
 *
 * Implements features from the "MSN Plus! Live" extension for MSN Messenger
 * and Windows Live Messenger. These features can be: custom formatting in
 * nick names, personal messages and in chat text; sending/receiving of
 * little sound clips; contact pinging; special colored phrases which trigger
 * a sound; various IRC-style commands, like /me; et cetera.
 * Some of them are worth adding in KMess, some others are kind of useless but
 * someday they could be implemented.
 *
 * Currently the only implemented feature is text formatting, which is the
 * most used and also the most annoying to not have; reading friendly names
 * with all the tags and codes really IS annoying.
 *
 * @author Valerio Pilo <valerio@kmess.org>
 * @author Antonio Nastasi <sifcenter@gmail.com>
 */
class OldRichTextParser
{
  friend class KMessTest;

  public: // Public static methods

    // Return the given string with MSN Plus! formatting stripped out
    static void           getCleanString( QString &string );
    // Initialize the class
    static void           initialize();
    // Return the given string with links and emoticons translated to HTML
    static void           parseMsnString( QString &text, bool showEmoticons = true, bool showSmallEmoticons = true, bool showLinks = true, bool showFormatting = false, const QString &handle = *((QString*)0), QStringList &pendingEmoticonTags = *((QStringList*)0) );
    static void           oldParseMsnString( QString &text, bool showEmoticons = true, bool showSmallEmoticons = true, bool showLinks = true, bool showFormatting = false, const QString &handle = *((QString*)0), QStringList &pendingEmoticonTags = *((QStringList*)0) );


  private: // Private static methods

    // Return the given string with MSN Plus! formatting parsed
    static void           getFormattedString( QString &string );
    // Turns color codes (english color names, RGB triplets, MSN Plus! palette colors) into an HTML RGB color code
    static QString        getHtmlColor( const QString& color );
    // Turns a string into a gradient colored one, using Qt HTML tags
    static QString        getHtmlGradient( const QString& text, const QString& start, const QString& end );
    // Replace the Messenger Plus characters with HTML markup
    static void           parseMsnPlusString( QString &text );


  private: // Private properties

    // QHash maps for storing the string already parsed
    static QHash<QString, QString> cleanedStringsCache_;
    static QHash<QString, QString> formattedStringsCache_;

    // Regular expression to match colors
    static QRegExp        colorMatch_;
    // The last assigned ID for pending emoticon placeholders
    static int            lastPendingEmoticonId_;
    // An instance of the Emoticon Manager
    static EmoticonManager *emoticonManager_;
    // List of MSN Plus colors
    static QStringList    predefinedColors_;

};



/**
 * @brief A collection of strings to use with formatting
 *
 * A little class to hold together three strings: the original one, a formatted and a cleaned up version of it;
 * it also allows for very easy manipulation.
 *
 * @author Valerio Pilo <valerio@kmess.org>
 */
class OldFormattedString
{
  public:
    // Constructor, can be told to not parse the initial string but just save it (during KMess initialization)
    OldFormattedString( const QString &string = QString(), bool parseName = true );
    // Set a string, which will be formatted according to the given flags
    void setString( const QString &string );
    // Returns the specified version of the string
    const QString &getString( OldFormattingMode mode = OLD_STRING_CLEANED ) const;

    // Returns the cleaned up version of the set string
    inline const QString &  getCleaned() const { return cleaned_;   }
    // Returns the formatted version of the set string
    inline const QString &getFormatted() const { return formatted_; }
    // Returns the original string
    inline const QString & getOriginal() const { return original_;  }
    // Changes the formatting options which will be used for the string
    inline void setOptions( bool showEmoticons = true, bool showSmallEmoticons = true, bool showLinks = false )
    {
      showEmoticons_      = showEmoticons;
      showLinks_          = showLinks;
      showSmallEmoticons_ = showSmallEmoticons;
    }

  private:
    // HTML-Escaped version of the string
    QString               escaped_;
    // cleaned up version of the string
    QString               cleaned_;
    // The formatted version of the string
    QString               formatted_;
    // The original string
    QString               original_;
    // Whether to show emoticons in the formatted string
    bool                  showEmoticons_;
    // Whether to make links clickable or not
    bool                  showLinks_;
    // Whether to display the emoticons big or small
    bool                  showSmallEmoticons_;
};



#endif
