/* Generated by JTB 1.4.4 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.syntaxtree.*;
import java.util.*;

/**
 * Provides default methods which visit each node in the tree in depth-first order.<br>
 * In your "RetArgu" visitors extend this class and override part or all of these methods.
 *
 * @param <R> The user return information type
 * @param <A> The user argument type
 */
public class DepthFirstRetArguVisitor<R, A> implements IRetArguVisitor<R, A> {


  /*
   * Base nodes classes visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link NodeChoice} node, passing it an argument.
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NodeChoice n, final A argu) {
    final R nRes = n.choice.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link NodeList} node, passing it an argument.
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NodeList n, final A argu) {
    R nRes = null;
    for (final Iterator<INode> e = n.elements(); e.hasNext();) {
      @SuppressWarnings("unused")
      final R sRes = e.next().accept(this, argu);
    }
    return nRes;
  }

  /**
   * Visits a {@link NodeListOptional} node, passing it an argument.
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NodeListOptional n, final A argu) {
    if (n.present()) {
      R nRes = null;
      for (final Iterator<INode> e = n.elements(); e.hasNext();) {
        @SuppressWarnings("unused")
        R sRes = e.next().accept(this, argu);
        }
      return nRes;
    } else
      return null;
  }

  /**
   * Visits a {@link NodeOptional} node, passing it an argument.
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NodeOptional n, final A argu) {
    if (n.present()) {
      final R nRes = n.node.accept(this, argu);
      return nRes;
    } else
    return null;
  }

  /**
   * Visits a {@link NodeSequence} node, passing it an argument.
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NodeSequence n, final A argu) {
    R nRes = null;
    for (final Iterator<INode> e = n.elements(); e.hasNext();) {
      @SuppressWarnings("unused")
      R subRet = e.next().accept(this, argu);
    }
    return nRes;
  }

  /**
   * Visits a {@link NodeToken} node, passing it an argument.
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NodeToken n, @SuppressWarnings("unused") final A argu) {
    R nRes = null;
    @SuppressWarnings("unused")
    final String tkIm = n.tokenImage;
    return nRes;
  }

  /*
   * User grammar generated visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link AFancyProduction} node, whose children are the following :
   * <p>
   * try {<br>
   * f0 -> ( #0 ( Annotation() )*<br>
   * .. .. . #1 ( %0 LabeledStatement()<br>
   * .. .. . .. | %1 AssertStatement()<br>
   * .. .. . .. | %2 Block()<br>
   * .. .. . .. | %3 EmptyStatement()<br>
   * .. .. . .. | %4 $0 StatementExpression() $1 ";"<br>
   * .. .. . .. | %5 SwitchStatement()<br>
   * .. .. . .. | %6 TryStatement() )<br>
   * .. .. . #2 [ MarkerAnnotation() ] )<br>
   * }<br>
   * catch (Name() < IDENTIFIER >) Block()<br>
   * catch (Name() < IDENTIFIER >) Block()<br>
   * finally Block()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AFancyProduction n, final A argu) {
    R nRes = null;
    // try {
    // f0 -> ( #0 ( Annotation() )*
    // .. .. . #1 ( %0 LabeledStatement()
    // .. .. . .. | %1 AssertStatement()
    // .. .. . .. | %2 Block()
    // .. .. . .. | %3 EmptyStatement()
    // .. .. . .. | %4 $0 StatementExpression() $1 ";"
    // .. .. . .. | %5 SwitchStatement()
    // .. .. . .. | %6 TryStatement() )
    // .. .. . #2 [ MarkerAnnotation() ] )
    // }
    // catch (Name() < IDENTIFIER >) Block()
    // catch (Name() < IDENTIFIER >) Block()
    // finally Block()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link JavaCCInput} node, whose children are the following :
   * <p>
   * f0 -> JavaCCOptions()<br>
   * f1 -> "PARSER_BEGIN"<br>
   * f2 -> "("<br>
   * f3 -> Identifier()<br>
   * f4 -> ")"<br>
   * f5 -> CompilationUnit()<br>
   * f6 -> "PARSER_END"<br>
   * f7 -> "("<br>
   * f8 -> Identifier()<br>
   * f9 -> ")"<br>
   * f10 -> ( Production() )+<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final JavaCCInput n, final A argu) {
    R nRes = null;
    // f0 -> JavaCCOptions()
    n.f0.accept(this, argu);
    // f1 -> "PARSER_BEGIN"
    n.f1.accept(this, argu);
    // f2 -> "("
    n.f2.accept(this, argu);
    // f3 -> Identifier()
    n.f3.accept(this, argu);
    // f4 -> ")"
    n.f4.accept(this, argu);
    // f5 -> CompilationUnit()
    n.f5.accept(this, argu);
    // f6 -> "PARSER_END"
    n.f6.accept(this, argu);
    // f7 -> "("
    n.f7.accept(this, argu);
    // f8 -> Identifier()
    n.f8.accept(this, argu);
    // f9 -> ")"
    n.f9.accept(this, argu);
    // f10 -> ( Production() )+
    n.f10.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link JavaCCOptions} node, whose children are the following :
   * <p>
   * f0 -> [ #0 "options" #1 "{"<br>
   * .. .. . #2 ( OptionBinding() )* #3 "}" ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final JavaCCOptions n, final A argu) {
    R nRes = null;
    // f0 -> [ #0 "options" #1 "{"
    // .. .. . #2 ( OptionBinding() )* #3 "}" ]
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link OptionBinding} node, whose children are the following :
   * <p>
   * f0 -> ( %0 < IDENTIFIER ><br>
   * .. .. | %1 "LOOKAHEAD"<br>
   * .. .. | %2 "IGNORE_CASE"<br>
   * .. .. | %3 "static" )<br>
   * f1 -> "="<br>
   * f2 -> ( %0 IntegerLiteral()<br>
   * .. .. | %1 BooleanLiteral()<br>
   * .. .. | %2 StringLiteral() )<br>
   * f3 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final OptionBinding n, final A argu) {
    R nRes = null;
    // f0 -> ( %0 < IDENTIFIER >
    // .. .. | %1 "LOOKAHEAD"
    // .. .. | %2 "IGNORE_CASE"
    // .. .. | %3 "static" )
    n.f0.accept(this, argu);
    // f1 -> "="
    n.f1.accept(this, argu);
    // f2 -> ( %0 IntegerLiteral()
    // .. .. | %1 BooleanLiteral()
    // .. .. | %2 StringLiteral() )
    n.f2.accept(this, argu);
    // f3 -> ";"
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Production} node, whose children are the following :
   * <p>
   * f0 -> . %0 JavaCodeProduction()<br>
   * .. .. | %1 RegularExprProduction()<br>
   * .. .. | %2 TokenManagerDecls()<br>
   * .. .. | %3 BNFProduction()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Production n, final A argu) {
    R nRes = null;
    // f0 -> . %0 JavaCodeProduction()
    // .. .. | %1 RegularExprProduction()
    // .. .. | %2 TokenManagerDecls()
    // .. .. | %3 BNFProduction()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link JavaCodeProduction} node, whose children are the following :
   * <p>
   * f0 -> "JAVACODE"<br>
   * f1 -> AccessModifier()<br>
   * f2 -> ResultType()<br>
   * f3 -> Identifier()<br>
   * f4 -> FormalParameters()<br>
   * f5 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f6 -> Block()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final JavaCodeProduction n, final A argu) {
    R nRes = null;
    // f0 -> "JAVACODE"
    n.f0.accept(this, argu);
    // f1 -> AccessModifier()
    n.f1.accept(this, argu);
    // f2 -> ResultType()
    n.f2.accept(this, argu);
    // f3 -> Identifier()
    n.f3.accept(this, argu);
    // f4 -> FormalParameters()
    n.f4.accept(this, argu);
    // f5 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    n.f5.accept(this, argu);
    // f6 -> Block()
    n.f6.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link BNFProduction} node, whose children are the following :
   * <p>
   * f0 -> AccessModifier()<br>
   * f1 -> ResultType()<br>
   * f2 -> Identifier()<br>
   * f3 -> FormalParameters()<br>
   * f4 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f5 -> ":"<br>
   * f6 -> Block()<br>
   * f7 -> "{"<br>
   * f8 -> ExpansionChoices()<br>
   * f9 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final BNFProduction n, final A argu) {
    R nRes = null;
    // f0 -> AccessModifier()
    n.f0.accept(this, argu);
    // f1 -> ResultType()
    n.f1.accept(this, argu);
    // f2 -> Identifier()
    n.f2.accept(this, argu);
    // f3 -> FormalParameters()
    n.f3.accept(this, argu);
    // f4 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    n.f4.accept(this, argu);
    // f5 -> ":"
    n.f5.accept(this, argu);
    // f6 -> Block()
    n.f6.accept(this, argu);
    // f7 -> "{"
    n.f7.accept(this, argu);
    // f8 -> ExpansionChoices()
    n.f8.accept(this, argu);
    // f9 -> "}"
    n.f9.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AccessModifier} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "public"<br>
   * .. .. | %1 "protected"<br>
   * .. .. | %2 "private" )?<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AccessModifier n, final A argu) {
    R nRes = null;
    // f0 -> ( %0 "public"
    // .. .. | %1 "protected"
    // .. .. | %2 "private" )?
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link RegularExprProduction} node, whose children are the following :
   * <p>
   * f0 -> [ %0 #0 "<" #1 "*" #2 ">"<br>
   * .. .. | %1 #0 "<" #1 < IDENTIFIER ><br>
   * .. .. . .. #2 ( $0 "," $1 < IDENTIFIER > )* #3 ">" ]<br>
   * f1 -> RegExprKind()<br>
   * f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]<br>
   * f3 -> ":"<br>
   * f4 -> "{"<br>
   * f5 -> RegExprSpec()<br>
   * f6 -> ( #0 "|" #1 RegExprSpec() )*<br>
   * f7 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final RegularExprProduction n, final A argu) {
    R nRes = null;
    // f0 -> [ %0 #0 "<" #1 "*" #2 ">"
    // .. .. | %1 #0 "<" #1 < IDENTIFIER >
    // .. .. . .. #2 ( $0 "," $1 < IDENTIFIER > )* #3 ">" ]
    n.f0.accept(this, argu);
    // f1 -> RegExprKind()
    n.f1.accept(this, argu);
    // f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]
    n.f2.accept(this, argu);
    // f3 -> ":"
    n.f3.accept(this, argu);
    // f4 -> "{"
    n.f4.accept(this, argu);
    // f5 -> RegExprSpec()
    n.f5.accept(this, argu);
    // f6 -> ( #0 "|" #1 RegExprSpec() )*
    n.f6.accept(this, argu);
    // f7 -> "}"
    n.f7.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link TokenManagerDecls} node, whose children are the following :
   * <p>
   * f0 -> "TOKEN_MGR_DECLS"<br>
   * f1 -> ":"<br>
   * f2 -> ClassOrInterfaceBody()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final TokenManagerDecls n, final A argu) {
    R nRes = null;
    // f0 -> "TOKEN_MGR_DECLS"
    n.f0.accept(this, argu);
    // f1 -> ":"
    n.f1.accept(this, argu);
    // f2 -> ClassOrInterfaceBody()
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link RegExprKind} node, whose children are the following :
   * <p>
   * f0 -> . %0 "TOKEN"<br>
   * .. .. | %1 "SPECIAL_TOKEN"<br>
   * .. .. | %2 "SKIP"<br>
   * .. .. | %3 "MORE"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final RegExprKind n, final A argu) {
    R nRes = null;
    // f0 -> . %0 "TOKEN"
    // .. .. | %1 "SPECIAL_TOKEN"
    // .. .. | %2 "SKIP"
    // .. .. | %3 "MORE"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link RegExprSpec} node, whose children are the following :
   * <p>
   * f0 -> RegularExpression()<br>
   * f1 -> [ Block() ]<br>
   * f2 -> [ #0 ":" #1 < IDENTIFIER > ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final RegExprSpec n, final A argu) {
    R nRes = null;
    // f0 -> RegularExpression()
    n.f0.accept(this, argu);
    // f1 -> [ Block() ]
    n.f1.accept(this, argu);
    // f2 -> [ #0 ":" #1 < IDENTIFIER > ]
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ExpansionChoices} node, whose children are the following :
   * <p>
   * f0 -> Expansion()<br>
   * f1 -> ( #0 "|" #1 Expansion() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ExpansionChoices n, final A argu) {
    R nRes = null;
    // f0 -> Expansion()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "|" #1 Expansion() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Expansion} node, whose children are the following :
   * <p>
   * f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?<br>
   * f1 -> ( ExpansionUnit() )+<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Expansion n, final A argu) {
    R nRes = null;
    // f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?
    n.f0.accept(this, argu);
    // f1 -> ( ExpansionUnit() )+
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link LocalLookahead} node, whose children are the following :
   * <p>
   * f0 -> [ IntegerLiteral() ]<br>
   * f1 -> [ "," ]<br>
   * f2 -> [ ExpansionChoices() ]<br>
   * f3 -> [ "," ]<br>
   * f4 -> [ #0 "{" #1 Expression() #2 "}" ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final LocalLookahead n, final A argu) {
    R nRes = null;
    // f0 -> [ IntegerLiteral() ]
    n.f0.accept(this, argu);
    // f1 -> [ "," ]
    n.f1.accept(this, argu);
    // f2 -> [ ExpansionChoices() ]
    n.f2.accept(this, argu);
    // f3 -> [ "," ]
    n.f3.accept(this, argu);
    // f4 -> [ #0 "{" #1 Expression() #2 "}" ]
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ExpansionUnit} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"<br>
   * .. .. | %1 Block()<br>
   * .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"<br>
   * .. .. | %3 ExpansionUnitInTCF()<br>
   * .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]<br>
   * .. .. . .. #1 ( &0 $0 Identifier() $1 Arguments()<br>
   * .. .. . .. .. | &1 $0 RegularExpression()<br>
   * .. .. . .. .. . .. $1 [ 0 "." 1 < IDENTIFIER > ] )<br>
   * .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?" )?<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ExpansionUnit n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
    // .. .. | %1 Block()
    // .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"
    // .. .. | %3 ExpansionUnitInTCF()
    // .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]
    // .. .. . .. #1 ( &0 $0 Identifier() $1 Arguments()
    // .. .. . .. .. | &1 $0 RegularExpression()
    // .. .. . .. .. . .. $1 [ 0 "." 1 < IDENTIFIER > ] )
    // .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?" )?
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ExpansionUnitInTCF} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> "{"<br>
   * f2 -> ExpansionChoices()<br>
   * f3 -> "}"<br>
   * f4 -> ( #0 "catch" #1 "(" #2 Name() #3 < IDENTIFIER > #4 ")" #5 Block() )*<br>
   * f5 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ExpansionUnitInTCF n, final A argu) {
    R nRes = null;
    // f0 -> "try"
    n.f0.accept(this, argu);
    // f1 -> "{"
    n.f1.accept(this, argu);
    // f2 -> ExpansionChoices()
    n.f2.accept(this, argu);
    // f3 -> "}"
    n.f3.accept(this, argu);
    // f4 -> ( #0 "catch" #1 "(" #2 Name() #3 < IDENTIFIER > #4 ")" #5 Block() )*
    n.f4.accept(this, argu);
    // f5 -> [ #0 "finally" #1 Block() ]
    n.f5.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link RegularExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 < LANGLE : "<" ><br>
   * .. .. . .. #1 [ $0 [ "#" ] $1 Identifier() $2 ":" ] #2 ComplexRegularExpressionChoices() #3 < RANGLE : ">" ><br>
   * .. .. | %2 #0 "<" #1 Identifier() #2 ">"<br>
   * .. .. | %3 #0 "<" #1 "EOF" #2 ">"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final RegularExpression n, final A argu) {
    R nRes = null;
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 < LANGLE : "<" >
    // .. .. . .. #1 [ $0 [ "#" ] $1 Identifier() $2 ":" ] #2 ComplexRegularExpressionChoices() #3 < RANGLE : ">" >
    // .. .. | %2 #0 "<" #1 Identifier() #2 ">"
    // .. .. | %3 #0 "<" #1 "EOF" #2 ">"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpressionChoices} node, whose children are the following :
   * <p>
   * f0 -> ComplexRegularExpression()<br>
   * f1 -> ( #0 "|" #1 ComplexRegularExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ComplexRegularExpressionChoices n, final A argu) {
    R nRes = null;
    // f0 -> ComplexRegularExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "|" #1 ComplexRegularExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpression} node, whose children are the following :
   * <p>
   * f0 -> ( ComplexRegularExpressionUnit() )+<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ComplexRegularExpression n, final A argu) {
    R nRes = null;
    // f0 -> ( ComplexRegularExpressionUnit() )+
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpressionUnit} node, whose children are the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<" #1 Identifier() #2 ">"<br>
   * .. .. | %2 CharacterList()<br>
   * .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?"<br>
   * .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()<br>
   * .. .. . .. .. . .. $2 [ 0 ","<br>
   * .. .. . .. .. . .. .. . 1 [ IntegerLiteral() ] ] $3 "}" )?<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ComplexRegularExpressionUnit n, final A argu) {
    R nRes = null;
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<" #1 Identifier() #2 ">"
    // .. .. | %2 CharacterList()
    // .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?"
    // .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()
    // .. .. . .. .. . .. $2 [ 0 ","
    // .. .. . .. .. . .. .. . 1 [ IntegerLiteral() ] ] $3 "}" )?
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link CharacterList} node, whose children are the following :
   * <p>
   * f0 -> [ "~" ]<br>
   * f1 -> "["<br>
   * f2 -> [ #0 CharacterDescriptor()<br>
   * .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]<br>
   * f3 -> "]"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final CharacterList n, final A argu) {
    R nRes = null;
    // f0 -> [ "~" ]
    n.f0.accept(this, argu);
    // f1 -> "["
    n.f1.accept(this, argu);
    // f2 -> [ #0 CharacterDescriptor()
    // .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]
    n.f2.accept(this, argu);
    // f3 -> "]"
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link CharacterDescriptor} node, whose children are the following :
   * <p>
   * f0 -> StringLiteral()<br>
   * f1 -> [ #0 "-" #1 StringLiteral() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final CharacterDescriptor n, final A argu) {
    R nRes = null;
    // f0 -> StringLiteral()
    n.f0.accept(this, argu);
    // f1 -> [ #0 "-" #1 StringLiteral() ]
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Identifier} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Identifier n, final A argu) {
    R nRes = null;
    // f0 -> < IDENTIFIER >
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link JavaIdentifier} node, whose children are the following :
   * <p>
   * f0 -> ( %00 < IDENTIFIER ><br>
   * .. .. | %01 "LOOKAHEAD"<br>
   * .. .. | %02 "IGNORE_CASE"<br>
   * .. .. | %03 "PARSER_BEGIN"<br>
   * .. .. | %04 "PARSER_END"<br>
   * .. .. | %05 "JAVACODE"<br>
   * .. .. | %06 "TOKEN"<br>
   * .. .. | %07 "SPECIAL_TOKEN"<br>
   * .. .. | %08 "MORE"<br>
   * .. .. | %09 "SKIP"<br>
   * .. .. | %10 "TOKEN_MGR_DECLS"<br>
   * .. .. | %11 "EOF" )<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final JavaIdentifier n, final A argu) {
    R nRes = null;
    // f0 -> ( %00 < IDENTIFIER >
    // .. .. | %01 "LOOKAHEAD"
    // .. .. | %02 "IGNORE_CASE"
    // .. .. | %03 "PARSER_BEGIN"
    // .. .. | %04 "PARSER_END"
    // .. .. | %05 "JAVACODE"
    // .. .. | %06 "TOKEN"
    // .. .. | %07 "SPECIAL_TOKEN"
    // .. .. | %08 "MORE"
    // .. .. | %09 "SKIP"
    // .. .. | %10 "TOKEN_MGR_DECLS"
    // .. .. | %11 "EOF" )
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link CompilationUnit} node, whose children are the following :
   * <p>
   * f0 -> [ PackageDeclaration() ]<br>
   * f1 -> ( ImportDeclaration() )*<br>
   * f2 -> ( TypeDeclaration() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final CompilationUnit n, final A argu) {
    R nRes = null;
    // f0 -> [ PackageDeclaration() ]
    n.f0.accept(this, argu);
    // f1 -> ( ImportDeclaration() )*
    n.f1.accept(this, argu);
    // f2 -> ( TypeDeclaration() )*
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link PackageDeclaration} node, whose children are the following :
   * <p>
   * f0 -> ( Annotation() )*<br>
   * f1 -> "package"<br>
   * f2 -> Name()<br>
   * f3 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final PackageDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> ( Annotation() )*
    n.f0.accept(this, argu);
    // f1 -> "package"
    n.f1.accept(this, argu);
    // f2 -> Name()
    n.f2.accept(this, argu);
    // f3 -> ";"
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ImportDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "import"<br>
   * f1 -> [ "static" ]<br>
   * f2 -> Name()<br>
   * f3 -> [ #0 "." #1 "*" ]<br>
   * f4 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ImportDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> "import"
    n.f0.accept(this, argu);
    // f1 -> [ "static" ]
    n.f1.accept(this, argu);
    // f2 -> Name()
    n.f2.accept(this, argu);
    // f3 -> [ #0 "." #1 "*" ]
    n.f3.accept(this, argu);
    // f4 -> ";"
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Modifiers} node, whose children are the following :
   * <p>
   * f0 -> ( ( %00 "public"<br>
   * .. .. . | %01 "static"<br>
   * .. .. . | %02 "protected"<br>
   * .. .. . | %03 "private"<br>
   * .. .. . | %04 "final"<br>
   * .. .. . | %05 "abstract"<br>
   * .. .. . | %06 "synchronized"<br>
   * .. .. . | %07 "native"<br>
   * .. .. . | %08 "transient"<br>
   * .. .. . | %09 "volatile"<br>
   * .. .. . | %10 "strictfp"<br>
   * .. .. . | %11 Annotation() ) )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Modifiers n, final A argu) {
    R nRes = null;
    // f0 -> ( ( %00 "public"
    // .. .. . | %01 "static"
    // .. .. . | %02 "protected"
    // .. .. . | %03 "private"
    // .. .. . | %04 "final"
    // .. .. . | %05 "abstract"
    // .. .. . | %06 "synchronized"
    // .. .. . | %07 "native"
    // .. .. . | %08 "transient"
    // .. .. . | %09 "volatile"
    // .. .. . | %10 "strictfp"
    // .. .. . | %11 Annotation() ) )*
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link TypeDeclaration} node, whose children are the following :
   * <p>
   * f0 -> . %0 ";"<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration() )<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final TypeDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> . %0 ";"
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration() )
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceDeclaration} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "class"<br>
   * .. .. | %1 "interface" )<br>
   * f1 -> < IDENTIFIER ><br>
   * f2 -> [ TypeParameters() ]<br>
   * f3 -> [ ExtendsList() ]<br>
   * f4 -> [ ImplementsList() ]<br>
   * f5 -> ClassOrInterfaceBody()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ClassOrInterfaceDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> ( %0 "class"
    // .. .. | %1 "interface" )
    n.f0.accept(this, argu);
    // f1 -> < IDENTIFIER >
    n.f1.accept(this, argu);
    // f2 -> [ TypeParameters() ]
    n.f2.accept(this, argu);
    // f3 -> [ ExtendsList() ]
    n.f3.accept(this, argu);
    // f4 -> [ ImplementsList() ]
    n.f4.accept(this, argu);
    // f5 -> ClassOrInterfaceBody()
    n.f5.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ExtendsList} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ExtendsList n, final A argu) {
    R nRes = null;
    // f0 -> "extends"
    n.f0.accept(this, argu);
    // f1 -> ClassOrInterfaceType()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ImplementsList} node, whose children are the following :
   * <p>
   * f0 -> "implements"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ImplementsList n, final A argu) {
    R nRes = null;
    // f0 -> "implements"
    n.f0.accept(this, argu);
    // f1 -> ClassOrInterfaceType()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link EnumDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "enum"<br>
   * f1 -> < IDENTIFIER ><br>
   * f2 -> [ ImplementsList() ]<br>
   * f3 -> EnumBody()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final EnumDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> "enum"
    n.f0.accept(this, argu);
    // f1 -> < IDENTIFIER >
    n.f1.accept(this, argu);
    // f2 -> [ ImplementsList() ]
    n.f2.accept(this, argu);
    // f3 -> EnumBody()
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link EnumBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 EnumConstant()<br>
   * .. .. . #1 ( $0 "," $1 EnumConstant() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> [ #0 ";"<br>
   * .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]<br>
   * f4 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final EnumBody n, final A argu) {
    R nRes = null;
    // f0 -> "{"
    n.f0.accept(this, argu);
    // f1 -> [ #0 EnumConstant()
    // .. .. . #1 ( $0 "," $1 EnumConstant() )* ]
    n.f1.accept(this, argu);
    // f2 -> [ "," ]
    n.f2.accept(this, argu);
    // f3 -> [ #0 ";"
    // .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]
    n.f3.accept(this, argu);
    // f4 -> "}"
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link EnumConstant} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> < IDENTIFIER ><br>
   * f2 -> [ Arguments() ]<br>
   * f3 -> [ ClassOrInterfaceBody() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final EnumConstant n, final A argu) {
    R nRes = null;
    // f0 -> Modifiers()
    n.f0.accept(this, argu);
    // f1 -> < IDENTIFIER >
    n.f1.accept(this, argu);
    // f2 -> [ Arguments() ]
    n.f2.accept(this, argu);
    // f3 -> [ ClassOrInterfaceBody() ]
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link TypeParameters} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeParameter()<br>
   * f2 -> ( #0 "," #1 TypeParameter() )*<br>
   * f3 -> ">"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final TypeParameters n, final A argu) {
    R nRes = null;
    // f0 -> "<"
    n.f0.accept(this, argu);
    // f1 -> TypeParameter()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "," #1 TypeParameter() )*
    n.f2.accept(this, argu);
    // f3 -> ">"
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link TypeParameter} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> [ TypeBound() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final TypeParameter n, final A argu) {
    R nRes = null;
    // f0 -> < IDENTIFIER >
    n.f0.accept(this, argu);
    // f1 -> [ TypeBound() ]
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link TypeBound} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final TypeBound n, final A argu) {
    R nRes = null;
    // f0 -> "extends"
    n.f0.accept(this, argu);
    // f1 -> ClassOrInterfaceType()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( ClassOrInterfaceBodyDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ClassOrInterfaceBody n, final A argu) {
    R nRes = null;
    // f0 -> "{"
    n.f0.accept(this, argu);
    // f1 -> ( ClassOrInterfaceBodyDeclaration() )*
    n.f1.accept(this, argu);
    // f2 -> "}"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceBodyDeclaration} node, whose children are the following :
   * <p>
   * f0 -> . %0 Initializer()<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 ConstructorDeclaration()<br>
   * .. .. . .. .. | &3 FieldDeclaration()<br>
   * .. .. . .. .. | &4 MethodDeclaration() )<br>
   * .. .. | %2 ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ClassOrInterfaceBodyDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> . %0 Initializer()
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 ConstructorDeclaration()
    // .. .. . .. .. | &3 FieldDeclaration()
    // .. .. . .. .. | &4 MethodDeclaration() )
    // .. .. | %2 ";"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link FieldDeclaration} node, whose children are the following :
   * <p>
   * f0 -> Type()<br>
   * f1 -> VariableDeclarator()<br>
   * f2 -> ( #0 "," #1 VariableDeclarator() )*<br>
   * f3 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final FieldDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> Type()
    n.f0.accept(this, argu);
    // f1 -> VariableDeclarator()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "," #1 VariableDeclarator() )*
    n.f2.accept(this, argu);
    // f3 -> ";"
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link VariableDeclarator} node, whose children are the following :
   * <p>
   * f0 -> VariableDeclaratorId()<br>
   * f1 -> [ #0 "=" #1 VariableInitializer() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final VariableDeclarator n, final A argu) {
    R nRes = null;
    // f0 -> VariableDeclaratorId()
    n.f0.accept(this, argu);
    // f1 -> [ #0 "=" #1 VariableInitializer() ]
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link VariableDeclaratorId} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final VariableDeclaratorId n, final A argu) {
    R nRes = null;
    // f0 -> < IDENTIFIER >
    n.f0.accept(this, argu);
    // f1 -> ( #0 "[" #1 "]" )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link VariableInitializer} node, whose children are the following :
   * <p>
   * f0 -> . %0 ArrayInitializer()<br>
   * .. .. | %1 Expression()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final VariableInitializer n, final A argu) {
    R nRes = null;
    // f0 -> . %0 ArrayInitializer()
    // .. .. | %1 Expression()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 VariableInitializer()<br>
   * .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ArrayInitializer n, final A argu) {
    R nRes = null;
    // f0 -> "{"
    n.f0.accept(this, argu);
    // f1 -> [ #0 VariableInitializer()
    // .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]
    n.f1.accept(this, argu);
    // f2 -> [ "," ]
    n.f2.accept(this, argu);
    // f3 -> "}"
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MethodDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> ResultType()<br>
   * f2 -> MethodDeclarator()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> ( %0 Block()<br>
   * .. .. | %1 ";" )<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MethodDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> [ TypeParameters() ]
    n.f0.accept(this, argu);
    // f1 -> ResultType()
    n.f1.accept(this, argu);
    // f2 -> MethodDeclarator()
    n.f2.accept(this, argu);
    // f3 -> [ #0 "throws" #1 NameList() ]
    n.f3.accept(this, argu);
    // f4 -> ( %0 Block()
    // .. .. | %1 ";" )
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MethodDeclarator} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> FormalParameters()<br>
   * f2 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MethodDeclarator n, final A argu) {
    R nRes = null;
    // f0 -> < IDENTIFIER >
    n.f0.accept(this, argu);
    // f1 -> FormalParameters()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "[" #1 "]" )*
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link FormalParameters} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ #0 FormalParameter()<br>
   * .. .. . #1 ( $0 "," $1 FormalParameter() )* ]<br>
   * f2 -> ")"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final FormalParameters n, final A argu) {
    R nRes = null;
    // f0 -> "("
    n.f0.accept(this, argu);
    // f1 -> [ #0 FormalParameter()
    // .. .. . #1 ( $0 "," $1 FormalParameter() )* ]
    n.f1.accept(this, argu);
    // f2 -> ")"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link FormalParameter} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> Type()<br>
   * f2 -> [ "..." ]<br>
   * f3 -> VariableDeclaratorId()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final FormalParameter n, final A argu) {
    R nRes = null;
    // f0 -> Modifiers()
    n.f0.accept(this, argu);
    // f1 -> Type()
    n.f1.accept(this, argu);
    // f2 -> [ "..." ]
    n.f2.accept(this, argu);
    // f3 -> VariableDeclaratorId()
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ConstructorDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> < IDENTIFIER ><br>
   * f2 -> FormalParameters()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> "{"<br>
   * f5 -> [ ExplicitConstructorInvocation() ]<br>
   * f6 -> ( BlockStatement() )*<br>
   * f7 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ConstructorDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> [ TypeParameters() ]
    n.f0.accept(this, argu);
    // f1 -> < IDENTIFIER >
    n.f1.accept(this, argu);
    // f2 -> FormalParameters()
    n.f2.accept(this, argu);
    // f3 -> [ #0 "throws" #1 NameList() ]
    n.f3.accept(this, argu);
    // f4 -> "{"
    n.f4.accept(this, argu);
    // f5 -> [ ExplicitConstructorInvocation() ]
    n.f5.accept(this, argu);
    // f6 -> ( BlockStatement() )*
    n.f6.accept(this, argu);
    // f7 -> "}"
    n.f7.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ExplicitConstructorInvocation} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "this" #1 Arguments() #2 ";"<br>
   * .. .. | %1 #0 [ $0 PrimaryExpression() $1 "." ] #1 "super" #2 Arguments() #3 ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ExplicitConstructorInvocation n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 "this" #1 Arguments() #2 ";"
    // .. .. | %1 #0 [ $0 PrimaryExpression() $1 "." ] #1 "super" #2 Arguments() #3 ";"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Initializer} node, whose children are the following :
   * <p>
   * f0 -> [ "static" ]<br>
   * f1 -> Block()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Initializer n, final A argu) {
    R nRes = null;
    // f0 -> [ "static" ]
    n.f0.accept(this, argu);
    // f1 -> Block()
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Type} node, whose children are the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 PrimitiveType()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Type n, final A argu) {
    R nRes = null;
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 PrimitiveType()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ReferenceType} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 PrimitiveType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )+<br>
   * .. .. | %1 #0 ClassOrInterfaceType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ReferenceType n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 PrimitiveType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )+
    // .. .. | %1 #0 ClassOrInterfaceType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceType} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> [ TypeArguments() ]<br>
   * f2 -> ( #0 "." #1 < IDENTIFIER ><br>
   * .. .. . #2 [ TypeArguments() ] )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ClassOrInterfaceType n, final A argu) {
    R nRes = null;
    // f0 -> < IDENTIFIER >
    n.f0.accept(this, argu);
    // f1 -> [ TypeArguments() ]
    n.f1.accept(this, argu);
    // f2 -> ( #0 "." #1 < IDENTIFIER >
    // .. .. . #2 [ TypeArguments() ] )*
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link TypeArguments} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeArgument()<br>
   * f2 -> ( #0 "," #1 TypeArgument() )*<br>
   * f3 -> ">"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final TypeArguments n, final A argu) {
    R nRes = null;
    // f0 -> "<"
    n.f0.accept(this, argu);
    // f1 -> TypeArgument()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "," #1 TypeArgument() )*
    n.f2.accept(this, argu);
    // f3 -> ">"
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link TypeArgument} node, whose children are the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 #0 "?"<br>
   * .. .. . .. #1 [ WildcardBounds() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final TypeArgument n, final A argu) {
    R nRes = null;
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 #0 "?"
    // .. .. . .. #1 [ WildcardBounds() ]
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link WildcardBounds} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "extends" #1 ReferenceType()<br>
   * .. .. | %1 #0 "super" #1 ReferenceType()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final WildcardBounds n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 "extends" #1 ReferenceType()
    // .. .. | %1 #0 "super" #1 ReferenceType()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link PrimitiveType} node, whose children are the following :
   * <p>
   * f0 -> . %0 "boolean"<br>
   * .. .. | %1 "char"<br>
   * .. .. | %2 "byte"<br>
   * .. .. | %3 "short"<br>
   * .. .. | %4 "int"<br>
   * .. .. | %5 "long"<br>
   * .. .. | %6 "float"<br>
   * .. .. | %7 "double"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final PrimitiveType n, final A argu) {
    R nRes = null;
    // f0 -> . %0 "boolean"
    // .. .. | %1 "char"
    // .. .. | %2 "byte"
    // .. .. | %3 "short"
    // .. .. | %4 "int"
    // .. .. | %5 "long"
    // .. .. | %6 "float"
    // .. .. | %7 "double"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ResultType} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "void"<br>
   * .. .. | %1 Type() )<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ResultType n, final A argu) {
    R nRes = null;
    // f0 -> ( %0 "void"
    // .. .. | %1 Type() )
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Name} node, whose children are the following :
   * <p>
   * f0 -> JavaIdentifier()<br>
   * f1 -> ( #0 "." #1 JavaIdentifier() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Name n, final A argu) {
    R nRes = null;
    // f0 -> JavaIdentifier()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "." #1 JavaIdentifier() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link NameList} node, whose children are the following :
   * <p>
   * f0 -> Name()<br>
   * f1 -> ( #0 "," #1 Name() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NameList n, final A argu) {
    R nRes = null;
    // f0 -> Name()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "," #1 Name() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Expression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalExpression()<br>
   * f1 -> [ #0 AssignmentOperator() #1 Expression() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Expression n, final A argu) {
    R nRes = null;
    // f0 -> ConditionalExpression()
    n.f0.accept(this, argu);
    // f1 -> [ #0 AssignmentOperator() #1 Expression() ]
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AssignmentOperator} node, whose children are the following :
   * <p>
   * f0 -> . %00 "="<br>
   * .. .. | %01 "*="<br>
   * .. .. | %02 "/="<br>
   * .. .. | %03 "%="<br>
   * .. .. | %04 "+="<br>
   * .. .. | %05 "-="<br>
   * .. .. | %06 "<<="<br>
   * .. .. | %07 ">>="<br>
   * .. .. | %08 ">>>="<br>
   * .. .. | %09 "&="<br>
   * .. .. | %10 "^="<br>
   * .. .. | %11 "|="<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AssignmentOperator n, final A argu) {
    R nRes = null;
    // f0 -> . %00 "="
    // .. .. | %01 "*="
    // .. .. | %02 "/="
    // .. .. | %03 "%="
    // .. .. | %04 "+="
    // .. .. | %05 "-="
    // .. .. | %06 "<<="
    // .. .. | %07 ">>="
    // .. .. | %08 ">>>="
    // .. .. | %09 "&="
    // .. .. | %10 "^="
    // .. .. | %11 "|="
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ConditionalExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalOrExpression()<br>
   * f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ConditionalExpression n, final A argu) {
    R nRes = null;
    // f0 -> ConditionalOrExpression()
    n.f0.accept(this, argu);
    // f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ConditionalOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalAndExpression()<br>
   * f1 -> ( #0 "||" #1 ConditionalAndExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ConditionalOrExpression n, final A argu) {
    R nRes = null;
    // f0 -> ConditionalAndExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "||" #1 ConditionalAndExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ConditionalAndExpression} node, whose children are the following :
   * <p>
   * f0 -> InclusiveOrExpression()<br>
   * f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ConditionalAndExpression n, final A argu) {
    R nRes = null;
    // f0 -> InclusiveOrExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link InclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ExclusiveOrExpression()<br>
   * f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final InclusiveOrExpression n, final A argu) {
    R nRes = null;
    // f0 -> ExclusiveOrExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ExclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> AndExpression()<br>
   * f1 -> ( #0 "^" #1 AndExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ExclusiveOrExpression n, final A argu) {
    R nRes = null;
    // f0 -> AndExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "^" #1 AndExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AndExpression} node, whose children are the following :
   * <p>
   * f0 -> EqualityExpression()<br>
   * f1 -> ( #0 "&" #1 EqualityExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AndExpression n, final A argu) {
    R nRes = null;
    // f0 -> EqualityExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "&" #1 EqualityExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link EqualityExpression} node, whose children are the following :
   * <p>
   * f0 -> InstanceOfExpression()<br>
   * f1 -> ( #0 ( %0 "=="<br>
   * .. .. . .. | %1 "!=" ) #1 InstanceOfExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final EqualityExpression n, final A argu) {
    R nRes = null;
    // f0 -> InstanceOfExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 ( %0 "=="
    // .. .. . .. | %1 "!=" ) #1 InstanceOfExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link InstanceOfExpression} node, whose children are the following :
   * <p>
   * f0 -> RelationalExpression()<br>
   * f1 -> [ #0 "instanceof" #1 Type() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final InstanceOfExpression n, final A argu) {
    R nRes = null;
    // f0 -> RelationalExpression()
    n.f0.accept(this, argu);
    // f1 -> [ #0 "instanceof" #1 Type() ]
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link RelationalExpression} node, whose children are the following :
   * <p>
   * f0 -> ShiftExpression()<br>
   * f1 -> ( #0 ( %0 "<"<br>
   * .. .. . .. | %1 ">"<br>
   * .. .. . .. | %2 "<="<br>
   * .. .. . .. | %3 ">=" ) #1 ShiftExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final RelationalExpression n, final A argu) {
    R nRes = null;
    // f0 -> ShiftExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 ( %0 "<"
    // .. .. . .. | %1 ">"
    // .. .. . .. | %2 "<="
    // .. .. . .. | %3 ">=" ) #1 ShiftExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ShiftExpression} node, whose children are the following :
   * <p>
   * f0 -> AdditiveExpression()<br>
   * f1 -> ( #0 ( %0 "<<"<br>
   * .. .. . .. | %1 RSIGNEDSHIFT()<br>
   * .. .. . .. | %2 RUNSIGNEDSHIFT() ) #1 AdditiveExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ShiftExpression n, final A argu) {
    R nRes = null;
    // f0 -> AdditiveExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 ( %0 "<<"
    // .. .. . .. | %1 RSIGNEDSHIFT()
    // .. .. . .. | %2 RUNSIGNEDSHIFT() ) #1 AdditiveExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AdditiveExpression} node, whose children are the following :
   * <p>
   * f0 -> MultiplicativeExpression()<br>
   * f1 -> ( #0 ( %0 "+"<br>
   * .. .. . .. | %1 "-" ) #1 MultiplicativeExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AdditiveExpression n, final A argu) {
    R nRes = null;
    // f0 -> MultiplicativeExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 ( %0 "+"
    // .. .. . .. | %1 "-" ) #1 MultiplicativeExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MultiplicativeExpression} node, whose children are the following :
   * <p>
   * f0 -> UnaryExpression()<br>
   * f1 -> ( #0 ( %0 "*"<br>
   * .. .. . .. | %1 "/"<br>
   * .. .. . .. | %2 "%" ) #1 UnaryExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MultiplicativeExpression n, final A argu) {
    R nRes = null;
    // f0 -> UnaryExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 ( %0 "*"
    // .. .. . .. | %1 "/"
    // .. .. . .. | %2 "%" ) #1 UnaryExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link UnaryExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "+"<br>
   * .. .. . .. .. | &1 "-" ) #1 UnaryExpression()<br>
   * .. .. | %1 PreIncrementExpression()<br>
   * .. .. | %2 PreDecrementExpression()<br>
   * .. .. | %3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final UnaryExpression n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 ( &0 "+"
    // .. .. . .. .. | &1 "-" ) #1 UnaryExpression()
    // .. .. | %1 PreIncrementExpression()
    // .. .. | %2 PreDecrementExpression()
    // .. .. | %3 UnaryExpressionNotPlusMinus()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link PreIncrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "++"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final PreIncrementExpression n, final A argu) {
    R nRes = null;
    // f0 -> "++"
    n.f0.accept(this, argu);
    // f1 -> PrimaryExpression()
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link PreDecrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "--"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final PreDecrementExpression n, final A argu) {
    R nRes = null;
    // f0 -> "--"
    n.f0.accept(this, argu);
    // f1 -> PrimaryExpression()
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link UnaryExpressionNotPlusMinus} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!" ) #1 UnaryExpression()<br>
   * .. .. | %1 CastExpression()<br>
   * .. .. | %2 PostfixExpression()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final UnaryExpressionNotPlusMinus n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 ( &0 "~"
    // .. .. . .. .. | &1 "!" ) #1 UnaryExpression()
    // .. .. | %1 CastExpression()
    // .. .. | %2 PostfixExpression()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link CastLookahead} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 PrimitiveType()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"<br>
   * .. .. | %2 #0 "(" #1 Type() #2 ")"<br>
   * .. .. . .. #3 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!"<br>
   * .. .. . .. .. | &2 "("<br>
   * .. .. . .. .. | &3 < IDENTIFIER ><br>
   * .. .. . .. .. | &4 "this"<br>
   * .. .. . .. .. | &5 "super"<br>
   * .. .. . .. .. | &6 "new"<br>
   * .. .. . .. .. | &7 Literal() )<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final CastLookahead n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 "(" #1 PrimitiveType()
    // .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"
    // .. .. | %2 #0 "(" #1 Type() #2 ")"
    // .. .. . .. #3 ( &0 "~"
    // .. .. . .. .. | &1 "!"
    // .. .. . .. .. | &2 "("
    // .. .. . .. .. | &3 < IDENTIFIER >
    // .. .. . .. .. | &4 "this"
    // .. .. . .. .. | &5 "super"
    // .. .. . .. .. | &6 "new"
    // .. .. . .. .. | &7 Literal() )
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link PostfixExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryExpression()<br>
   * f1 -> [ %0 "++"<br>
   * .. .. | %1 "--" ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final PostfixExpression n, final A argu) {
    R nRes = null;
    // f0 -> PrimaryExpression()
    n.f0.accept(this, argu);
    // f1 -> [ %0 "++"
    // .. .. | %1 "--" ]
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link CastExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final CastExpression n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
    // .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link PrimaryExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryPrefix()<br>
   * f1 -> ( PrimarySuffix() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final PrimaryExpression n, final A argu) {
    R nRes = null;
    // f0 -> PrimaryPrefix()
    n.f0.accept(this, argu);
    // f1 -> ( PrimarySuffix() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MemberSelector} node, whose children are the following :
   * <p>
   * f0 -> "."<br>
   * f1 -> TypeArguments()<br>
   * f2 -> < IDENTIFIER ><br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MemberSelector n, final A argu) {
    R nRes = null;
    // f0 -> "."
    n.f0.accept(this, argu);
    // f1 -> TypeArguments()
    n.f1.accept(this, argu);
    // f2 -> < IDENTIFIER >
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link PrimaryPrefix} node, whose children are the following :
   * <p>
   * f0 -> . %0 Literal()<br>
   * .. .. | %1 "this"<br>
   * .. .. | %2 #0 "super" #1 "." #2 < IDENTIFIER ><br>
   * .. .. | %3 #0 "(" #1 Expression() #2 ")"<br>
   * .. .. | %4 AllocationExpression()<br>
   * .. .. | %5 #0 ResultType() #1 "." #2 "class"<br>
   * .. .. | %6 Name()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final PrimaryPrefix n, final A argu) {
    R nRes = null;
    // f0 -> . %0 Literal()
    // .. .. | %1 "this"
    // .. .. | %2 #0 "super" #1 "." #2 < IDENTIFIER >
    // .. .. | %3 #0 "(" #1 Expression() #2 ")"
    // .. .. | %4 AllocationExpression()
    // .. .. | %5 #0 ResultType() #1 "." #2 "class"
    // .. .. | %6 Name()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link PrimarySuffix} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "." #1 "this"<br>
   * .. .. | %1 #0 "." #1 AllocationExpression()<br>
   * .. .. | %2 MemberSelector()<br>
   * .. .. | %3 #0 "[" #1 Expression() #2 "]"<br>
   * .. .. | %4 #0 "." #1 < IDENTIFIER ><br>
   * .. .. | %5 Arguments()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final PrimarySuffix n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 "." #1 "this"
    // .. .. | %1 #0 "." #1 AllocationExpression()
    // .. .. | %2 MemberSelector()
    // .. .. | %3 #0 "[" #1 Expression() #2 "]"
    // .. .. | %4 #0 "." #1 < IDENTIFIER >
    // .. .. | %5 Arguments()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Literal} node, whose children are the following :
   * <p>
   * f0 -> . %0 < INTEGER_LITERAL ><br>
   * .. .. | %1 < FLOATING_POINT_LITERAL ><br>
   * .. .. | %2 < CHARACTER_LITERAL ><br>
   * .. .. | %3 < STRING_LITERAL ><br>
   * .. .. | %4 BooleanLiteral()<br>
   * .. .. | %5 NullLiteral()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Literal n, final A argu) {
    R nRes = null;
    // f0 -> . %0 < INTEGER_LITERAL >
    // .. .. | %1 < FLOATING_POINT_LITERAL >
    // .. .. | %2 < CHARACTER_LITERAL >
    // .. .. | %3 < STRING_LITERAL >
    // .. .. | %4 BooleanLiteral()
    // .. .. | %5 NullLiteral()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link IntegerLiteral} node, whose children are the following :
   * <p>
   * f0 -> < INTEGER_LITERAL ><br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final IntegerLiteral n, final A argu) {
    R nRes = null;
    // f0 -> < INTEGER_LITERAL >
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link BooleanLiteral} node, whose children are the following :
   * <p>
   * f0 -> . %0 "true"<br>
   * .. .. | %1 "false"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final BooleanLiteral n, final A argu) {
    R nRes = null;
    // f0 -> . %0 "true"
    // .. .. | %1 "false"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link StringLiteral} node, whose children are the following :
   * <p>
   * f0 -> < STRING_LITERAL ><br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final StringLiteral n, final A argu) {
    R nRes = null;
    // f0 -> < STRING_LITERAL >
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link NullLiteral} node, whose children are the following :
   * <p>
   * f0 -> "null"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NullLiteral n, final A argu) {
    R nRes = null;
    // f0 -> "null"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Arguments} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ ArgumentList() ]<br>
   * f2 -> ")"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Arguments n, final A argu) {
    R nRes = null;
    // f0 -> "("
    n.f0.accept(this, argu);
    // f1 -> [ ArgumentList() ]
    n.f1.accept(this, argu);
    // f2 -> ")"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ArgumentList} node, whose children are the following :
   * <p>
   * f0 -> Expression()<br>
   * f1 -> ( #0 "," #1 Expression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ArgumentList n, final A argu) {
    R nRes = null;
    // f0 -> Expression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "," #1 Expression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AllocationExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()<br>
   * .. .. | %1 #0 "new" #1 ClassOrInterfaceType()<br>
   * .. .. . .. #2 [ TypeArguments() ]<br>
   * .. .. . .. #3 ( &0 ArrayDimsAndInits()<br>
   * .. .. . .. .. | &1 $0 Arguments()<br>
   * .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AllocationExpression n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
    // .. .. | %1 #0 "new" #1 ClassOrInterfaceType()
    // .. .. . .. #2 [ TypeArguments() ]
    // .. .. . .. #3 ( &0 ArrayDimsAndInits()
    // .. .. . .. .. | &1 $0 Arguments()
    // .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ArrayDimsAndInits} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   * .. .. | %1 #0 ( $0 "[" $1 "]" )+ #1 ArrayInitializer()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ArrayDimsAndInits n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    // .. .. | %1 #0 ( $0 "[" $1 "]" )+ #1 ArrayInitializer()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Statement} node, whose children are the following :
   * <p>
   * f0 -> . %00 LabeledStatement()<br>
   * .. .. | %01 AssertStatement()<br>
   * .. .. | %02 Block()<br>
   * .. .. | %03 EmptyStatement()<br>
   * .. .. | %04 #0 StatementExpression() #1 ";"<br>
   * .. .. | %05 SwitchStatement()<br>
   * .. .. | %06 IfStatement()<br>
   * .. .. | %07 WhileStatement()<br>
   * .. .. | %08 DoStatement()<br>
   * .. .. | %09 ForStatement()<br>
   * .. .. | %10 BreakStatement()<br>
   * .. .. | %11 ContinueStatement()<br>
   * .. .. | %12 ReturnStatement()<br>
   * .. .. | %13 ThrowStatement()<br>
   * .. .. | %14 SynchronizedStatement()<br>
   * .. .. | %15 TryStatement()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Statement n, final A argu) {
    R nRes = null;
    // f0 -> . %00 LabeledStatement()
    // .. .. | %01 AssertStatement()
    // .. .. | %02 Block()
    // .. .. | %03 EmptyStatement()
    // .. .. | %04 #0 StatementExpression() #1 ";"
    // .. .. | %05 SwitchStatement()
    // .. .. | %06 IfStatement()
    // .. .. | %07 WhileStatement()
    // .. .. | %08 DoStatement()
    // .. .. | %09 ForStatement()
    // .. .. | %10 BreakStatement()
    // .. .. | %11 ContinueStatement()
    // .. .. | %12 ReturnStatement()
    // .. .. | %13 ThrowStatement()
    // .. .. | %14 SynchronizedStatement()
    // .. .. | %15 TryStatement()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AssertStatement} node, whose children are the following :
   * <p>
   * f0 -> "assert"<br>
   * f1 -> Expression()<br>
   * f2 -> [ #0 ":" #1 Expression() ]<br>
   * f3 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AssertStatement n, final A argu) {
    R nRes = null;
    // f0 -> "assert"
    n.f0.accept(this, argu);
    // f1 -> Expression()
    n.f1.accept(this, argu);
    // f2 -> [ #0 ":" #1 Expression() ]
    n.f2.accept(this, argu);
    // f3 -> ";"
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link LabeledStatement} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> ":"<br>
   * f2 -> Statement()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final LabeledStatement n, final A argu) {
    R nRes = null;
    // f0 -> < IDENTIFIER >
    n.f0.accept(this, argu);
    // f1 -> ":"
    n.f1.accept(this, argu);
    // f2 -> Statement()
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Block} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( BlockStatement() )*<br>
   * f2 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Block n, final A argu) {
    R nRes = null;
    // f0 -> "{"
    n.f0.accept(this, argu);
    // f1 -> ( BlockStatement() )*
    n.f1.accept(this, argu);
    // f2 -> "}"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link BlockStatement} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"<br>
   * .. .. | %1 Statement()<br>
   * .. .. | %2 ClassOrInterfaceDeclaration()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final BlockStatement n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"
    // .. .. | %1 Statement()
    // .. .. | %2 ClassOrInterfaceDeclaration()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link LocalVariableDeclaration} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> Type()<br>
   * f2 -> VariableDeclarator()<br>
   * f3 -> ( #0 "," #1 VariableDeclarator() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final LocalVariableDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> Modifiers()
    n.f0.accept(this, argu);
    // f1 -> Type()
    n.f1.accept(this, argu);
    // f2 -> VariableDeclarator()
    n.f2.accept(this, argu);
    // f3 -> ( #0 "," #1 VariableDeclarator() )*
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link EmptyStatement} node, whose children are the following :
   * <p>
   * f0 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final EmptyStatement n, final A argu) {
    R nRes = null;
    // f0 -> ";"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link StatementExpression} node, whose children are the following :
   * <p>
   * f0 -> . %0 PreIncrementExpression()<br>
   * .. .. | %1 PreDecrementExpression()<br>
   * .. .. | %2 #0 PrimaryExpression()<br>
   * .. .. . .. #1 [ &0 "++"<br>
   * .. .. . .. .. | &1 "--"<br>
   * .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final StatementExpression n, final A argu) {
    R nRes = null;
    // f0 -> . %0 PreIncrementExpression()
    // .. .. | %1 PreDecrementExpression()
    // .. .. | %2 #0 PrimaryExpression()
    // .. .. . .. #1 [ &0 "++"
    // .. .. . .. .. | &1 "--"
    // .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link SwitchStatement} node, whose children are the following :
   * <p>
   * f0 -> "switch"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> "{"<br>
   * f5 -> ( #0 SwitchLabel()<br>
   * .. .. . #1 ( BlockStatement() )* )*<br>
   * f6 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final SwitchStatement n, final A argu) {
    R nRes = null;
    // f0 -> "switch"
    n.f0.accept(this, argu);
    // f1 -> "("
    n.f1.accept(this, argu);
    // f2 -> Expression()
    n.f2.accept(this, argu);
    // f3 -> ")"
    n.f3.accept(this, argu);
    // f4 -> "{"
    n.f4.accept(this, argu);
    // f5 -> ( #0 SwitchLabel()
    // .. .. . #1 ( BlockStatement() )* )*
    n.f5.accept(this, argu);
    // f6 -> "}"
    n.f6.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link SwitchLabel} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 "case" #1 Expression() #2 ":"<br>
   * .. .. | %1 #0 "default" #1 ":"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final SwitchLabel n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 "case" #1 Expression() #2 ":"
    // .. .. | %1 #0 "default" #1 ":"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link IfStatement} node, whose children are the following :
   * <p>
   * f0 -> "if"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   * f5 -> [ #0 "else" #1 Statement() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final IfStatement n, final A argu) {
    R nRes = null;
    // f0 -> "if"
    n.f0.accept(this, argu);
    // f1 -> "("
    n.f1.accept(this, argu);
    // f2 -> Expression()
    n.f2.accept(this, argu);
    // f3 -> ")"
    n.f3.accept(this, argu);
    // f4 -> Statement()
    n.f4.accept(this, argu);
    // f5 -> [ #0 "else" #1 Statement() ]
    n.f5.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link WhileStatement} node, whose children are the following :
   * <p>
   * f0 -> "while"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final WhileStatement n, final A argu) {
    R nRes = null;
    // f0 -> "while"
    n.f0.accept(this, argu);
    // f1 -> "("
    n.f1.accept(this, argu);
    // f2 -> Expression()
    n.f2.accept(this, argu);
    // f3 -> ")"
    n.f3.accept(this, argu);
    // f4 -> Statement()
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link DoStatement} node, whose children are the following :
   * <p>
   * f0 -> "do"<br>
   * f1 -> Statement()<br>
   * f2 -> "while"<br>
   * f3 -> "("<br>
   * f4 -> Expression()<br>
   * f5 -> ")"<br>
   * f6 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final DoStatement n, final A argu) {
    R nRes = null;
    // f0 -> "do"
    n.f0.accept(this, argu);
    // f1 -> Statement()
    n.f1.accept(this, argu);
    // f2 -> "while"
    n.f2.accept(this, argu);
    // f3 -> "("
    n.f3.accept(this, argu);
    // f4 -> Expression()
    n.f4.accept(this, argu);
    // f5 -> ")"
    n.f5.accept(this, argu);
    // f6 -> ";"
    n.f6.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ForStatement} node, whose children are the following :
   * <p>
   * f0 -> "for"<br>
   * f1 -> "("<br>
   * f2 -> ( %0 #0 Modifiers() #1 Type() #2 < IDENTIFIER > #3 ":" #4 Expression()<br>
   * .. .. | %1 #0 [ ForInit() ] #1 ";"<br>
   * .. .. . .. #2 [ Expression() ] #3 ";"<br>
   * .. .. . .. #4 [ ForUpdate() ] )<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ForStatement n, final A argu) {
    R nRes = null;
    // f0 -> "for"
    n.f0.accept(this, argu);
    // f1 -> "("
    n.f1.accept(this, argu);
    // f2 -> ( %0 #0 Modifiers() #1 Type() #2 < IDENTIFIER > #3 ":" #4 Expression()
    // .. .. | %1 #0 [ ForInit() ] #1 ";"
    // .. .. . .. #2 [ Expression() ] #3 ";"
    // .. .. . .. #4 [ ForUpdate() ] )
    n.f2.accept(this, argu);
    // f3 -> ")"
    n.f3.accept(this, argu);
    // f4 -> Statement()
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ForInit} node, whose children are the following :
   * <p>
   * f0 -> . %0 LocalVariableDeclaration()<br>
   * .. .. | %1 StatementExpressionList()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ForInit n, final A argu) {
    R nRes = null;
    // f0 -> . %0 LocalVariableDeclaration()
    // .. .. | %1 StatementExpressionList()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link StatementExpressionList} node, whose children are the following :
   * <p>
   * f0 -> StatementExpression()<br>
   * f1 -> ( #0 "," #1 StatementExpression() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final StatementExpressionList n, final A argu) {
    R nRes = null;
    // f0 -> StatementExpression()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "," #1 StatementExpression() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ForUpdate} node, whose children are the following :
   * <p>
   * f0 -> StatementExpressionList()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ForUpdate n, final A argu) {
    R nRes = null;
    // f0 -> StatementExpressionList()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link BreakStatement} node, whose children are the following :
   * <p>
   * f0 -> "break"<br>
   * f1 -> [ < IDENTIFIER > ]<br>
   * f2 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final BreakStatement n, final A argu) {
    R nRes = null;
    // f0 -> "break"
    n.f0.accept(this, argu);
    // f1 -> [ < IDENTIFIER > ]
    n.f1.accept(this, argu);
    // f2 -> ";"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ContinueStatement} node, whose children are the following :
   * <p>
   * f0 -> "continue"<br>
   * f1 -> [ < IDENTIFIER > ]<br>
   * f2 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ContinueStatement n, final A argu) {
    R nRes = null;
    // f0 -> "continue"
    n.f0.accept(this, argu);
    // f1 -> [ < IDENTIFIER > ]
    n.f1.accept(this, argu);
    // f2 -> ";"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ReturnStatement} node, whose children are the following :
   * <p>
   * f0 -> "return"<br>
   * f1 -> [ Expression() ]<br>
   * f2 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ReturnStatement n, final A argu) {
    R nRes = null;
    // f0 -> "return"
    n.f0.accept(this, argu);
    // f1 -> [ Expression() ]
    n.f1.accept(this, argu);
    // f2 -> ";"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link ThrowStatement} node, whose children are the following :
   * <p>
   * f0 -> "throw"<br>
   * f1 -> Expression()<br>
   * f2 -> ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final ThrowStatement n, final A argu) {
    R nRes = null;
    // f0 -> "throw"
    n.f0.accept(this, argu);
    // f1 -> Expression()
    n.f1.accept(this, argu);
    // f2 -> ";"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link SynchronizedStatement} node, whose children are the following :
   * <p>
   * f0 -> "synchronized"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Block()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final SynchronizedStatement n, final A argu) {
    R nRes = null;
    // f0 -> "synchronized"
    n.f0.accept(this, argu);
    // f1 -> "("
    n.f1.accept(this, argu);
    // f2 -> Expression()
    n.f2.accept(this, argu);
    // f3 -> ")"
    n.f3.accept(this, argu);
    // f4 -> Block()
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link TryStatement} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> Block()<br>
   * f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*<br>
   * f3 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final TryStatement n, final A argu) {
    R nRes = null;
    // f0 -> "try"
    n.f0.accept(this, argu);
    // f1 -> Block()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*
    n.f2.accept(this, argu);
    // f3 -> [ #0 "finally" #1 Block() ]
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link RUNSIGNEDSHIFT} node, whose children are the following :
   * <p>
   * f0 -> ">"<br>
   * f1 -> ">"<br>
   * f2 -> ">"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final RUNSIGNEDSHIFT n, final A argu) {
    R nRes = null;
    // f0 -> ">"
    n.f0.accept(this, argu);
    // f1 -> ">"
    n.f1.accept(this, argu);
    // f2 -> ">"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link RSIGNEDSHIFT} node, whose children are the following :
   * <p>
   * f0 -> ">"<br>
   * f1 -> ">"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final RSIGNEDSHIFT n, final A argu) {
    R nRes = null;
    // f0 -> ">"
    n.f0.accept(this, argu);
    // f1 -> ">"
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link Annotation} node, whose children are the following :
   * <p>
   * f0 -> . %0 NormalAnnotation()<br>
   * .. .. | %1 SingleMemberAnnotation()<br>
   * .. .. | %2 MarkerAnnotation()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final Annotation n, final A argu) {
    R nRes = null;
    // f0 -> . %0 NormalAnnotation()
    // .. .. | %1 SingleMemberAnnotation()
    // .. .. | %2 MarkerAnnotation()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link NormalAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> [ MemberValuePairs() ]<br>
   * f4 -> ")"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final NormalAnnotation n, final A argu) {
    R nRes = null;
    // f0 -> "@"
    n.f0.accept(this, argu);
    // f1 -> Name()
    n.f1.accept(this, argu);
    // f2 -> "("
    n.f2.accept(this, argu);
    // f3 -> [ MemberValuePairs() ]
    n.f3.accept(this, argu);
    // f4 -> ")"
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MarkerAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MarkerAnnotation n, final A argu) {
    R nRes = null;
    // f0 -> "@"
    n.f0.accept(this, argu);
    // f1 -> Name()
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link SingleMemberAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> MemberValue()<br>
   * f4 -> ")"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final SingleMemberAnnotation n, final A argu) {
    R nRes = null;
    // f0 -> "@"
    n.f0.accept(this, argu);
    // f1 -> Name()
    n.f1.accept(this, argu);
    // f2 -> "("
    n.f2.accept(this, argu);
    // f3 -> MemberValue()
    n.f3.accept(this, argu);
    // f4 -> ")"
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MemberValuePairs} node, whose children are the following :
   * <p>
   * f0 -> MemberValuePair()<br>
   * f1 -> ( #0 "," #1 MemberValuePair() )*<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MemberValuePairs n, final A argu) {
    R nRes = null;
    // f0 -> MemberValuePair()
    n.f0.accept(this, argu);
    // f1 -> ( #0 "," #1 MemberValuePair() )*
    n.f1.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MemberValuePair} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> "="<br>
   * f2 -> MemberValue()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MemberValuePair n, final A argu) {
    R nRes = null;
    // f0 -> < IDENTIFIER >
    n.f0.accept(this, argu);
    // f1 -> "="
    n.f1.accept(this, argu);
    // f2 -> MemberValue()
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MemberValue} node, whose children are the following :
   * <p>
   * f0 -> . %0 Annotation()<br>
   * .. .. | %1 MemberValueArrayInitializer()<br>
   * .. .. | %2 ConditionalExpression()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MemberValue n, final A argu) {
    R nRes = null;
    // f0 -> . %0 Annotation()
    // .. .. | %1 MemberValueArrayInitializer()
    // .. .. | %2 ConditionalExpression()
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link MemberValueArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> MemberValue()<br>
   * f2 -> ( #0 "," #1 MemberValue() )*<br>
   * f3 -> [ "," ]<br>
   * f4 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final MemberValueArrayInitializer n, final A argu) {
    R nRes = null;
    // f0 -> "{"
    n.f0.accept(this, argu);
    // f1 -> MemberValue()
    n.f1.accept(this, argu);
    // f2 -> ( #0 "," #1 MemberValue() )*
    n.f2.accept(this, argu);
    // f3 -> [ "," ]
    n.f3.accept(this, argu);
    // f4 -> "}"
    n.f4.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> "interface"<br>
   * f2 -> < IDENTIFIER ><br>
   * f3 -> AnnotationTypeBody()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AnnotationTypeDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> "@"
    n.f0.accept(this, argu);
    // f1 -> "interface"
    n.f1.accept(this, argu);
    // f2 -> < IDENTIFIER >
    n.f2.accept(this, argu);
    // f3 -> AnnotationTypeBody()
    n.f3.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( AnnotationTypeMemberDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AnnotationTypeBody n, final A argu) {
    R nRes = null;
    // f0 -> "{"
    n.f0.accept(this, argu);
    // f1 -> ( AnnotationTypeMemberDeclaration() )*
    n.f1.accept(this, argu);
    // f2 -> "}"
    n.f2.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeMemberDeclaration} node, whose children are the following :
   * <p>
   * f0 -> . %0 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 $0 Type() $1 < IDENTIFIER > $2 "(" $3 ")"<br>
   * .. .. . .. .. $4 [ DefaultValue() ] $5 ";"<br>
   * .. .. . .. .. | &1 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &2 EnumDeclaration()<br>
   * .. .. . .. .. | &3 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration() )<br>
   * .. .. | %1 ";"<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final AnnotationTypeMemberDeclaration n, final A argu) {
    R nRes = null;
    // f0 -> . %0 #0 Modifiers()
    // .. .. . .. #1 ( &0 $0 Type() $1 < IDENTIFIER > $2 "(" $3 ")"
    // .. .. . .. .. $4 [ DefaultValue() ] $5 ";"
    // .. .. . .. .. | &1 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &2 EnumDeclaration()
    // .. .. . .. .. | &3 AnnotationTypeDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration() )
    // .. .. | %1 ";"
    n.f0.accept(this, argu);
    return nRes;
  }

  /**
   * Visits a {@link DefaultValue} node, whose children are the following :
   * <p>
   * f0 -> "default"<br>
   * f1 -> MemberValue()<br>
   *
   * @param n the node to visit
   * @param argu the user argument
   * @return the user return information
   */
  public R visit(final DefaultValue n, final A argu) {
    R nRes = null;
    // f0 -> "default"
    n.f0.accept(this, argu);
    // f1 -> MemberValue()
    n.f1.accept(this, argu);
    return nRes;
  }

}
