/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.format;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.format.DateFormatter;
import net.sourceforge.stripes.format.EnumFormatter;
import net.sourceforge.stripes.format.Formatter;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.format.NumberFormatter;
import net.sourceforge.stripes.format.ObjectFormatter;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFormatterFactory
implements FormatterFactory {
    private static final Log log = Log.getInstance(DefaultFormatterFactory.class);
    private Map<Class<?>, Class<? extends Formatter<?>>> formatters = new ConcurrentHashMap();
    private Map<Class<?>, Class<? extends Formatter<?>>> classCache = new ConcurrentHashMap();
    private Configuration configuration;

    @Override
    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        this.add(Date.class, DateFormatter.class);
        this.add(Number.class, NumberFormatter.class);
        this.add(Enum.class, EnumFormatter.class);
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Map<Class<?>, Class<? extends Formatter<?>>> getFormatters() {
        return this.formatters;
    }

    @Override
    public void add(Class<?> targetType, Class<? extends Formatter<?>> formatterClass) {
        this.formatters.put(targetType, formatterClass);
        this.clearCache();
    }

    protected void clearCache() {
        log.debug("Clearing formatter cache");
        this.classCache.clear();
    }

    @Override
    public Formatter<?> getFormatter(Class<?> clazz, Locale locale, String formatType, String formatPattern) {
        Class<? extends Formatter<?>> formatterClass = this.findFormatterClass(clazz);
        if (formatterClass != null) {
            try {
                return this.getInstance(formatterClass, formatType, formatPattern, locale);
            }
            catch (Exception e) {
                log.error(e, "Unable to instantiate Formatter ", formatterClass);
                return null;
            }
        }
        log.trace("Couldn't find a formatter for ", clazz);
        return null;
    }

    protected Class<? extends Formatter<?>> findFormatterClass(Class<?> targetClass) {
        Class<Formatter<?>> formatterClass = this.findInSuperclasses(targetClass);
        if (formatterClass != null) {
            return formatterClass;
        }
        formatterClass = this.findInInterfaces(targetClass, targetClass.getInterfaces());
        if (formatterClass != null) {
            return formatterClass;
        }
        return this.cacheFormatterClass(targetClass, ObjectFormatter.class);
    }

    protected Class<? extends Formatter<?>> findInSuperclasses(Class<?> targetClass) {
        Class<Formatter<?>> formatterClass = this.formatters.get(targetClass);
        if (formatterClass != null) {
            return formatterClass;
        }
        formatterClass = this.classCache.get(targetClass);
        if (formatterClass != null) {
            return formatterClass;
        }
        for (Class<?> iface : targetClass.getInterfaces()) {
            formatterClass = this.formatters.get(iface);
            if (formatterClass != null) {
                return this.cacheFormatterClass(targetClass, formatterClass);
            }
            formatterClass = this.classCache.get(iface);
            if (formatterClass == null) continue;
            return this.cacheFormatterClass(targetClass, formatterClass);
        }
        for (Annotation annotation : targetClass.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!this.formatters.containsKey(annotationType)) continue;
            return this.cacheFormatterClass(targetClass, this.formatters.get(annotationType));
        }
        Class<?> parent = targetClass.getSuperclass();
        if (parent != null && (formatterClass = this.findInSuperclasses(parent)) != null) {
            return this.cacheFormatterClass(targetClass, formatterClass);
        }
        return null;
    }

    protected Class<? extends Formatter<?>> findInInterfaces(Class<?> targetClass, Class<?> ... ifaces) {
        Class<Formatter<?>> formatterClass = null;
        for (Class<?> iface : ifaces) {
            formatterClass = this.formatters.get(iface);
            if (formatterClass != null) {
                return this.cacheFormatterClass(targetClass, formatterClass);
            }
            formatterClass = this.classCache.get(iface);
            if (formatterClass != null) {
                return this.cacheFormatterClass(targetClass, formatterClass);
            }
            formatterClass = this.findInInterfaces(targetClass, iface.getInterfaces());
            if (formatterClass == null) continue;
            return this.cacheFormatterClass(targetClass, formatterClass);
        }
        return null;
    }

    protected Class<? extends Formatter<?>> cacheFormatterClass(Class<?> clazz, Class<? extends Formatter<?>> formatterClass) {
        log.debug("Caching Formatter for ", clazz, " => ", formatterClass);
        this.classCache.put(clazz, formatterClass);
        return formatterClass;
    }

    public Formatter<?> getInstance(Class<? extends Formatter<?>> clazz, String formatType, String formatPattern, Locale locale) throws Exception {
        Formatter<?> formatter = clazz.newInstance();
        formatter.setFormatType(formatType);
        formatter.setFormatPattern(formatPattern);
        formatter.setLocale(locale);
        formatter.init();
        return formatter;
    }
}

