/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.config;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.stripes.config.ConfigurableComponent;
import net.sourceforge.stripes.config.DefaultConfiguration;
import net.sourceforge.stripes.config.TargetTypes;
import net.sourceforge.stripes.controller.ActionBeanContextFactory;
import net.sourceforge.stripes.controller.ActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.multipart.MultipartWrapperFactory;
import net.sourceforge.stripes.exception.ExceptionHandler;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.format.Formatter;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.localization.LocalePicker;
import net.sourceforge.stripes.localization.LocalizationBundleFactory;
import net.sourceforge.stripes.tag.PopulationStrategy;
import net.sourceforge.stripes.tag.TagErrorRendererFactory;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.TypeConverterFactory;
import net.sourceforge.stripes.validation.ValidationMetadataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeConfiguration
extends DefaultConfiguration {
    private static final Log log = Log.getInstance(RuntimeConfiguration.class);
    public static final String DEBUG_MODE = "Stripes.DebugMode";
    public static final String ACTION_RESOLVER = "ActionResolver.Class";
    public static final String ACTION_BEAN_PROPERTY_BINDER = "ActionBeanPropertyBinder.Class";
    public static final String ACTION_BEAN_CONTEXT_FACTORY = "ActionBeanContextFactory.Class";
    public static final String TYPE_CONVERTER_FACTORY = "TypeConverterFactory.Class";
    public static final String LOCALIZATION_BUNDLE_FACTORY = "LocalizationBundleFactory.Class";
    public static final String LOCALE_PICKER = "LocalePicker.Class";
    public static final String FORMATTER_FACTORY = "FormatterFactory.Class";
    public static final String TAG_ERROR_RENDERER_FACTORY = "TagErrorRendererFactory.Class";
    public static final String POPULATION_STRATEGY = "PopulationStrategy.Class";
    public static final String EXCEPTION_HANDLER = "ExceptionHandler.Class";
    public static final String MULTIPART_WRAPPER_FACTORY = "MultipartWrapperFactory.Class";
    public static final String VALIDATION_METADATA_PROVIDER = "ValidationMetadataProvider.Class";
    public static final String CORE_INTERCEPTOR_LIST = "CoreInterceptor.Classes";
    public static final String INTERCEPTOR_LIST = "Interceptor.Classes";

    @Override
    protected Boolean initDebugMode() {
        try {
            return Boolean.valueOf(this.getBootstrapPropertyResolver().getProperty(DEBUG_MODE).toLowerCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected ActionResolver initActionResolver() {
        return this.initializeComponent(ActionResolver.class, ACTION_RESOLVER);
    }

    @Override
    protected ActionBeanPropertyBinder initActionBeanPropertyBinder() {
        return this.initializeComponent(ActionBeanPropertyBinder.class, ACTION_BEAN_PROPERTY_BINDER);
    }

    @Override
    protected ActionBeanContextFactory initActionBeanContextFactory() {
        return this.initializeComponent(ActionBeanContextFactory.class, ACTION_BEAN_CONTEXT_FACTORY);
    }

    @Override
    protected TypeConverterFactory initTypeConverterFactory() {
        return this.initializeComponent(TypeConverterFactory.class, TYPE_CONVERTER_FACTORY);
    }

    @Override
    protected LocalizationBundleFactory initLocalizationBundleFactory() {
        return this.initializeComponent(LocalizationBundleFactory.class, LOCALIZATION_BUNDLE_FACTORY);
    }

    @Override
    protected LocalePicker initLocalePicker() {
        return this.initializeComponent(LocalePicker.class, LOCALE_PICKER);
    }

    @Override
    protected FormatterFactory initFormatterFactory() {
        return this.initializeComponent(FormatterFactory.class, FORMATTER_FACTORY);
    }

    @Override
    protected TagErrorRendererFactory initTagErrorRendererFactory() {
        return this.initializeComponent(TagErrorRendererFactory.class, TAG_ERROR_RENDERER_FACTORY);
    }

    @Override
    protected PopulationStrategy initPopulationStrategy() {
        return this.initializeComponent(PopulationStrategy.class, POPULATION_STRATEGY);
    }

    @Override
    protected ExceptionHandler initExceptionHandler() {
        return this.initializeComponent(ExceptionHandler.class, EXCEPTION_HANDLER);
    }

    @Override
    protected MultipartWrapperFactory initMultipartWrapperFactory() {
        return this.initializeComponent(MultipartWrapperFactory.class, MULTIPART_WRAPPER_FACTORY);
    }

    @Override
    protected ValidationMetadataProvider initValidationMetadataProvider() {
        return this.initializeComponent(ValidationMetadataProvider.class, VALIDATION_METADATA_PROVIDER);
    }

    @Override
    protected Map<LifecycleStage, Collection<Interceptor>> initCoreInterceptors() {
        List<Class<?>> coreInterceptorClasses = this.getBootstrapPropertyResolver().getClassPropertyList(CORE_INTERCEPTOR_LIST);
        if (coreInterceptorClasses.size() == 0) {
            return super.initCoreInterceptors();
        }
        return this.initInterceptors(coreInterceptorClasses);
    }

    @Override
    protected Map<LifecycleStage, Collection<Interceptor>> initInterceptors() {
        return this.initInterceptors(this.getBootstrapPropertyResolver().getClassPropertyList(INTERCEPTOR_LIST, Interceptor.class));
    }

    protected Map<LifecycleStage, Collection<Interceptor>> initInterceptors(List classes) {
        HashMap<LifecycleStage, Collection<Interceptor>> map = new HashMap<LifecycleStage, Collection<Interceptor>>();
        for (Object type : classes) {
            try {
                Interceptor interceptor = (Interceptor)((Class)type).newInstance();
                this.addInterceptor(map, interceptor);
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Could not instantiate configured Interceptor [" + type.getClass().getName() + "].", e);
            }
        }
        return map;
    }

    protected <T extends ConfigurableComponent> T initializeComponent(Class<T> componentType, String propertyName) {
        Class<T> clazz = this.getBootstrapPropertyResolver().getClassProperty(propertyName, componentType);
        if (clazz != null) {
            try {
                ConfigurableComponent component = (ConfigurableComponent)clazz.newInstance();
                component.init(this);
                return (T)component;
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Could not instantiate configured " + componentType.getSimpleName() + " of type [" + clazz.getSimpleName() + "]. Please check " + "the configuration parameters specified in your web.xml.", e);
            }
        }
        return null;
    }

    @Override
    public void init() {
        super.init();
        List<Class<Formatter>> formatters = this.getBootstrapPropertyResolver().getClassPropertyList(Formatter.class);
        for (Class<Formatter> formatter : formatters) {
            TargetTypes targetTypes;
            Type[] typeArguments = ReflectUtil.getActualTypeArguments(formatter, Formatter.class);
            log.trace("Found Formatter [", formatter, "] - type parameters: ", typeArguments);
            if (typeArguments != null && typeArguments.length == 1 && !typeArguments[0].equals(Object.class)) {
                if (typeArguments[0] instanceof Class) {
                    log.debug("Adding auto-discovered Formatter [", formatter, "] for [", typeArguments[0], "] (from type parameter)");
                    this.getFormatterFactory().add((Class)typeArguments[0], formatter);
                } else {
                    log.warn("Type parameter for non-abstract Formatter [", formatter, "] is not a class.");
                }
            }
            if ((targetTypes = formatter.getAnnotation(TargetTypes.class)) == null) continue;
            for (Class<?> targetType : targetTypes.value()) {
                log.debug("Adding auto-discovered Formatter [", formatter, "] for [", targetType, "] (from TargetTypes annotation)");
                this.getFormatterFactory().add(targetType, formatter);
            }
        }
        List<Class<TypeConverter>> typeConverters = this.getBootstrapPropertyResolver().getClassPropertyList(TypeConverter.class);
        for (Class<TypeConverter> typeConverter : typeConverters) {
            TargetTypes targetTypes;
            Type[] typeArguments = ReflectUtil.getActualTypeArguments(typeConverter, TypeConverter.class);
            log.trace("Found TypeConverter [", typeConverter, "] - type parameters: ", typeArguments);
            if (typeArguments != null && typeArguments.length == 1 && !typeArguments[0].equals(Object.class)) {
                if (typeArguments[0] instanceof Class) {
                    log.debug("Adding auto-discovered TypeConverter [", typeConverter, "] for [", typeArguments[0], "] (from type parameter)");
                    this.getTypeConverterFactory().add((Class)typeArguments[0], typeConverter);
                } else {
                    log.warn("Type parameter for non-abstract TypeConverter [", typeConverter, "] is not a class.");
                }
            }
            if ((targetTypes = typeConverter.getAnnotation(TargetTypes.class)) == null) continue;
            for (Class<?> targetType : targetTypes.value()) {
                log.debug("Adding auto-discovered TypeConverter [", typeConverter, "] for [", targetType, "] (from TargetTypes annotation)");
                this.getTypeConverterFactory().add(targetType, typeConverter);
            }
        }
    }
}

