/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.ant;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;

public class SeleneseAntTask
extends Task {
    private static final String SELENIUM_JAVASCRIPT_DIR = "selenium.javascript.dir";
    private int port = 4444;
    private int timeoutInSeconds = 1800;
    private boolean slowResources;
    private boolean multiWindow;
    private String browser;
    private String startURL;
    private File suite;
    private File results;
    private File outputDir;
    private boolean haltOnFailure = true;
    private String failureProperty;
    private static final Pattern browserPattern = Pattern.compile("\\*(\\w+)");

    public void execute() {
        this.checkForNulls();
        this.checkResultsFile();
        this.checkForJavaScriptCoreDir();
        SeleniumServer server = null;
        try {
            server = new SeleniumServer(this.port, this.slowResources, this.multiWindow);
            server.start();
            HTMLLauncher launcher = new HTMLLauncher(server);
            String result = launcher.runHTMLSuite(this.browser, this.startURL, this.suite, this.results, this.timeoutInSeconds, this.multiWindow);
            server.stop();
            if (!"PASSED".equals(result)) {
                String errorMessage = "Tests failed, see result file for details: " + this.results.getAbsolutePath();
                if (this.haltOnFailure) {
                    throw new BuildException(errorMessage);
                }
                this.log(errorMessage, 0);
                if (this.failureProperty != null) {
                    this.getProject().setProperty(this.failureProperty, "true");
                }
            }
        }
        catch (Exception e) {
            if (server != null) {
                server.stop();
            }
            throw new BuildException(e);
        }
    }

    private void checkForJavaScriptCoreDir() {
        if (System.getProperties().containsKey(SELENIUM_JAVASCRIPT_DIR)) {
            return;
        }
        String antProperty = this.getProject().getProperty(SELENIUM_JAVASCRIPT_DIR);
        if (antProperty != null) {
            System.setProperty(SELENIUM_JAVASCRIPT_DIR, antProperty);
        }
    }

    private void checkForNulls() {
        if (this.browser == null) {
            throw new BuildException("You must specify a browser");
        }
        if (this.startURL == null) {
            throw new BuildException("You must specify a start URL");
        }
        if (this.suite == null) {
            throw new BuildException("You must specify a suite file");
        }
        if (this.outputDir == null) {
            this.outputDir = this.getProject().getBaseDir();
        }
        if (this.results == null) {
            String options = (this.multiWindow ? "multiWindow-" : "") + (this.slowResources ? "slowResources-" : "");
            String name = "results-" + this.extractUsableBrowserName() + '-' + options + this.suite.getName();
            this.setResults(new File(name));
        }
    }

    private String extractUsableBrowserName() {
        Matcher m = browserPattern.matcher(this.browser);
        if (m.find()) {
            return m.group(1);
        }
        throw new BuildException("Couldn't parse browser string " + this.browser + "to generate default results file. Please specify a results file.");
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public void setMultiWindow(boolean multiWindow) {
        this.multiWindow = multiWindow;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setResults(File results) {
        this.results = results;
    }

    private void checkResultsFile() {
        if (!this.results.isAbsolute()) {
            this.results = new File(this.outputDir, this.results.getPath());
        }
        try {
            this.results.createNewFile();
        }
        catch (IOException e) {
            throw new BuildException("can't write to results file: " + this.results.getAbsolutePath(), e);
        }
        if (!this.results.canWrite()) {
            throw new BuildException("can't write to results file: " + this.results.getAbsolutePath());
        }
        this.log("Results will go to " + this.results.getAbsolutePath());
    }

    public void setSlowResources(boolean slowResources) {
        this.slowResources = slowResources;
    }

    public void setStartURL(URL u) {
        this.startURL = u.toString();
    }

    public void setSuite(File suite) {
        if (!suite.exists()) {
            throw new BuildException("suite doesn't exist: " + suite.getAbsolutePath());
        }
        if (!suite.canRead()) {
            throw new BuildException("can't read suite file: " + suite.getAbsolutePath());
        }
        this.suite = suite;
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public void setJavaScriptCoreDir(File coreDir) {
        if (!coreDir.exists()) {
            throw new BuildException("core dir doesn't exist: " + coreDir.getAbsolutePath());
        }
        System.setProperty(SELENIUM_JAVASCRIPT_DIR, coreDir.getAbsolutePath());
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }
}

