/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.hsqldb.util.SqlToolError;

public class SqlFile {
    private static final int DEFAULT_HISTORY_SIZE = 20;
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String chunkPrompt = "raw> ";
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private boolean htmlMode = false;
    private HashMap userVars = null;
    private String[] statementHistory = null;
    private boolean chunking = false;
    private String csvNullRep = null;
    BooleanBucket possiblyUncommitteds = new BooleanBucket();
    private static final int SEP_LEN = 2;
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String SPACES = "                                                                                                                                  ";
    private static String revnum = null;
    private static String BANNER;
    private static final String BUFFER_HELP_TEXT = "BUFFER Commands (only \":;\" is available for non-interactive use).\n    :?                Help\n    :;                Execute current buffer as an SQL Statement\n    :a[text]          Enter append mode with a copy of the buffer\n    :l                List current contents of buffer\n    :s/from/to        Substitute \"to\" for first occurrence of \"from\"\n    :s/from/to/[i;g2] Substitute \"to\" for occurrence(s) of \"from\"\n                from:  '$'s represent line breaks\n                to:    If empty, from's will be deleted (e.g. \":s/x//\").\n                       '$'s represent line breaks\n                       You can't use ';' in order to execute the SQL (use\n                       the ';' switch for this purpose, as explained below).\n                /:     Can actually be any character which occurs in\n                       neither \"to\" string nor \"from\" string.\n                SUBSTITUTION MODE SWITCHES:\n                       i:  case Insensitive\n                       ;:  execute immediately after substitution\n                       g:  Global (substitute ALL occurrences of \"from\" string)\n                       2:  Narrows substitution to specified buffer line number\n                           (Use any line number in place of '2').\n";
    private static final String HELP_TEXT = "SPECIAL Commands.\n* commands only available for interactive use.\nIn place of \"3\" below, you can use nothing for the previous command, or\nan integer \"X\" to indicate the Xth previous command.\nFilter substrings are cases-sensitive!  Use \"SCHEMANAME.\" to narrow schema.\n    \\?                   Help\n    \\p [line to print]   Print string to stdout\n    \\w file/path.sql     Append current buffer to file\n    \\i file/path.sql     Include/execute commands from external file\n    \\d{tvsiSanur*} [substr]  List objects of specified type:\n  (Tbls/Views/Seqs/Indexes/SysTbls/Aliases/schemaNames/Users/Roles/table-like)\n    \\d OBJECTNAME [subs] Describe table or view columns\n    \\o [file/path.html]  Tee (or stop teeing) query output to specified file\n    \\H                   Toggle HTML output mode\n    \\! COMMAND ARGS      Execute external program (no support for stdin)\n    \\c [true|false]      Continue upon errors (a.o.t. abort upon error)\n    \\a [true|false]      Auto-commit JDBC DML commands\n    \\b                   save next result to Binary buffer (no display)\n    \\bd file/path.bin    Dump Binary buffer to file\n    \\bl file/path.bin    Load file into Binary buffer\n    \\bp                  Use ? in next SQL statement to upload Bin. buffer\n    \\.                   Enter raw SQL.  End with line containing only \".\"\n    \\s                   * Show previous commands (i.e. SQL command history)\n    \\-[3][;]             * reload a command to buffer (opt. exec. w/ \":;\"))\n    \\x {TABLE|SELECT...} eXport table or query to CSV text file\n    \\m file/path.csv     iMport CSV text file records into a table\n    \\q [abort message]   Quit (or end input like Ctrl-Z or Ctrl-D)\n";
    private static final String PL_HELP_TEXT = "PROCEDURAL LANGUAGE Commands.\n    *?                            Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value\n    * VARNAME =                   Unset variable\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * VARNAME _                   Same as * VARNAME _, except the query is\n                                  done silently (i.e, no rows to screen)\n    * list[value] [VARNAME1...]   List variable(s) (defaults to all)\n    * load VARNAME path.txt       Load variable value from text file\n    * dump VARNAME path.txt       Dump variable value to text file\n    * prepare VARNAME             Use ? in next SQL statement to upload val.\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may use /VARNAME instead iff /VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n'* VARNAME ~' or '* VARNAME _' sets the variable value according to the very\nnext SQL statement (~ will echo the value, _ will do it silently):\n    Query:  The value of the first field of the first row returned.\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n";
    public boolean recursed = false;
    private String curCommand = null;
    private int curLinenum = -1;
    private int curHist = -1;
    private PrintStream psStd = null;
    private PrintStream psErr = null;
    private PrintWriter pwQuery = null;
    private PrintWriter pwCsv = null;
    StringBuffer stringBuffer = new StringBuffer();
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private BufferedReader br = null;
    private String charset = null;
    private boolean doPrepare = false;
    private String prepareVar = null;
    private String csvColDelim = null;
    private String csvRowDelim = null;
    private static final String CSV_SYNTAX_MSG = "Export syntax:  x table_or_view_anme [column_delimiter [record_delimiter]]";
    private static final char[] nonVarChars;
    public boolean plMode = false;
    private String fetchingVar = null;
    private boolean silentFetch = false;
    private boolean fetchBinary = false;
    private static final String DEFAULT_NULL_REP = "[null]";
    private static final String DEFAULT_ROW_DELIM;
    private static final String DEFAULT_COL_DELIM = "|";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas = false;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR;
    private static final String PRE_TD;
    byte[] binBuffer = null;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    public SqlFile(File file, boolean bl, HashMap hashMap) throws IOException {
        this.file = file;
        this.interactive = bl;
        this.userVars = hashMap;
        try {
            this.statementHistory = new String[this.interactive ? Integer.parseInt(System.getProperty("sqltool.historyLength")) : 1];
        }
        catch (Throwable throwable) {
            this.statementHistory = null;
        }
        if (this.statementHistory == null) {
            this.statementHistory = new String[20];
        }
        if (this.file != null && !this.file.canRead()) {
            throw new IOException("Can't read SQL file '" + this.file + "'");
        }
    }

    public SqlFile(boolean bl, HashMap hashMap) throws IOException {
        this(null, bl, hashMap);
    }

    public void execute(Connection connection, Boolean bl) throws IOException, SqlToolError, SQLException {
        this.execute(connection, System.out, System.err, bl);
    }

    public void execute(Connection connection, boolean bl) throws IOException, SqlToolError, SQLException {
        this.execute(connection, System.out, System.err, new Boolean(bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void execute(Connection connection, PrintStream printStream, PrintStream printStream2, Boolean bl) throws IOException, SqlToolError, SQLException {
        boolean bl2;
        block53: {
            String string;
            this.psStd = printStream;
            this.psErr = printStream2;
            this.curConn = connection;
            this.curLinenum = -1;
            boolean bl3 = false;
            bl2 = false;
            boolean bl4 = this.continueOnError = bl == null ? this.interactive : bl;
            if (this.userVars != null && this.userVars.size() > 0) {
                this.plMode = true;
            }
            this.charset = (string = System.getProperty("sqlfile.charset")) == null ? DEFAULT_CHARSET : string;
            try {
                try {
                    this.br = new BufferedReader(new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file), this.charset));
                    this.curLinenum = 0;
                    if (this.interactive) {
                        this.stdprintln(BANNER);
                    }
                    while (true) {
                        block52: {
                            String string2;
                            int n;
                            String string3;
                            if (this.interactive) {
                                this.psStd.print(this.stringBuffer.length() == 0 ? (this.chunking ? this.chunkPrompt : this.primaryPrompt) : this.contPrompt);
                            }
                            if ((string3 = this.br.readLine()) == null) {
                                if (!this.interactive) break;
                                this.psStd.println();
                                break;
                            }
                            ++this.curLinenum;
                            if (this.chunking) {
                                if (string3.equals(".")) {
                                    this.chunking = false;
                                    this.setBuf(this.stringBuffer.toString());
                                    this.stringBuffer.setLength(0);
                                    if (!this.interactive) continue;
                                    this.stdprintln("Raw SQL chunk moved into buffer.  Run \":;\" to execute the chunk.");
                                    continue;
                                }
                                if (this.stringBuffer.length() > 0) {
                                    this.stringBuffer.append('\n');
                                }
                                this.stringBuffer.append(string3);
                                continue;
                            }
                            if (bl3) {
                                n = string3.indexOf("*/") + 2;
                                if (n <= 1) continue;
                                string3 = string3.substring(n);
                                this.stringBuffer.setLength(0);
                                bl3 = false;
                            }
                            String string4 = string3.trim();
                            try {
                                if (this.stringBuffer.length() == 0) {
                                    if (string4.startsWith("/*")) {
                                        n = string4.indexOf("*/", 2) + 2;
                                        if (n > 1) {
                                            string3 = string3.substring(n + string3.length() - string4.length());
                                            string4 = string3.trim();
                                        } else {
                                            this.stringBuffer.append("COMMENT");
                                            bl3 = true;
                                            continue;
                                        }
                                    }
                                    if (string4.length() == 0) continue;
                                    if (string4.charAt(0) == '*' && (string4.length() < 2 || string4.charAt(1) != '{')) {
                                        try {
                                            this.processPL(string4.length() == 1 ? "" : string4.substring(1).trim());
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string3 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                    if (string4.charAt(0) == '\\') {
                                        try {
                                            this.processSpecial(string4.substring(1));
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string3 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                    if (string4.charAt(0) == ':' && (this.interactive || string4.charAt(1) == ';')) {
                                        try {
                                            this.processBuffer(string4.substring(1));
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string3 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                    String string5 = string4.toUpperCase();
                                    if (string5.startsWith("DECLARE") || string5.startsWith("BEGIN")) {
                                        this.chunking = true;
                                        this.stringBuffer.append(string3);
                                        if (!this.interactive) continue;
                                        this.stdprintln("Enter RAW SQL.  No \\, :, * commands.  End with a line containing only \".\":");
                                        continue;
                                    }
                                }
                                if (string4.length() == 0) {
                                    if (!this.interactive || bl3) continue;
                                    this.setBuf(this.stringBuffer.toString());
                                    this.stringBuffer.setLength(0);
                                    this.stdprintln("Current input moved into buffer.");
                                    continue;
                                }
                                String string6 = SqlFile.deTerminated(string3);
                                if (!string4.equals(";")) {
                                    if (this.stringBuffer.length() > 0) {
                                        this.stringBuffer.append('\n');
                                    }
                                    this.stringBuffer.append(string6 == null ? string3 : string6);
                                }
                                if (string6 == null) continue;
                                this.curCommand = this.stringBuffer.toString();
                                String string7 = this.curCommand.trim();
                                if (string7.length() == 0) {
                                    throw new SQLException("Empty SQL Statement");
                                }
                                this.setBuf(this.curCommand);
                                this.processSQL();
                            }
                            catch (SQLException sQLException) {
                                this.errprintln("SQL Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + this.curCommand + "\"\n" + sQLException.getMessage());
                                if (!this.continueOnError) {
                                    throw sQLException;
                                }
                            }
                            catch (BreakException breakException) {
                                string2 = breakException.getMessage();
                                if (!this.recursed && string2 != null && !string2.equals("file")) {
                                    this.errprintln("Unsatisfied break statement" + (string2 == null ? "" : " (type " + string2 + ')') + '.');
                                } else {
                                    bl2 = true;
                                }
                                if (this.recursed) throw breakException;
                                if (!this.continueOnError) {
                                    throw breakException;
                                }
                            }
                            catch (ContinueException continueException) {
                                string2 = continueException.getMessage();
                                if (!this.recursed) {
                                    this.errprintln("Unsatisfied continue statement" + (string2 == null ? "" : " (type " + string2 + ')') + '.');
                                } else {
                                    bl2 = true;
                                }
                                if (this.recursed) throw continueException;
                                if (!this.continueOnError) {
                                    throw continueException;
                                }
                            }
                            catch (QuitNow quitNow) {
                                throw quitNow;
                            }
                            catch (SqlToolError sqlToolError) {
                                if (this.continueOnError) break block52;
                                throw sqlToolError;
                            }
                        }
                        this.stringBuffer.setLength(0);
                    }
                    if (bl3 || this.stringBuffer.length() != 0) {
                        this.errprintln("Unterminated input:  [" + this.stringBuffer + ']');
                        throw new SqlToolError("Unterminated input:  [" + this.stringBuffer + ']');
                    }
                    bl2 = true;
                }
                catch (QuitNow quitNow) {
                    boolean bl5 = bl2 = quitNow.getMessage() == null;
                    if (!this.recursed && !bl2) {
                        this.errprintln("Aborting: " + quitNow.getMessage());
                    }
                    if (this.recursed) throw quitNow;
                    if (!bl2) {
                        throw quitNow;
                    }
                    Object var16_25 = null;
                    this.closeQueryOutputStream();
                    if (this.fetchingVar != null) {
                        this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                        bl2 = false;
                    }
                    if (this.br != null) {
                        this.br.close();
                    }
                    if (bl2) return;
                    if (!this.possiblyUncommitteds.get()) return;
                    this.errprintln("Rolling back SQL transaction.");
                    this.curConn.rollback();
                    this.possiblyUncommitteds.set(false);
                    return;
                }
                Object var16_24 = null;
                this.closeQueryOutputStream();
                if (this.fetchingVar != null) {
                    this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                    bl2 = false;
                }
                if (this.br == null) break block53;
            }
            catch (Throwable throwable) {
                Object var16_26 = null;
                this.closeQueryOutputStream();
                if (this.fetchingVar != null) {
                    this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                    bl2 = false;
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (bl2) throw throwable;
                if (!this.possiblyUncommitteds.get()) throw throwable;
                this.errprintln("Rolling back SQL transaction.");
                this.curConn.rollback();
                this.possiblyUncommitteds.set(false);
                throw throwable;
            }
            this.br.close();
        }
        if (bl2) return;
        if (!this.possiblyUncommitteds.get()) return;
        this.errprintln("Rolling back SQL transaction.");
        this.curConn.rollback();
        this.possiblyUncommitteds.set(false);
    }

    private static String deTerminated(String string) {
        int n = string.lastIndexOf(59);
        if (n < 0) {
            return null;
        }
        for (int i = n + 1; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return null;
        }
        return string.substring(0, n);
    }

    private void processBuffer(String string) throws BadSpecial, SQLException {
        boolean bl = false;
        int n = 105;
        String string2 = null;
        if (string.length() > 0) {
            n = string.charAt(0);
            string2 = string.substring(1);
            if (string2.trim().length() == 0) {
                string2 = null;
            }
        }
        switch (n) {
            case 59: {
                this.curCommand = this.commandFromHistory(0);
                this.stdprintln("Executing command from buffer:\n" + this.curCommand + '\n');
                this.processSQL();
                return;
            }
            case 65: 
            case 97: {
                this.stringBuffer.append(this.commandFromHistory(0));
                if (string2 != null) {
                    String string3 = SqlFile.deTerminated(string2);
                    if (!string2.equals(";")) {
                        this.stringBuffer.append(string3 == null ? string2 : string3);
                    }
                    if (string3 != null) {
                        this.curCommand = this.stringBuffer.toString();
                        this.setBuf(this.curCommand);
                        this.stdprintln("Executing:\n" + this.curCommand + '\n');
                        this.processSQL();
                        this.stringBuffer.setLength(0);
                        return;
                    }
                }
                this.stdprintln("Appending to:\n" + this.stringBuffer);
                return;
            }
            case 76: 
            case 108: {
                this.stdprintln("Current Buffer:\n" + this.commandFromHistory(0));
                return;
            }
            case 83: 
            case 115: {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                int n2 = 0;
                try {
                    int n3;
                    int n4;
                    String string4 = this.commandFromHistory(0);
                    StringBuffer stringBuffer = new StringBuffer(string4);
                    if (string2 == null) {
                        throw new BadSwitch(0);
                    }
                    String string5 = string2.substring(0, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, string5, true);
                    if (stringTokenizer.countTokens() < 4 || !stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(1);
                    }
                    String string6 = stringTokenizer.nextToken().replace('$', '\n');
                    if (!stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(2);
                    }
                    String string7 = stringTokenizer.nextToken().replace('$', '\n');
                    if (string7.equals(string5)) {
                        string7 = "";
                    } else if (stringTokenizer.countTokens() > 0 && !stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(3);
                    }
                    if (stringTokenizer.countTokens() > 0) {
                        String string8 = stringTokenizer.nextToken("");
                        block15: for (n4 = 0; n4 < string8.length(); ++n4) {
                            switch (string8.charAt(n4)) {
                                case 'i': {
                                    bl2 = true;
                                    continue block15;
                                }
                                case ';': {
                                    bl4 = true;
                                    continue block15;
                                }
                                case 'g': {
                                    bl3 = true;
                                    continue block15;
                                }
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    n2 = Character.digit(string8.charAt(n4), 10);
                                    continue block15;
                                }
                                default: {
                                    throw new BadSpecial("Unknown Substitution option: " + string8.charAt(n4));
                                }
                            }
                        }
                    }
                    if (bl2) {
                        string4 = string4.toUpperCase();
                        string6 = string6.toUpperCase();
                    }
                    int n5 = 0;
                    n4 = -1;
                    if (n2 > 0) {
                        for (n3 = 1; n3 < n2; ++n3) {
                            if ((n5 = string4.indexOf(10, n5) + 1) >= 1) continue;
                            throw new BadSpecial("There are not " + n2 + " lines in the buffer.");
                        }
                        n4 = string4.indexOf(10, n5);
                    }
                    if (n4 < 0) {
                        n4 = string4.length();
                    }
                    if (bl3) {
                        n3 = n4;
                        while ((n3 = string4.lastIndexOf(string6, n3 - 1)) >= n5) {
                            stringBuffer.replace(n3, n3 + string6.length(), string7);
                        }
                    } else {
                        n3 = string4.indexOf(string6, n5);
                        if (n3 > -1 && n3 < n4) {
                            stringBuffer.replace(n3, n3 + string6.length(), string7);
                        }
                    }
                    this.curCommand = stringBuffer.toString();
                    this.setBuf(this.curCommand);
                    this.stdprintln((bl4 ? "Executing" : "Current Buffer") + ":\n" + this.curCommand);
                    if (bl4) {
                        this.stdprintln();
                    }
                }
                catch (BadSwitch badSwitch) {
                    throw new BadSpecial("Substitution syntax:  \":s/from this/to that/i;g2\".  Use '$' for line separations.  [" + badSwitch.getMessage() + ']');
                }
                if (bl4) {
                    this.processSQL();
                    this.stringBuffer.setLength(0);
                }
                return;
            }
            case 63: {
                this.stdprintln(BUFFER_HELP_TEXT);
                return;
            }
        }
        throw new BadSpecial("Unknown Buffer Command");
    }

    private void processSpecial(String string) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        boolean bl = false;
        String string2 = null;
        if (string.length() < 1) {
            throw new BadSpecial("Null special command");
        }
        if (this.plMode) {
            string = this.dereference(string, false);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken("").trim();
        }
        switch (string3.charAt(0)) {
            case 'q': {
                if (string2 != null) {
                    throw new QuitNow(string2);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.htmlMode = !this.htmlMode;
                this.stdprintln("HTML Mode is now set to: " + this.htmlMode);
                return;
            }
            case 'm': {
                if (string3.length() != 1 || string2 == null) {
                    throw new BadSpecial();
                }
                this.csvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
                this.csvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
                this.csvNullRep = (String)this.userVars.get("*CSV_NULL_REP");
                if (this.csvColDelim == null) {
                    this.csvColDelim = DEFAULT_COL_DELIM;
                }
                if (this.csvRowDelim == null) {
                    this.csvRowDelim = DEFAULT_ROW_DELIM;
                }
                if (this.csvNullRep == null) {
                    this.csvNullRep = DEFAULT_NULL_REP;
                }
                try {
                    this.importCsv(string2);
                }
                catch (IOException iOException) {
                    System.err.println("Failed to read in CSV file:  " + iOException);
                }
                return;
            }
            case 'x': {
                try {
                    try {
                        if (string3.length() != 1 || string2 == null) {
                            throw new BadSpecial();
                        }
                        String string4 = string2.indexOf(32) > 0 ? null : string2;
                        this.csvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
                        this.csvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
                        this.csvNullRep = (String)this.userVars.get("*CSV_NULL_REP");
                        String string5 = (String)this.userVars.get("*CSV_FILEPATH");
                        if (string5 == null && string4 == null) {
                            throw new BadSpecial("You must set PL variable '*CSV_FILEPATH' in order to use the query variant of \\x");
                        }
                        File file = new File(string5 == null ? string4 + ".csv" : string5);
                        if (this.csvColDelim == null) {
                            this.csvColDelim = DEFAULT_COL_DELIM;
                        }
                        if (this.csvRowDelim == null) {
                            this.csvRowDelim = DEFAULT_ROW_DELIM;
                        }
                        if (this.csvNullRep == null) {
                            this.csvNullRep = DEFAULT_NULL_REP;
                        }
                        this.pwCsv = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset));
                        this.displayResultSet(null, this.curConn.createStatement().executeQuery(string4 == null ? string2 : "SELECT * FROM " + string4), null, null);
                        this.pwCsv.flush();
                        this.stdprintln("Wrote " + file.length() + " characters to file '" + file + "'");
                    }
                    catch (Exception exception) {
                        if (exception instanceof BadSpecial) {
                            if (exception.getMessage() == null) {
                                throw new BadSpecial(CSV_SYNTAX_MSG);
                            }
                            throw (BadSpecial)exception;
                        }
                        throw new BadSpecial("Failed to write to file '" + string2 + "':  " + exception);
                    }
                    Object var11_25 = null;
                    if (this.pwCsv != null) {
                        this.pwCsv.close();
                    }
                    this.pwCsv = null;
                    this.csvColDelim = null;
                    this.csvRowDelim = null;
                }
                catch (Throwable throwable) {
                    Object var11_26 = null;
                    if (this.pwCsv != null) {
                        this.pwCsv.close();
                    }
                    this.pwCsv = null;
                    this.csvColDelim = null;
                    this.csvRowDelim = null;
                    throw throwable;
                }
                return;
            }
            case 'd': {
                if (string3.length() == 2) {
                    this.listTables(string3.charAt(1), string2);
                    return;
                }
                if (string3.length() == 1 && string2 != null) {
                    int n = string2.indexOf(32);
                    if (n < 0) {
                        this.describe(string2, null);
                    } else {
                        this.describe(string2.substring(0, n), string2.substring(n + 1).trim());
                    }
                    return;
                }
                throw new BadSpecial("Describe commands must be like '\\dX' or like '\\d OBJECTNAME'.");
            }
            case 'o': {
                if (string2 == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial("There is no query output file to close");
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln("Closing current query output file and opening new one");
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2, true), this.charset));
                    this.pwQuery.println((this.htmlMode ? "<HTML>\n<!--" : "#") + " " + new Date() + ".  Query output from " + this.getClass().getName() + (this.htmlMode ? ". -->\n\n<BODY>" : ".\n"));
                    this.pwQuery.flush();
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to write to file '" + string2 + "':  " + exception);
                }
                return;
            }
            case 'w': {
                if (string2 == null) {
                    throw new BadSpecial("You must supply a destination file name");
                }
                if (this.commandFromHistory(0).length() == 0) {
                    throw new BadSpecial("Empty command in buffer");
                }
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2, true), this.charset));
                    printWriter.println(this.commandFromHistory(0) + ';');
                    printWriter.flush();
                    printWriter.close();
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to append to file '" + string2 + "':  " + exception);
                }
                return;
            }
            case 'i': {
                if (string2 == null) {
                    throw new BadSpecial("You must supply an SQL file name");
                }
                try {
                    SqlFile sqlFile = new SqlFile(new File(string2), false, this.userVars);
                    sqlFile.recursed = true;
                    sqlFile.possiblyUncommitteds = this.possiblyUncommitteds;
                    sqlFile.plMode = this.plMode;
                    sqlFile.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException continueException) {
                    throw continueException;
                }
                catch (BreakException breakException) {
                    String string6 = breakException.getMessage();
                    if (string6 != null && !string6.equals("file")) {
                        throw breakException;
                    }
                }
                catch (QuitNow quitNow) {
                    throw quitNow;
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to execute SQL from file '" + string2 + "':  " + exception.getMessage());
                }
                return;
            }
            case 'p': {
                if (string2 == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(string2, true);
                }
                return;
            }
            case 'a': {
                if (string2 != null) {
                    this.curConn.setAutoCommit(Boolean.valueOf(string2));
                }
                this.stdprintln("Auto-commit is set to: " + this.curConn.getAutoCommit());
                return;
            }
            case 'b': {
                if (string3.length() == 1) {
                    this.fetchBinary = true;
                    return;
                }
                if (string3.charAt(1) == 'p') {
                    this.doPrepare = true;
                    return;
                }
                if (string3.charAt(1) != 'd' && string3.charAt(1) != 'l' || string2 == null) {
                    throw new BadSpecial("Malformatted binary command");
                }
                File file = new File(string2);
                try {
                    if (string3.charAt(1) == 'd') {
                        this.dump(file);
                    } else {
                        this.load(file);
                    }
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to load/dump binary  data to file '" + string2 + "'");
                }
                return;
            }
            case '*': 
            case 'c': {
                if (string2 != null) {
                    this.continueOnError = Boolean.valueOf(string2);
                }
                this.stdprintln("Continue-on-error is set to: " + this.continueOnError);
                return;
            }
            case 's': {
                this.showHistory();
                return;
            }
            case '-': {
                String string7;
                boolean bl2;
                int n = 0;
                boolean bl3 = bl2 = string3.charAt(string3.length() - 1) == ';';
                if (bl2) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                String string8 = string7 = string3.length() == 1 ? null : string3.substring(1, string3.length());
                if (string7 == null) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BadSpecial("Malformatted command number");
                    }
                }
                this.setBuf(this.commandFromHistory(n));
                if (bl2) {
                    this.processBuffer(";");
                } else {
                    this.stdprintln("RESTORED following command to buffer.  Enter \":?\" to see buffer commands:\n" + this.commandFromHistory(0));
                }
                return;
            }
            case '?': {
                this.stdprintln(HELP_TEXT);
                return;
            }
            case '!': {
                byte[] byArray = new byte[1024];
                String string9 = (string3.length() == 1 ? "" : string3.substring(1)) + (string3.length() > 1 && string2 != null ? " " : "") + (string2 == null ? "" : string2);
                try {
                    int n;
                    Process process = Runtime.getRuntime().exec(string9);
                    process.getOutputStream().close();
                    InputStream inputStream = process.getInputStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.stdprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    inputStream = process.getErrorStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.errprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    if (process.waitFor() != 0) {
                        throw new BadSpecial("External command failed: '" + string9 + "'");
                    }
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to execute command '" + string9 + "':  " + exception);
                }
                return;
            }
            case '.': {
                this.chunking = true;
                if (this.interactive) {
                    this.stdprintln("Enter RAW SQL.  No \\, :, * commands.  End with a line containing only \".\":");
                }
                return;
            }
        }
        throw new BadSpecial("Unknown Special Command");
    }

    static int pastName(String string, int n) {
        String string2 = string.substring(n);
        int n2 = string.length();
        for (int i = 0; i < nonVarChars.length; ++i) {
            int n3 = string2.indexOf(nonVarChars[i]);
            if (n3 <= -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n + n2;
    }

    private String dereference(String string, boolean bl) throws SQLException {
        String string2;
        int n;
        String string3;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl && string.trim().charAt(0) == '/') {
            int n3 = string.indexOf(47);
            n2 = SqlFile.pastName(string.substring(n3 + 1), 0);
            if (n2 < 1) {
                throw new SQLException("Malformed PL alias use");
            }
            string3 = string.substring(n3 + 1, n3 + 1 + n2);
            String string4 = (String)this.userVars.get(string3);
            if (string4 == null) {
                throw new SQLException("Undefined PL variable:  " + string3);
            }
            stringBuffer.replace(n3, n3 + 1 + n2, (String)this.userVars.get(string3));
        }
        while ((n = (string2 = stringBuffer.toString()).indexOf("*{")) >= 0) {
            n2 = string2.indexOf(125, n + 2);
            if (n2 == n + 2) {
                throw new SQLException("Empty PL variable name");
            }
            if (n2 < 0) {
                throw new SQLException("Unterminated PL variable name");
            }
            string3 = string2.substring(n + 2, n2);
            if (!this.userVars.containsKey(string3)) {
                throw new SQLException("Use of undefined PL variable: " + string3);
            }
            stringBuffer.replace(n, n2 + 1, (String)this.userVars.get(string3));
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPL(String var1_1) throws BadSpecial, SqlToolError, SQLException {
        block72: {
            block73: {
                if (var1_1.length() < 1) {
                    this.plMode = true;
                    this.stdprintln("PL variable expansion mode is now on");
                    return;
                }
                if (var1_1.charAt(0) == '?') {
                    this.stdprintln("PROCEDURAL LANGUAGE Commands.\n    *?                            Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value\n    * VARNAME =                   Unset variable\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * VARNAME _                   Same as * VARNAME _, except the query is\n                                  done silently (i.e, no rows to screen)\n    * list[value] [VARNAME1...]   List variable(s) (defaults to all)\n    * load VARNAME path.txt       Load variable value from text file\n    * dump VARNAME path.txt       Dump variable value to text file\n    * prepare VARNAME             Use ? in next SQL statement to upload val.\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may use /VARNAME instead iff /VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n'* VARNAME ~' or '* VARNAME _' sets the variable value according to the very\nnext SQL statement (~ will echo the value, _ will do it silently):\n    Query:  The value of the first field of the first row returned.\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n");
                    return;
                }
                if (this.plMode) {
                    var1_1 = this.dereference(var1_1, false);
                }
                var2_2 = new StringTokenizer(var1_1);
                var3_3 = var2_2.nextToken();
                var4_4 = null;
                this.plMode = true;
                if (this.userVars == null) {
                    this.userVars = new HashMap<K, V>();
                }
                if (var3_3.equals("end")) {
                    throw new BadSpecial("PL end statements may only occur inside of a PL block");
                }
                if (var3_3.equals("continue")) {
                    if (var2_2.hasMoreTokens() == false) throw new ContinueException();
                    var5_5 = var2_2.nextToken("").trim();
                    if (var5_5.equals("foreach") != false) throw new ContinueException(var5_5);
                    if (var5_5.equals("while") == false) throw new BadSpecial("Bad continue statement.You may use no argument or one of 'foreach', 'while'");
                    throw new ContinueException(var5_5);
                }
                if (var3_3.equals("break")) {
                    if (var2_2.hasMoreTokens() == false) throw new BreakException();
                    var5_6 = var2_2.nextToken("").trim();
                    if (var5_6.equals("foreach") != false) throw new BreakException(var5_6);
                    if (var5_6.equals("if") != false) throw new BreakException(var5_6);
                    if (var5_6.equals("while") != false) throw new BreakException(var5_6);
                    if (var5_6.equals("file") == false) throw new BadSpecial("Bad break statement.You may use no argument or one of 'foreach', 'if', 'while', 'file'");
                    throw new BreakException(var5_6);
                }
                if (!var3_3.equals("list") && !var3_3.equals("listvalue")) break block73;
                var6_14 = var3_3.equals("listvalue");
                if (var2_2.countTokens() == 0) {
                    this.stdprint(SqlFile.formatNicely(this.userVars, var6_14));
                    return;
                }
                var4_4 = SqlFile.getTokenArray(var2_2.nextToken(""));
                if (var6_14) {
                    this.stdprintln("The outermost parentheses are not part of the values.");
                    break block72;
                } else {
                    this.stdprintln("Showing variable names and length of values (use 'listvalue' to see values).");
                }
                break block72;
            }
            if (var3_3.equals("dump") || var3_3.equals("load")) {
                if (var2_2.countTokens() != 2) {
                    throw new BadSpecial("Malformatted PL dump/load command");
                }
                var5_8 = var2_2.nextToken();
                var6_15 = new File(var2_2.nextToken());
                try {
                    if (var3_3.equals("dump")) {
                        this.dump(var5_8, var6_15);
                        return;
                    }
                    this.load(var5_8, var6_15);
                    return;
                }
                catch (Exception var7_21) {
                    throw new BadSpecial("Failed to dump/load variable '" + var5_8 + "' to file '" + var6_15 + "'");
                }
            }
            if (var3_3.equals("prepare")) {
                if (var2_2.countTokens() != 1) {
                    throw new BadSpecial("Malformatted prepare command");
                }
                var5_9 = var2_2.nextToken();
                if (this.userVars.get(var5_9) == null) {
                    throw new SQLException("Use of unset PL variable: " + var5_9);
                }
                this.prepareVar = var5_9;
                this.doPrepare = true;
                return;
            }
            if (var3_3.equals("foreach")) {
                if (var2_2.countTokens() < 2) {
                    throw new BadSpecial("Malformatted PL foreach command (1)");
                }
                var5_10 = var2_2.nextToken();
                var6_16 = var2_2.nextToken("").trim();
                if (var6_16.length() < 2) throw new BadSpecial("Malformatted PL foreach command (2)");
                if (var6_16.charAt(0) != '(') throw new BadSpecial("Malformatted PL foreach command (2)");
                if (var6_16.charAt(var6_16.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL foreach command (2)");
                }
                var7_22 = SqlFile.getTokenArray(var6_16.substring(1, var6_16.length() - 1));
                var8_26 = null;
                try {
                    var8_26 = this.plBlockFile("foreach");
                }
                catch (IOException var10_41) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + var10_41);
                }
                var10_42 = (String)this.userVars.get(var5_10);
                try {
                    for (var12_44 = 0; var12_44 < var7_22.length; ++var12_44) {
                        try {
                            var9_46 = var7_22[var12_44];
                            this.userVars.put(var5_10, var9_46);
                            var11_51 = new SqlFile(var8_26, false, this.userVars);
                            var11_51.plMode = true;
                            var11_51.recursed = true;
                            var11_51.possiblyUncommitteds = this.possiblyUncommitteds;
                            var11_51.execute(this.curConn, this.continueOnError);
                            continue;
                        }
                        catch (ContinueException var13_55) {
                            var14_56 = var13_55.getMessage();
                            if (var14_56 == null || var14_56.equals("foreach")) continue;
                            throw var13_55;
                        }
                    }
                }
                catch (BreakException var11_52) {
                    var12_45 = var11_52.getMessage();
                    if (var12_45 != null && !var12_45.equals("foreach")) {
                        throw var11_52;
                    }
                }
                catch (QuitNow var11_53) {
                    throw var11_53;
                }
                catch (Exception var11_54) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + var11_54.getMessage());
                }
                if (var10_42 == null) {
                    this.userVars.remove(var5_10);
                } else {
                    this.userVars.put(var5_10, var10_42);
                }
                if (var8_26 == null) return;
                if (var8_26.delete() != false) return;
                throw new BadSpecial("Error occurred while trying to remove temp file '" + var8_26 + "'");
            }
            if (var3_3.equals("if")) {
                if (var2_2.countTokens() < 1) {
                    throw new BadSpecial("Malformatted PL if command (1)");
                }
                var5_11 = var2_2.nextToken("").trim();
                if (var5_11.length() < 2) throw new BadSpecial("Malformatted PL if command (2)");
                if (var5_11.charAt(0) != '(') throw new BadSpecial("Malformatted PL if command (2)");
                if (var5_11.charAt(var5_11.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL if command (2)");
                }
                var6_17 = SqlFile.getTokenArray(var5_11.substring(1, var5_11.length() - 1));
                var7_23 = null;
                try {
                    var7_23 = this.plBlockFile("if");
                }
                catch (IOException var8_27) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + var8_27);
                }
                try {
                    if (this.eval(var6_17)) {
                        var8_28 = new SqlFile(var7_23, false, this.userVars);
                        var8_28.plMode = true;
                        var8_28.recursed = true;
                        var8_28.possiblyUncommitteds = this.possiblyUncommitteds;
                        var8_28.execute(this.curConn, this.continueOnError);
                    }
                }
                catch (BreakException var8_29) {
                    var9_47 = var8_29.getMessage();
                    if (var9_47 == null) throw var8_29;
                    if (!var9_47.equals("if")) {
                        throw var8_29;
                    }
                }
                catch (ContinueException var8_30) {
                    throw var8_30;
                }
                catch (QuitNow var8_31) {
                    throw var8_31;
                }
                catch (BadSpecial var8_32) {
                    throw new BadSpecial("Malformatted PL if command (3): " + var8_32);
                }
                catch (Exception var8_33) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + var8_33.getMessage());
                }
                if (var7_23 == null) return;
                if (var7_23.delete() != false) return;
                throw new BadSpecial("Error occurred while trying to remove temp file '" + var7_23 + "'");
            }
            if (var3_3.equals("while")) {
                if (var2_2.countTokens() < 1) {
                    throw new BadSpecial("Malformatted PL while command (1)");
                }
                var5_12 = var2_2.nextToken("").trim();
                if (var5_12.length() < 2) throw new BadSpecial("Malformatted PL while command (2)");
                if (var5_12.charAt(0) != '(') throw new BadSpecial("Malformatted PL while command (2)");
                if (var5_12.charAt(var5_12.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL while command (2)");
                }
                var6_18 = SqlFile.getTokenArray(var5_12.substring(1, var5_12.length() - 1));
                var7_24 = null;
                try {
                    var7_24 = this.plBlockFile("while");
                }
                catch (IOException var8_34) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + var8_34);
                }
                ** try [egrp 7[TRYBLOCK] [14, 15, 16, 17 : 1722->1818)] { 
lbl174:
                // 1 sources

            } else {
                var2_2 = null;
                var5_13 = SqlFile.pastName(var1_1, 0);
                var6_19 = var1_1.length();
                var7_25 = var1_1.substring(0, var5_13);
                while (var5_13 + 1 < var6_19 && (var1_1.charAt(var5_13) == ' ' || var1_1.charAt(var5_13) == '\t')) {
                    ++var5_13;
                }
                if (var5_13 + 1 > var6_19) {
                    throw new BadSpecial("Unterminated PL variable definition");
                }
                var8_40 = var1_1.charAt(var5_13);
                var9_50 = var1_1.substring(var5_13 + 1);
                switch (var1_1.charAt(var5_13)) {
                    case '_': {
                        this.silentFetch = true;
                    }
                    case '~': {
                        if (var9_50.length() > 0) {
                            throw new BadSpecial("PL ~/_ set commands take no other args");
                        }
                        this.userVars.remove(var7_25);
                        this.fetchingVar = var7_25;
                        return;
                    }
                    case '=': {
                        if (this.fetchingVar != null && this.fetchingVar.equals(var7_25)) {
                            this.fetchingVar = null;
                        }
                        if (var9_50.length() > 0) {
                            this.userVars.put(var7_25, var1_1.substring(var5_13 + 1).trim());
                            return;
                        }
                        this.userVars.remove(var7_25);
                        return;
                    }
                }
                throw new BadSpecial("Unknown PL command (3)");
            }
        }
        var7_20 = 0;
        while (var7_20 < var4_4.length) {
            var5_7 = (String)this.userVars.get(var4_4[var7_20]);
            this.stdprintln("    " + var4_4[var7_20] + ": " + (var6_14 != false ? "(" + var5_7 + ')' : Integer.toString(var5_7.length())));
            ++var7_20;
        }
        return;
        {
            while (this.eval(var6_18)) {
                try {
                    var8_35 = new SqlFile(var7_24, false, this.userVars);
                    var8_35.recursed = true;
                    var8_35.possiblyUncommitteds = this.possiblyUncommitteds;
                    var8_35.plMode = true;
                    var8_35.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException var9_48) {
                    var10_43 = var9_48.getMessage();
                    if (var10_43 == null || var10_43.equals("while")) continue;
                    throw var9_48;
                }
            }
        }
lbl228:
        // 1 sources

        catch (BreakException var8_36) {
            var9_49 = var8_36.getMessage();
            if (var9_49 != null && !var9_49.equals("while")) {
                throw var8_36;
            }
        }
lbl233:
        // 1 sources

        catch (QuitNow var8_37) {
            throw var8_37;
        }
lbl235:
        // 1 sources

        catch (BadSpecial var8_38) {
            throw new BadSpecial("Malformatted PL while command (3): " + var8_38);
        }
lbl237:
        // 1 sources

        catch (Exception var8_39) {
            throw new BadSpecial("Failed to execute SQL from PL block.  " + var8_39.getMessage());
        }
        if (var7_24 == null) return;
        if (var7_24.delete() != false) return;
        throw new BadSpecial("Error occurred while trying to remove temp file '" + var7_24 + "'");
    }

    private File plBlockFile(String string) throws IOException, SqlToolError {
        int n = 1;
        if (string == null || !string.equals("foreach") && !string.equals("if") && !string.equals("while")) {
            throw new RuntimeException("Assertion failed.  Unsupported PL block type:  " + string);
        }
        File file = File.createTempFile("sqltool-", ".sql");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset));
        printWriter.println("/* " + new Date() + ". " + this.getClass().getName() + " PL block. */\n");
        while (true) {
            String string2;
            if ((string2 = this.br.readLine()) == null) {
                this.errprintln("Unterminated '" + string + "' PL block");
                throw new SqlToolError("Unterminated '" + string + "' PL block");
            }
            ++this.curLinenum;
            if (string2.trim().length() > 1 && string2.trim().charAt(0) == '*') {
                StringTokenizer stringTokenizer = new StringTokenizer(string2.trim().substring(1));
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(string)) {
                    ++n;
                } else if (string3.equals("end")) {
                    if (stringTokenizer.countTokens() < 1) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (1)");
                        throw new SqlToolError("PL end statement requires arg  of 'foreach' or 'if' or 'while' (1)");
                    }
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equals(string) && --n < 1) break;
                    if (!(string4.equals("foreach") || string4.equals("if") || string4.equals("while"))) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                        throw new SqlToolError("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                    }
                }
            }
            printWriter.println(string2);
        }
        printWriter.flush();
        printWriter.close();
        return file;
    }

    private void stdprintln() {
        this.stdprintln(false);
    }

    private void stdprint(String string) {
        this.stdprint(string, false);
    }

    private void stdprintln(String string) {
        this.stdprintln(string, false);
    }

    private void stdprintln(boolean bl) {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
        if (bl && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprint(String string) {
        this.psErr.print(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void errprintln(String string) {
        this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void stdprint(String string, boolean bl) {
        this.psStd.print(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String string, boolean bl) {
        this.psStd.println(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listTables(char var1_1, String var2_2) throws BadSpecial {
        block47: {
            block46: {
                block45: {
                    var3_3 = null;
                    var4_4 = null;
                    var5_5 = null;
                    var6_6 = null;
                    var7_7 = null;
                    var8_8 = null;
                    var9_9 = "";
                    var10_10 = var2_2;
                    try {
                        try {
                            var11_11 = this.curConn.getMetaData();
                            var12_14 = var11_11.getDatabaseProductName();
                            var13_15 = null;
                            var5_5 = new String[1];
                            switch (var1_1) {
                                case '*': {
                                    var5_5 = null;
                                    break;
                                }
                                case 'S': {
                                    if (var12_14.indexOf("Oracle") > -1) {
                                        System.err.println("*** WARNING:\n*** Listing tables in system-supplied schemas since\n*** Oracle(TM) doesn't return a JDBC system table list.");
                                        var5_5[0] = "TABLE";
                                        var3_3 = "SYS";
                                        var6_6 = SqlFile.oracleSysSchemas;
                                        break;
                                    }
                                    var5_5[0] = "SYSTEM TABLE";
                                    break;
                                }
                                case 's': {
                                    if (var12_14.indexOf("HSQL") > -1) {
                                        if (var10_10 != null && var10_10.charAt(var10_10.length() - 1) == '.') {
                                            var9_9 = "\nWHERE sequence_schema = '" + var10_10.substring(0, var10_10.length() - 1) + "'";
                                            var10_10 = null;
                                        }
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT sequence_schema, sequence_name FROM information_schema.system_sequences" + var9_9);
                                        break;
                                    }
                                    var5_5[0] = "SEQUENCE";
                                    break;
                                }
                                case 'r': {
                                    if (var12_14.indexOf("HSQL") > -1) {
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT authorization_name FROM information_schema.system_authorizations\nWHERE authorization_type = 'ROLE'\nORDER BY authorization_name");
                                        break;
                                    }
                                    if (var12_14.indexOf("Adaptive Server Enterprise") <= -1) throw new BadSpecial("SqlFile does not yet support \\dr for your database vendor");
                                    var7_7 = this.curConn.createStatement();
                                    var7_7.execute("SELECT name FROM syssrvroles ORDER BY name");
                                    break;
                                }
                                case 'u': {
                                    if (var12_14.indexOf("HSQL") > -1) {
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT user, admin FROM information_schema.system_users\nORDER BY user");
                                        break;
                                    }
                                    if (var12_14.indexOf("Oracle") > -1) {
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT username, created FROM all_users ORDER BY username");
                                        break;
                                    }
                                    if (var12_14.indexOf("PostgreSQL") > -1) {
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT usename, usesuper FROM pg_catalog.pg_user ORDER BY usename");
                                        break;
                                    }
                                    if (var12_14.indexOf("Adaptive Server Enterprise") <= -1) throw new BadSpecial("SqlFile does not yet support \\du for your database vendor");
                                    var7_7 = this.curConn.createStatement();
                                    var7_7.execute("SELECT name, accdate, fullname FROM syslogins ORDER BY name");
                                    break;
                                }
                                case 'a': {
                                    if (var12_14.indexOf("HSQL") > -1) {
                                        if (var10_10 != null && var10_10.charAt(var10_10.length() - 1) == '.') {
                                            var9_9 = "\nWHERE alias_schem = '" + var10_10.substring(0, var10_10.length() - 1) + "'";
                                            var10_10 = null;
                                        }
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT alias_schem, alias FROM information_schema.system_aliases" + var9_9);
                                        break;
                                    }
                                    var5_5[0] = "ALIAS";
                                    break;
                                }
                                case 't': {
                                    this.excludeSysSchemas = var12_14.indexOf("Oracle") > -1;
                                    var5_5[0] = "TABLE";
                                    break;
                                }
                                case 'v': {
                                    var5_5[0] = "VIEW";
                                    break;
                                }
                                case 'n': {
                                    var8_8 = var11_11.getSchemas();
                                    if (var8_8 == null) {
                                        throw new BadSpecial("Failed to get metadata from database");
                                    }
                                    this.displayResultSet(null, var8_8, SqlFile.listMDSchemaCols, var10_10);
                                    var17_16 = null;
                                    this.excludeSysSchemas = false;
                                    if (var8_8 != null) {
                                        var8_8 = null;
                                    }
                                    if (var7_7 == null) return;
                                    break block45;
                                }
                                case 'i': {
                                    var3_3 = null;
                                    var14_24 = null;
                                    if (var10_10 != null) {
                                        var15_26 = var10_10.indexOf(46);
                                        v0 = var3_3 = var15_26 > 0 ? var10_10.substring(0, var15_26) : null;
                                        if (var15_26 < var10_10.length() - 1) {
                                            var14_24 = var15_26 > 0 ? var10_10.substring(var15_26 + 1) : var10_10;
                                        }
                                        var10_10 = null;
                                    }
                                    if ((var8_8 = var11_11.getIndexInfo(null, var3_3, var14_24, false, true)) == null) {
                                        throw new BadSpecial("Failed to get metadata from database");
                                    }
                                    this.displayResultSet(null, var8_8, SqlFile.listMDIndexCols, null);
                                    break block46;
                                }
                                default: {
                                    throw new BadSpecial("Unknown describe option: '" + var1_1 + "'");
                                }
                            }
                            if (var7_7 == null) {
                                var4_4 = var12_14.indexOf("HSQL") > -1 ? SqlFile.listMDTableCols[1] : (var12_14.indexOf("Oracle") > -1 ? SqlFile.listMDTableCols[2] : SqlFile.listMDTableCols[0]);
                                if (var3_3 == null && var10_10 != null && var10_10.charAt(var10_10.length() - 1) == '.') {
                                    var3_3 = var10_10.substring(0, var10_10.length() - 1);
                                    var10_10 = null;
                                }
                            }
                            v1 = var8_8 = var7_7 == null ? var11_11.getTables(null, var3_3, null, var5_5) : var7_7.getResultSet();
                            if (var8_8 == null) {
                                throw new BadSpecial("Failed to get metadata from database");
                            }
                            this.displayResultSet(null, var8_8, var4_4, var10_10);
                            if (var6_6 != null) {
                                for (var14_25 = 1; var14_25 < var6_6.length; ++var14_25) {
                                    var8_8 = var11_11.getTables(null, var6_6[var14_25], null, var5_5);
                                    if (var8_8 == null) {
                                        throw new BadSpecial("Failed to get metadata from database for '" + var6_6[var14_25] + "'");
                                    }
                                    if (!var8_8.next()) continue;
                                    this.displayResultSet(null, var11_11.getTables(null, var6_6[var14_25], null, var5_5), var4_4, var10_10);
                                }
                            }
                            break block47;
                        }
                        catch (SQLException var11_12) {
                            throw new BadSpecial("Failure getting MetaData: " + var11_12);
                        }
                        catch (NullPointerException var11_13) {
                            throw new BadSpecial("Failure getting MetaData (NPE)");
                        }
                    }
                    catch (Throwable var16_27) {
                        var17_19 = null;
                        this.excludeSysSchemas = false;
                        if (var8_8 != null) {
                            var8_8 = null;
                        }
                        if (var7_7 == null) throw var16_27;
                        try {
                            var7_7.close();
                        }
                        catch (Exception var18_23) {
                            // empty catch block
                        }
                        var7_7 = null;
                        throw var16_27;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [10 : 1307->1317)] { 
lbl156:
                // 1 sources

                var7_7.close();
                return;
lbl158:
                // 1 sources

                catch (Exception var18_20) {
                    // empty catch block
                }
                return;
            }
            var17_17 = null;
            this.excludeSysSchemas = false;
            if (var8_8 != null) {
                var8_8 = null;
            }
            if (var7_7 == null) return;
            ** try [egrp 2[TRYBLOCK] [10 : 1307->1317)] { 
lbl168:
            // 1 sources

            var7_7.close();
            return;
lbl170:
            // 1 sources

            catch (Exception var18_21) {
                // empty catch block
            }
            return;
        }
        var17_18 = null;
        this.excludeSysSchemas = false;
        if (var8_8 != null) {
            var8_8 = null;
        }
        if (var7_7 == null) return;
        ** try [egrp 2[TRYBLOCK] [10 : 1307->1317)] { 
lbl180:
        // 1 sources

        var7_7.close();
        return;
lbl182:
        // 1 sources

        catch (Exception var18_22) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSQL() throws SQLException {
        String string = this.plMode ? this.dereference(this.curCommand, true) : this.curCommand;
        Statement statement = null;
        if (this.doPrepare) {
            if (string.indexOf(63) < 1) {
                throw new SQLException("Prepared statements must contain one '?'");
            }
            this.doPrepare = false;
            PreparedStatement preparedStatement = this.curConn.prepareStatement(string);
            if (this.prepareVar == null) {
                if (this.binBuffer == null) {
                    throw new SQLException("Binary SqlFile buffer is empty");
                }
                preparedStatement.setBytes(1, this.binBuffer);
            } else {
                String string2 = (String)this.userVars.get(this.prepareVar);
                if (string2 == null) {
                    throw new SQLException("PL Variable '" + this.prepareVar + "' is empty");
                }
                this.prepareVar = null;
                preparedStatement.setString(1, string2);
            }
            preparedStatement.executeUpdate();
            statement = preparedStatement;
        } else {
            statement = this.curConn.createStatement();
            statement.execute(string);
        }
        this.possiblyUncommitteds.set(true);
        try {
            this.displayResultSet(statement, statement.getResultSet(), null, null);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private void displayResultSet(Statement statement, ResultSet resultSet, int[] nArray, String string) throws SQLException {
        int n = statement == null ? -1 : statement.getUpdateCount();
        boolean bl = this.silentFetch;
        boolean bl2 = this.fetchBinary;
        this.silentFetch = false;
        this.fetchBinary = false;
        if (this.excludeSysSchemas) {
            this.stdprintln("*** WARNING:\n*** Omitting tables from system-supplied schemas\n*** (because Oracle(TM) doesn't differentiate them to JDBC).");
        }
        switch (n) {
            case -1: {
                int n2;
                String[] stringArray;
                int n3;
                boolean bl3;
                int n4;
                if (resultSet == null) {
                    this.stdprintln("No result", true);
                    break;
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n5 = resultSetMetaData.getColumnCount();
                int n6 = nArray == null ? n5 : nArray.length;
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                String[] stringArray2 = null;
                int[] nArray2 = new int[n6];
                if (!this.htmlMode) {
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = 0;
                    }
                }
                boolean[] blArray = new boolean[n6];
                int[] nArray3 = new int[n6];
                boolean[] blArray2 = new boolean[n6];
                int n7 = -1;
                stringArray2 = new String[n6];
                for (n4 = 1; n4 <= n5; ++n4) {
                    if (nArray != null) {
                        bl3 = true;
                        for (n3 = 0; n3 < nArray.length; ++n3) {
                            if (n4 != nArray[n3]) continue;
                            bl3 = false;
                        }
                        if (bl3) continue;
                    }
                    stringArray2[++n7] = resultSetMetaData.getColumnLabel(n4);
                    nArray3[n7] = resultSetMetaData.getColumnType(n4);
                    blArray[n7] = false;
                    blArray2[n7] = true;
                    switch (nArray3[n7]) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            blArray[n7] = true;
                            break;
                        }
                        case -3: 
                        case 12: {
                            blArray2[n7] = false;
                        }
                    }
                    if (this.htmlMode || stringArray2[n7].length() <= nArray2[n7]) continue;
                    nArray2[n7] = stringArray2[n7].length();
                }
                while (resultSet.next()) {
                    stringArray = new String[n6];
                    n7 = -1;
                    n4 = string != null ? 1 : 0;
                    for (n3 = 1; n3 <= n5; ++n3) {
                        if (nArray != null) {
                            bl3 = true;
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                if (n3 != nArray[n2]) continue;
                                bl3 = false;
                            }
                            if (bl3) continue;
                        }
                        if (!SqlFile.canDisplayType(nArray3[++n7])) {
                            bl2 = true;
                        }
                        String string2 = null;
                        if (!bl2) {
                            if (nArray3[n7] == 93) {
                                Timestamp timestamp = resultSet.getTimestamp(n3);
                                string2 = timestamp == null ? null : timestamp.toString();
                            } else {
                                string2 = resultSet.getString(n3);
                                if (string2 == null) {
                                    try {
                                        string2 = this.streamToString(resultSet.getAsciiStream(n3));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        if (bl2 || string2 == null && !resultSet.wasNull()) {
                            if (this.pwCsv != null) {
                                throw new SQLException("Table has a binary column.  CSV files are text, not binary, files");
                            }
                            try {
                                this.binBuffer = this.streamToBytes(resultSet.getBinaryStream(n3));
                            }
                            catch (IOException iOException) {
                                throw new SQLException("Failed to read value using stream");
                            }
                            this.stdprintln("Read " + this.binBuffer.length + " bytes from field '" + stringArray2[n7] + "' (type " + SqlFile.sqlTypeToString(nArray3[n7]) + ") into binary buffer");
                            return;
                        }
                        if (this.excludeSysSchemas && n3 == 2) {
                            for (n2 = 0; n2 < oracleSysSchemas.length; ++n2) {
                                if (!string2.equals(oracleSysSchemas[n2])) continue;
                                n4 = 1;
                                break;
                            }
                        }
                        if (this.fetchingVar != null) {
                            this.userVars.put(this.fetchingVar, string2);
                            this.fetchingVar = null;
                        }
                        if (bl) {
                            return;
                        }
                        if (string != null && (string2 == null || string2.indexOf(string) > -1)) {
                            n4 = 0;
                        }
                        stringArray[n7] = string2 == null && this.pwCsv == null ? (nArray3[n7] == 12 ? (this.htmlMode ? "<I>null</I>" : DEFAULT_NULL_REP) : "") : string2;
                        if (this.htmlMode || this.pwCsv != null || stringArray[n7].length() <= nArray2[n7]) continue;
                        nArray2[n7] = stringArray[n7].length();
                    }
                    if (n4 != 0) continue;
                    arrayList.add(stringArray);
                }
                if (this.pwCsv == null) {
                    this.condlPrintln("<TABLE border='1'>", true);
                    if (n6 > 1) {
                        this.condlPrint(SqlFile.htmlRow(0) + '\n' + PRE_TD, true);
                        for (n3 = 0; n3 < stringArray2.length; ++n3) {
                            this.condlPrint("<TD>" + stringArray2[n3] + "</TD>", true);
                            this.condlPrint((n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray2[n3], nArray2[n3], blArray[n3], n3 < stringArray2.length - 1 || blArray[n3]), false);
                        }
                        this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        if (!this.htmlMode) {
                            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                                this.condlPrint((n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray2[n3]), false);
                            }
                            this.condlPrintln("", false);
                        }
                    }
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        this.condlPrint(SqlFile.htmlRow(n3 % 2 == 0 ? 2 : 1) + '\n' + PRE_TD, true);
                        stringArray = (String[])arrayList.get(n3);
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            this.condlPrint("<TD>" + stringArray[n2] + "</TD>", true);
                            this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray[n2], nArray2[n2], blArray[n2], n2 < stringArray.length - 1 || blArray[n2]), false);
                        }
                        this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                    }
                    this.condlPrintln("</TABLE>", true);
                    if (arrayList.size() != 1) {
                        this.stdprintln("\n" + arrayList.size() + " rows", true);
                    }
                    this.condlPrintln("<HR>", true);
                    break;
                }
                if (n6 > 0) {
                    for (n3 = 0; n3 < stringArray2.length; ++n3) {
                        this.csvSafe(stringArray2[n3]);
                        this.pwCsv.print(stringArray2[n3]);
                        if (n3 >= stringArray2.length - 1) continue;
                        this.pwCsv.print(this.csvColDelim);
                    }
                    this.pwCsv.print(this.csvRowDelim);
                }
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    stringArray = (String[])arrayList.get(n3);
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        this.csvSafe(stringArray[n2]);
                        this.pwCsv.print(stringArray[n2] == null ? (blArray2[n2] ? "" : this.csvNullRep) : stringArray[n2]);
                        if (n2 >= stringArray.length - 1) continue;
                        this.pwCsv.print(this.csvColDelim);
                    }
                    this.pwCsv.print(this.csvRowDelim);
                }
                this.stdprintln(Integer.toString(arrayList.size()) + " rows read from DB");
                break;
            }
            default: {
                if (this.fetchingVar != null) {
                    this.userVars.put(this.fetchingVar, Integer.toString(n));
                    this.fetchingVar = null;
                }
                if (n == 0) break;
                this.stdprintln(Integer.toString(n) + " row" + (n == 1 ? "" : "s") + " updated");
            }
        }
    }

    private static String htmlRow(int n) {
        switch (n) {
            case 0: {
                return PRE_TR + "<TR style='font-weight: bold;'>";
            }
            case 1: {
                return PRE_TR + "<TR style='background: #94d6ef; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return PRE_TR + "<TR style='background: silver; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int n) {
        return n > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, n);
    }

    private static String spaces(int n) {
        return n > SPACES.length() ? SPACES : SPACES.substring(0, n);
    }

    private static String pad(String string, int n, boolean bl, boolean bl2) {
        if (!bl2) {
            return string;
        }
        int n2 = n - string.length();
        if (n2 < 1) {
            return string;
        }
        String string2 = SqlFile.spaces(n2);
        return (bl ? string2 : "") + string + (bl ? "" : string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showHistory() {
        String[] stringArray;
        int n;
        block17: {
            block16: {
                block15: {
                    n = -1;
                    stringArray = new String[this.statementHistory.length];
                    try {
                        String string;
                        int n2;
                        for (n2 = this.curHist; n2 >= 0; --n2) {
                            string = this.statementHistory[n2];
                            if (string == null) {
                                Object var6_5 = null;
                                if (n < 0) {
                                    this.stdprintln("<<<    No history yet    >>>");
                                    return;
                                }
                                break block15;
                            }
                            stringArray[++n] = string;
                        }
                        for (n2 = this.statementHistory.length - 1; n2 > this.curHist; --n2) {
                            string = this.statementHistory[n2];
                            if (string == null) {
                                break block16;
                            }
                            stringArray[++n] = string;
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        if (n < 0) {
                            this.stdprintln("<<<    No history yet    >>>");
                            return;
                        }
                        int n3 = n;
                        while (true) {
                            if (n3 < 0) {
                                this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                                throw throwable;
                            }
                            this.psStd.println((n3 == 0 ? "BUFR" : "-" + n3 + "  ") + " **********************************************\n" + stringArray[n3]);
                            --n3;
                        }
                    }
                }
                for (int i = n; i >= 0; --i) {
                    this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
                }
                this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                return;
            }
            Object var6_6 = null;
            if (n < 0) {
                this.stdprintln("<<<    No history yet    >>>");
                return;
            }
            for (int i = n; i >= 0; --i) {
                this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
            }
            this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
            return;
        }
        Object var6_7 = null;
        if (n < 0) {
            this.stdprintln("<<<    No history yet    >>>");
            return;
        }
        for (int i = n; i >= 0; --i) {
            this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
        }
        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
    }

    private String commandFromHistory(int n) throws BadSpecial {
        if (n >= this.statementHistory.length) {
            throw new BadSpecial("History can only hold up to " + this.statementHistory.length + " commands");
        }
        String string = this.statementHistory[(this.statementHistory.length + this.curHist - n) % this.statementHistory.length];
        if (string == null) {
            throw new BadSpecial("History doesn't go back that far");
        }
        return string;
    }

    private void setBuf(String string) {
        ++this.curHist;
        if (this.curHist == this.statementHistory.length) {
            this.curHist = 0;
        }
        this.statementHistory[this.curHist] = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describe(String string, String string2) throws SQLException {
        String string3 = string2;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[]{"name", "datatype", "width", "no-nulls"};
        int[] nArray = new int[]{0, 0, 0, 0};
        boolean[] blArray = new boolean[]{false, false, true, false};
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.htmlMode || stringArray[i].length() <= nArray[i]) continue;
            nArray[i] = stringArray[i].length();
        }
        Statement statement = this.curConn.createStatement();
        ResultSet resultSet = null;
        try {
            int n;
            String[] stringArray2;
            int n2;
            statement.execute("SELECT * FROM " + string + " WHERE 1 = 2");
            resultSet = statement.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray2 = new String[4];
                stringArray2[0] = resultSetMetaData.getColumnName(n2 + 1);
                if (string3 != null && stringArray2[0].indexOf(string3) < 0) continue;
                stringArray2[1] = resultSetMetaData.getColumnTypeName(n2 + 1);
                stringArray2[2] = Integer.toString(resultSetMetaData.getColumnDisplaySize(n2 + 1));
                stringArray2[3] = resultSetMetaData.isNullable(n2 + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : "*";
                arrayList.add(stringArray2);
                for (n = 0; n < stringArray2.length; ++n) {
                    if (stringArray2[n].length() <= nArray[n]) continue;
                    nArray[n] = stringArray2[n].length();
                }
            }
            this.condlPrint("<TABLE border='1'>\n" + SqlFile.htmlRow(0) + '\n' + PRE_TD, true);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.condlPrint("<TD>" + stringArray[n2] + "</TD>", true);
                this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray[n2], nArray[n2], blArray[n2], n2 < stringArray.length - 1 || blArray[n2]), false);
            }
            this.condlPrintln("\n" + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            if (!this.htmlMode) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray[n2]), false);
                }
                this.condlPrintln("", false);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.condlPrint(SqlFile.htmlRow(n2 % 2 == 0 ? 2 : 1) + '\n' + PRE_TD, true);
                stringArray2 = (String[])arrayList.get(n2);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.condlPrint("<TD>" + stringArray2[n] + "</TD>", true);
                    this.condlPrint((n > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray2[n], nArray[n], blArray[n], n < stringArray2.length - 1 || blArray[n]), false);
                }
                this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
            }
            this.condlPrintln("\n</TABLE>\n<HR>", true);
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            statement.close();
        }
        catch (Exception exception) {}
    }

    public static String[] getTokenArray(String string) {
        String[] stringArray = new String[]{};
        if (string == null) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringTokenizer.nextToken();
        }
        return stringArray2;
    }

    private boolean eval(String[] stringArray) throws BadSpecial {
        boolean bl = stringArray.length > 0 && stringArray[0].equals("!");
        String[] stringArray2 = new String[bl ? stringArray.length - 1 : stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray[i + (bl ? 1 : 0)].length() > 1 && stringArray[i + (bl ? 1 : 0)].charAt(0) == '*' ? (String)this.userVars.get(stringArray[i + (bl ? 1 : 0)].substring(1)) : (stringArray2[i] = stringArray[i + (bl ? 1 : 0)]);
            if (stringArray2[i] != null) continue;
            stringArray2[i] = "";
        }
        if (stringArray2.length == 1) {
            return (stringArray2[0].length() > 0 && !stringArray2[0].equals("0")) ^ bl;
        }
        if (stringArray2.length == 3) {
            if (stringArray2[1].equals("==")) {
                return stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals("!=") || stringArray2[1].equals("<>") || stringArray2[1].equals("><")) {
                return !stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals(">")) {
                return (stringArray2[0].length() > stringArray2[2].length() || stringArray2[0].length() == stringArray2[2].length() && stringArray2[0].compareTo(stringArray2[2]) > 0) ^ bl;
            }
            if (stringArray2[1].equals("<")) {
                return (stringArray2[2].length() > stringArray2[0].length() || stringArray2[2].length() == stringArray2[0].length() && stringArray2[2].compareTo(stringArray2[0]) > 0) ^ bl;
            }
        }
        throw new BadSpecial("Unrecognized logical operation");
    }

    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        if (this.htmlMode) {
            this.pwQuery.println("</BODY></HTML>");
            this.pwQuery.flush();
        }
        this.pwQuery.close();
        this.pwQuery = null;
    }

    private void condlPrintln(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        this.psStd.println(string);
        if (this.pwQuery != null) {
            this.pwQuery.println(string);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        this.psStd.print(string);
        if (this.pwQuery != null) {
            this.pwQuery.print(string);
            this.pwQuery.flush();
        }
    }

    private static String formatNicely(Map map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = new TreeMap(map).keySet().iterator();
        if (bl) {
            stringBuffer.append("The outermost parentheses are not part of the values.\n");
        } else {
            stringBuffer.append("Showing variable names and length of values (use 'listvalue' to see values).\n");
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            stringBuffer.append("    " + string + ": " + (bl ? "(" + string2 + ')' : Integer.toString(string2.length())) + '\n');
        }
        return stringBuffer.toString();
    }

    private void dump(String string, File file) throws IOException, BadSpecial {
        char c;
        String string2 = (String)this.userVars.get(string);
        if (string2 == null) {
            throw new BadSpecial("Variable '" + string + "' has no value set");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
        outputStreamWriter.write(string2);
        boolean bl = false;
        if (string2.length() > 0 && (c = string2.charAt(string2.length() - 1)) != '\n' && c != '\r') {
            bl = true;
            outputStreamWriter.write(10);
        }
        outputStreamWriter.flush();
        outputStreamWriter.close();
        this.stdprintln("Saved " + file.length() + " characters to '" + file + "'");
    }

    private void dump(File file) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial("Binary SqlFile buffer is currently empty");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(this.binBuffer);
        int n = this.binBuffer.length;
        this.binBuffer = null;
        fileOutputStream.flush();
        fileOutputStream.close();
        this.stdprintln("Saved " + n + " bytes to '" + file + "'");
    }

    private String streamToString(InputStream inputStream) throws IOException {
        int n;
        char[] cArray = new char[10240];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charset);
        while ((n = inputStreamReader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        return stringWriter.toString();
    }

    private byte[] streamToBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void load(String string, File file) throws IOException {
        int n;
        char[] cArray = new char[10240];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
        while ((n = inputStreamReader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        inputStreamReader.close();
        this.userVars.put(string, stringWriter.toString());
    }

    private void load(File file) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        while ((n = fileInputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        this.binBuffer = byteArrayOutputStream.toByteArray();
        this.stdprintln("Loaded " + this.binBuffer.length + " bytes into Binary buffer");
    }

    public static boolean canDisplayType(int n) {
        switch (n) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown type " + n;
    }

    public void csvSafe(String string) throws SQLException {
        if (this.pwCsv == null || this.csvColDelim == null || this.csvRowDelim == null || this.csvNullRep == null) {
            throw new RuntimeException("Assertion failed.  \ncsvSafe called when CSV settings are incomplete");
        }
        if (string == null) {
            return;
        }
        if (string.indexOf(this.csvColDelim) > 0) {
            throw new SQLException("Table data contains our column delimiter '" + this.csvColDelim + "'");
        }
        if (string.indexOf(this.csvRowDelim) > 0) {
            throw new SQLException("Table data contains our row delimiter '" + this.csvRowDelim + "'");
        }
        if (string.indexOf(this.csvNullRep) > 0) {
            throw new SQLException("Table data contains our null representation '" + this.csvNullRep + "'");
        }
    }

    public static String convertEscapes(String string) {
        if (string == null) {
            return null;
        }
        String string2 = new String(string);
        int n = 0;
        while ((n = string2.indexOf("\\n", n)) > -1 && n < string2.length() - 1) {
            string2 = string2.substring(0, n) + '\n' + string2.substring(n + 2);
        }
        n = 0;
        while ((n = string2.indexOf("\\r", n)) > -1 && n < string2.length() - 1) {
            string2 = string2.substring(0, n) + '\r' + string2.substring(n + 2);
        }
        n = 0;
        while ((n = string2.indexOf("\\t", n)) > -1 && n < string2.length() - 1) {
            string2 = string2.substring(0, n) + '\t' + string2.substring(n + 2);
        }
        return string2;
    }

    public void importCsv(String string) throws IOException, BadSpecial {
        int n;
        int n2;
        String[] stringArray;
        int n3;
        char[] cArray = null;
        File file = new File(string);
        if (!file.canRead()) {
            throw new IOException("Can't read file '" + file + "'");
        }
        int n4 = (int)file.length();
        try {
            cArray = new char[n4];
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("SqlFile can only read in your CSV file in one chunk at this time.\nPlease run the program with more RAM (try Java -Xm* switches).");
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
        int n5 = inputStreamReader.read(cArray, 0, cArray.length);
        inputStreamReader.close();
        if (n5 != cArray.length) {
            throw new IOException("Didn't read all characters.  Read in " + n5 + " characters");
        }
        String string2 = null;
        try {
            string2 = new String(cArray);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("SqlFile converts your entire CSV file to a String at this time.\nPlease run the program with more RAM (try Java -Xm* switches).");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n6 = 0;
        int n7 = string2.indexOf(this.csvRowDelim, n6);
        if (n7 < 0) {
            n7 = string2.length();
        }
        int n8 = n6;
        int n9 = -1;
        while (n9 != n7) {
            n9 = string2.indexOf(this.csvColDelim, n8);
            if (n9 < 0 || n9 > n7) {
                n9 = n7;
            }
            if (n9 - n8 < 1) {
                throw new IOException("No column header for column " + (arrayList.size() + 1));
            }
            arrayList.add(string2.substring(n8, n9));
            n8 = n9 + this.csvColDelim.length();
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        boolean[] blArray = new boolean[stringArray2.length];
        String string3 = (String)this.userVars.get("*CSV_TABLENAME");
        if (string3 == null && (n3 = (string3 = file.getName()).lastIndexOf(46)) > 0) {
            string3 = string3.substring(0, n3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray2[i]);
        }
        StringBuffer stringBuffer2 = new StringBuffer("INSERT INTO " + string3 + " (" + stringBuffer + ") VALUES (");
        StringBuffer stringBuffer3 = new StringBuffer("SELECT " + stringBuffer + " FROM " + string3 + " WHERE 1 = 2");
        try {
            stringArray = this.curConn.createStatement().executeQuery(stringBuffer3.toString()).getMetaData();
            if (stringArray.getColumnCount() != blArray.length) {
                throw new BadSpecial("Metadata mismatch for columns");
            }
            for (n2 = 0; n2 < blArray.length; ++n2) {
                n = stringArray.getColumnType(n2 + 1);
                blArray[n2] = n != -3 && n != 12;
            }
        }
        catch (SQLException sQLException) {
            throw new BadSpecial("Failed to get metadata for query: " + sQLException.getMessage());
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append('?');
        }
        try {
            PreparedStatement preparedStatement = this.curConn.prepareStatement(stringBuffer2.toString() + ')');
            stringArray = new String[stringArray2.length];
            n2 = 0;
            while ((n6 = n7 + this.csvRowDelim.length()) < string2.length()) {
                n7 = string2.indexOf(this.csvRowDelim, n6);
                if (n7 < 0) {
                    n7 = string2.length();
                }
                n8 = n6;
                n9 = -1;
                int n10 = 0;
                ++n2;
                while (n9 != n7) {
                    n9 = string2.indexOf(this.csvColDelim, n8);
                    if (n9 < 0 || n9 > n7) {
                        n9 = n7;
                    }
                    if (n10 == stringArray.length) {
                        throw new IOException("Header has " + stringArray2.length + " columns.  CSV record " + n2 + " has too many column values.");
                    }
                    stringArray[n10++] = string2.substring(n8, n9);
                    n8 = n9 + this.csvColDelim.length();
                }
                if (n10 != stringArray.length) {
                    throw new IOException("Header has " + stringArray2.length + " columns.  CSV record " + n2 + " has " + n10 + " column values.");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(i + 1, stringArray[i].length() < 1 && blArray[i] || stringArray[i].equals(this.csvNullRep) ? null : stringArray[i]);
                }
                n5 = preparedStatement.executeUpdate();
                if (n5 != 1) {
                    this.curConn.rollback();
                    throw new BadSpecial("Insert of row " + n2 + " failed.  " + n5 + " rows modified");
                }
                this.possiblyUncommitteds.set(true);
            }
            this.stdprintln("Successfully inserted " + n2 + " rows into table '" + string3 + "'");
        }
        catch (SQLException sQLException) {
            try {
                this.curConn.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new BadSpecial("SQL error encountered when inserting CSV data: " + sQLException);
        }
    }

    static {
        revnum = "$Revision: 1.134 $".substring("$Revision: ".length(), "$Revision: 1.134 $".length() - 2);
        BANNER = "(SqlFile processor v. " + revnum + ")\n" + "Distribution is permitted under the terms of the HSQLDB license.\n" + "(c) 2004-2005 Blaine Simpson and the HSQLDB Development Group.\n\n" + "    \\q    to Quit.\n" + "    \\?    lists Special Commands.\n" + "    :?    lists Buffer/Editing commands.\n" + "    *?    lists PL commands (including alias commands).\n\n" + "SPECIAL Commands begin with '\\' and execute when you hit ENTER.\n" + "BUFFER Commands begin with ':' and execute when you hit ENTER.\n" + "COMMENTS begin with '/*' and end with the very next '*/'.\n" + "PROCEDURAL LANGUAGE commands begin with '*' and end when you hit ENTER.\n" + "All other lines comprise SQL Statements.\n" + "  SQL Statements are terminated by either a blank line (which moves the\n" + "  statement into the buffer without executing) or a line ending with ';'\n" + "  (which executes the statement).\n" + "  SQL Statements may begin with '/PLVARNAME' and/or contain *{PLVARNAME}s.\n";
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r'};
        DEFAULT_ROW_DELIM = System.getProperty("line.separator");
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        PRE_TR = SqlFile.spaces(4);
        PRE_TD = SqlFile.spaces(8);
    }

    private class BadSwitch
    extends Exception {
        private BadSwitch(int n) {
            super(Integer.toString(n));
        }
    }

    private class ContinueException
    extends SqlToolError {
        public ContinueException() {
        }

        public ContinueException(String string) {
            super(string);
        }
    }

    private class BreakException
    extends SqlToolError {
        public BreakException() {
        }

        public BreakException(String string) {
            super(string);
        }
    }

    private class QuitNow
    extends SqlToolError {
        public QuitNow(String string) {
            super(string);
        }

        public QuitNow() {
        }
    }

    private class BadSpecial
    extends Exception {
        private BadSpecial() {
        }

        private BadSpecial(String string) {
            super(string);
        }
    }

    private static class BooleanBucket {
        private boolean bPriv = false;

        private BooleanBucket() {
        }

        public void set(boolean bl) {
            this.bPriv = bl;
        }

        public boolean get() {
            return this.bPriv;
        }
    }
}

