/*
 * Jitsi, the OpenSource Java VoIP and Instant Messaging client.
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package net.java.sip.communicator.impl.protocol.zeroconf;

import net.java.sip.communicator.service.protocol.*;

/**
 * Implements typing notifications for the Zeroconf protocol. The operation
 * set would simply mirror all outgoing typing notifications and make them
 * appear as incoming events generated by the contact that we are currently
 * writing a message to.
 *
 * @author Christian Vincenot
 * @author Maxime Catelin
 * @author Jonathan Martin
 */
public class OperationSetTypingNotificationsZeroconfImpl
    extends AbstractOperationSetTypingNotifications<ProtocolProviderServiceZeroconfImpl>
{

    /**
     * Creates a new instance of this operation set and keeps the parent
     * provider as a reference.
     *
     * @param provider a ref to the <tt>ProtocolProviderServiceImpl</tt>
     * that created us and that we'll use for retrieving the underlying aim
     * connection.
     */
    OperationSetTypingNotificationsZeroconfImpl(
        ProtocolProviderServiceZeroconfImpl provider)
    {
        super(provider);
    }

    /**
     * Sends a notification to <tt>notifiedContatct</tt> that we have entered
     * <tt>typingState</tt>.
     *
     * @param notifiedContact the <tt>Contact</tt> to notify
     * @param typingState the typing state that we have entered.
     *
     * @throws java.lang.IllegalStateException if the underlying stack is
     * not registered and initialized.
     * @throws java.lang.IllegalArgumentException if <tt>notifiedContact</tt> is
     * not an instance belonging to the underlying implementation.
     */
    public void sendTypingNotification(Contact notifiedContact, int typingState)
        throws IllegalStateException, IllegalArgumentException
    {
        if( !(notifiedContact instanceof ContactZeroconfImpl) )
           throw new IllegalArgumentException(
               "The specified contact is not a Zeroconf contact."
               + notifiedContact);

        ContactZeroconfImpl to = (ContactZeroconfImpl)notifiedContact;

        ClientThread thread = to.getClientThread();
        if (thread == null) return;/*throw new IllegalStateException(
               "No communication channel opened to chat with this contact");*/

        if (typingState != STATE_TYPING)
            return;

        MessageZeroconfImpl message =
                new MessageZeroconfImpl("",null, MessageZeroconfImpl.TYPING);
        thread.sendMessage(message);
    }
}
