/*
 * File    : TextStyleEditorPanel.java
 * Created : 05-jun-2003 12:49
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.activities.text;

import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.Style;
import edu.xtec.util.Options;
import javax.swing.JComboBox;
import edu.xtec.util.FontCheck;
import edu.xtec.jclic.beans.ColorButton;
import java.awt.Color;
import java.util.HashMap;
import java.awt.Component;
import edu.xtec.util.StreamIO;
import java.awt.Dimension;
import javax.swing.text.DefaultStyledDocument;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.net)
 * @version 1.0
 */
public class TextStyleEditorPanel extends javax.swing.JPanel implements java.beans.PropertyChangeListener, java.awt.event.ActionListener, javax.swing.event.ChangeListener  {
    
    Options options;
    StyleContext sc;
    private static StyleContext emptySc;
    
    /** Creates new form TextStyleEditorPanel */
    public TextStyleEditorPanel(Options options, StyleContext sc) {
        this.options=options;
        initComponents();
        setStyleContext(sc);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        javax.swing.JLabel bgColorLb;
        javax.swing.JLabel colorsLb;
        javax.swing.JLabel errorBgLb;
        javax.swing.JLabel errorFgLb;
        javax.swing.JLabel errorLb;
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel mainLb;
        javax.swing.JPanel previewFrame;
        javax.swing.JScrollPane previewScroll;
        javax.swing.JLabel tabLb;
        javax.swing.JLabel targetBgLb;
        javax.swing.JLabel targetFgLb;
        javax.swing.JLabel targetLb;
        javax.swing.JLabel textColorLb;

        mainLb = new javax.swing.JLabel();
        fontFaceCombo = new JComboBox(FontCheck.getFontList(false));
        fontSizeCombo = new JComboBox(FontCheck.fontSizes);
        boldBtn = new javax.swing.JToggleButton();
        italicBtn = new javax.swing.JToggleButton();
        underlineBtn = new javax.swing.JToggleButton();
        colorsLb = new javax.swing.JLabel();
        textColorLb = new javax.swing.JLabel();
        textColorBtn = new edu.xtec.jclic.beans.ColorButton();
        textColorBtn.setOptions(options);
        bgColorLb = new javax.swing.JLabel();
        bgColorBtn = new edu.xtec.jclic.beans.ColorButton();
        bgColorBtn.setOptions(options);
        tabLb = new javax.swing.JLabel();
        tabSlider = new javax.swing.JSlider();
        targetLb = new javax.swing.JLabel();
        targetFgLb = new javax.swing.JLabel();
        targetFgColor = new edu.xtec.jclic.beans.ColorButton();
        targetFgColor.setOptions(options);
        targetBgLb = new javax.swing.JLabel();
        targetBgColor = new edu.xtec.jclic.beans.ColorButton();
        targetBgColor.setOptions(options);
        errorLb = new javax.swing.JLabel();
        errorFgLb = new javax.swing.JLabel();
        errorFgColor = new edu.xtec.jclic.beans.ColorButton();
        errorFgColor.setOptions(options);
        errorBgLb = new javax.swing.JLabel();
        errorBgColor = new edu.xtec.jclic.beans.ColorButton();
        errorBgColor.setOptions(options);
        previewFrame = new javax.swing.JPanel();
        previewScroll = new javax.swing.JScrollPane();
        previewPanel = new javax.swing.JTextPane();

        setLayout(new java.awt.GridBagLayout());

        mainLb.setText(options.getMsg("edit_text_act_mainStyle"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(mainLb, gridBagConstraints);

        fontFaceCombo.setEditable(true);
        fontFaceCombo.setPreferredSize(new Dimension(125, fontFaceCombo.getPreferredSize().height));
        fontFaceCombo.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(fontFaceCombo, gridBagConstraints);

        fontSizeCombo.setEditable(true);
        fontSizeCombo.setPreferredSize(new Dimension(50, fontSizeCombo.getPreferredSize().height));
        fontSizeCombo.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 4);
        add(fontSizeCombo, gridBagConstraints);

        boldBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/font_bold.gif")));
        boldBtn.setToolTipText(options.getMsg("edit_font_bold"));
        boldBtn.setPreferredSize(new java.awt.Dimension(27, 27));
        boldBtn.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        add(boldBtn, gridBagConstraints);

        italicBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/font_italic.gif")));
        italicBtn.setToolTipText(options.getMsg("edit_font_italic"));
        italicBtn.setPreferredSize(new java.awt.Dimension(27, 27));
        italicBtn.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(italicBtn, gridBagConstraints);

        underlineBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/font_underline.gif")));
        underlineBtn.setToolTipText(options.getMsg("edit_font_italic"));
        underlineBtn.setPreferredSize(new java.awt.Dimension(27, 27));
        underlineBtn.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 4);
        add(underlineBtn, gridBagConstraints);

        colorsLb.setText(options.getMsg("edit_text_act_colors"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(colorsLb, gridBagConstraints);

        textColorLb.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        textColorLb.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        add(textColorLb, gridBagConstraints);

        textColorBtn.setToolTipText(options.getMsg("edit_act_textColor_tooltip"));
        textColorBtn.addPropertyChangeListener(ColorButton.PROP_COLOR, this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(textColorBtn, gridBagConstraints);

        bgColorLb.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        bgColorLb.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        add(bgColorLb, gridBagConstraints);

        bgColorBtn.setToolTipText(options.getMsg("edit_act_bgColor_tooltip"));
        bgColorBtn.addPropertyChangeListener(ColorButton.PROP_COLOR, this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 4);
        add(bgColorBtn, gridBagConstraints);

        tabLb.setText(options.getMsg("edit_text_act_tabSize"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(tabLb, gridBagConstraints);

        tabSlider.setMinorTickSpacing(5);
        tabSlider.setPaintLabels(true);
        tabSlider.setPaintTicks(true);
        tabSlider.setMajorTickSpacing(10);
        tabSlider.setMaximum(50);
        tabSlider.setValue(12);
        tabSlider.addChangeListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(tabSlider, gridBagConstraints);

        targetLb.setText(options.getMsg("edit_text_act_targetStyle"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(targetLb, gridBagConstraints);

        targetFgLb.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        targetFgLb.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        add(targetFgLb, gridBagConstraints);

        targetFgColor.setToolTipText(options.getMsg("edit_act_textColor_tooltip"));
        targetFgColor.addPropertyChangeListener(ColorButton.PROP_COLOR, this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(targetFgColor, gridBagConstraints);

        targetBgLb.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        targetBgLb.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        add(targetBgLb, gridBagConstraints);

        targetBgColor.setToolTipText(options.getMsg("edit_act_bgColor_tooltip"));
        targetBgColor.addPropertyChangeListener(ColorButton.PROP_COLOR, this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 4);
        add(targetBgColor, gridBagConstraints);

        errorLb.setText(options.getMsg("edit_text_act_errorStyle"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(errorLb, gridBagConstraints);

        errorFgLb.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        errorFgLb.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        add(errorFgLb, gridBagConstraints);

        errorFgColor.setToolTipText(options.getMsg("edit_act_textColor_tooltip"));
        errorFgColor.addPropertyChangeListener(ColorButton.PROP_COLOR, this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(errorFgColor, gridBagConstraints);

        errorBgLb.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        errorBgLb.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        add(errorBgLb, gridBagConstraints);

        errorBgColor.setToolTipText(options.getMsg("edit_act_bgColor_tooltip"));
        errorBgColor.addPropertyChangeListener(ColorButton.PROP_COLOR, this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 4);
        add(errorBgColor, gridBagConstraints);

        previewFrame.setLayout(new java.awt.BorderLayout());

        previewFrame.setBorder(new javax.swing.border.TitledBorder(options.getMsg("edit_text_act_preview")));
        previewScroll.setPreferredSize(new java.awt.Dimension(300, 100));
        previewPanel.setEditable(false);
        previewScroll.setViewportView(previewPanel);

        previewFrame.add(previewScroll, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(previewFrame, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    private static StyleContext getEmptySc(){
        if(emptySc==null){
            emptySc=new StyleContext();
            TextActivityDocument.checkStyleContext(emptySc);
        }
        return emptySc;
    }
    
    public void setStyleContext(StyleContext styleContext){
        sc = (styleContext==null ? getEmptySc() : styleContext);
        TextActivityDocument.checkStyleContext(sc);
        Style defaultStyle=sc.getStyle(StyleContext.DEFAULT_STYLE);
        
        fontFaceCombo.setSelectedItem(StyleConstants.getFontFamily(defaultStyle));
        fontSizeCombo.setSelectedItem(Integer.toString(StyleConstants.getFontSize(defaultStyle)));
        boldBtn.setSelected(StyleConstants.isBold(defaultStyle));
        italicBtn.setSelected(StyleConstants.isItalic(defaultStyle));
        underlineBtn.setSelected(StyleConstants.isUnderline(defaultStyle));
        bgColorBtn.setColor(StyleConstants.getBackground(defaultStyle));
        
        textColorBtn.setColor(StyleConstants.getForeground(defaultStyle));
        
        int tabSpc=TextActivityDocument.DEFAULT_TAB;
        Object o=defaultStyle.getAttribute(TextActivityDocument.TABSPC);
        if(o!=null){
            try{
                tabSpc=Math.max(1, Math.min(Integer.parseInt(o.toString()), 50));
            } catch(Exception ex){
                // ???
            }
        }        
        tabSlider.setValue(tabSpc);
        
        Style targetStyle=sc.getStyle(TextActivityDocument.TARGET);
        targetBgColor.setColor(StyleConstants.getBackground(targetStyle));
        targetFgColor.setColor(StyleConstants.getForeground(targetStyle));
        
        Style errorStyle=sc.getStyle(TextActivityDocument.TARGET_ERROR);
        errorBgColor.setColor(StyleConstants.getBackground(errorStyle));
        errorFgColor.setColor(StyleConstants.getForeground(errorStyle));
        
        updatePreview(null);
        
    }
    
    public StyleContext getStyleContext(java.util.EventObject evt){
        
        Object src=(evt==null ? null : evt.getSource());
        
        Style defaultStyle=sc.getStyle(StyleContext.DEFAULT_STYLE);
        
        if(src==null || src==fontFaceCombo){
            String fontFace=(String)fontFaceCombo.getSelectedItem();
            if(fontFace!=null && fontFace.length()>0 && !fontFace.equals(StyleConstants.getFontFamily(defaultStyle)))
                StyleConstants.setFontFamily(defaultStyle, fontFace);
        }
        
        if(src==null || src==fontSizeCombo){
            String fontSize=(String)fontSizeCombo.getSelectedItem();
            if(fontSize!=null && fontSize.length()>0){
                try{
                    int fs=Integer.parseInt(fontSize);
                    if(fs!=StyleConstants.getFontSize(defaultStyle))
                        StyleConstants.setFontSize(defaultStyle, fs);
                } catch(Exception ex){
                    // ignore
                }
            }
        }
        
        if(src==null || src==boldBtn){
            boolean bold=boldBtn.isSelected();
            if(bold!=StyleConstants.isBold(defaultStyle))
                StyleConstants.setBold(defaultStyle, bold);
        }
        
        if(src==null || src==italicBtn){
            boolean italic=italicBtn.isSelected();
            if(italic!=StyleConstants.isItalic(defaultStyle))
                StyleConstants.setItalic(defaultStyle, italic);
        }
        
        if(src==null || src==underlineBtn){
            boolean underline=underlineBtn.isSelected();
            if(underline!=StyleConstants.isUnderline(defaultStyle))
                StyleConstants.setUnderline(defaultStyle, underline);
        }
        
        if(src==null || src==bgColorBtn){
            Color c=bgColorBtn.getColor();
            if(!c.equals(StyleConstants.getBackground(defaultStyle)))
                StyleConstants.setBackground(defaultStyle, c);
        }
        
        if(src==null || src==textColorBtn){
            Color c=textColorBtn.getColor();
            if(!c.equals(StyleConstants.getForeground(defaultStyle)))
                StyleConstants.setForeground(defaultStyle, c);
        }
        
        if(src==null || src==tabSlider){
            String tabSpc=Integer.toString(Math.max(1, tabSlider.getValue()));
            if(!tabSpc.equals(defaultStyle.getAttribute(TextActivityDocument.TABSPC))){
                defaultStyle.removeAttribute(TextActivityDocument.TABSPC);
                defaultStyle.addAttribute(TextActivityDocument.TABSPC, tabSpc);
            }
        }
        
        Style targetStyle=sc.getStyle(TextActivityDocument.TARGET);
        if(src==null || src==targetFgColor){
            Color c=targetFgColor.getColor();
            if(!c.equals(StyleConstants.getForeground(targetStyle)))
                StyleConstants.setForeground(targetStyle, c);
        }
        
        if(src==null || src==targetBgColor){
            Color c=targetBgColor.getColor();
            if(!c.equals(StyleConstants.getBackground(targetStyle)))
                StyleConstants.setBackground(targetStyle, c);
        }
        
        Style errorStyle=sc.getStyle(TextActivityDocument.TARGET_ERROR);
        if(src==null || src==errorFgColor){
            Color c=errorFgColor.getColor();
            if(!c.equals(StyleConstants.getForeground(errorStyle)))
                StyleConstants.setForeground(errorStyle, c);
        }
        
        if(src==null || src==errorBgColor){
            Color c=errorBgColor.getColor();
            if(!c.equals(StyleConstants.getBackground(errorStyle)))
                StyleConstants.setBackground(errorStyle, c);
        }
        
        return sc;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent evt) {
        updatePreview(evt);
    }
    
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        updatePreview(evt);
    }
    
    public void stateChanged(javax.swing.event.ChangeEvent evt) {
        if(evt!=null && evt.getSource()==tabSlider && !tabSlider.getValueIsAdjusting())
            updatePreview(evt);
    }
    
    private void updatePreview(java.util.EventObject evt){
        if(evt!=null)
            getStyleContext(evt);
        try{
            Style defaultStyle=sc.getStyle(StyleContext.DEFAULT_STYLE);
            DefaultStyledDocument dsd;
            dsd=new DefaultStyledDocument((StyleContext)StreamIO.cloneObject(sc));
            Object tabObj=defaultStyle.getAttribute(TextActivityDocument.TABSPC);
            if(tabObj!=null){
                int tabSpc=Math.max(1, Integer.parseInt(tabObj.toString()));
                TextActivityDocument.setStyledDocumentTabSpc(tabSpc, dsd, sc);
            }
            StringBuffer sb=new StringBuffer();
            for(int i=0; i<5; i++)
                sb.append("T").append(i).append("\t");
            dsd.insertString(0, sb.append("\n").toString(), defaultStyle);
            
            for(int i=0; i<2; i++){
                sb.setLength(0);
                sb.append(options.getMsg("edit_text_act_styleSample_default_start")).append(" ");
                dsd.insertString(dsd.getLength(), sb.toString(), defaultStyle);
                
                sb.setLength(0);
                sb.append(options.getMsg("edit_text_act_styleSample_target"));
                dsd.insertString(dsd.getLength(), sb.toString(), sc.getStyle(TextActivityDocument.TARGET));
                
                sb.setLength(0);
                sb.append(" ").append(options.getMsg("edit_text_act_styleSample_default_fill")).append(" ");
                dsd.insertString(dsd.getLength(), sb.toString(), defaultStyle);
                
                sb.setLength(0);
                sb.append(options.getMsg("edit_text_act_styleSample_error"));
                dsd.insertString(dsd.getLength(), sb.toString(), sc.getStyle(TextActivityDocument.TARGET_ERROR));
                
                sb.setLength(0);
                sb.append(" ").append(options.getMsg("edit_text_act_styleSample_default_end")).append("\n");
                dsd.insertString(dsd.getLength(), sb.toString(), defaultStyle);
            }
            
            previewPanel.setStyledDocument(dsd);
            previewPanel.setBackground(StyleConstants.getBackground(defaultStyle));
            
        } catch(Exception ex){
            System.err.println("Internal error:\n"+ex);
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private edu.xtec.jclic.beans.ColorButton bgColorBtn;
    private javax.swing.JToggleButton boldBtn;
    private edu.xtec.jclic.beans.ColorButton errorBgColor;
    private edu.xtec.jclic.beans.ColorButton errorFgColor;
    private javax.swing.JComboBox fontFaceCombo;
    private javax.swing.JComboBox fontSizeCombo;
    private javax.swing.JToggleButton italicBtn;
    private javax.swing.JTextPane previewPanel;
    private javax.swing.JSlider tabSlider;
    private edu.xtec.jclic.beans.ColorButton targetBgColor;
    private edu.xtec.jclic.beans.ColorButton targetFgColor;
    private edu.xtec.jclic.beans.ColorButton textColorBtn;
    private javax.swing.JToggleButton underlineBtn;
    // End of variables declaration//GEN-END:variables
    
    private static HashMap panels=new HashMap(1);
    public static StyleContext editStyleContext(Options options, StyleContext sc, Component parent){
        
        StyleContext result=null;
        StyleContext clon=null;
        if(sc!=null){
            try{
                clon=(StyleContext)StreamIO.cloneObject(sc);
            } catch(Exception ex){
                System.err.println("Internal error: cannot clone object: "+sc+"\n"+ex);
            }
        }
        TextStyleEditorPanel tsep=(TextStyleEditorPanel)panels.get(options);
        if(tsep==null){
            tsep=new TextStyleEditorPanel(options, clon);
            panels.put(options, tsep);
        }
        else
            tsep.setStyleContext(clon);
        if(options.getMessages().showInputDlg(parent, tsep, "edit_style_title"))
            result=tsep.getStyleContext(null);
        
        //tsep.setStyleContext(getEmptySc());
        return result;
    }
    
}
