/*
 *  LockWidget.h - widget for locking a client
 *
 *  Copyright (c) 2006-2016 Tobias Doerffel <tobydox/at/users/dot/sf/dot/net>
 *
 *  This file is part of iTALC - http://italc.sourceforge.net
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef LOCK_WIDGET_H
#define LOCK_WIDGET_H

#include <italcconfig.h>

#include <QWidget>
#include <QPixmap>

#include "InputDeviceBlocker.h"


class LockWidget : public QWidget
{
	Q_OBJECT
public:
	typedef enum Modes
	{
		DesktopVisible,
		Black,
		NoBackground
	} Mode;

	LockWidget( Mode mode = Black );
	virtual ~LockWidget();


private:
	virtual void paintEvent( QPaintEvent * );

	QPixmap m_background;
	Mode m_mode;
	InputDeviceBlocker m_inputDeviceBlocker;

} ;

#endif

