/*
 * Copyright (c) 2012, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.el;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_el extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "WAST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "WAST",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MST",
               "\u038f\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MT",
            };
        final String[] Omsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OST",
               "\u038f\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HAST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HADT",
               "\u038f\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "SST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "SST",
               "\u038f\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YST",
               "\u038f\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03bf\u03cd \u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Vladivostok = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VST",
               "\u038f\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WEST",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WET",
            };
        final String[] Brasilia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BST",
               "\u038f\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BT",
            };
        final String[] Hovd = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HST",
               "\u038f\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1\u03c2",
               "WIT",
            };
        final String[] Amazon = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AST",
               "\u038f\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "UBST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "UBST",
               "\u038f\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "UBT",
            };
        final String[] Africa_Central = new String[] {
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1\u03c2",
               "CIT",
            };
        final String[] America_Pacific = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd",
               "PST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd",
               "PDT",
               "\u038f\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "\u038f\u03c1\u03b1 \u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "WAST",
               "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "WAST",
               "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NDT",
               "\u038f\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03bb\u03b3\u03ba\u03bf\u03b3\u03ba\u03c1\u03b1\u03bd\u03c4",
               "VST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03bb\u03b3\u03ba\u03bf\u03b3\u03ba\u03c1\u03b1\u03bd\u03c4",
               "VST",
               "\u038f\u03c1\u03b1 \u0392\u03cc\u03bb\u03b3\u03ba\u03bf\u03b3\u03ba\u03c1\u03b1\u03bd\u03c4",
               "VT",
            };
        final String[] America_Central = new String[] {
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "CST",
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "CDT",
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Argentina = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "AST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "AST",
               "\u038f\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b5\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b5\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YST",
               "\u038f\u03c1\u03b1 \u0393\u03b5\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YT",
            };
        final String[] Lord_Howe = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHDT",
               "\u038f\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHT",
            };
        final String[] Africa_Southern = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03cc\u03c4\u03b9\u03b1\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "\u038f\u03c1\u03b1 \u039c\u03b1\u03ba\u03bf\u03c5\u03ac\u03c1\u03b9",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AEST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AEDT",
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IST",
               "\u038f\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IT",
            };
        final String[] Choibalsan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CST",
               "\u038f\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u038f\u03c1\u03b1 \u03b4\u03c5\u03c4\u03b9\u03ba\u03bf\u03cd \u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] America_Eastern = new String[] {
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "EST",
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "EDT",
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AWST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AWDT",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWDT",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KST",
               "\u038f\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1\u03c2",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNST",
               "\u038f\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NST",
               "\u038f\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "MST",
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "MDT",
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "MT",
            };
        final String[] Europe_Central = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CEST",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CET",
            };
        final String[] Alaska = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKDT",
               "\u038f\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACDT",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "CAT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EEST",
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "AST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "ADT",
               "\u038f\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "AT",
            };
        final String[] Magadan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03ac\u03b3\u03ba\u03b1\u03bd\u03c4\u03b1\u03bd",
               "MST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03b1\u03b3\u03ba\u03b1\u03bd\u03c4\u03ac\u03bd",
               "MST",
               "\u038f\u03c1\u03b1 \u039c\u03ac\u03b3\u03ba\u03b1\u03bd\u03c4\u03b1\u03bd",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "Europe/Samara", Moscow },
            { "Africa/Douala", Africa_Western },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/New_York", America_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Ndjamena", Africa_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Istanbul", Europe_Eastern },
            { "Europe/Copenhagen", Europe_Central },
            { "America/Thule", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "America/Cayman", America_Eastern },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Berlin", Europe_Central },
            { "America/St_Johns", Newfoundland },
            { "Africa/Asmera", Africa_Eastern },
            { "Asia/Omsk", Omsk },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Maseru", Africa_Southern },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Europe/Prague", Europe_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Toronto", America_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Montserrat", Atlantic },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Indianapolis", America_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "America/Halifax", Atlantic },
            { "Europe/Vilnius", Europe_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Nome", Alaska },
            { "America/Moncton", Atlantic },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Belize", America_Central },
            { "America/Vancouver", America_Pacific },
            { "America/Cuiaba", Amazon },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Africa/Nairobi", Africa_Eastern },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Europe/Paris", Europe_Central },
            { "America/Lower_Princes", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Asia/Irkutsk", Irkutsk },
            { "Africa/Porto-Novo", Africa_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Juba", Africa_Eastern },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "America/Jamaica", America_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Phoenix", America_Mountain },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Anchorage", Alaska },
            { "Australia/Currie", Australia_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "America/Jujuy", Argentina },
            { "Europe/Rome", Europe_Central },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Denver", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Chicago", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "Africa/Libreville", Africa_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Minsk", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Edmonton", America_Mountain },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "America/Los_Angeles", America_Pacific },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Africa/Casablanca", Europe_Western },
            { "America/St_Barthelemy", Atlantic },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Europe/Bratislava", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Europe/Zagreb", Europe_Central },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Europe/Warsaw", Europe_Central },
            { "America/Monterrey", America_Central },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Sitka", Alaska },
        };
        return data;
    }
}
