/* 
 * IRiver ifp supporting functions, a basic (primative) API.
 * $Id: error_strings.c,v 1.1.1.1 2005/08/04 19:45:27 jim-campbell Exp $
 *
 * Copyright (C) Geoff Oakham, 2004; <oakhamg@users.sourceforge.net>
 */

static const char rcsid[] = "$Id: ";

#include <stdio.h>
#include <string.h>

#include "ifp.h"
#include "ifp_os.h"

#define IFP_ERR_BASE (3)

#define MAX_MESSAGES 9
static const char * messages[MAX_MESSAGES] = {
	"File not found.",
	"Filename is not available--allready in use by a file or directory.",
	"Directory not found.",
	"Directory exists.",
	"Directory is not empty.",
	"Device is present, but not responding; try jiggling the handle.",
	"FM station frequency is outside the reasonable range.  Typically, FM stations are between 87.5MHz and 108.0MHz.",
	"Filename contains characters that aren't supported by iFP devices.",
	"Progress callback requested transfer be cancelled.",
};

/** \brief Return an English string describing an error number. 
 *
 * (Available only in userland.)*/
const char * ifp_error_message(int n) {
	if (n<0) {
		return strerror(-n);
	} else if (n == 0) {
		return "error: succeeded.  Please install windows and try again.";
	} else if (n < IFP_ERR_BASE || n >= IFP_ERR_BASE + MAX_MESSAGES) {
		return "internal error.. unknown error number.";
	} else {
		return messages[n - IFP_ERR_BASE];
	}
}
IFP_EXPORT(ifp_error_message);

