package CParse::Enumerator;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $name = shift;
    my $value = shift;

    my $self = {name => $name,
                value => $value,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $name = $self->{name};

    if (defined $self->{value})
      {
        my $value = $self->{value}->dump_c;
        return "$name = $value";
      }
    else
      {
        return $name;
      }
  }

sub get_member
  {
    my $self = shift;
    my $namespace = shift;

    return {name => $self->{name}, value => $self->{value} ? $self->{value}->get_expr : undef};
  }

1;
