// Code generated by gqlclientgen - DO NOT EDIT.

package buildssrht

import (
	"context"
	"encoding/json"
	"fmt"
	gqlclient "git.sr.ht/~emersion/gqlclient"
)

type AccessKind string

const (
	AccessKindRo AccessKind = "RO"
	AccessKindRw AccessKind = "RW"
)

type AccessScope string

const (
	AccessScopeProfile AccessScope = "PROFILE"
	AccessScopeJobs    AccessScope = "JOBS"
	AccessScopeLogs    AccessScope = "LOGS"
	AccessScopeSecrets AccessScope = "SECRETS"
)

type Artifact struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	// Original path in the guest
	Path string `json:"path"`
	// Size in bytes
	Size int32 `json:"size"`
	// URL at which the artifact may be downloaded, or null if pruned
	Url *string `json:"url,omitempty"`
}

type Binary string

type Cursor string

type EmailTrigger struct {
	Condition TriggerCondition `json:"condition"`
	To        string           `json:"to"`
	Cc        *string          `json:"cc,omitempty"`
	InReplyTo *string          `json:"inReplyTo,omitempty"`
}

func (*EmailTrigger) isTrigger() {}

type EmailTriggerInput struct {
	To        string  `json:"to"`
	Cc        *string `json:"cc,omitempty"`
	InReplyTo *string `json:"inReplyTo,omitempty"`
}

type Entity struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Updated gqlclient.Time `json:"updated"`
	// The canonical name of this entity. For users, this is their username
	// prefixed with '~'. Additional entity types will be supported in the future.
	CanonicalName string `json:"canonicalName"`

	// Underlying value of the GraphQL interface
	Value EntityValue `json:"-"`
}

func (base *Entity) UnmarshalJSON(b []byte) error {
	type Raw Entity
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "User":
		base.Value = new(User)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Entity: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// EntityValue is one of: User
type EntityValue interface {
	isEntity()
}

type File string

type Job struct {
	Id         int32          `json:"id"`
	Created    gqlclient.Time `json:"created"`
	Updated    gqlclient.Time `json:"updated"`
	Status     JobStatus      `json:"status"`
	Manifest   string         `json:"manifest"`
	Note       *string        `json:"note,omitempty"`
	Tags       []string       `json:"tags"`
	Visibility Visibility     `json:"visibility"`
	// Name of the build image
	Image string `json:"image"`
	// Name of the build runner which picked up this job, or null if the job is
	// pending or queued.
	Runner    *string    `json:"runner,omitempty"`
	Owner     *Entity    `json:"owner"`
	Group     *JobGroup  `json:"group,omitempty"`
	Tasks     []Task     `json:"tasks"`
	Artifacts []Artifact `json:"artifacts"`
	// The job's top-level log file, not associated with any tasks
	Log *Log `json:"log,omitempty"`
	// List of secrets available to this job, or null if they were disabled
	Secrets []Secret `json:"secrets,omitempty"`
}

// A cursor for enumerating a list of jobs
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type JobCursor struct {
	Results []Job   `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type JobEvent struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
	Job   *Job           `json:"job"`
}

func (*JobEvent) isWebhookPayload() {}

type JobGroup struct {
	Id       int32          `json:"id"`
	Created  gqlclient.Time `json:"created"`
	Note     *string        `json:"note,omitempty"`
	Owner    *Entity        `json:"owner"`
	Jobs     []Job          `json:"jobs"`
	Triggers []Trigger      `json:"triggers"`
}

type JobStatus string

const (
	JobStatusPending   JobStatus = "PENDING"
	JobStatusQueued    JobStatus = "QUEUED"
	JobStatusRunning   JobStatus = "RUNNING"
	JobStatusSuccess   JobStatus = "SUCCESS"
	JobStatusFailed    JobStatus = "FAILED"
	JobStatusTimeout   JobStatus = "TIMEOUT"
	JobStatusCancelled JobStatus = "CANCELLED"
)

type Log struct {
	// The most recently written 128 KiB of the build log.
	Last128KiB string `json:"last128KiB"`
	// The URL at which the full build log can be downloaded with an authenticated
	// GET request (text/plain).
	FullURL string `json:"fullURL"`
}

type OAuthClient struct {
	Uuid string `json:"uuid"`
}

type PGPKey struct {
	Id         int32          `json:"id"`
	Created    gqlclient.Time `json:"created"`
	Uuid       string         `json:"uuid"`
	Name       *string        `json:"name,omitempty"`
	FromUser   *Entity        `json:"fromUser,omitempty"`
	PrivateKey Binary         `json:"privateKey"`
}

func (*PGPKey) isSecret() {}

type SSHKey struct {
	Id         int32          `json:"id"`
	Created    gqlclient.Time `json:"created"`
	Uuid       string         `json:"uuid"`
	Name       *string        `json:"name,omitempty"`
	FromUser   *Entity        `json:"fromUser,omitempty"`
	PrivateKey Binary         `json:"privateKey"`
}

func (*SSHKey) isSecret() {}

type Secret struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Uuid    string         `json:"uuid"`
	Name    *string        `json:"name,omitempty"`
	// Set when this secret was copied from another user account
	FromUser *Entity `json:"fromUser,omitempty"`

	// Underlying value of the GraphQL interface
	Value SecretValue `json:"-"`
}

func (base *Secret) UnmarshalJSON(b []byte) error {
	type Raw Secret
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "SSHKey":
		base.Value = new(SSHKey)
	case "PGPKey":
		base.Value = new(PGPKey)
	case "SecretFile":
		base.Value = new(SecretFile)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Secret: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// SecretValue is one of: SSHKey | PGPKey | SecretFile
type SecretValue interface {
	isSecret()
}

// A cursor for enumerating a list of secrets
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type SecretCursor struct {
	Results []Secret `json:"results"`
	Cursor  *Cursor  `json:"cursor,omitempty"`
}

type SecretFile struct {
	Id       int32          `json:"id"`
	Created  gqlclient.Time `json:"created"`
	Uuid     string         `json:"uuid"`
	Name     *string        `json:"name,omitempty"`
	FromUser *Entity        `json:"fromUser,omitempty"`
	Path     string         `json:"path"`
	Mode     int32          `json:"mode"`
	Data     Binary         `json:"data"`
}

func (*SecretFile) isSecret() {}

type Settings struct {
	SshUser      string `json:"sshUser"`
	BuildTimeout string `json:"buildTimeout"`
}

type Task struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Updated gqlclient.Time `json:"updated"`
	Name    string         `json:"name"`
	Status  TaskStatus     `json:"status"`
	Log     *Log           `json:"log,omitempty"`
	Job     *Job           `json:"job"`
}

type TaskStatus string

const (
	TaskStatusPending TaskStatus = "PENDING"
	TaskStatusRunning TaskStatus = "RUNNING"
	TaskStatusSuccess TaskStatus = "SUCCESS"
	TaskStatusFailed  TaskStatus = "FAILED"
	TaskStatusSkipped TaskStatus = "SKIPPED"
)

// Triggers run upon the completion of all of the jobs in a job group. Note that
// these triggers are distinct from the ones defined by an individual job's
// build manifest, but are similar in functionality.
type Trigger struct {
	Condition TriggerCondition `json:"condition"`

	// Underlying value of the GraphQL interface
	Value TriggerValue `json:"-"`
}

func (base *Trigger) UnmarshalJSON(b []byte) error {
	type Raw Trigger
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "EmailTrigger":
		base.Value = new(EmailTrigger)
	case "WebhookTrigger":
		base.Value = new(WebhookTrigger)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Trigger: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// TriggerValue is one of: EmailTrigger | WebhookTrigger
type TriggerValue interface {
	isTrigger()
}

type TriggerCondition string

const (
	TriggerConditionSuccess TriggerCondition = "SUCCESS"
	TriggerConditionFailure TriggerCondition = "FAILURE"
	TriggerConditionAlways  TriggerCondition = "ALWAYS"
)

type TriggerInput struct {
	Type      TriggerType          `json:"type"`
	Condition TriggerCondition     `json:"condition"`
	Email     *EmailTriggerInput   `json:"email,omitempty"`
	Webhook   *WebhookTriggerInput `json:"webhook,omitempty"`
}

type TriggerType string

const (
	TriggerTypeEmail   TriggerType = "EMAIL"
	TriggerTypeWebhook TriggerType = "WEBHOOK"
)

type User struct {
	Id            int32          `json:"id"`
	Created       gqlclient.Time `json:"created"`
	Updated       gqlclient.Time `json:"updated"`
	CanonicalName string         `json:"canonicalName"`
	Username      string         `json:"username"`
	Email         string         `json:"email"`
	Url           *string        `json:"url,omitempty"`
	Location      *string        `json:"location,omitempty"`
	Bio           *string        `json:"bio,omitempty"`
	// Jobs submitted by this user.
	Jobs *JobCursor `json:"jobs"`
}

func (*User) isEntity() {}

type UserWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type UserWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

func (*UserWebhookSubscription) isWebhookSubscription() {}

type Version struct {
	Major int32 `json:"major"`
	Minor int32 `json:"minor"`
	Patch int32 `json:"patch"`
	// If this API version is scheduled for deprecation, this is the date on which
	// it will stop working; or null if this API version is not scheduled for
	// deprecation.
	DeprecationDate gqlclient.Time `json:"deprecationDate,omitempty"`
	Settings        *Settings      `json:"settings"`
}

type Visibility string

const (
	VisibilityPublic   Visibility = "PUBLIC"
	VisibilityUnlisted Visibility = "UNLISTED"
	VisibilityPrivate  Visibility = "PRIVATE"
)

type WebhookDelivery struct {
	Uuid         string               `json:"uuid"`
	Date         gqlclient.Time       `json:"date"`
	Event        WebhookEvent         `json:"event"`
	Subscription *WebhookSubscription `json:"subscription"`
	RequestBody  string               `json:"requestBody"`
	// These details are provided only after a response is received from the
	// remote server. If a response is sent whose Content-Type is not text/*, or
	// cannot be decoded as UTF-8, the response body will be null. It will be
	// truncated after 64 KiB.
	ResponseBody    *string `json:"responseBody,omitempty"`
	ResponseHeaders *string `json:"responseHeaders,omitempty"`
	ResponseStatus  *int32  `json:"responseStatus,omitempty"`
}

// A cursor for enumerating a list of webhook deliveries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookDeliveryCursor struct {
	Results []WebhookDelivery `json:"results"`
	Cursor  *Cursor           `json:"cursor,omitempty"`
}

type WebhookEvent string

const (
	WebhookEventJobCreated WebhookEvent = "JOB_CREATED"
)

type WebhookPayload struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`

	// Underlying value of the GraphQL interface
	Value WebhookPayloadValue `json:"-"`
}

func (base *WebhookPayload) UnmarshalJSON(b []byte) error {
	type Raw WebhookPayload
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "JobEvent":
		base.Value = new(JobEvent)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookPayload: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookPayloadValue is one of: JobEvent
type WebhookPayloadValue interface {
	isWebhookPayload()
}

type WebhookSubscription struct {
	Id     int32          `json:"id"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
	Url    string         `json:"url"`
	// If this webhook was registered by an authorized OAuth 2.0 client, this
	// field is non-null.
	Client *OAuthClient `json:"client,omitempty"`
	// All deliveries which have been sent to this webhook.
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	// Returns a sample payload for this subscription, for testing purposes
	Sample string `json:"sample"`

	// Underlying value of the GraphQL interface
	Value WebhookSubscriptionValue `json:"-"`
}

func (base *WebhookSubscription) UnmarshalJSON(b []byte) error {
	type Raw WebhookSubscription
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "UserWebhookSubscription":
		base.Value = new(UserWebhookSubscription)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookSubscription: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookSubscriptionValue is one of: UserWebhookSubscription
type WebhookSubscriptionValue interface {
	isWebhookSubscription()
}

// A cursor for enumerating a list of webhook subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookSubscriptionCursor struct {
	Results []WebhookSubscription `json:"results"`
	Cursor  *Cursor               `json:"cursor,omitempty"`
}

type WebhookTrigger struct {
	Condition TriggerCondition `json:"condition"`
	Url       string           `json:"url"`
}

func (*WebhookTrigger) isTrigger() {}

type WebhookTriggerInput struct {
	Url string `json:"url"`
}

func Submit(client *gqlclient.Client, ctx context.Context, manifest string, tags []string, note *string, visibility *Visibility) (submit *Job, err error) {
	op := gqlclient.NewOperation("mutation submit ($manifest: String!, $tags: [String!], $note: String, $visibility: Visibility) {\n\tsubmit(manifest: $manifest, tags: $tags, note: $note, visibility: $visibility) {\n\t\tid\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t}\n}\n")
	op.Var("manifest", manifest)
	op.Var("tags", tags)
	op.Var("note", note)
	op.Var("visibility", visibility)
	var respData struct {
		Submit *Job
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Submit, err
}

func Cancel(client *gqlclient.Client, ctx context.Context, jobId int32) (cancel *Job, err error) {
	op := gqlclient.NewOperation("mutation cancel ($jobId: Int!) {\n\tcancel(jobId: $jobId) {\n\t\tid\n\t}\n}\n")
	op.Var("jobId", jobId)
	var respData struct {
		Cancel *Job
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Cancel, err
}

func CreateUserWebhook(client *gqlclient.Client, ctx context.Context, config UserWebhookInput) (createUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createUserWebhook ($config: UserWebhookInput!) {\n\tcreateUserWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateUserWebhook, err
}

func DeleteUserWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteUserWebhook ($id: Int!) {\n\tdeleteUserWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteUserWebhook, err
}

func ShareSecret(client *gqlclient.Client, ctx context.Context, uuid string, user string) (shareSecret *Secret, err error) {
	op := gqlclient.NewOperation("mutation shareSecret ($uuid: String!, $user: String!) {\n\tshareSecret(uuid: $uuid, user: $user) {\n\t\tuuid\n\t}\n}\n")
	op.Var("uuid", uuid)
	op.Var("user", user)
	var respData struct {
		ShareSecret *Secret
	}
	err = client.Execute(ctx, op, &respData)
	return respData.ShareSecret, err
}

func Monitor(client *gqlclient.Client, ctx context.Context, id int32) (job *Job, err error) {
	op := gqlclient.NewOperation("query monitor ($id: Int!) {\n\tjob(id: $id) {\n\t\tstatus\n\t\tlog {\n\t\t\tfullURL\n\t\t}\n\t\ttasks {\n\t\t\tname\n\t\t\tstatus\n\t\t\tlog {\n\t\t\t\tfullURL\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		Job *Job
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Job, err
}

func Manifest(client *gqlclient.Client, ctx context.Context, id int32) (job *Job, err error) {
	op := gqlclient.NewOperation("query manifest ($id: Int!) {\n\tjob(id: $id) {\n\t\tmanifest\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t\tvisibility\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		Job *Job
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Job, err
}

func JobIDs(client *gqlclient.Client, ctx context.Context) (jobs *JobCursor, err error) {
	op := gqlclient.NewOperation("query jobIDs {\n\tjobs {\n\t\tresults {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	var respData struct {
		Jobs *JobCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Jobs, err
}

func Jobs(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (jobs *JobCursor, err error) {
	op := gqlclient.NewOperation("query jobs ($cursor: Cursor) {\n\tjobs(cursor: $cursor) {\n\t\t... jobs\n\t}\n}\nfragment jobs on JobCursor {\n\tresults {\n\t\tid\n\t\tstatus\n\t\tnote\n\t\ttags\n\t\ttasks {\n\t\t\tname\n\t\t\tstatus\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Jobs *JobCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Jobs, err
}

func JobsByUser(client *gqlclient.Client, ctx context.Context, username string, cursor *Cursor) (userByName *User, err error) {
	op := gqlclient.NewOperation("query jobsByUser ($username: String!, $cursor: Cursor) {\n\tuserByName(username: $username) {\n\t\tjobs(cursor: $cursor) {\n\t\t\t... jobs\n\t\t}\n\t}\n}\nfragment jobs on JobCursor {\n\tresults {\n\t\tid\n\t\tstatus\n\t\tnote\n\t\ttags\n\t\ttasks {\n\t\t\tname\n\t\t\tstatus\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("username", username)
	op.Var("cursor", cursor)
	var respData struct {
		UserByName *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserByName, err
}

func ExportJob(client *gqlclient.Client, ctx context.Context, id int32) (job *Job, err error) {
	op := gqlclient.NewOperation("query exportJob ($id: Int!) {\n\tjob(id: $id) {\n\t\t... jobExport\n\t}\n}\nfragment jobExport on Job {\n\tid\n\tstatus\n\tnote\n\ttags\n\tvisibility\n\tlog {\n\t\tfullURL\n\t}\n\ttasks {\n\t\tname\n\t\tstatus\n\t\tlog {\n\t\t\tfullURL\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		Job *Job
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Job, err
}

func ExportJobs(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (jobs *JobCursor, err error) {
	op := gqlclient.NewOperation("query exportJobs ($cursor: Cursor) {\n\tjobs(cursor: $cursor) {\n\t\tresults {\n\t\t\t... jobExport\n\t\t}\n\t\tcursor\n\t}\n}\nfragment jobExport on Job {\n\tid\n\tstatus\n\tnote\n\ttags\n\tvisibility\n\tlog {\n\t\tfullURL\n\t}\n\ttasks {\n\t\tname\n\t\tstatus\n\t\tlog {\n\t\t\tfullURL\n\t\t}\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Jobs *JobCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Jobs, err
}

func Show(client *gqlclient.Client, ctx context.Context, id int32) (job *Job, err error) {
	op := gqlclient.NewOperation("query show ($id: Int!) {\n\tjob(id: $id) {\n\t\tid\n\t\tstatus\n\t\tnote\n\t\ttags\n\t\tlog {\n\t\t\tfullURL\n\t\t}\n\t\ttasks {\n\t\t\tname\n\t\t\tstatus\n\t\t\tlog {\n\t\t\t\tfullURL\n\t\t\t}\n\t\t}\n\t\tgroup {\n\t\t\tjobs {\n\t\t\t\tid\n\t\t\t\tstatus\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		Job *Job
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Job, err
}

func Secrets(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (secrets *SecretCursor, err error) {
	op := gqlclient.NewOperation("query secrets ($cursor: Cursor) {\n\tsecrets(cursor: $cursor) {\n\t\tresults {\n\t\t\tcreated\n\t\t\tuuid\n\t\t\tname\n\t\t\tfromUser {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t\t__typename\n\t\t\t... on SecretFile {\n\t\t\t\tpath\n\t\t\t\tmode\n\t\t\t}\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Secrets *SecretCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Secrets, err
}

func GetSSHInfo(client *gqlclient.Client, ctx context.Context, id int32) (job *Job, version *Version, err error) {
	op := gqlclient.NewOperation("query getSSHInfo ($id: Int!) {\n\tjob(id: $id) {\n\t\tid\n\t\trunner\n\t}\n\tversion {\n\t\tsettings {\n\t\t\tsshUser\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		Job     *Job
		Version *Version
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Job, respData.Version, err
}

func RunningJobs(client *gqlclient.Client, ctx context.Context) (jobs *JobCursor, err error) {
	op := gqlclient.NewOperation("query runningJobs {\n\tjobs {\n\t\tresults {\n\t\t\tid\n\t\t\tstatus\n\t\t\tnote\n\t\t\ttags\n\t\t}\n\t}\n}\n")
	var respData struct {
		Jobs *JobCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Jobs, err
}

func Artifacts(client *gqlclient.Client, ctx context.Context, id int32) (job *Job, err error) {
	op := gqlclient.NewOperation("query artifacts ($id: Int!) {\n\tjob(id: $id) {\n\t\tartifacts {\n\t\t\tpath\n\t\t\tsize\n\t\t\turl\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		Job *Job
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Job, err
}

func UserWebhooks(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (userWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query userWebhooks ($cursor: Cursor) {\n\tuserWebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		UserWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserWebhooks, err
}

func CompleteSecrets(client *gqlclient.Client, ctx context.Context) (secrets *SecretCursor, err error) {
	op := gqlclient.NewOperation("query completeSecrets {\n\tsecrets {\n\t\tresults {\n\t\t\tuuid\n\t\t\tname\n\t\t}\n\t}\n}\n")
	var respData struct {
		Secrets *SecretCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Secrets, err
}
