# Rendering small caps, superscripts and subscripts with and without `raw_html`

## Small caps

```
% pandoc --wrap=none -f latex -t commonmark-raw_html
This has \textsc{small caps} in it.
^D
This has SMALL CAPS in it.
```

```
% pandoc --wrap=none -f latex -t commonmark+raw_html
This has \textsc{small caps} in it.
^D
This has <span class="smallcaps">small caps</span> in it.
```

```
% pandoc --wrap=none -f latex -t markdown_strict+raw_html
This has \textsc{small caps} in it.
^D
This has <span class="smallcaps">small caps</span> in it.
```

## Strikeout

```
% pandoc --wrap=none -f html -t commonmark-raw_html-strikeout
This has <s>strikeout</s> in it.
^D
This has strikeout in it.
```

```
% pandoc --wrap=none -f html -t commonmark+raw_html-strikeout
This has <s>strikeout</s> in it.
^D
This has <s>strikeout</s> in it.
```

```
% pandoc --wrap=none -f html -t commonmark-raw_html+strikeout
This has <s>strikeout</s> in it.
^D
This has ~~strikeout~~ in it.
```

```
% pandoc --wrap=none -f html -t commonmark+raw_html+strikeout
This has <s>strikeout</s> in it.
^D
This has ~~strikeout~~ in it.
```

```
% pandoc --wrap=none -f html -t markdown_strict-raw_html-strikeout
This has <s>strikeout</s> in it.
^D
This has strikeout in it.
```

```
% pandoc --wrap=none -f html -t markdown_strict+raw_html-strikeout
This has <s>strikeout</s> in it.
^D
This has <s>strikeout</s> in it.
```

```
% pandoc --wrap=none -f html -t markdown_strict-raw_html+strikeout
This has <s>strikeout</s> in it.
^D
This has ~~strikeout~~ in it.
```

```
% pandoc --wrap=none -f html -t markdown_strict+raw_html+strikeout
This has <s>strikeout</s> in it.
^D
This has ~~strikeout~~ in it.
```

## Superscript

```
% pandoc --wrap=none -f html -t commonmark-raw_html
This has <sup>superscript</sup> in it and <sup>2 3</sup> again. With emphasis: <sup><em>2</em> 3</sup>. With letters: <sup>foo</sup>. With a span: <sup><span class=foo>2</span></sup>.
^D
This has ^(superscript) in it and ² ³ again. With emphasis: ^(*2* 3). With letters: ^(foo). With a span: ².
```

```
% pandoc --wrap=none -f html -t commonmark+raw_html
This has <sup>superscript</sup> in it and <sup>2</sup> again.
^D
This has <sup>superscript</sup> in it and <sup>2</sup> again.
```

```
% pandoc --wrap=none -f html -t markdown_strict-raw_html-superscript
This has <sup>superscript</sup> in it and <sup>2</sup> again.
^D
This has ^(superscript) in it and ² again.
```

```
% pandoc --wrap=none -f html -t markdown_strict+raw_html-superscript
This has <sup>superscript</sup> in it and <sup>2</sup> again.
^D
This has <sup>superscript</sup> in it and <sup>2</sup> again.
```

```
% pandoc --wrap=none -f html -t markdown_strict+raw_html+superscript
This has <sup>superscript</sup> in it and <sup>2</sup> again.
^D
This has ^superscript^ in it and ^2^ again.
```

## Subscript

```
% pandoc --wrap=none -f html -t commonmark-raw_html
This has <sub>subscript</sub> in it and <sub>2 3</sub> again. With emphasis: <sub><em>2</em> 3</sub>. With letters: <sub>foo</sub>. With a span: <sub><span class=foo>2</span></sub>.
^D
This has _(subscript) in it and ₂ ₃ again. With emphasis: _(*2* 3). With letters: _(foo). With a span: ₂.
```

```
% pandoc --wrap=none -f html -t commonmark+raw_html
This has <sub>subscript</sub> in it and <sub>2</sub> again.
^D
This has <sub>subscript</sub> in it and <sub>2</sub> again.
```

```
% pandoc --wrap=none -f html -t markdown_strict-raw_html-subscript
This has <sub>subscript</sub> in it and <sub>2</sub> again.
^D
This has _(subscript) in it and ₂ again.
```

```
% pandoc --wrap=none -f html -t markdown_strict+raw_html-subscript
This has <sub>subscript</sub> in it and <sub>2</sub> again.
^D
This has <sub>subscript</sub> in it and <sub>2</sub> again.
```

```
% pandoc --wrap=none -f html -t markdown_strict+raw_html+subscript
This has <sub>subscript</sub> in it and <sub>2</sub> again.
^D
This has ~subscript~ in it and ~2~ again.
```
