#!/usr/bin/env runhaskell

-- file: Setup.hs

-- Haskell bindings for the Augeas library
-- Copyright (c) 2009-2012 Jude Nagurney

-- This library is free software; you can redistribute it and/or modify it 
-- under the terms of the GNU Lesser General Public License as published by 
-- the Free Software Foundation; either version 3 of the License, or 
-- (at your option) any later version.

-- This library is distributed in the hope that it will be useful, but 
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
-- or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public 
-- License for more details.

-- You should have received a copy of the GNU Lesser General Public License 
-- along with this library; if not, write to the Free Software Foundation, 
-- Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

-- Contact the author at 
-- jude@pwan.org 

import Data.List (isInfixOf)
import Distribution.PackageDescription
import Distribution.Simple
import Distribution.Simple.LocalBuildInfo (buildDir)
import System.Process 

-- main = defaultMain

-- Thanks http://mechablue.livejournal.com/11055.html
main = defaultMainWithHooks autoconfUserHooks { runTests = _runTests, instHook = _instHook }
    where
        -- Run all executables with names that end in -tests
        _runTests _ _ pd lbi = do
            let exeNames = [buildDir lbi ++ "/" ++ fp ++ "/" ++ fp | fp <- map exeName (executables pd)]
            sequence [_runTest e | e <- exeNames, isInfixOf "test-" e]
            return ()
        _runTest fp = do
            ph <- runCommand fp
            waitForProcess ph
        
        -- Only install executables that don't end in -tests
        _instHook pd lbi uhs ifs = do
            let execs = filter (\e -> not $ isInfixOf "test-" (exeName e)) (executables pd)
            (instHook simpleUserHooks) (pd {executables = execs}) lbi uhs ifs
 




