(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     54965,       1320]
NotebookOptionsPosition[     53236,       1254]
NotebookOutlinePosition[     53591,       1270]
CellTagsIndexPosition[     53548,       1267]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Rot3", "Title",
 CellChangeTimes->{{3.53503261234345*^9, 3.535032616575417*^9}}],

Cell["Taylor Expansion in Logmap", "Subsubtitle",
 CellChangeTimes->{{3.53503257044002*^9, 3.535032603813589*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.53494959325854*^9, 3.5349495996148577`*^9}, {
  3.534949645480898*^9, 3.534949695346019*^9}, {3.5349519201240377`*^9, 
  3.534951920202557*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "2"], "+", 
   FractionBox[
    SuperscriptBox["t", "2"], "12"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t", "]"}], "4"],
    SeriesData[$CellContext`t, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`t, 0, {
    Rational[1, 2], 0, 
    Rational[1, 12]}, 0, 4, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.534949687074999*^9, 3.5349496959309673`*^9}, 
   3.534951921216683*^9, 3.535032674514707*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], "+", 
    FractionBox[
     SuperscriptBox["t", "2"], "12"], "-", 
    RowBox[{"t", "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", 
      SuperscriptBox["10", 
       RowBox[{"-", "4"}]]}], ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "4"}]]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5349519227655277`*^9, 3.534952059744272*^9}, {
  3.534952158494419*^9, 3.5349521906793823`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGDwBWIQvfKAxs1HZlL7GaBAaoEO91EjBL+r3sB2uR6Mv2BP
jp3Fwmw1hLzBHvfML6II+W3b036yfpWEyx9at0RSczOMv8Dm1hyFqHx9hLzc
x7X3LwlKwPnGgVGbldnFEeq7F+1ZzygGl59i13BK6JkIXF7+b41a8l1huPxe
Y/72rn1CcP4bF1vZt0sEEfzELkbbeQJw9/57e/PKcSZ+uPwx/btOH97xwOU3
qknI9D/lQviHt+7f7fUccPtLeZRqmRewweX9fn9guZnMApf3mv/9u4oRE1z+
RZRNu7caA9z8MN4Ie4c7v/fB+ApTNq+Yt/37Pph6s98pKpFWn2HyNiozud8y
LHkLl0+Z5cq0K+spnF+xI6wijOEmnJ/zSXWO9JYDcP7J4jOcco/228H4rzcu
7Fyz9iaCfyQ//J/kUzjf40OSax7fOzi/d7G1c1POZzh/03xPbYm273B+925G
xqAfv+F8gSty/tn8DPYwvrloq5G5BBOcb5F2gCfUl8Ue5r/p8/d6zYhhg/Mv
vOiv153BAVefLqUi8WItF5x/e1qDq85OHjhfU3lT5qEPfHD+69OXftg1CsD5
enzmO1wXCML5D0r/OwruEoLzD15cUfv+gDCc3791z5Zvd0Vg7tnT07txrsAL
Ubj89y6uwPdvxOB8f4Fz/7+xS8D51zqLEgQFJOH8jUmhy9aISCLMs7Z44y6J
kHd++7e8TgnB3xDQ2f/aBMHvFl+w72gkgu+w9KxM1WIEX7puQ5LoCgT/W9jk
FRvWIOxbyxFp8nwrgi+V88Q75ARC/Rej31V6bxH889z3Dpz8iOCvenKALfUb
gp84rW3S7P8I/rmfgqs4hKQQ6i99eb9YTAoen62rr5vaS8P5e2xi5x4sVUGo
FzdrYBfURPA/8SX7rtFF8M89d53sboTgQ8svOB8Aw5IwBQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->NCache[{{
      Rational[-1, 10000], 
      Rational[1, 10000]}, {-1.1102230246251565`*^-16, 
     1.1102230246251565`*^-16}}, {{-0.0001, 
    0.0001}, {-1.1102230246251565`*^-16, 1.1102230246251565`*^-16}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.534951942222381*^9, 3.534952060527275*^9}, {
   3.534952162599*^9, 3.534952191138659*^9}, 3.5350326747077627`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", "-", "1"}], ")"}], "/", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2.999", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.534952571728985*^9, 3.534952573574695*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd03s403sYAHCJmLScXKJ0dE8zzBSnyKtDirJTISXMyGXJJTSRRTtlUglj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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2.999, 0},
  PlotRange->{{2.999, 3}, {0., 0.031624094042906566`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5349525739053583`*^9, 3.5350326747659903`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exp", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"t", "-", "1"}], ")"}], "/", "2"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"ArcCos", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"t", "-", "1"}], ")"}], "/", "2"}], "]"}], "]"}]}], ")"}]}],
    "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.5349524147561817`*^9, 3.534952440599073*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcCos", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "]"}], 
  SqrtBox[
   RowBox[{"3", "+", 
    RowBox[{"2", " ", "t"}], "-", 
    SuperscriptBox["t", "2"]}]]]], "Output",
 CellChangeTimes->{{3.5349524185902843`*^9, 3.534952440931364*^9}, 
   3.53495257882157*^9, 3.535032674837762*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"exp", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "3", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.534952442827351*^9, 3.534952504096322*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"Floor", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Arg", "[", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "t"}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"t", "-", "3"}], "12"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"t", "-", "3"}], "]"}], "2"],
      SeriesData[$CellContext`t, 3, {}, 0, 4, 2],
      Editable->False]}],
    SeriesData[$CellContext`t, 3, {
      Rational[1, 2], 0, 
      Rational[-1, 12]}, 0, 4, 2],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{{3.534952468159314*^9, 3.534952504519527*^9}, 
   3.5349525813815613`*^9, 3.535032675341729*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"exp", "-", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox[
        RowBox[{"t", "-", "3"}], "12"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"3", "-", 
      SuperscriptBox["10", 
       RowBox[{"-", "5"}]]}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5349523003273087`*^9, 3.5349523851505747`*^9}, {
  3.53495248711434*^9, 3.534952536039465*^9}, {3.534952588798771*^9, 
  3.534952638528079*^9}, {3.534952687358019*^9, 3.53495271171415*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxNl3dczv33xy8hm8gmMm5bkmyHpFsh2VvpThIqDSpFXaU9dLWudl3V1S5a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     "]], 
    LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQzVZfvPzff3YHIcZUizX7j9nm2QusBPGBUgwBIgv2
SlvvXgXjJ/ju2HvCLG0NjM9wPHtvmZHgOhi/YM8aW2W9Peth/AUFu/de0Ezf
COMbHNxsW6cqtBnGP+C32FZbce8WGP+B96K9N2QytsHtu7XS9uROrh0w/ofG
o7a7wtbuhNs/d63t6s/+u2H8Crlte+dM+LQH7h7djXt7dafug+t32Wdbd8r8
AIw/IX2TbX76rYMwfkNT494EltrDMH6G3BbbwIXyR2F8nd8HbJ3sDh2Du9dg
1V7j2ykn4PxbG/aqVLCfgvE74rbbioquOg3jO7A12LJt8jkL4194tsP2h9/7
czD+Bte1e1++nngBxlfRP2Z75EvJRXh8nN+yd8Hf8Etw/0/bbFvBoXYZxO+b
9/fxyuxjewGnuMBY
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQne6/7u+//+wOQoypFmv2H7M9tUbjP4gPlGLQ6Nm3
l6XsAsN/KJ9hX5KtnX0FE4y/gG+rbTmHAguMr2F0cO+Gi8dZ4eq199q+mpXP
DuPviNtg+8oylAPGV7izxPblDStOGL9hZ6Hti3IFLhhfwGX53hdibNwwfsGV
3XtfbH0N55+Ytdn2echFHhjf4VfX3meft/HC+AGv9+59NmkOH4x/wGC+7TPD
Jn4Y/8bBnXufXkgXgPundartk3xfQbh7lh2wfcJnLATn31m698laCWG4e+KW
2D72+Qfnf9l5ZO+j149F4OHhu3vvo66TojC+RP+GvY8014vB+BvaF+0VyYgQ
/48U/gBzi6AA
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQ7b/mivj//+wOQoypFmv2H7N9kF4lAeIDpRgUdk/Z
+4AtQRLGX/B5wd4HS12lYHyBw+v23nfRlobxT3zYuffeYwEZGP/Cuv2295q+
IfjvV9veU7wjCzdfbt7euwcOysH4HB8P296JXy4P43/4uNT2zr8eBRi/4PbW
vXfmFinC+Anv1tretolQgvElenbuvXXbVhnGd0iaYHurSlkFxn9hvc+25hWL
KozvwXXIVjbqGZw/Reuw7b6Tx9Vg/JDKQ7YJlivVYfwJD/fbMq7s0oDxI8S2
2y6SyNGEy3MttXXp8NWC+69s+t6KBZLayOELACBjkig=
     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQ3b/8vPn//+wOQoypFmv2H7ONakqxAPGBUgwJu+fv
/fPR1RLGL7BdtndeoroVjO8RuWmv/UUOaxi/Y83evQ8cXsH5N4wP2zZtOG0D
4wtIbrZVVlhrC+MrPJq490h/nx2M/0X3wN60//n2cPNLt9iy5wc6wPgM29fv
PcP6zRHGP3PioO2kObOcYfwNtav3Rhjbu8L4FxgX2cqdeuwG40+w3Gj7JKHD
A8YP4Ftqu+q7jhdc/veyvQV9F71h/AfXjtiaqZb5ws27vmzvn91S/jC+wc9l
toeC9gfA9fNutu14mRwEd+/6pbYMGwyDkcMXAA+ckuw=
     "]], 
    LineBox[{{2.999998729757736, 4.137968357662562*^-11}, {
     2.9999987309883034`, 3.7702174715548153`*^-11}, {
     2.999998743229053, -1.4494294653388806`*^-11}, {2.999998755469803, 
     6.441402966572696*^-12}, {2.9999987677105526`, 1.259414794674285*^-11}, {
     2.9999987743468823`, 2.920952368867802*^-11}, {
     2.999998780241817, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999991679239697`, 4.137968357662562*^-11}, {
     2.99999917833395, -9.078404694662368*^-12}, {2.9999991904816525`, 
     1.2033374297004684`*^-11}, {2.999999202629355, 
     1.0655143434235015`*^-11}, {
     2.9999992147770573`, -1.4256928970723948`*^-11}, {
     2.999999221279455, -4.078276301635248*^-11}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQXdUVd+vff3YHIcZUizX7j9kahJndBvGBUgwOa6fb
csdL3oHxz8Qe3vss/Q+c/0Jnl+2hgvt3YfwA2x1751YeugfjZxw9aFvRtPQ+
jF+xd8vekO6OBzC+he72vfpTsh/C9Rfs2cs11+8RjL/j9Bbbp0sNH8P4H74t
tj2wTuQJjN/wqHfvnO3f4fyOpC17yw/cegrja/w/vDfo5N5nMP6BiIl79S4t
eA7jJ6zZY8t5u/kFjM/wIML2yeO0lzD+jOu7bfe/8XwF4ytsmbl31led1zD+
hp3rbMv+8b+B8U8w7NzLffTxG+TwBABEPp4n
     "]], 
    LineBox[{{2.9999979523912486`, 4.137968357662562*^-11}, {
     2.9999979630466145`, 1.2050249686978987`*^-11}, {2.9999979753804116`, 
     2.31316077403676*^-11}, {2.9999979877142087`, 
     2.4898971773268386`*^-11}, {2.9999980000480058`, 
     1.7180257216864447`*^-11}, {
     2.999998012381803, -2.0095036745715333`*^-13}, {
     2.9999980247155995`, -2.7426061421920167`*^-11}, {
     2.999998037049396, -8.121392447435483*^-12}, {2.9999980493831933`, 
     1.6789902801406242`*^-12}, {2.9999980617169903`, 
     1.793898363189328*^-12}, {2.9999980719124095`, 4.137968357662562*^-11}}],
     LineBox[{{2.999998415870899, 4.137968357662562*^-11}, {2.999998420954344,
      2.4574564605472915`*^-11}, {
     2.999998427515397, -7.182032746300138*^-13}, {2.9999984340764496`, 
     4.123978936121375*^-11}, {2.999998440637502, 8.902989456771593*^-12}, {
     2.9999984471985552`, -2.7172597505398244`*^-11}, {2.999998453759608, 
     4.76718664543796*^-12}, {2.9999984603206604`, 
     3.3484437444997184`*^-11}, {
     2.9999984668817135`, -1.3478440585856788`*^-11}, {2.9999984734427665`, 
     8.357647907075716*^-12}, {
     2.9999984793524264`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999988660270827`, -4.078276301635248*^-11}, {
     2.9999988672554956`, -3.20067305992211*^-11}, {2.9999988738918253`, 
     1.1074807737543324`*^-11}, {
     2.999998879580244, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999990423679734`, 4.137968357662562*^-11}, {
     2.999999054420918, -4.0456971106550554`*^-11}, {
     2.9999990668122214`, -2.8421598408101545`*^-11}, {
     2.9999990792035245`, -3.6906033784589454`*^-11}, {2.999999089705189, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.999997760326214, -4.078276301635248*^-11}, {
     2.9999977657006793`, -1.4762968625348094`*^-11}, {2.9999977723082556`, 
     1.4966472505761885`*^-11}, {
     2.999997778915832, -7.570166715709092*^-12}, {2.9999977855234086`, 
     1.7429502285892795`*^-11}, {
     2.999997792130985, -1.0178080600553585`*^-11}, {2.999997798738561, 
     1.0005107853316986`*^-11}, {
     2.999997805346138, -2.2764568008426522`*^-11}, {2.999997811766081, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.9999988103312685`, 4.137968357662562*^-11}, {
     2.9999988141648597`, 3.531697156944347*^-11}, {2.999998820801189, 
     2.0035195724688037`*^-11}, {
     2.9999988274375182`, -1.1457501614131615`*^-13}, {
     2.999998834073848, -2.5215385335286555`*^-11}, {2.9999988407101776`, 
     4.041533774312711*^-11}, {2.9999988473465073`, 5.706879413480692*^-12}, {
     2.999998853982837, -3.42070816117257*^-11}, {
     2.9999988549480543`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999990068743654`, -4.078276301635248*^-11}, {
     2.999999017247008, 3.40198980097739*^-11}, {
     2.999999029638311, -8.530176565102465*^-12}, {2.9999990414843354`, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.999999417440062, -4.078276301635248*^-11}, {
     2.9999994188258308`, -2.7483459952293288`*^-11}, {2.999999425415637, 
     2.7762792065288977`*^-11}, {2.9999994273260087`, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.9999996186373243`, -4.078276301635248*^-11}, {
     2.999999620465748, -2.6567081867767683`*^-11}, {2.9999996327640037`, 
     2.397237963691623*^-11}, {
     2.9999996353163465`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999989087621386`, -4.078276301635248*^-11}, {
     2.9999989137098027`, -3.021238814682192*^-11}, {
     2.9999989203461324`, -2.0958790258873705`*^-11}, {
     2.999998926982462, -1.6721291018484408`*^-11}, {
     2.9999989336187918`, -1.759348222662993*^-11}, {
     2.999998940255121, -2.3671287152637888`*^-11}, {
     2.9999989468914503`, -3.505318257879253*^-11}, {
     2.9999989491564976`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999993163197938`, 4.137968357662562*^-11}, {
     2.99999932410638, -2.8517410655126696`*^-11}, {
     2.999999336254082, -2.078115457493368*^-12}, {
     2.9999993484017846`, -2.961519918187605*^-12}, {
     2.999999360549487, -3.2724933873851114`*^-11}, {2.9999993682657724`, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.9999995273249276`, -4.078276301635248*^-11}, {
     2.9999995308525325`, 2.2504775820664236`*^-11}, {
     2.9999995340567023`, -4.078276301635248*^-11}}], 
    LineBox[{{2.999998790896425, -4.078276301635248*^-11}, {
     2.9999987942558706`, -3.9319325573217156`*^-11}, {
     2.9999988000783278`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999984824095, -4.078276301635248*^-11}, {
     2.9999984865648717`, -3.142675009115692*^-11}, {
     2.9999984931259247`, -2.0096369013344884`*^-11}, {
     2.9999984996869777`, -1.2253642545090315`*^-11}, {2.9999985041620345`, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.9999988822350554`, -4.078276301635248*^-11}, {
     2.9999988871644847`, -1.5826673305241457`*^-11}, {2.9999988938008144`, 
     1.3197443138324161`*^-11}, {2.9999989004371437`, 
     3.756528421661187*^-11}, {2.999998906781339, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999990950581226`, 4.137968357662562*^-11}, {
     2.9999991039861307`, 5.066169705969514*^-12}, {2.99999911262117, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.9999992905355075`, 4.137968357662562*^-11}, {
     2.999999299810975, 8.844036614163997*^-13}, {2.9999993059875734`, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.9999994513025157`, -4.078276301635248*^-11}, {
     2.999999451774861, -3.9497072279459644`*^-11}, {
     2.999999458364667, -3.1145530599019366`*^-11}, {
     2.999999464954473, -3.273359361344319*^-11}, {
     2.999999469412017, -4.078276301635248*^-11}}], 
    LineBox[{{2.999999656828211, -4.078276301635248*^-11}, {
     2.999999657360516, -2.959632539045742*^-11}, {
     2.9999996585503648`, -4.078276301635248*^-11}}], 
    LineBox[{{2.999999592172529, 4.137968357662562*^-11}, {
     2.9999995958692356`, 1.5955792243005362`*^-11}, {
     2.9999996009205363`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999992308915, -4.078276301635248*^-11}, {2.999999239072462, 
     6.7128524960935465`*^-12}, {2.9999992478132254`, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.9999991336941814`, 4.137968357662562*^-11}, {
     2.999999141160041, -3.040567797540916*^-11}, {
     2.999999150250492, -4.078276301635248*^-11}}], 
    LineBox[{{2.999999541954612, -4.078276301635248*^-11}, {
     2.9999995440321445`, -9.993783578465809*^-12}, {2.9999995478598223`, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.999999738212422, 4.137968357662562*^-11}, {
     2.999999743448308, -2.2793322784764314`*^-11}, {
     2.999999744357581, -4.078276301635248*^-11}}], 
    LineBox[{{2.999999515245024, 4.137968357662562*^-11}, {
     2.9999995176729204`, 8.210765400917808*^-12}, {
     2.9999995207793715`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999989543964616`, -4.078276301635248*^-11}, {
     2.9999989601641097`, 3.2633562518924464`*^-11}, {2.9999989668004394`, 
     5.40933964288115*^-12}, {2.999998973436769, -2.7529534207815232`*^-11}, {
     2.99999897996147, 4.137968357662562*^-11}}], 
    LineBox[{{2.9999995625552316`, -4.078276301635248*^-11}, {
     2.9999995638015617`, -2.8495317216936655`*^-11}, {2.9999995703913678`, 
     2.5830892980138742`*^-11}, {2.9999995727639277`, 
     4.137968357662562*^-11}}], 
    LineBox[{{2.999999376990404, 4.137968357662562*^-11}, {
     2.9999993792869954`, 1.8613999230865375`*^-11}, {
     2.9999993844668693`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999998967616786`, 4.137968357662562*^-11}, {
     2.9999998970357087`, 3.4293456963041535`*^-11}, {
     2.9999998989866516`, -4.078276301635248*^-11}}], 
    LineBox[{{2.999999841358731, -4.078276301635248*^-11}, {
     2.999999842121529, -2.2412405265015423`*^-11}, {
     2.999999842333874, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999994002532095`, -4.078276301635248*^-11}, {
     2.9999994056462187`, 2.50955922709295*^-11}, {
     2.9999994093944387`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999993869796544`, -4.078276301635248*^-11}, {
     2.9999993924666075`, 3.9654168837444104`*^-11}, {
     2.999999398042915, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999994950289133`, 4.137968357662562*^-11}, {
     2.9999994979035023`, 1.7652435069237526`*^-11}, {
     2.9999995036685814`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999989802286438`, 4.137968357662562*^-11}, {
     2.9999989910688742`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999992786367082`, -4.078276301635248*^-11}, {
     2.999999286468044, 4.137968357662562*^-11}}], 
    LineBox[{{2.999999480918261, 4.137968357662562*^-11}, {
     2.9999994831151495`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999996895760663`, -4.078276301635248*^-11}, {
     2.999999691746315, 4.137968357662562*^-11}}], 
    LineBox[{{2.99999994808602, 4.137968357662562*^-11}, {
     2.999999948518558, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999998094438145`, 4.137968357662562*^-11}, {
     2.999999811207503, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999995048670858`, -4.078276301635248*^-11}, {
     2.999999508540812, 4.137968357662562*^-11}}], 
    LineBox[{{2.999999920140293, 4.137968357662562*^-11}, {
     2.9999999211634516`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999992525230046`, 4.137968357662562*^-11}, {
     2.9999992604450125`, -4.078276301635248*^-11}}], 
    LineBox[{{2.99999915404008, -4.078276301635248*^-11}, {
     2.9999991646970012`, 4.137968357662562*^-11}}], 
    LineBox[{{2.9999996979463224`, 4.137968357662562*^-11}, {
     2.9999997011390565`, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999998536378976`, -4.078276301635248*^-11}, {
     2.999999854302099, 4.137968357662562*^-11}}], 
    LineBox[{{2.999999963560477, -4.078276301635248*^-11}, {2.999999963714412,
      4.137968357662562*^-11}}], 
    LineBox[{{2.9999997247574126`, -4.078276301635248*^-11}, {
     2.999999727870441, 4.137968357662562*^-11}}], 
    LineBox[{{2.9999999356680074`, 4.137968357662562*^-11}, {
     2.999999936348366, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999999927138608`, 4.137968357662562*^-11}, {
     2.999999992787509, -4.078276301635248*^-11}}], 
    LineBox[{{2.999999487015771, -4.078276301635248*^-11}, {2.999999490145552,
      4.137968357662562*^-11}}], 
    LineBox[{{2.9999994333847657`, 4.137968357662562*^-11}, {
     2.999999436782472, -4.078276301635248*^-11}}], 
    LineBox[{{2.99999880090784, -4.078276301635248*^-11}, {
     2.9999988071896433`, 4.137968357662562*^-11}}], 
    LineBox[{{2.9999998191820207`, -4.078276301635248*^-11}, {
     2.9999998214868384`, 4.137968357662562*^-11}}], 
    LineBox[{{2.9999999266019315`, -4.078276301635248*^-11}, {
     2.9999999272500997`, 4.137968357662562*^-11}}], 
    LineBox[{{2.999999980411552, -4.078276301635248*^-11}, {
     2.9999999804777793`, 4.137968357662562*^-11}}], 
    LineBox[{{2.999999804037609, -4.078276301635248*^-11}, {
     2.9999998059851647`, 4.137968357662562*^-11}}], 
    LineBox[{{2.9999999153191155`, -4.078276301635248*^-11}, {
     2.999999915987557, 4.137968357662562*^-11}}], 
    LineBox[{{2.999999552042987, 4.137968357662562*^-11}, {
     2.999999555192412, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999999682430767`, 4.137968357662562*^-11}, {
     2.999999968444087, -4.078276301635248*^-11}}], 
    LineBox[{{2.999999831842573, 4.137968357662562*^-11}, {
     2.999999833067167, -4.078276301635248*^-11}}], 
    LineBox[{{2.9999999399891086`, -4.078276301635248*^-11}, {
     2.999999940631249, 4.137968357662562*^-11}}], 
    LineBox[{{2.999999471677722, -4.078276301635248*^-11}, {
     2.9999994745252874`, 4.137968357662562*^-11}}], 
    LineBox[{{2.9999999993474757`, -4.078276301635248*^-11}, {
     2.9999999999997957`, -1.27675647831893*^-14}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2.99999, 0},
  PlotRange->NCache[{{
      Rational[299999, 100000], 3}, {-4.078276301635248*^-11, 
     4.137968357662562*^-11}}, {{2.99999, 3}, {-4.078276301635248*^-11, 
     4.137968357662562*^-11}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5349523079366093`*^9, {3.534952353736347*^9, 3.534952385656258*^9}, {
   3.534952519930941*^9, 3.5349525364084663`*^9}, {3.534952589651496*^9, 
   3.534952638952092*^9}, {3.5349526890749397`*^9, 3.53495271213483*^9}, 
   3.535032675404014*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"Sin", "[", "t", "]"}]}], "-", 
      RowBox[{"t", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Cos", "[", "t", "]"}]}], ")"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "*", 
      RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], "]"}], "//", 
  "CForm"}]], "Input",
 CellChangeTimes->{{3.534957853110901*^9, 3.53495787627563*^9}, {
  3.534957939857259*^9, 3.5349579893278913`*^9}, {3.534958154426886*^9, 
  3.534958155993161*^9}}],

Cell["1 - (t*Cot(t/2.))/2.", "Output",
 CellChangeTimes->{{3.534957857880176*^9, 3.534957876734346*^9}, {
   3.534957969196027*^9, 3.534957990086001*^9}, 3.534958156565527*^9, 
   3.5350326755888557`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cayley Transform in retract", "Subtitle",
 CellChangeTimes->{{3.535032631197674*^9, 3.535032640284687*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Skew", "[", 
   RowBox[{"xi_", ",", "yi_", ",", "zi_"}], "]"}], ":=", 
  RowBox[{"(", GridBox[{
     {"0", 
      RowBox[{"-", "zi"}], "yi"},
     {"zi", "0", 
      RowBox[{"-", "xi"}]},
     {
      RowBox[{"-", "yi"}], "xi", "0"}
    }], ")"}]}]], "Input",
 CellChangeTimes->{{3.534792086525635*^9, 3.534792116896299*^9}, {
  3.534792158173279*^9, 3.53479216472799*^9}, {3.534792288463591*^9, 
  3.5347922999679413`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"I3", "=", 
   RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.534792468765259*^9, 3.534792475463044*^9}, 
   3.53479453986604*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cayley", "[", "A_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"I3", "-", "A"}], ")"}], ".", 
   RowBox[{"Inverse", "[", 
    RowBox[{"I3", "+", "A"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.534792413006259*^9, 3.534792514894662*^9}, {
  3.53479438804801*^9, 3.534794399920623*^9}, {3.53479444890162*^9, 
  3.5347944810270233`*^9}, {3.5347945649687643`*^9, 3.534794580760129*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cayley", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", GridBox[{
        {"0", 
         RowBox[{"-", "z"}], "y"},
        {"z", "0", 
         RowBox[{"-", "x"}]},
        {
         RowBox[{"-", "y"}], "x", "0"}
       }], ")"}]}], "/", "2"}], "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.534794736641182*^9, 3.534794794595385*^9}, {
  3.534794827306637*^9, 3.5347949302401047`*^9}, {3.53479499457475*^9, 
  3.53479500887815*^9}, {3.534795085606778*^9, 3.534795126525136*^9}, {
  3.5347952414583607`*^9, 3.5347952790572643`*^9}, {3.5348001493303022`*^9, 
  3.5348001595511427`*^9}, {3.534802709607703*^9, 3.53480271071006*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"], "-", 
       SuperscriptBox["z", "2"]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "x", " ", "y"}], "-", 
       RowBox[{"4", " ", "z"}]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"4", " ", "y"}], "+", 
       RowBox[{"2", " ", "x", " ", "z"}]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "x", " ", "y"}], "+", 
       RowBox[{"4", " ", "z"}]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]], ",", 
     FractionBox[
      RowBox[{"4", "-", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "-", 
       SuperscriptBox["z", "2"]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "x"}], "+", 
         RowBox[{"y", " ", "z"}]}], ")"}]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "y"}], "+", 
         RowBox[{"x", " ", "z"}]}], ")"}]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"4", " ", "x"}], "+", 
       RowBox[{"2", " ", "y", " ", "z"}]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]], ",", 
     FractionBox[
      RowBox[{"4", "-", 
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.534794740458538*^9, 3.534794795032645*^9}, {
   3.534794829552143*^9, 3.534794930591991*^9}, {3.534795003580193*^9, 
   3.53479500947468*^9}, {3.5347950865543413`*^9, 3.5347951270879927`*^9}, 
   3.5347952423882933`*^9, {3.5347952742561703`*^9, 3.53479528028828*^9}, {
   3.5348001511710167`*^9, 3.5348001635975103`*^9}, 3.5348027111236687`*^9, 
   3.535032675837214*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Inverse Cayley Transform in localCoordinates\
\>", "Subtitle",
 CellChangeTimes->{{3.534851852589015*^9, 3.53485186951376*^9}, {
  3.5350327400274553`*^9, 3.535032754058358*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cayley", "[", 
    RowBox[{"(", GridBox[{
       {"a", "b", "c"},
       {"d", "e", "f"},
       {"g", "h", "i"}
      }], ")"}], "]"}], "//", "Simplify"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.5348668592411547`*^9, 3.534866893568824*^9}, {
   3.534867079809691*^9, 3.53486710458702*^9}, 3.534867157215678*^9, {
   3.534867196764654*^9, 3.53486719869942*^9}, {3.534867368508621*^9, 
   3.534867369905733*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"1", "+", "e", "+", 
        RowBox[{"c", " ", "g"}], "+", 
        RowBox[{"c", " ", "e", " ", "g"}], "-", 
        RowBox[{"c", " ", "d", " ", "h"}], "-", 
        RowBox[{"f", " ", "h"}], "+", "i", "+", 
        RowBox[{"e", " ", "i"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", 
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"d", " ", "i"}]}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "e", "-", 
           RowBox[{"f", " ", "h"}], "+", "i", "+", 
           RowBox[{"e", " ", "i"}]}], ")"}]}]}], 
       RowBox[{"1", "+", "e", "-", 
        RowBox[{"c", " ", "g"}], "-", 
        RowBox[{"c", " ", "e", " ", "g"}], "+", 
        RowBox[{"c", " ", "d", " ", "h"}], "-", 
        RowBox[{"f", " ", "h"}], "+", "i", "+", 
        RowBox[{"e", " ", "i"}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", 
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "e", "-", 
           RowBox[{"f", " ", "h"}], "+", "i", "+", 
           RowBox[{"e", " ", "i"}]}], ")"}]}]}]], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"b", "-", 
           RowBox[{"c", " ", "h"}], "+", 
           RowBox[{"b", " ", "i"}]}], ")"}]}], 
        RowBox[{"1", "+", "e", "-", 
         RowBox[{"c", " ", "g"}], "-", 
         RowBox[{"c", " ", "e", " ", "g"}], "+", 
         RowBox[{"c", " ", "d", " ", "h"}], "-", 
         RowBox[{"f", " ", "h"}], "+", "i", "+", 
         RowBox[{"e", " ", "i"}], "-", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", 
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "e", "-", 
            RowBox[{"f", " ", "h"}], "+", "i", "+", 
            RowBox[{"e", " ", "i"}]}], ")"}]}]}]]}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"c", " ", "e"}], "-", 
           RowBox[{"b", " ", "f"}]}], ")"}]}], 
        RowBox[{"1", "+", "e", "-", 
         RowBox[{"c", " ", "g"}], "-", 
         RowBox[{"c", " ", "e", " ", "g"}], "+", 
         RowBox[{"c", " ", "d", " ", "h"}], "-", 
         RowBox[{"f", " ", "h"}], "+", "i", "+", 
         RowBox[{"e", " ", "i"}], "-", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", 
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "e", "-", 
            RowBox[{"f", " ", "h"}], "+", "i", "+", 
            RowBox[{"e", " ", "i"}]}], ")"}]}]}]]}]},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", 
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"d", " ", "i"}]}], ")"}]}], 
        RowBox[{"1", "+", "e", "-", 
         RowBox[{"c", " ", "g"}], "-", 
         RowBox[{"c", " ", "e", " ", "g"}], "+", 
         RowBox[{"c", " ", "d", " ", "h"}], "-", 
         RowBox[{"f", " ", "h"}], "+", "i", "+", 
         RowBox[{"e", " ", "i"}], "-", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", 
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "e", "-", 
            RowBox[{"f", " ", "h"}], "+", "i", "+", 
            RowBox[{"e", " ", "i"}]}], ")"}]}]}]]}], 
      FractionBox[
       RowBox[{"1", "-", "e", "-", 
        RowBox[{"c", " ", "g"}], "+", 
        RowBox[{"c", " ", "e", " ", "g"}], "-", 
        RowBox[{"c", " ", "d", " ", "h"}], "+", 
        RowBox[{"f", " ", "h"}], "+", "i", "-", 
        RowBox[{"e", " ", "i"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", 
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"f", " ", "h"}], "+", "i", "-", 
           RowBox[{"e", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "i"}], ")"}]}]}], ")"}]}]}], 
       RowBox[{"1", "+", "e", "-", 
        RowBox[{"c", " ", "g"}], "-", 
        RowBox[{"c", " ", "e", " ", "g"}], "+", 
        RowBox[{"c", " ", "d", " ", "h"}], "-", 
        RowBox[{"f", " ", "h"}], "+", "i", "+", 
        RowBox[{"e", " ", "i"}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", 
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "e", "-", 
           RowBox[{"f", " ", "h"}], "+", "i", "+", 
           RowBox[{"e", " ", "i"}]}], ")"}]}]}]], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "c"}], " ", "d"}], "+", "f", "+", 
           RowBox[{"a", " ", "f"}]}], ")"}]}], 
        RowBox[{"1", "+", "e", "-", 
         RowBox[{"c", " ", "g"}], "-", 
         RowBox[{"c", " ", "e", " ", "g"}], "+", 
         RowBox[{"c", " ", "d", " ", "h"}], "-", 
         RowBox[{"f", " ", "h"}], "+", "i", "+", 
         RowBox[{"e", " ", "i"}], "-", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", 
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "e", "-", 
            RowBox[{"f", " ", "h"}], "+", "i", "+", 
            RowBox[{"e", " ", "i"}]}], ")"}]}]}]]}]},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"g", "+", 
           RowBox[{"e", " ", "g"}], "-", 
           RowBox[{"d", " ", "h"}]}], ")"}]}], 
        RowBox[{"1", "+", "e", "-", 
         RowBox[{"c", " ", "g"}], "-", 
         RowBox[{"c", " ", "e", " ", "g"}], "+", 
         RowBox[{"c", " ", "d", " ", "h"}], "-", 
         RowBox[{"f", " ", "h"}], "+", "i", "+", 
         RowBox[{"e", " ", "i"}], "-", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", 
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "e", "-", 
            RowBox[{"f", " ", "h"}], "+", "i", "+", 
            RowBox[{"e", " ", "i"}]}], ")"}]}]}]]}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], " ", "g"}], "+", "h", "+", 
           RowBox[{"a", " ", "h"}]}], ")"}]}], 
        RowBox[{"1", "+", "e", "-", 
         RowBox[{"c", " ", "g"}], "-", 
         RowBox[{"c", " ", "e", " ", "g"}], "+", 
         RowBox[{"c", " ", "d", " ", "h"}], "-", 
         RowBox[{"f", " ", "h"}], "+", "i", "+", 
         RowBox[{"e", " ", "i"}], "-", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", 
            RowBox[{"f", " ", "g"}], "+", 
            RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "e", "-", 
            RowBox[{"f", " ", "h"}], "+", "i", "+", 
            RowBox[{"e", " ", "i"}]}], ")"}]}]}]]}], 
      FractionBox[
       RowBox[{"1", "+", "e", "+", 
        RowBox[{"c", " ", "g"}], "+", 
        RowBox[{"c", " ", "e", " ", "g"}], "-", 
        RowBox[{"c", " ", "d", " ", "h"}], "+", 
        RowBox[{"f", " ", "h"}], "-", "i", "-", 
        RowBox[{"e", " ", "i"}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"f", " ", "g"}], "-", 
           RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "e", "+", 
           RowBox[{"f", " ", "h"}], "-", "i", "-", 
           RowBox[{"e", " ", "i"}]}], ")"}]}]}], 
       RowBox[{"1", "+", "e", "-", 
        RowBox[{"c", " ", "g"}], "-", 
        RowBox[{"c", " ", "e", " ", "g"}], "+", 
        RowBox[{"c", " ", "d", " ", "h"}], "-", 
        RowBox[{"f", " ", "h"}], "+", "i", "+", 
        RowBox[{"e", " ", "i"}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", 
           RowBox[{"f", " ", "g"}], "+", 
           RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "e", "-", 
           RowBox[{"f", " ", "h"}], "+", "i", "+", 
           RowBox[{"e", " ", "i"}]}], ")"}]}]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.534866885388957*^9, 3.534866896313146*^9}, {
   3.534867081290526*^9, 3.534867105413108*^9}, 3.534867157654133*^9, 
   3.534867199577175*^9, 3.535032676157619*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"1", "+", "e", "-", 
    RowBox[{"c", " ", "g"}], "-", 
    RowBox[{"c", " ", "e", " ", "g"}], "+", 
    RowBox[{"c", " ", "d", " ", "h"}], "-", 
    RowBox[{"f", " ", "h"}], "+", "i", "+", 
    RowBox[{"e", " ", "i"}], "-", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"d", "-", 
       RowBox[{"f", " ", "g"}], "+", 
       RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "e", "-", 
       RowBox[{"f", " ", "h"}], "+", "i", "+", 
       RowBox[{"e", " ", "i"}]}], ")"}]}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "+", "e", "-", 
     RowBox[{"f", " ", "h"}], "+", "i", "+", 
     RowBox[{"e", " ", "i"}]}], "\[Rule]", "K"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5348674422589073`*^9, 3.5348674422771378`*^9}, {
  3.5348675075614977`*^9, 3.534867521418206*^9}, {3.535032788609457*^9, 
  3.535032790665083*^9}, {3.535032843526026*^9, 3.535033005751606*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "e"}], ")"}], " ", "g"}], "+", 
  RowBox[{"c", " ", "d", " ", "h"}], "-", 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"d", "-", 
     RowBox[{"f", " ", "g"}], "+", 
     RowBox[{"d", " ", "i"}]}], ")"}]}], "+", 
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "e", "-", 
     RowBox[{"f", " ", "h"}], "+", "i", "+", 
     RowBox[{"e", " ", "i"}]}], ")"}]}], "+", "K"}]], "Output",
 CellChangeTimes->{{3.5348675112204113`*^9, 3.534867521782625*^9}, 
   3.535032676270063*^9, 3.53503279118965*^9, {3.535032857389606*^9, 
   3.535032876409691*^9}, {3.535032914921414*^9, 3.5350330062704144`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 752},
WindowMargins->{{28, Automatic}, {36, Automatic}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 86, 1, 76, "Title"],
Cell[668, 25, 114, 1, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[807, 30, 417, 11, 27, "Input"],
Cell[1227, 43, 527, 16, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1791, 64, 602, 19, 49, "Input"],
Cell[2396, 85, 1619, 33, 227, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4052, 123, 321, 9, 27, "Input"],
Cell[4376, 134, 2527, 47, 231, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6940, 186, 507, 16, 27, "Input"],
Cell[7450, 204, 413, 13, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7900, 222, 209, 5, 27, "Input"],
Cell[8112, 229, 891, 29, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9040, 263, 615, 17, 46, "Input"],
Cell[9658, 282, 25211, 438, 205, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34906, 725, 604, 18, 27, "Input"],
Cell[35513, 745, 204, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35754, 753, 113, 1, 46, "Subtitle"],
Cell[35870, 756, 459, 14, 61, "Input"],
Cell[36332, 772, 201, 5, 27, "Input"],
Cell[36536, 779, 430, 10, 27, "Input"],
Cell[CellGroupData[{
Cell[36991, 793, 686, 17, 61, "Input"],
Cell[37680, 812, 3190, 95, 143, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40919, 913, 188, 4, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[41132, 921, 473, 12, 61, "Input"],
Cell[41608, 935, 9811, 262, 97, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51456, 1202, 1022, 26, 43, "Input"],
Cell[52481, 1230, 715, 19, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
