// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/pad.h>
#include <gstreamermm/private/pad_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/buffer.h>
#include <gstreamermm/caps.h>
#include <gstreamermm/element.h>
#include <gstreamermm/event.h>
#include <gstreamermm/padtemplate.h>
#include <gstreamermm/iterator.h>
#include <gstreamermm/message.h>
#include <gstreamermm/bus.h>


namespace
{

extern "C"
{
static GstPadProbeReturn Pad_Probe_gstreamermm_callback(GstPad* pad, GstPadProbeInfo* probe_info, void* data)
{
  Gst::Pad::SlotProbe* the_slot = static_cast<Gst::Pad::SlotProbe*>(data);
  Glib::RefPtr<Gst::Pad> pad_wrapper = Glib::wrap(pad, true);
  try
  {
      return static_cast<GstPadProbeReturn>((*the_slot)(pad_wrapper, Glib::wrap(probe_info, true)));
  }
  catch(...)
  {
    pad_wrapper->exception_handler();
  }

  return GST_PAD_PROBE_DROP;
}

static void Pad_Probe_gstreamermm_callback_disconnect(void* data)
{
  Gst::Pad::SlotProbe* the_slot = static_cast<Gst::Pad::SlotProbe*>(data);

  if(the_slot)
    delete the_slot;
}

} // extern "C"

} // anonymous namespace

namespace Gst
{

Pad::Pad(PadDirection dir)
  : // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(pad_class_.init(), "name",static_cast<char*>(0),"direction",dir, static_cast<char*>(0)))
{}

Pad::Pad(const Glib::RefPtr<const Gst::PadTemplate>& templ,
  const Glib::ustring& name)
  : // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(pad_class_.init(), "name",(name.empty() ? static_cast<char*>(0) : name.c_str()),"direction",(templ ? static_cast<GstPadDirection>(templ->get_direction())
      : GST_PAD_UNKNOWN),"template",Glib::unwrap(templ), static_cast<char*>(0)))
{
  if(!templ)
    gstreamermm_handle_error(
      "Gst::Pad::Pad(const Glib::RefPtr<Gst::PadTemplate>&, "
      "const Glib::ustring&): Failed to construct pad (name = " + name + ") "
      "from null template.");
}

Pad::Pad(const Glib::RefPtr<const Gst::PadTemplate>& templ)
  : // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(pad_class_.init(), "name",static_cast<char*>(0),"direction",(templ ? static_cast<GstPadDirection>(templ->get_direction())
      : GST_PAD_UNKNOWN),"template",Glib::unwrap(templ), static_cast<char*>(0)))
{
  if(!templ)
    gstreamermm_handle_error(
      "Gst::Pad::Pad(const Glib::RefPtr<Gst::PadTemplate>&): Failed to "
      "construct pad from null template.");
}

void Pad::exception_handler()
{
  Glib::RefPtr<Element> parent = parent.cast_dynamic(get_parent());
  
  if (!parent)
  {
    Glib::exception_handlers_invoke();
    return;
  }

  Glib::RefPtr<Message> error_msg;

  try
  {
    throw;
  }
  catch(const Glib::Error& error)
  {
    Glib::Error err = error;
    error_msg = MessageError::create(parent, err, "glibmm exception");
  }
  catch(const std::exception& ex)
  {
    Glib::Error err(GST_CORE_ERROR, GST_CORE_ERROR_FAILED, ex.what());
    error_msg = MessageError::create(parent, err, "standard exception");
  }
  catch(...)
  {
    Glib::Error err(GST_CORE_ERROR, GST_CORE_ERROR_FAILED, "");
    error_msg = MessageError::create(parent, err, "unknown error type");
  }

  parent->post_message(error_msg);
}

gulong Pad::add_probe(PadProbeType mask, const SlotProbe& slot)
{
    SlotProbe* slot_copy = new SlotProbe(slot);
    return gst_pad_add_probe(gobj(), static_cast<GstPadProbeType>(mask), &Pad_Probe_gstreamermm_callback, slot_copy, &Pad_Probe_gstreamermm_callback_disconnect);
}

// This is handcoded because the documentation tells us that we need to copy
// the Caps
Glib::RefPtr<const Gst::Caps> Pad::get_pad_template_caps() const
{
  const GstCaps* caps = gst_pad_get_pad_template_caps(const_cast<GstPad*>(gobj()));
  GstCaps* copy_caps = gst_caps_copy(caps);
  return Glib::wrap(copy_caps, false);
}


FlowReturn Pad::get_range(guint64 offset, guint size, Glib::RefPtr<Gst::Buffer>& buffer)
{
  GstBuffer* c_buffer = 0;
  GstFlowReturn result = gst_pad_get_range(gobj(), offset, size, &c_buffer);
  buffer = Glib::wrap(c_buffer, false);
  return FlowReturn(result);
}

FlowReturn Pad::push(Glib::RefPtr<Gst::Buffer>& buffer)
{
    GstBuffer *buffer_gobj = buffer->gobj();
    /* gst_pad_push takes ownership of given "buffer". It is recommended (for performance reasons) that the buffer given to gst_pad_push() has
     * only one reference, since in other cases it will be copied whenever "make_writable" will be called.
     */
    buffer->reference();  //allocate additional ref for gst_pad_push()
    buffer.reset();  //take away buffer from the caller
    return FlowReturn(gst_pad_push(gobj(), buffer_gobj));
}

bool Pad::push_event(const Glib::RefPtr<Gst::Event>& event)
{
  event->reference();
  return gst_pad_push_event(gobj(), event->gobj());
}

FlowReturn Pad::pull_range(guint64 offset, guint size, Glib::RefPtr<Gst::Buffer>& buffer)
{
  GstBuffer* c_buffer = 0;
  GstFlowReturn result = gst_pad_pull_range(gobj(), offset, size, &c_buffer);
  buffer = Glib::wrap(c_buffer, false);
  return FlowReturn(result);
}

bool Pad::send_event(const Glib::RefPtr<Gst::Event>& event)
{
  event->reference();
  return gst_pad_send_event(gobj(), event->gobj());
}

bool Pad::query_position(Format& format) const
{
  return gst_pad_query_position(const_cast<GstPad*>(gobj()), (GstFormat)format, 0);
}

bool Pad::query_duration(Format& format) const
{
  return gst_pad_query_duration(const_cast<GstPad*>(gobj()), (GstFormat)format, 0);
}

FlowReturn Pad::chain(Glib::RefPtr<Gst::Buffer>& buffer)
{
  buffer->reference();  //hold reference for gst_pad_chain()
  buffer.reset();       //free caller's reference
  return FlowReturn(gst_pad_chain(gobj(), buffer->gobj()));
}

GstFlowReturn Pad::Pad_Chain_gstreamermm_callback(GstPad* pad, GstObject*, GstBuffer *buffer)
{
  //FIXME: It's made like vfunc wrappers, but why there is no reffing of pad?
  Gst::Pad *pad_wrapper = dynamic_cast<Gst::Pad*>
    (static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)pad)
      )
    );
  g_assert(pad);

  try
  {
    Glib::RefPtr<Buffer> buffer_wrapped = Glib::wrap(buffer, false);  //manage object

    return static_cast<GstFlowReturn>(
      pad_wrapper->slot_chain(Glib::wrap(pad, true),  //take copy
                              buffer_wrapped
                           ));
  }
  catch(...)
  {
    pad_wrapper->exception_handler();
  }

  return GST_FLOW_ERROR;
}

gboolean Pad::Pad_Query_gstreamermm_callback(GstPad* pad, GstObject*, GstQuery* query)
{
  Gst::Pad *pad_wrapper = dynamic_cast<Gst::Pad*>
    (static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)pad)
      )
    );
  g_assert(pad);

  try
  {
    //We cannot make copy of query, since some elements fail to answer the query if it's refcount>1 (is not writtable)
    Glib::RefPtr<Query> query_wrapped = Glib::wrap(query, false);

    gboolean res = pad_wrapper->slot_query(Glib::wrap(pad, true), query_wrapped);
    
    //we have to increase refcount, since freeing RefPtr will decrease it which would be inaccurate here, since the
    //caller is responsible for managing the object (see "transfer none" on this parameter)
    query_wrapped->reference();
    return res;
  }
  catch(...)
  {
    pad_wrapper->exception_handler();
  }

  return false;
}

gboolean Pad::Pad_Event_gstreamermm_callback(GstPad* pad, GstObject*, GstEvent* event)
{
  Gst::Pad *pad_wrapper = dynamic_cast<Gst::Pad*>
    (static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)pad)
      )
    );
  g_assert(pad);

  try
  {
    //we don't make copy, since ownership is transfered to the callee ("transfer full")
    Glib::RefPtr<Event> event_wrapped = Glib::wrap(event, false);

    return pad_wrapper->slot_event(Glib::wrap(pad, true), event_wrapped);
  }
  catch(...)
  {
    pad_wrapper->exception_handler();
  }

  return false;
}

gboolean Pad::Pad_Activate_gstreamermm_callback(GstPad* pad, GstObject*)
{
  Gst::Pad *pad_wrapper = dynamic_cast<Gst::Pad*>
    (static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)pad)
      )
    );
  g_assert(pad);

  try
  {
    return pad_wrapper->slot_activate(Glib::wrap(pad, true));
  }
  catch(...)
  {
    pad_wrapper->exception_handler();
  }

  return false;
}

gboolean Pad::Pad_Activatemode_gstreamermm_callback(GstPad* pad, GstObject*, GstPadMode mode, gboolean active)
{
  Gst::Pad *pad_wrapper = dynamic_cast<Gst::Pad*>
    (static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)pad)
      )
    );
  g_assert(pad);

  try
  {
    return pad_wrapper->slot_activatemode(Glib::wrap(pad, true), static_cast<PadMode>(mode), active);
  }
  catch(...)
  {
    pad_wrapper->exception_handler();
  }

  return false;
}

GstFlowReturn Pad::Pad_Getrange_gstreamermm_callback(GstPad* pad, GstObject*, guint64 offset, guint length, GstBuffer **buffer)
{
  Gst::Pad *pad_wrapper = dynamic_cast<Gst::Pad*>
    (static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)pad)
      )
    );
  g_assert(pad);
  Glib::RefPtr<Buffer> buf = Glib::wrap(*buffer, false);
  try
  {
    return static_cast<GstFlowReturn>(
    		pad_wrapper->slot_getrange(Glib::wrap(pad, true), offset, length, buf)
    		);
  }
  catch(...)
  {
    pad_wrapper->exception_handler();
  }

  return GST_FLOW_ERROR;
}

void Pad::set_chain_function(const SlotChain& slot)
{
  slot_chain = slot;
  gst_pad_set_chain_function(GST_PAD(gobj()), &Pad_Chain_gstreamermm_callback);
}

void Pad::set_query_function(const SlotQuery& slot)
{
	slot_query = slot;
	gst_pad_set_query_function(GST_PAD(gobj()), &Pad_Query_gstreamermm_callback);
}

void Pad::set_event_function(const SlotEvent& slot)
{
	slot_event = slot;
	gst_pad_set_event_function(GST_PAD(gobj()), &Pad_Event_gstreamermm_callback);
}

void Pad::set_activate_function(const SlotActivate& slot)
{
  slot_activate = slot;
  gst_pad_set_activate_function(GST_PAD(gobj()), &Pad_Activate_gstreamermm_callback);
}

void Pad::set_activatemode_function(const SlotActivatemode& slot)
{
  slot_activatemode= slot;
  gst_pad_set_activatemode_function(GST_PAD(gobj()), &Pad_Activatemode_gstreamermm_callback);
}

void Pad::set_getrange_function(const SlotGetrange& slot)
{
  slot_getrange = slot;
  gst_pad_set_getrange_function(GST_PAD(gobj()), &Pad_Getrange_gstreamermm_callback);
}

bool Pad::is_ghost_pad() const
{
	return GST_IS_GHOST_PAD(gobj());
}

bool Pad::is_proxy_pad() const
{
	return GST_IS_PROXY_PAD(gobj());
}

PadProbeInfo::PadProbeInfo()
: gobj_(g_try_new(GstPadProbeInfo, 1)),
  take_ownership(true)
{
  // Handle possible memory allocation failure.
  if(!gobj_)
  {
    gstreamermm_handle_error(
      "Failed to allocate a new Gst::PadProbeInfo.");
  }
}

PadProbeInfo::PadProbeInfo(GstPadProbeInfo& castitem, bool take_ownership)
: gobj_(&castitem),
  take_ownership(take_ownership)
{
}

PadProbeInfo::PadProbeInfo(GstPadProbeInfo* castitem, bool take_copy)
: take_ownership(take_copy)
{
  if(take_copy)
  {
    gobj_ = (g_try_new(GstPadProbeInfo, 1));

    if(!gobj_)
    {
        gstreamermm_handle_error(
              "Failed to allocate a new Gst::PadProbeInfo.");
        return;
    }

    if(castitem)
      *gobj_ = *castitem;
  }
  else
  {
    gobj_ = castitem;
  }
}

PadProbeInfo::PadProbeInfo(const PadProbeInfo& other)
: gobj_(g_try_new(GstPadProbeInfo, 1)),
  take_ownership(true)
{
  if(!gobj_)
  {
    gstreamermm_handle_error("Failed to allocate a new Gst::PadProbeInfo.");
    return;
  }

  // I can do it, because there is no dynamic allocated memory in pad
  *gobj_ = *other.gobj_;
}

PadProbeInfo::~PadProbeInfo()
{
  if(take_ownership)
    g_free(gobj_);
}

PadProbeType PadProbeInfo::get_type() const
{
  return static_cast<PadProbeType>(GST_PAD_PROBE_INFO_TYPE(gobj()));
}

} //namespace Gst

namespace Glib
{
Gst::PadProbeInfo wrap(GstPadProbeInfo* probe_info, bool take_copy)
{
  return Gst::PadProbeInfo(probe_info, take_copy);
}
}

namespace
{


static void Pad_signal_linked_callback(GstPad* self, GstPad* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Gst::Pad>& > SlotType;

  Pad* obj = dynamic_cast<Pad*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Pad_signal_linked_info =
{
  "linked",
  (GCallback) &Pad_signal_linked_callback,
  (GCallback) &Pad_signal_linked_callback
};


static void Pad_signal_unlinked_callback(GstPad* self, GstPad* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Gst::Pad>& > SlotType;

  Pad* obj = dynamic_cast<Pad*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Pad_signal_unlinked_info =
{
  "unlinked",
  (GCallback) &Pad_signal_unlinked_callback,
  (GCallback) &Pad_signal_unlinked_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gst::PadMode>::value_type()
{
  return gst_pad_mode_get_type();
}

// static
GType Glib::Value<Gst::FlowReturn>::value_type()
{
  return gst_flow_return_get_type();
}

// static
GType Glib::Value<Gst::PadDirection>::value_type()
{
  return gst_pad_direction_get_type();
}

// static
GType Glib::Value<Gst::PadFlags>::value_type()
{
  return gst_pad_flags_get_type();
}

// static
GType Glib::Value<Gst::PadLinkReturn>::value_type()
{
  return gst_pad_link_return_get_type();
}

// static
GType Glib::Value<Gst::PadLinkCheck>::value_type()
{
  return gst_pad_link_check_get_type();
}

// static
GType Glib::Value<Gst::PadProbeType>::value_type()
{
  return gst_pad_probe_type_get_type();
}

// static
GType Glib::Value<Gst::PadProbeReturn>::value_type()
{
  return gst_pad_probe_return_get_type();
}


namespace Glib
{

Glib::RefPtr<Gst::Pad> wrap(GstPad* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Pad>( dynamic_cast<Gst::Pad*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Pad_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Pad_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_pad_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Pad_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->linked = &linked_callback;
  klass->unlinked = &unlinked_callback;
}


void Pad_Class::linked_callback(GstPad* self, GstPad* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_linked(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->linked)
    (*base->linked)(self, p0);
}
void Pad_Class::unlinked_callback(GstPad* self, GstPad* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_unlinked(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unlinked)
    (*base->unlinked)(self, p0);
}


Glib::ObjectBase* Pad_Class::wrap_new(GObject* object)
{
  return new Pad((GstPad*)object);
}


/* The implementation: */

GstPad* Pad::gobj_copy()
{
  reference();
  return gobj();
}

Pad::Pad(const Glib::ConstructParams& construct_params)
:
  Object(construct_params)
{

}

Pad::Pad(GstPad* castitem)
:
  Object((GstObject*)(castitem))
{}


Pad::~Pad()
{}


Pad::CppClassType Pad::pad_class_; // initialize static member

GType Pad::get_type()
{
  return pad_class_.init().get_type();
}


GType Pad::get_base_type()
{
  return gst_pad_get_type();
}


Pad::Pad(const Glib::ustring& name, PadDirection direction)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Object(Glib::ConstructParams(pad_class_.init(), "name", name.c_str(), "direction", ((GstPadDirection)(direction)), static_cast<char*>(0)))
{
  

}

Glib::RefPtr<Pad> Pad::create(const Glib::ustring& name, PadDirection dir)
{
  return Glib::RefPtr<Pad>( new Pad(name, dir) );
}

Glib::RefPtr<Pad> Pad::create(PadDirection dir)
{
  return Glib::RefPtr<Pad>( new Pad(dir) );
}

Glib::RefPtr<Pad> Pad::create(const Glib::RefPtr<const Gst::PadTemplate>& pad_template)
{
  return Glib::RefPtr<Pad>( new Pad(pad_template) );
}

Glib::RefPtr<Pad> Pad::create(const Glib::RefPtr<const Gst::PadTemplate>& pad_template, const Glib::ustring& name)
{
  return Glib::RefPtr<Pad>( new Pad(pad_template, name) );
}

Glib::RefPtr<Gst::Caps> Pad::query_caps(Glib::RefPtr<Gst::Caps> caps)
{
  return Glib::wrap(gst_pad_query_caps(gobj(), Glib::unwrap(caps)));
}

Glib::RefPtr<const Gst::Caps> Pad::query_caps(Glib::RefPtr<Gst::Caps> caps) const
{
  return const_cast<Pad*>(this)->query_caps(caps);
}

PadDirection Pad::get_direction() const
{
  return ((PadDirection)(gst_pad_get_direction(const_cast<GstPad*>(gobj()))));
}

Glib::RefPtr<Gst::Element> Pad::get_parent_element()
{
  return Glib::wrap(gst_pad_get_parent_element(gobj()));
}

Glib::RefPtr<const Gst::Element> Pad::get_parent_element() const
{
  return const_cast<Pad*>(this)->get_parent_element();
}

Glib::RefPtr<Gst::PadTemplate> Pad::get_pad_template()
{
  return Glib::wrap(gst_pad_get_pad_template(gobj()));
}

Glib::RefPtr<const Gst::PadTemplate> Pad::get_pad_template() const
{
  return const_cast<Pad*>(this)->get_pad_template();
}

PadLinkReturn Pad::link(const Glib::RefPtr<Gst::Pad>& sink_pad)
{
  return ((PadLinkReturn)(gst_pad_link(gobj(), Glib::unwrap(sink_pad))));
}

bool Pad::unlink(const Glib::RefPtr<Gst::Pad>& sink_pad)
{
  return gst_pad_unlink(gobj(), Glib::unwrap(sink_pad));
}

bool Pad::is_linked() const
{
  return gst_pad_is_linked(const_cast<GstPad*>(gobj()));
}

bool Pad::can_link(const Glib::RefPtr<const Gst::Pad>& other_pad) const
{
  return gst_pad_can_link(const_cast<GstPad*>(gobj()), const_cast<GstPad*>(Glib::unwrap(other_pad)));
}

Glib::RefPtr<Gst::Caps> Pad::get_allowed_caps()
{
  return Glib::wrap(gst_pad_get_allowed_caps(gobj()));
}

Glib::RefPtr<const Gst::Caps> Pad::get_allowed_caps() const
{
  return const_cast<Pad*>(this)->get_allowed_caps();
}

void Pad::remove_probe(gulong id)
{
  gst_pad_remove_probe(gobj(), id);
}

Glib::RefPtr<Gst::Pad> Pad::get_peer()
{
  return Glib::wrap(gst_pad_get_peer(gobj()));
}

Glib::RefPtr<const Gst::Pad> Pad::get_peer() const
{
  return const_cast<Pad*>(this)->get_peer();
}

void Pad::use_fixed_caps()
{
  gst_pad_use_fixed_caps(gobj());
}

bool Pad::is_active() const
{
  return gst_pad_is_active(const_cast<GstPad*>(gobj()));
}

bool Pad::is_blocked() const
{
  return gst_pad_is_blocked(const_cast<GstPad*>(gobj()));
}

bool Pad::is_blocking() const
{
  return gst_pad_is_blocking(const_cast<GstPad*>(gobj()));
}

bool Pad::query_accept_caps(const Glib::RefPtr<const Gst::Caps>& caps) const
{
  return gst_pad_query_accept_caps(const_cast<GstPad*>(gobj()), const_cast<GstCaps*>(Glib::unwrap(caps)));
}

bool Pad::proxy_query_caps(const Glib::RefPtr<Gst::Query>& query)
{
  return gst_pad_proxy_query_caps(gobj(), Glib::unwrap(query));
}

bool Pad::proxy_query_caps(const Glib::RefPtr<Gst::Query>& query) const
{
  return const_cast<Pad*>(this)->proxy_query_caps(query);
}

bool Pad::peer_query_accept_caps(const Glib::RefPtr<const Gst::Caps>& caps) const
{
  return gst_pad_peer_query_accept_caps(const_cast<GstPad*>(gobj()), const_cast<GstCaps*>(Glib::unwrap(caps)));
}

bool Pad::activate_mode(Gst::PadMode mode, bool active)
{
  return gst_pad_activate_mode(gobj(), ((GstPadMode)(mode)), static_cast<int>(active));
}

bool Pad::event_default(const Glib::RefPtr<Gst::Object>& parent, const Glib::RefPtr<Gst::Event>& event)
{
  return gst_pad_event_default(gobj(), Glib::unwrap(parent), Glib::unwrap(event));
}

bool Pad::event_default(const Glib::RefPtr<Gst::Event>& event)
{
  return gst_pad_event_default(gobj(), 0, Glib::unwrap(event));
}

bool Pad::query(const Glib::RefPtr<Gst::Query>& query) const
{
  return gst_pad_query(const_cast<GstPad*>(gobj()), Glib::unwrap(query));
}

bool Pad::peer_query(const Glib::RefPtr<Gst::Query>& query) const
{
  return gst_pad_peer_query(const_cast<GstPad*>(gobj()), Glib::unwrap(query));
}

Glib::RefPtr<Gst::Caps> Pad::peer_query_caps(const Glib::RefPtr<Gst::Caps>& filter) const
{
  return Glib::wrap(gst_pad_peer_query_caps(const_cast<GstPad*>(gobj()), Glib::unwrap(filter)));
}

bool Pad::query_default(const Glib::RefPtr<Gst::Object>& parent, const Glib::RefPtr<Gst::Query>& query) const
{
  return gst_pad_query_default(const_cast<GstPad*>(gobj()), Glib::unwrap(parent), Glib::unwrap(query));
}

bool Pad::query_default(const Glib::RefPtr<Gst::Query>& query) const
{
  return gst_pad_query_default(const_cast<GstPad*>(gobj()), 0, Glib::unwrap(query));
}

bool Pad::query_position(Format format, gint64& position) const
{
  return gst_pad_query_position(const_cast<GstPad*>(gobj()), ((GstFormat)(format)), &(position));
}

bool Pad::query_duration(Format format, gint64& duration) const
{
  return gst_pad_query_duration(const_cast<GstPad*>(gobj()), ((GstFormat)(format)), &(duration));
}

bool Pad::query_convert(Format src_format, gint64 src_value, Format dst_format, gint64& dst_value) const
{
  return gst_pad_query_convert(const_cast<GstPad*>(gobj()), ((GstFormat)(src_format)), src_value, ((GstFormat)(dst_format)), &(dst_value));
}

bool Pad::peer_query_convert(Format src_format, gint64 src_value, Format dst_format, gint64& dst_value) const
{
  return gst_pad_peer_query_convert(const_cast<GstPad*>(gobj()), ((GstFormat)(src_format)), src_value, ((GstFormat)(dst_format)), &(dst_value));
}

Gst::Iterator<Gst::Pad> Pad::iterate_internal_links()
{
  return Gst::Iterator<Gst::Pad>(gst_pad_iterate_internal_links(gobj()));
}

Gst::Iterator<const Gst::Pad> Pad::iterate_internal_links() const
{
  return Gst::Iterator<const Gst::Pad>(gst_pad_iterate_internal_links(const_cast<GstPad*>(gobj())));
}

Gst::Iterator<Gst::Pad> Pad::iterate_internal_links_default(const Glib::RefPtr<Gst::Object>& parent)
{
  return Gst::Iterator<Gst::Pad>(gst_pad_iterate_internal_links_default(gobj(), Glib::unwrap(parent)));
}

Gst::Iterator<Gst::Pad> Pad::iterate_internal_links_default()
{
  return Gst::Iterator<Gst::Pad>(gst_pad_iterate_internal_links_default(gobj(), 0));
}

Gst::Iterator<const Gst::Pad> Pad::iterate_internal_links_default(const Glib::RefPtr<Gst::Object>& parent) const
{
  return Gst::Iterator<const Gst::Pad>(gst_pad_iterate_internal_links_default(const_cast<GstPad*>(gobj()), Glib::unwrap(parent)));
}

Gst::Iterator<const Gst::Pad> Pad::iterate_internal_links_default() const
{
  return Gst::Iterator<const Gst::Pad>(gst_pad_iterate_internal_links_default(const_cast<GstPad*>(gobj()), 0));
}

Glib::RefPtr<Gst::Caps> Pad::get_current_caps()
{
  return Glib::wrap(gst_pad_get_current_caps(gobj()));
}

bool Pad::pause_task()
{
  return gst_pad_pause_task(gobj());
}

bool Pad::stop_task()
{
  return gst_pad_stop_task(gobj());
}

bool Pad::set_active(bool active)
{
  return gst_pad_set_active(gobj(), static_cast<int>(active));
}

Glib::RefPtr<Gst::Event> Pad::get_sticky_event(Gst::EventType event_type, guint idx) const
{
  return Glib::wrap(gst_pad_get_sticky_event(const_cast<GstPad*>(gobj()), ((GstEventType)(event_type)), idx));
}


Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& > Pad::signal_linked()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& >(this, &Pad_signal_linked_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& > Pad::signal_unlinked()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& >(this, &Pad_signal_unlinked_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gst::Caps> > Pad::property_caps() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gst::Caps> >(this, "caps");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< PadDirection > Pad::property_direction() const
{
  return Glib::PropertyProxy_ReadOnly< PadDirection >(this, "direction");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< PadTemplate > Pad::property_template() 
{
  return Glib::PropertyProxy< PadTemplate >(this, "template");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< PadTemplate > Pad::property_template() const
{
  return Glib::PropertyProxy_ReadOnly< PadTemplate >(this, "template");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void Gst::Pad::on_linked(const Glib::RefPtr<Gst::Pad>& peer_pad)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->linked)
    (*base->linked)(gobj(),Glib::unwrap(peer_pad));
}
void Gst::Pad::on_unlinked(const Glib::RefPtr<Gst::Pad>& peer_pad)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unlinked)
    (*base->unlinked)(gobj(),Glib::unwrap(peer_pad));
}


} // namespace Gst


namespace Gst
{


 gulong PadProbeInfo::get_id() const
{
  return gobj()->id;
}
 
Glib::RefPtr<Gst::Event> PadProbeInfo::get_event()
{
  Glib::RefPtr<Gst::Event> retvalue = Glib::wrap(gst_pad_probe_info_get_event(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

const Glib::RefPtr<Gst::Event> PadProbeInfo::get_event() const
{
  return const_cast<PadProbeInfo*>(this)->get_event();
}

Glib::RefPtr<Gst::Query> PadProbeInfo::get_query()
{
  return Glib::wrap(gst_pad_probe_info_get_query(gobj()));
}

const Glib::RefPtr<Gst::Query> PadProbeInfo::get_query() const
{
  return const_cast<PadProbeInfo*>(this)->get_query();
}

Glib::RefPtr<Gst::Buffer> PadProbeInfo::get_buffer()
{
  Glib::RefPtr<Gst::Buffer> retvalue = Glib::wrap(gst_pad_probe_info_get_buffer(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

const Glib::RefPtr<Gst::Buffer> PadProbeInfo::get_buffer() const
{
  return const_cast<PadProbeInfo*>(this)->get_buffer();
}

Glib::RefPtr<Gst::BufferList> PadProbeInfo::get_buffer_list()
{
  return Glib::wrap(gst_pad_probe_info_get_buffer_list(gobj()));
}

const Glib::RefPtr<Gst::BufferList> PadProbeInfo::get_buffer_list() const
{
  return const_cast<PadProbeInfo*>(this)->get_buffer_list();
}


} // namespace Gst


