//*****************************************************************************
//                              PnlGnuCapFO.hpp                               *
//                             -----------------                              *
// Description : This class derives from the Analysis Panel base class and    *
//               provides a GUI for a user to configure a Fourier Analysis    *
//               for GNU-Cap electronic circuit simulator.                    *
// Started     : 26/04/2004                                                   *
// Last Update : 03/08/2009                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLGNUCAPFO_HPP
#define PNLGNUCAPFO_HPP

// System Includes

#include <cfloat>

// wxWidgets Library Includes

#include <wx/config.h>

// Application Includes

#include "base/PnlAnaBase.hpp"
#include "netlist/SimnGnuCap.hpp"
#include "gnucap/dialogs/DlgGcpCfgGEN.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlGnuCapFO : public PnlAnaBase
{
  private :

    // Output Parameters
    wxStaticBox   m_oSbxOutputs;
    wxCheckBox    m_oCbxMag;
    wxCheckBox    m_oCbxPhase;
    wxCheckBox    m_oCbxMagDb;
    wxCheckBox    m_oCbxMagRel;

    // Generator configuration
    wxButton      m_oBtnSetup;
    DlgGcpCfgGEN  m_oDlgCfgGEN;

    void  Create( void );
    void  CreateOutputs( void );

    bool  bIsCreatedOutputs( void )
                              { return( m_oSbxOutputs.GetParent( ) != NULL ); }

    void  GetConfig( void );
    void  SetConfig( void );

  public :

    PnlGnuCapFO( wxWindow * poWin );
   ~PnlGnuCapFO( );

    bool  bClear( void );

    bool  bLoad( SimnGnuCap & roSimn );
    bool  bSave( SimnGnuCap & roSimn );

    // Event handlers
    void  OnBtnSetup( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum ePnlItemID
    {
      ID_BTN_SETUP = PnlAnaBase::ID_LST+1,

      ID_CBX_MAG,
      ID_CBX_PHASE,
      ID_CBX_MAGDB,
      ID_CBX_MAGREL,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_BTN_SETUP,
      ID_LST = ID_CBX_MAGREL
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLGNUCAPFO_HPP
