/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

/* Linux PSK31 modem driver for soundcard -- Filter coefficients
 *
 * these FIR coefs are those used by G0TJZ in his TMC320C50 code
 *
 * Hansi Reiser, DL9RDZ, 20 April 1998
 */

/* 64-tap raised-cosine FIR*/
float fir1c[64]={
         0.000000,
         0.000038,
         0.000150,
         0.000336,
         0.000595,
         0.000922,
         0.001317,
         0.001773,
         0.002288,
         0.002856,
         0.003472,
         0.004130,
         0.004823,
         0.005545,
         0.006288,
         0.007047,
         0.007812,
         0.008578,
         0.009337,
         0.010080,
         0.010802,
         0.011495,
         0.012153,
         0.012769,
         0.013337,
         0.013852,
         0.014308,
         0.014703,
         0.015030,
         0.015289,
         0.015475,
         0.015587,
         0.015625,
         0.015587,
         0.015475,
         0.015289,
         0.015030,
         0.014703,
         0.014308,
         0.013852,
         0.013337,
         0.012769,
         0.012153,
         0.011495,
         0.010802,
         0.010080,
         0.009337,
         0.008578,
         0.007813,
         0.007047,
         0.006288,
         0.005545,
         0.004823,
         0.004130,
         0.003472,
         0.002856,
         0.002288,
         0.001773,
         0.001317,
         0.000922,
         0.000595,
         0.000336,
         0.000150,
         0.000038,
};

/* 4-bit receive filter for 31.25 baud BPSK
 * Designed by G3PLX, version 2
 */
float fir2c[64]={
         -0.00044789,
         -0.00063167,
         -0.00100256,
         -0.00156531,
         -0.00232266,
         -0.00327063,
         -0.00439342,
         -0.00565850,
         -0.00701253,
         -0.00837907,
         -0.00965823,
         -0.01072878,
         -0.01145278,
         -0.01168246,
         -0.01126911,
         -0.01007335,
         -0.00797606,
         -0.00488924,
         -0.00076591,
          0.00439171,
          0.01052660,
          0.01752432,
          0.02521404,
          0.03337329,
          0.04173643,
          0.05000649,
          0.05786981,
          0.06501264,
          0.07113857,
          0.07598566,
          0.07934199,
          0.08105860,
          0.08105860,
          0.07934199,
          0.07598566,
          0.07113857,
          0.06501264,
          0.05786981,
          0.05000649,
          0.04173643,
          0.03337329,
          0.02521404,
          0.01752432,
          0.01052660,
          0.00439171,
         -0.00076591,
         -0.00488924,
         -0.00797606,
         -0.01007335,
         -0.01126911,
         -0.01168246,
         -0.01145278,
         -0.01072878,
         -0.00965823,
         -0.00837907,
         -0.00701253,
         -0.00565850,
         -0.00439342,
         -0.00327063,
         -0.00232266,
         -0.00156531,
         -0.00100256,
         -0.00063167,
         -0.00044789,
};

float fir2cnew[64]={
	0.000625000,
	0.000820912,
	0.001374651,
	0.002188141,
	0.003110600,
	0.003956273,
	0.004526787,
	0.004635947,
	0.004134515,
	0.002932456,
	0.001016352,
	-0.001539947,
	-0.004572751,
	-0.007834665,
	-0.011009254,
	-0.013733305,
	-0.015625000,
	-0.016315775,
	-0.015483216,
	-0.012882186,
	-0.008371423,
	-0.001933193,
	0.006315933,
	0.016124399,
	0.027115485,
	0.038807198,
	0.050640928,
	0.062016866,
	0.072333574,
	0.081028710,
	0.087617820,
	0.091728168,
	0.093125000,
	0.091728168,
	0.087617820,
	0.081028710,
	0.072333574,
	0.062016866,
	0.050640928,
	0.038807198,
	0.027115485,
	0.016124399,
	0.006315933,
	-0.001933193,
	-0.008371423,
	-0.012882186,
	-0.015483216,
	-0.016315775,
	-0.015625000,
	-0.013733305,
	-0.011009254,
	-0.007834665,
	-0.004572751,
	-0.001539947,
	0.001016352,
	0.002932456,
	0.004134515,
	0.004635947,
	0.004526787,
	0.003956273,
	0.003110600,
	0.002188141,
	0.001374651,
	0.000820912
};


float ampcof[16] = {
	-0.097545161,
	-0.093796555,
	-0.086443400,
	-0.075768274,
	-0.062181416,
	-0.046204960,
	-0.028452874,
	-0.009607360,
	0.009607360,
	0.028452874,
	0.046204960,
	0.062181416,
	0.075768274,
	0.086443400,
	0.093796555,
	0.097545161
};
