/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.DeviceSettingsMesg;
import com.garmin.fit.DeviceSettingsMesgListener;
import com.garmin.fit.Field;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.LocalDateTime;
import com.garmin.fit.Mesg;
import com.garmin.fit.MonitoringInfoMesg;
import com.garmin.fit.MonitoringInfoMesgListener;
import com.garmin.fit.MonitoringMesg;
import com.garmin.fit.MonitoringMesgListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MonitoringReader
implements MonitoringInfoMesgListener,
MonitoringMesgListener,
DeviceSettingsMesgListener {
    public static final int DAILY_INTERVAL = 86400;
    private final String[] accumulatedFieldNames = new String[]{"cycles", "distance", "active_calories", "calories", "active_time"};
    private final String[] instantaneousFieldNames = new String[]{"intensity", "heart_rate", "temperature"};
    private ArrayList<MonitoringMesgListener> listeners;
    private int interval;
    private boolean outputDailyTotals;
    private MonitoringInfoMesg infoMesg;
    private HashMap<ActivityType, ArrayList<MonitoringMesg>> intervalMesgs;
    private HashMap<ActivityType, MonitoringMesg> lastMesgs;
    private long startTimestamp;
    private long endTimestamp;
    private long lastTimestamp;
    private long localTimeOffset;
    private long mesgTimestamp;
    private long systemToUtcTimestampOffset;
    private long systemToLocalTimestampOffset;
    private HashMap<ActivityType, ExtractState> extractStates;

    public MonitoringReader(int n) {
        if (n < 0 || n > 86400) {
            throw new FitRuntimeException(n + "s is invalid.  Output interval duration must be between 1s and 86400s (1 day).");
        }
        this.listeners = new ArrayList();
        this.interval = n;
        this.outputDailyTotals = false;
        this.intervalMesgs = new HashMap();
        this.lastMesgs = new HashMap();
        this.localTimeOffset = 0L;
        this.systemToUtcTimestampOffset = 0L;
        this.systemToLocalTimestampOffset = 0L;
        this.extractStates = new HashMap();
    }

    public void outputDailyTotals() {
        if (this.interval != 86400) {
            throw new FitRuntimeException("Interval must be 86400s to output daily totals");
        }
        this.outputDailyTotals = true;
    }

    public void setSystemToUtcTimestampOffset(long l) {
        this.systemToUtcTimestampOffset = l;
    }

    public void setSystemToLocalTimestampOffset(long l) {
        this.systemToLocalTimestampOffset = l;
    }

    public void addListener(MonitoringMesgListener monitoringMesgListener) {
        this.listeners.add(monitoringMesgListener);
    }

    public void broadcast() {
        while (this.broadcastInterval(false)) {
        }
    }

    private void broadcastCompleteIntervals() {
        while (this.broadcastInterval(true)) {
        }
    }

    private boolean broadcastInterval(boolean bl) {
        Object object;
        Iterator<ActivityType> iterator = this.intervalMesgs.keySet().iterator();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        String[] stringArray = null;
        if (this.endTimestamp == this.lastTimestamp) {
            return false;
        }
        if (this.outputDailyTotals) {
            this.startTimestamp = this.modTimestampToLocalInterval(this.startTimestamp);
        }
        if (this.endTimestamp < this.startTimestamp) {
            this.endTimestamp = this.modTimestampToLocalInterval(this.startTimestamp);
        }
        if (bl && this.endTimestamp + (long)this.interval > this.lastTimestamp) {
            return false;
        }
        this.endTimestamp += (long)this.interval;
        if (this.endTimestamp > this.lastTimestamp) {
            this.endTimestamp = this.lastTimestamp;
        }
        while (iterator.hasNext()) {
            int n;
            Object object2;
            object = iterator.next();
            Object object3 = this.computeInterval((ActivityType)((Object)object), (ArrayList<MonitoringMesg>)(object2 = this.intervalMesgs.get(object)));
            if (object3 != null) {
                hashMap.put(object, object3);
                if (((MonitoringMesg)object3).getActivityType() == ActivityType.ALL) {
                    stringArray = object3;
                }
            }
            for (n = 0; n < object2.size() && object2.get(n).getTimestamp().getTimestamp() <= this.endTimestamp; ++n) {
            }
            --n;
            while (n > 0) {
                object2.remove(--n);
            }
        }
        if (hashMap.size() > 0) {
            object = (MonitoringMesg)hashMap.values().iterator().next();
            MonitoringMesg monitoringMesg = new MonitoringMesg();
            monitoringMesg.setTimestamp(((MonitoringMesg)object).getTimestamp());
            monitoringMesg.setLocalTimestamp(((MonitoringMesg)object).getLocalTimestamp());
            monitoringMesg.setActivityType(ActivityType.ALL);
            monitoringMesg.setDuration(((MonitoringMesg)object).getDuration());
            for (Object object2 : hashMap.keySet()) {
                object = (MonitoringMesg)hashMap.get(object2);
                if (((MonitoringMesg)object).getActivityType() == ActivityType.ALL) continue;
                for (String string : this.accumulatedFieldNames) {
                    if (((Mesg)object).getFieldDoubleValue(string) == null) continue;
                    if (monitoringMesg.getFieldDoubleValue(string) == null) {
                        monitoringMesg.setFieldValue(string, (Object)Float.valueOf(0.0f));
                    }
                    monitoringMesg.setFieldValue(string, (Object)(monitoringMesg.getFieldDoubleValue(string) + ((Mesg)object).getFieldDoubleValue(string)));
                }
            }
            if (monitoringMesg.getCalories() == null && this.infoMesg.getRestingMetabolicRate() != null) {
                monitoringMesg.setCalories((int)(monitoringMesg.getDuration() * (long)this.infoMesg.getRestingMetabolicRate().intValue() / 86400L));
                if (monitoringMesg.getActiveCalories() != null) {
                    monitoringMesg.setCalories(monitoringMesg.getCalories() + monitoringMesg.getActiveCalories());
                }
            }
            if (stringArray != null) {
                for (Object object3 : monitoringMesg.fields) {
                    if (stringArray.getField(((Field)object3).num) != null) continue;
                    stringArray.setField((Field)object3);
                }
            } else {
                hashMap.put((Object)ActivityType.ALL, monitoringMesg);
            }
            for (Object object2 : hashMap.keySet()) {
                for (MonitoringMesgListener monitoringMesgListener : this.listeners) {
                    monitoringMesgListener.onMesg((MonitoringMesg)hashMap.get(object2));
                }
            }
            this.startTimestamp = this.endTimestamp;
        }
        return true;
    }

    @Override
    public void onMesg(MonitoringInfoMesg monitoringInfoMesg) {
        this.infoMesg = monitoringInfoMesg;
        DateTime dateTime = this.infoMesg.getTimestamp();
        this.mesgTimestamp = dateTime.getTimestamp();
        dateTime.convertSystemTimeToUTC(this.systemToUtcTimestampOffset);
        this.infoMesg.setTimestamp(dateTime);
        this.lastTimestamp = dateTime.getTimestamp();
        if (this.infoMesg.getLocalTimestamp() != null) {
            LocalDateTime localDateTime = new LocalDateTime(this.infoMesg.getLocalTimestamp());
            localDateTime.convertSystemTimeToLocal(this.systemToLocalTimestampOffset);
            this.localTimeOffset = localDateTime.getTimestamp() - this.lastTimestamp;
        } else {
            this.localTimeOffset = this.systemToLocalTimestampOffset - this.systemToUtcTimestampOffset;
        }
        this.startTimestamp = this.lastTimestamp;
    }

    @Override
    public void onMesg(MonitoringMesg monitoringMesg) {
        MonitoringMesg monitoringMesg2;
        ArrayList<Object> arrayList;
        MonitoringMesg monitoringMesg3;
        if (this.infoMesg == null) {
            return;
        }
        MonitoringMesg monitoringMesg4 = this.extract(monitoringMesg);
        if (monitoringMesg4.getActivityType() == null) {
            monitoringMesg4.setActivityType(ActivityType.ALL);
        }
        if (monitoringMesg4.getTimestamp() == null) {
            return;
        }
        if (this.lastTimestamp != monitoringMesg4.getTimestamp().getTimestamp() && this.lastTimestamp - this.modTimestampToLocalInterval(this.startTimestamp) >= (long)this.interval) {
            this.broadcastCompleteIntervals();
        }
        if (monitoringMesg.getCurrentActivityTypeIntensity() != null) {
            monitoringMesg3 = this.lastMesgs.get((Object)monitoringMesg4.getActivityType());
            if (monitoringMesg3 == null) {
                arrayList = new ArrayList();
                monitoringMesg2 = new MonitoringMesg();
                monitoringMesg2.setActivityType(monitoringMesg4.getActivityType());
                monitoringMesg2.setTimestamp(new DateTime(monitoringMesg4.getTimestamp().getTimestamp() - monitoringMesg4.getActiveTime().longValue()));
                arrayList.add(monitoringMesg2);
                this.intervalMesgs.put(monitoringMesg2.getActivityType(), arrayList);
            }
            for (MonitoringMesg monitoringMesg5 : this.lastMesgs.values()) {
                if (monitoringMesg5.getActivityType() == monitoringMesg4.getActivityType()) continue;
                MonitoringMesg monitoringMesg6 = new MonitoringMesg();
                monitoringMesg6.setTimestamp(monitoringMesg4.getTimestamp());
                monitoringMesg6.setActivityType(monitoringMesg5.getActivityType());
                for (String string : this.accumulatedFieldNames) {
                    if (monitoringMesg5.getField(string) == null) continue;
                    monitoringMesg6.setField(monitoringMesg5.getField(string));
                }
                this.intervalMesgs.get((Object)monitoringMesg6.getActivityType()).add(monitoringMesg6);
            }
        }
        this.lastTimestamp = monitoringMesg4.getTimestamp().getTimestamp();
        monitoringMesg3 = this.lastMesgs.get((Object)monitoringMesg4.getActivityType());
        if (monitoringMesg3 == null) {
            monitoringMesg3 = new MonitoringMesg();
            this.lastMesgs.put(monitoringMesg4.getActivityType(), monitoringMesg3);
        }
        this.setFieldsFromMesg(monitoringMesg3, monitoringMesg4);
        arrayList = this.intervalMesgs.get((Object)monitoringMesg4.getActivityType());
        monitoringMesg2 = null;
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.intervalMesgs.put(monitoringMesg4.getActivityType(), arrayList);
        }
        if (arrayList.size() > 0) {
            monitoringMesg2 = (MonitoringMesg)arrayList.get(arrayList.size() - 1);
        }
        if (monitoringMesg2 != null && monitoringMesg4.getTimestamp().equals(monitoringMesg2.getTimestamp())) {
            this.setFieldsFromMesg(monitoringMesg2, monitoringMesg4);
        } else {
            arrayList.add(monitoringMesg4);
        }
    }

    @Override
    public void onMesg(DeviceSettingsMesg deviceSettingsMesg) {
        if (deviceSettingsMesg.getUtcOffset() != null) {
            int n = 0;
            long l = deviceSettingsMesg.getUtcOffset();
            this.setSystemToUtcTimestampOffset(l);
            if (deviceSettingsMesg.getActiveTimeZone() != null) {
                n = deviceSettingsMesg.getActiveTimeZone().shortValue();
            }
            if (deviceSettingsMesg.getTimeZoneOffset(n) != null) {
                l = (long)((double)l + (double)deviceSettingsMesg.getTimeZoneOffset(n).floatValue() * 3600.0);
            }
            this.setSystemToLocalTimestampOffset(l);
        }
    }

    private long modTimestampToLocalInterval(long l) {
        l += this.localTimeOffset;
        l -= l % (long)this.interval;
        return l -= this.localTimeOffset;
    }

    private void setFieldsFromMesg(MonitoringMesg monitoringMesg, MonitoringMesg monitoringMesg2) {
        Iterator iterator = monitoringMesg2.fields.iterator();
        while (iterator.hasNext()) {
            monitoringMesg.setField(new Field((Field)iterator.next()));
        }
    }

    private MonitoringMesg extract(MonitoringMesg monitoringMesg) {
        ExtractState extractState;
        MonitoringMesg monitoringMesg2 = new MonitoringMesg();
        int n = Integer.MAX_VALUE;
        MonitoringMesg monitoringMesg3 = null;
        if (monitoringMesg.getTimestamp() != null) {
            this.mesgTimestamp = monitoringMesg.getTimestamp().getTimestamp();
        } else if (monitoringMesg.getTimestamp16() != null) {
            this.mesgTimestamp += (long)monitoringMesg.getTimestamp16().intValue() - (this.mesgTimestamp & 0xFFFFL) & 0xFFFFL;
        } else if (monitoringMesg.getTimestampMin8() != null) {
            this.mesgTimestamp /= 60L;
            this.mesgTimestamp += (long)monitoringMesg.getTimestampMin8().shortValue() - (this.mesgTimestamp & 0xFFL) & 0xFFL;
            this.mesgTimestamp *= 60L;
        }
        DateTime dateTime = new DateTime(this.mesgTimestamp);
        dateTime.convertSystemTimeToUTC(this.systemToUtcTimestampOffset);
        monitoringMesg2.setTimestamp(dateTime);
        if (monitoringMesg.getLocalTimestamp() != null) {
            monitoringMesg2.setLocalTimestamp(monitoringMesg.getLocalTimestamp());
        } else {
            monitoringMesg2.setLocalTimestamp(dateTime.getTimestamp() + this.localTimeOffset);
        }
        if (monitoringMesg.getActivityType() != null) {
            monitoringMesg2.setActivityType(monitoringMesg.getActivityType());
        }
        if ((extractState = this.extractStates.get((Object)monitoringMesg2.getActivityType())) == null) {
            extractState = new ExtractState();
            this.extractStates.put(monitoringMesg2.getActivityType(), extractState);
        }
        if (this.infoMesg.getNumActivityType() > 0) {
            for (int i = 0; i < this.infoMesg.getNumActivityType(); ++i) {
                if (this.infoMesg.getActivityType(i) != monitoringMesg2.getActivityType()) continue;
                n = i;
            }
        }
        if ((monitoringMesg3 = this.lastMesgs.get((Object)monitoringMesg.getActivityType())) == null) {
            monitoringMesg3 = new MonitoringMesg();
        }
        if (monitoringMesg.getDuration() != null) {
            monitoringMesg2.setDuration(monitoringMesg.getDuration());
        } else if (monitoringMesg.getDurationMin() != null) {
            monitoringMesg2.setDuration((long)monitoringMesg.getDurationMin().intValue() * 60L);
        }
        if (monitoringMesg.getActiveTime() != null) {
            monitoringMesg2.setActiveTime(monitoringMesg.getActiveTime());
        } else if (monitoringMesg.getActiveTime16() != null) {
            long l = 0L;
            if (monitoringMesg3.getActiveTime() != null) {
                l = (long)((double)monitoringMesg3.getActiveTime().floatValue() + 0.5);
            }
            l += (long)monitoringMesg.getActiveTime16().intValue() - (l & 0xFFFFL) & 0xFFFFL;
            monitoringMesg2.setActiveTime(Float.valueOf(l));
        } else if (monitoringMesg.getCurrentActivityTypeIntensity() != null) {
            long l = 0L;
            if (monitoringMesg3.getActiveTime() != null) {
                l = (long)((double)monitoringMesg3.getActiveTime().floatValue() + 0.5);
            }
            monitoringMesg2.setActiveTime(Float.valueOf(l += dateTime.getTimestamp() - this.lastTimestamp));
        }
        if (monitoringMesg.getCycles() != null) {
            monitoringMesg2.setCycles(monitoringMesg.getCycles());
        } else if (monitoringMesg.getCycles16() != null) {
            long l = 0L;
            if (monitoringMesg3.getCycles() != null) {
                l = (long)(monitoringMesg3.getCycles().floatValue() * 2.0f);
            }
            l += (long)monitoringMesg.getCycles16().intValue() - (l & 0xFFFFL) & 0xFFFFL;
            monitoringMesg2.setCycles(Float.valueOf((float)l / 2.0f));
        }
        if (monitoringMesg.getDistance() != null) {
            monitoringMesg2.setDistance(monitoringMesg.getDistance());
        } else if (monitoringMesg.getDistance16() != null) {
            long l = 0L;
            if (monitoringMesg3.getDistance() != null) {
                l = (long)(monitoringMesg3.getDistance().floatValue() * 100.0f);
            }
            l += (long)monitoringMesg.getDistance16().intValue() - (l & 0xFFFFL) & 0xFFFFL;
            monitoringMesg2.setDistance(Float.valueOf((float)l / 100.0f));
        }
        if (monitoringMesg.getActiveCalories() != null) {
            monitoringMesg2.setActiveCalories(monitoringMesg.getActiveCalories());
        }
        if (monitoringMesg.getCalories() != null) {
            monitoringMesg2.setCalories(monitoringMesg.getCalories());
        }
        if (monitoringMesg.getIntensity() != null) {
            monitoringMesg2.setIntensity(monitoringMesg.getIntensity());
        }
        if (monitoringMesg.getHeartRate() != null) {
            monitoringMesg2.setHeartRate(monitoringMesg.getHeartRate());
        }
        if (monitoringMesg.getTemperature() != null) {
            monitoringMesg2.setTemperature(monitoringMesg.getTemperature());
        }
        if (monitoringMesg2.getDistance() != null) {
            extractState.cyclesToDistanceStartDist = monitoringMesg2.getDistance().floatValue();
            extractState.cyclesToDistanceStartCycles = monitoringMesg2.getCycles().floatValue();
        } else if (n < this.infoMesg.getNumCyclesToDistance() && monitoringMesg2.getCycles() != null) {
            monitoringMesg2.setDistance(Float.valueOf(extractState.cyclesToDistanceStartDist + (monitoringMesg2.getCycles().floatValue() - extractState.cyclesToDistanceStartCycles) * this.infoMesg.getCyclesToDistance(n).floatValue()));
        }
        if (monitoringMesg2.getActiveCalories() != null) {
            extractState.cyclesToCaloriesStartCal = monitoringMesg2.getActiveCalories();
            extractState.cyclesToCaloriesStartCycles = monitoringMesg2.getCycles().floatValue();
        } else if (n < this.infoMesg.getNumCyclesToCalories() && monitoringMesg2.getCycles() != null) {
            monitoringMesg2.setActiveCalories((int)((float)extractState.cyclesToCaloriesStartCal + (monitoringMesg2.getCycles().floatValue() - extractState.cyclesToCaloriesStartCycles) * this.infoMesg.getCyclesToCalories(n).floatValue()));
        }
        return monitoringMesg2;
    }

    private MonitoringMesg computeInterval(ActivityType activityType, ArrayList<MonitoringMesg> arrayList) {
        MonitoringMesg monitoringMesg = new MonitoringMesg();
        ArrayList<Field> arrayList2 = new ArrayList<Field>();
        boolean bl = false;
        boolean bl2 = false;
        if (arrayList.size() == 0) {
            return null;
        }
        monitoringMesg.setTimestamp(new DateTime(this.endTimestamp));
        monitoringMesg.setLocalTimestamp(this.endTimestamp + this.localTimeOffset);
        monitoringMesg.setActivityType(activityType);
        monitoringMesg.setDuration(this.endTimestamp - this.startTimestamp);
        for (String string : this.accumulatedFieldNames) {
            arrayList2.add(new AccumField(MonitoringMesg.monitoringMesg.getField(string)));
        }
        for (String string : this.instantaneousFieldNames) {
            arrayList2.add(new InstField(MonitoringMesg.monitoringMesg.getField(string)));
        }
        for (MonitoringMesg readerField : arrayList) {
            long l = readerField.getTimestamp().getTimestamp();
            if (l > this.startTimestamp && l < this.endTimestamp + (long)this.interval) {
                bl2 = true;
            }
            for (ReaderField readerField2 : arrayList2) {
                readerField2.onMesg(readerField);
            }
        }
        if (!bl2) {
            return null;
        }
        for (ReaderField readerField : arrayList2) {
            if (!readerField.setMesg(monitoringMesg)) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return monitoringMesg;
    }

    private class InstField
    extends Field
    implements ReaderField {
        private double sum;
        private double sumDuration;
        private long sumEndTimestamp;

        public InstField(Field field) {
            super(field);
            this.sum = 0.0;
            this.sumDuration = 0.0;
            this.sumEndTimestamp = MonitoringReader.this.startTimestamp;
        }

        @Override
        public boolean setMesg(MonitoringMesg monitoringMesg) {
            if (this.sumDuration == 0.0) {
                return false;
            }
            monitoringMesg.setFieldValue(this.num, 0, (Object)(this.sum / this.sumDuration));
            return true;
        }

        @Override
        public void onMesg(MonitoringMesg monitoringMesg) {
            Field field = monitoringMesg.getField(this.num);
            if (MonitoringReader.this.outputDailyTotals) {
                return;
            }
            long l = monitoringMesg.getTimestamp().getTimestamp();
            if (l > MonitoringReader.this.endTimestamp) {
                l = MonitoringReader.this.endTimestamp;
            }
            if (this.sumEndTimestamp >= l) {
                return;
            }
            double d = l - this.sumEndTimestamp;
            this.sumEndTimestamp = l;
            if (field == null) {
                return;
            }
            Double d2 = field.getDoubleValue();
            if (d2 == null) {
                return;
            }
            this.sumDuration += d;
            this.sum += d2 * d;
        }
    }

    private class AccumField
    extends Field
    implements ReaderField {
        private Double startValue;
        private long startValueTimestamp;
        private Double endValue;
        private long endValueTimestamp;

        public AccumField(Field field) {
            super(field);
            this.startValue = new Double(0.0);
            this.startValueTimestamp = MonitoringReader.this.startTimestamp + MonitoringReader.this.localTimeOffset;
            this.startValueTimestamp -= this.startValueTimestamp % 86400L;
            this.startValueTimestamp -= MonitoringReader.this.localTimeOffset;
            this.endValue = null;
            this.endValueTimestamp = 0L;
        }

        @Override
        public boolean setMesg(MonitoringMesg monitoringMesg) {
            if (this.endValue == null) {
                return false;
            }
            double d = this.endValue - this.startValue;
            if (d < 0.0) {
                d = 0.0;
            }
            monitoringMesg.setFieldValue(this.num, 0, (Object)d);
            return d != 0.0;
        }

        @Override
        public void onMesg(MonitoringMesg monitoringMesg) {
            Field field = monitoringMesg.getField(this.num);
            long l = monitoringMesg.getTimestamp().getTimestamp();
            Double d = null;
            if (field != null) {
                d = field.getDoubleValue();
            }
            if (l <= MonitoringReader.this.startTimestamp) {
                if (d != null) {
                    this.startValue = d;
                }
                this.startValueTimestamp = l;
            } else {
                if (this.startValueTimestamp < MonitoringReader.this.startTimestamp) {
                    if (d != null) {
                        this.startValue = this.startValue + (d - this.startValue) * (double)(MonitoringReader.this.startTimestamp - this.startValueTimestamp) / (double)(l - this.startValueTimestamp);
                    }
                    this.startValueTimestamp = MonitoringReader.this.startTimestamp;
                }
                if (l > MonitoringReader.this.endTimestamp && d != null) {
                    if (this.endValue == null) {
                        this.endValue = this.startValue;
                        this.endValueTimestamp = this.startValueTimestamp;
                    }
                    d = this.endValue + (d - this.endValue) * (double)(MonitoringReader.this.endTimestamp - this.endValueTimestamp) / (double)(l - this.endValueTimestamp);
                }
                this.endValueTimestamp = l;
                if (d != null) {
                    this.endValue = d;
                }
            }
        }
    }

    private static interface ReaderField
    extends MonitoringMesgListener {
        public boolean setMesg(MonitoringMesg var1);
    }

    private class ExtractState {
        public float cyclesToCaloriesStartCycles = 0.0f;
        public int cyclesToCaloriesStartCal = 0;
        public float cyclesToDistanceStartCycles = 0.0f;
        public float cyclesToDistanceStartDist = 0.0f;

        private ExtractState() {
        }
    }
}

