/*
View "stat" {
  T2(27,-30,0){ Sprintf("%g Tetrahedra", Mesh.NbTetrahedra) };
};
*/

//
// Hi,
//
// I took a look at your .geo file yesterday. I corrected a small bug
// in the 2D algorithm (the simple case of a triangular surface with
// too large characteristic lengths was not correctly handled), but
// there is still a bug I have to find in the recovery of surfaces in
// the initial 3D mesh. Nevertheless, for the moment, I was able to
// generate meshes for characteristic lengths much greater or much
// smaller than the characteristic lengths of the individual surfaces.
// Here are the results of my tests:
// 
//lc=5 ; // OK, circa 1,000 tets. Should work OK also for all lc > 5.
//
// lc in [1,5] does *not* work.

// Now it works! % Last Mod by Christophe on Wed Nov  7 12:06:15 2001


//
lc = 0.9 ; // OK, circa 40,000 tets
//lc = 0.7 ; // OK, circa 80,000 tets
//lc = 0.5 ; // OK, circa 225,000 tets
//lc = 0.3 ; // OK, circa 500,000 tets
//
// On which platform are you working? I had only time to update the
// web site for Windows and Linux versions (1.14). If you work with
// another OS, I can try to send you a corrected version in a few days
// if you want.
//
// My best,
//
// Christophe

Point(1) = {24.5472, 36.9927, 2.24128, 1.03074*lc};
Point(2) = {26.2937, 37.785, 1.48519, 1.03074*lc};
Point(3) = {21.7537, 39.4112, 1.44071, 1.89035*lc};
Point(4) = {26.8629, 54.0497, 1.00959, 1.17533*lc};
Point(5) = {18.7033, 43.2619, 1.27739, 2.45762*lc};
Point(6) = {27.0769, 44.5443, 2.13611, 3.41779*lc};
Point(7) = {15.2765, 70.0077, 1.0291, 0.909015*lc};
Point(8) = {10.2811, 50.9905, 1.13922, 3.02792*lc};
Point(9) = {4.12828, 54.8758, 1.29776, 2.01481*lc};
Point(10) = {5.57025, 62.5653, 1.59466, 2.12948*lc};
Point(11) = {2.39087, 58.5105, 1.2073, 2.01481*lc};
Point(12) = {9.78256, 62.8366, 1.02762, 2.00689*lc};
Point(13) = {37.6759, 73.0764, 1.05283, 2.59626*lc};
Point(14) = {11.7812, 66.2048, 1.90572, 2.00689*lc};
Point(15) = {21.9503, 72.9246, 1.07765, 2.68872*lc};
Point(16) = {16.3178, 70.9958, 2.14471, 0.909015*lc};
Point(17) = {26.8839, 74.9571, 1.74495, 2.61477*lc};
Point(18) = {31.2864, 77.7132, 1.13677, 2.61477*lc};
Point(19) = {38.0609, 78.2488, 1.29828, 2.59626*lc};
Point(20) = {31.4122, 59.66, 1.93328, 2.70827*lc};
Point(21) = {9.42876, 65.0248, 6.47762, 2.63764*lc};
Point(22) = {14.711, 46.8659, 1.33091, 2.68934*lc};
Point(23) = {28.2008, 52.1833, 1.51175, 1.17533*lc};
Point(24) = {5.62066, 56.3708, 7.35847, 1.95591*lc};
Point(25) = {37.9066, 69.4622, 7.49251, 2.38892*lc};
Point(26) = {20.8127, 43.2988, 7.81257, 2.64189*lc};
Point(27) = {15.6365, 47.4149, 6.85327, 2.35365*lc};
Point(28) = {1.84985, 57.4081, 7.27299, 1.95591*lc};
Point(29) = {38.0548, 74.1524, 8.39131, 2.17658*lc};
Point(30) = {25.9308, 37.3172, 10.4376, 1.24403*lc};
Point(31) = {28.2409, 37.8311, 9.66962, 1.24403*lc};
Point(32) = {35.1201, 65.3704, 1.59781, 3.40843*lc};
Point(33) = {33.3909, 78.1682, 7.50394, 2.52678*lc};
Point(34) = {30.6569, 52.2028, 6.74145, 2.88888*lc};
Point(35) = {34.298, 59.9116, 6.51016, 2.41886*lc};
Point(36) = {20.7251, 69.084, 7.93288, 2.92222*lc};
Point(37) = {29.6416, 74.7798, 7.50041, 2.52678*lc};
Point(38) = {17.8216, 46.3792, 10.892, 2.35365*lc};
Point(39) = {12.6765, 50.5637, 13.4513, 1.25365*lc};
Point(40) = {15.0307, 67.7683, 7.91899, 2.87527*lc};
Point(41) = {28.5696, 42.1996, 9.69589, 2.19046*lc};
Point(42) = {35.3365, 58.2728, 10.9418, 2.41886*lc};
Point(43) = {12.1156, 65.6213, 12.3868, 1.92832*lc};
Point(44) = {8.36472, 53.5479, 10.4097, 2.49041*lc};
Point(45) = {27.3893, 71.7634, 12.3614, 2.7691*lc};
Point(46) = {3.47976, 61.5178, 7.8948, 2.23231*lc};
Point(47) = {20.6058, 66.3961, 14.6852, 3.63431*lc};
Point(48) = {3.64632, 59.2474, 17.3521, 1.71809*lc};
Point(49) = {39.1442, 78.1346, 9.77163, 2.17658*lc};
Point(50) = {35.241, 78.0891, 14.6943, 3.14125*lc};
Point(51) = {28.3152, 37.9409, 16.3608, 1.48583*lc};
Point(52) = {24.2233, 39.7735, 13.3041, 2.07158*lc};
Point(53) = {29.2732, 40.5722, 17.3554, 1.48583*lc};
Point(54) = {9.60986, 64.7938, 15.1993, 1.92832*lc};
Point(55) = {14.1368, 50.0983, 15.4356, 1.25365*lc};
Point(56) = {38.4049, 62.9774, 15.2644, 2.57376*lc};
Point(57) = {13.6314, 64.3783, 18.4625, 2.59778*lc};
Point(58) = {31.8156, 49.5473, 13.0323, 3.22672*lc};
Point(59) = {5.51921, 62.0703, 17.9273, 1.71809*lc};
Point(60) = {39.4608, 73.0765, 15.8794, 2.62923*lc};
Point(61) = {40.4201, 78.1663, 14.971, 2.62923*lc};
Point(62) = {31.8303, 46.9699, 18.9487, 3.22672*lc};
Point(63) = {8.13025, 55.0729, 17.0434, 3.06706*lc};
Point(64) = {39.7607, 66.3855, 18.876, 2.57376*lc};
Point(65) = {37.0405, 55.0949, 17.6884, 2.21186*lc};
Point(66) = {31.3101, 74.2116, 26.1608, 2.93771*lc};
Point(67) = {18.5691, 45.6644, 29.4366, 2.65396*lc};
Point(68) = {20.3767, 62.7826, 22.0365, 2.24504*lc};
Point(69) = {35.2707, 78.2441, 24.5567, 2.93771*lc};
Point(70) = {42.2933, 78.1854, 22.9846, 3.59833*lc};
Point(71) = {13.9428, 50.1378, 24.8624, 3.24021*lc};
Point(72) = {27.4107, 69.4019, 20.8328, 2.05348*lc};
Point(73) = {8.61647, 54.4489, 31.8481, 1.99797*lc};
Point(74) = {41.9954, 71.2889, 25.1231, 3.6133*lc};
Point(75) = {27.1841, 37.7595, 24.6303, 0.927034*lc};
Point(76) = {30.5029, 42.1835, 23.57, 2.67008*lc};
Point(77) = {5.71835, 60.2702, 22.7492, 1.62305*lc};
Point(78) = {8.4608, 61.0365, 24.9231, 1.79123*lc};
Point(79) = {23.933, 65.5165, 21.8383, 2.24504*lc};
Point(80) = {29.8478, 39.8662, 28.8773, 2.26718*lc};
Point(81) = {38.5256, 53.5032, 21.5394, 2.21186*lc};
Point(82) = {40.9607, 58.0886, 22.7786, 2.66886*lc};
Point(83) = {6.06306, 57.1041, 23.377, 1.62305*lc};
Point(84) = {42.361, 63.9007, 26.0243, 3.40132*lc};
Point(85) = {26.6708, 65.4044, 29.499, 1.80532*lc};
Point(86) = {28.9011, 71.58, 17.6861, 2.05348*lc};
Point(87) = {7.29795, 57.5545, 29.707, 1.99797*lc};
Point(88) = {24.877, 62.3341, 28.8727, 1.80532*lc};
Point(89) = {42.3065, 3.13506, 26.8705, 1.81488*lc};
Point(90) = {46.1056, 52.6104, 29.4596, 2.32726*lc};
Point(91) = {36.2219, 4.99599, 27.3818, 2.20197*lc};
Point(92) = {41.4719, 9.32648, 26.0845, 2.31384*lc};
Point(93) = {45.1441, 57.8246, 29.9086, 2.66054*lc};
Point(94) = {42.86, 5.3921, 24.0822, 1.81488*lc};
Point(95) = {47.6298, 8.53693, 30.7253, 2.37743*lc};
Point(96) = {34.3116, 45.1333, 25.8743, 2.67008*lc};
Point(97) = {40.6631, 48.6854, 26.8306, 2.76704*lc};
Point(98) = {13.8286, 59.6794, 28.0708, 1.81345*lc};
Point(99) = {37.7411, 11.9929, 30.1829, 2.07526*lc};
Point(100) = {41.0847, 14.4386, 29.9267, 1.85084*lc};
Point(101) = {44.7109, 13.7593, 29.6238, 1.85084*lc};
Point(102) = {21.452, 59.7919, 27.6783, 2.21472*lc};
Point(103) = {38.5283, 1.58073, 29.4307, 2.30117*lc};
Point(104) = {46.2739, 5.5771, 34.1908, 2.37743*lc};
Point(105) = {33.882, 8.63214, 30.118, 2.32947*lc};
Point(106) = {41.35, 44.2637, 30.0868, 2.25072*lc};
Point(107) = {11.8272, 51.3426, 30.8681, 2.28682*lc};
Point(108) = {44.3834, 68.111, 31.6667, 3.17287*lc};
Point(109) = {44.8684, 78.2416, 31.5427, 3.37887*lc};
Point(110) = {34.0326, 3.49341, 30.8952, 2.20197*lc};
Point(111) = {25.5588, 38.4357, 24.0483, 0.927034*lc};
Point(112) = {34.6267, 41.2919, 30.9208, 2.69474*lc};
Point(113) = {10.4734, 57.8722, 32.6691, 2.17707*lc};
Point(114) = {28.6518, 71.1561, 34.7478, 1.71219*lc};
Point(115) = {38.0814, 16.5502, 36.9044, 2.69002*lc};
Point(116) = {45.6225, 25.3114, 32.4803, 2.10448*lc};
Point(117) = {42.1061, 23.0795, 33.0876, 2.10448*lc};
Point(118) = {21.9278, 42.207, 27.2141, 2.65396*lc};
Point(119) = {45.2773, 48.0591, 29.9735, 2.32726*lc};
Point(120) = {49.6311, 45.5027, 32.474, 2.38334*lc};
Point(121) = {49.0982, 51.7932, 33.1218, 2.39975*lc};
Point(122) = {15.3847, 57.237, 30.2543, 1.81345*lc};
Point(123) = {29.8531, 75.0956, 34.208, 2.07691*lc};
Point(124) = {40.6657, 2.44174, 35.7385, 3.30446*lc};
Point(125) = {48.3948, 15.8791, 34.6171, 2.65226*lc};
Point(126) = {48.7037, 21.3049, 34.7762, 2.12642*lc};
Point(127) = {46.5137, 62.5707, 34.5466, 3.29875*lc};
Point(128) = {33.884, 2.29957, 36.2228, 1.94519*lc};
Point(129) = {48.6083, 31.3503, 34.6483, 3.15456*lc};
Point(130) = {29.008, 32.8416, 37.4166, 1.76754*lc};
Point(131) = {27.7312, 36.1211, 30.3107, 1.42608*lc};
Point(132) = {31.3772, 33.6553, 34.9223, 1.76754*lc};
Point(133) = {38.9513, 34.5486, 34.5252, 2.02725*lc};
Point(134) = {43.6835, 40.7085, 31.5627, 2.25072*lc};
Point(135) = {42.4449, 32.7915, 33.4545, 2.02725*lc};
Point(136) = {48.8108, 37.5081, 33.2898, 3.14303*lc};
Point(137) = {11.5259, 51.9221, 39.8141, 1.88525*lc};
Point(138) = {10.9128, 54.4165, 37.0539, 1.88525*lc};
Point(139) = {25.518, 57.0832, 34.233, 1.51877*lc};
Point(140) = {49.583, 56.9339, 37.0825, 3.2538*lc};
Point(141) = {47.8455, 71.2158, 35.9844, 2.88229*lc};
Point(142) = {33.2083, 78.211, 31.798, 2.58705*lc};
Point(143) = {49.1414, 11.3052, 37.1978, 2.65226*lc};
Point(144) = {31.622, 6.51848, 33.6009, 2.32947*lc};
Point(145) = {38.1472, 27.9263, 36.6343, 2.56283*lc};
Point(146) = {53.572, 36.3515, 38.7356, 1.93914*lc};
Point(147) = {25.499, 34.8917, 31.5916, 1.42608*lc};
Point(148) = {51.9969, 47.1907, 36.2522, 2.38334*lc};
Point(149) = {13.2856, 47.3153, 39.357, 2.47629*lc};
Point(150) = {27.8983, 68.1875, 33.2161, 1.71219*lc};
Point(151) = {27.963, 68.6174, 39.8473, 1.79528*lc};
Point(152) = {28.4523, 77.9762, 40.7525, 2.86426*lc};
Point(153) = {49.8855, 78.2239, 36.0699, 3.35688*lc};
Point(154) = {51.4639, 21.5239, 38.0042, 2.12642*lc};
Point(155) = {54.473, 40.5924, 37.6391, 2.23603*lc};
Point(156) = {17.4486, 44.7211, 34.7879, 2.77406*lc};
Point(157) = {53.7075, 50.779, 39.5712, 2.5893*lc};
Point(158) = {15.0307, 56.113, 35.1214, 2.42744*lc};
Point(159) = {29.5933, 65.818, 36.6938, 2.12311*lc};
Point(160) = {52.7617, 72.7093, 38.598, 2.88229*lc};
Point(161) = {40.6845, 78.2468, 46.9963, 2.98256*lc};
Point(162) = {45.37, 6.97854, 39.2206, 2.64953*lc};
Point(163) = {53.7051, 33.5082, 41.3698, 1.93914*lc};
Point(164) = {33.8502, 30.672, 37.1532, 2.23566*lc};
Point(165) = {23.8879, 55.48, 36.2328, 1.51877*lc};
Point(166) = {29.2924, 56.4653, 36.4864, 2.21956*lc};
Point(167) = {32.9784, 63.5483, 37.8854, 1.64963*lc};
Point(168) = {51.5614, 66.9799, 38.6, 2.92689*lc};
Point(169) = {38.4028, 66.7347, 38.0686, 2.30379*lc};
Point(170) = {43.9049, 66.916, 38.1568, 2.70436*lc};
Point(171) = {34.8597, 3.71481, 39.7128, 1.94519*lc};
Point(172) = {33.1584, 10.6245, 43.0741, 1.58508*lc};
Point(173) = {49.0603, 16.6653, 41.5794, 3.24674*lc};
Point(174) = {53.3796, 26.7001, 41.3805, 1.78922*lc};
Point(175) = {36.2834, 22.6029, 41.8456, 3.10278*lc};
Point(176) = {24.9663, 33.1343, 37.7186, 2.03176*lc};
Point(177) = {19.1968, 38.9281, 40.1351, 1.72245*lc};
Point(178) = {33.4911, 57.1011, 37.829, 2.22688*lc};
Point(179) = {36.9426, 62.3696, 38.2769, 2.07711*lc};
Point(180) = {22.4206, 33.2002, 41.9922, 2.4874*lc};
Point(181) = {30.7481, 53.323, 41.3419, 2.28271*lc};
Point(182) = {54.8034, 56.965, 41.0778, 1.86931*lc};
Point(183) = {43.879, 60.5465, 38.0769, 2.02299*lc};
Point(184) = {47.1763, 62.046, 40.2069, 2.10105*lc};
Point(185) = {34.4724, 65.3991, 40.1718, 1.64963*lc};
Point(186) = {48.4675, 71.615, 40.6046, 3.08816*lc};
Point(187) = {29.5302, 66.9657, 42.6236, 1.79528*lc};
Point(188) = {36.3962, 70.8314, 40.7219, 2.05221*lc};
Point(189) = {42.2929, 71.5192, 40.4948, 2.6608*lc};
Point(190) = {25.6464, 73.2254, 42.2929, 2.854*lc};
Point(191) = {55.3331, 78.1217, 40.0115, 1.38103*lc};
Point(192) = {32.6845, 11.2354, 38.0551, 2.5391*lc};
Point(193) = {33.0596, 28.8143, 41.5046, 2.39848*lc};
Point(194) = {37.5582, 55.6426, 39.445, 2.30651*lc};
Point(195) = {55.6273, 63.2932, 41.0363, 2.93328*lc};
Point(196) = {57.9169, 74.2662, 42.6097, 1.80151*lc};
Point(197) = {40.4264, 5.96163, 42.5629, 3.02673*lc};
Point(198) = {44.2418, 12.6966, 47.2364, 2.32662*lc};
Point(199) = {52.928, 23.1638, 41.6902, 1.78922*lc};
Point(200) = {56.1152, 38.6189, 43.0036, 2.7306*lc};
Point(201) = {19.1032, 38.2155, 43.5042, 1.72245*lc};
Point(202) = {55.9496, 48.9746, 44.5549, 2.22945*lc};
Point(203) = {22.0438, 53.669, 40.2876, 1.79468*lc};
Point(204) = {31.3252, 69.0953, 46.2867, 1.98987*lc};
Point(205) = {38.2984, 72.8419, 43.7527, 2.05221*lc};
Point(206) = {53.4114, 78.0753, 41.9949, 1.38103*lc};
Point(207) = {45.4494, 78.2025, 41.7812, 0.893283*lc};
Point(208) = {46.7071, 18.0013, 47.954, 2.08136*lc};
Point(209) = {35.884, 14.9716, 41.5546, 2.67559*lc};
Point(210) = {15.0756, 44.2454, 42.8113, 2.13674*lc};
Point(211) = {24.3139, 52.0208, 42.5267, 1.79468*lc};
Point(212) = {43.8371, 56.8832, 39.794, 2.02299*lc};
Point(213) = {52.2757, 51.0931, 45.9319, 2.22945*lc};
Point(214) = {57.8488, 58.1832, 42.8719, 1.5028*lc};
Point(215) = {50.5358, 59.9272, 42.9541, 2.41468*lc};
Point(216) = {53.1972, 66.806, 42.2992, 2.49287*lc};
Point(217) = {44.2991, 76.9937, 42.4195, 0.893283*lc};
Point(218) = {57.0646, 77.605, 43.6622, 1.80151*lc};
Point(219) = {30.4184, 31.4449, 47.6064, 1.98643*lc};
Point(220) = {15.8496, 50.8384, 42.8708, 1.60384*lc};
Point(221) = {57.7059, 66.776, 44.4272, 2.49287*lc};
Point(222) = {34.6914, 8.59013, 44.9612, 1.58508*lc};
Point(223) = {37.5078, 24.3631, 47.9484, 1.11792*lc};
Point(224) = {35.7592, 25.578, 47.2662, 1.11792*lc};
Point(225) = {53.2106, 27.5169, 47.708, 3.19112*lc};
Point(226) = {27.0973, 50.2404, 46.489, 2.00923*lc};
Point(227) = {33.6951, 51.0722, 44.005, 2.28271*lc};
Point(228) = {54.4891, 56.3864, 44.9375, 1.29898*lc};
Point(229) = {57.3019, 58.3147, 45.8244, 1.5028*lc};
Point(230) = {37.3512, 15.2959, 47.2766, 2.42628*lc};
Point(231) = {22.2896, 36.2858, 47.6831, 2.79911*lc};
Point(232) = {18.6874, 40.7553, 46.9129, 2.13557*lc};
Point(233) = {14.8549, 48.2038, 44.4066, 1.60384*lc};
Point(234) = {19.983, 48.9191, 46.8646, 1.89916*lc};
Point(235) = {49.1302, 47.5524, 47.4298, 2.48367*lc};
Point(236) = {55.8172, 54.227, 44.3696, 1.29898*lc};
Point(237) = {57.2367, 61.8694, 46.2894, 1.79279*lc};
Point(238) = {22.633, 72.4487, 47.8177, 1.88536*lc};
Point(239) = {24.1797, 76.4413, 47.0444, 1.28597*lc};
Point(240) = {36.2067, 74.1787, 47.8056, 2.37635*lc};
Point(241) = {39.8935, 11.2265, 48.0005, 2.32662*lc};
Point(242) = {49.8021, 20.5209, 46.7704, 2.08136*lc};
Point(243) = {26.8476, 32.9568, 46.742, 1.98643*lc};
Point(244) = {55.8865, 44.8028, 47.9908, 2.70247*lc};
Point(245) = {44.7991, 49.7088, 45.0235, 2.70179*lc};
Point(246) = {24.3877, 69.1669, 47.2101, 1.78943*lc};
Point(247) = {26.0136, 78.0274, 47.9023, 1.28597*lc};
Point(248) = {53.837, 34.1048, 47.9139, 3.28628*lc};
Point(249) = {29.8652, 47.7337, 47.9733, 2.00923*lc};
Point(250) = {18.3626, 45.6597, 47.9499, 1.89916*lc};
Point(251) = {38.0962, 49.055, 46.5688, 2.73915*lc};
Point(252) = {27.7946, 68.3888, 47.982, 1.78943*lc};
Line (1) = {1, 3};
Line (2) = {3, 2};
Line (3) = {2, 1};
Line (6) = {5, 4};
Line (7) = {4, 3};
Line (8) = {3, 5};
Line (12) = {4, 2};
Line (16) = {4, 6};
Line (17) = {6, 2};
Line (21) = {22, 4};
Line (23) = {5, 22};
Line (26) = {4, 23};
Line (27) = {23, 6};
Line (31) = {4, 12};
Line (32) = {12, 7};
Line (33) = {7, 4};
Line (36) = {8, 4};
Line (38) = {22, 8};
Line (43) = {8, 12};
Line (46) = {9, 12};
Line (48) = {8, 9};
Line (51) = {9, 11};
Line (52) = {11, 12};
Line (57) = {4, 20};
Line (58) = {20, 23};
Line (61) = {11, 10};
Line (62) = {10, 12};
Line (66) = {4, 32};
Line (67) = {32, 20};
Line (72) = {7, 13};
Line (73) = {13, 4};
Line (77) = {13, 32};
Line (81) = {7, 15};
Line (82) = {15, 13};
Line (86) = {12, 14};
Line (87) = {14, 7};
Line (91) = {15, 18};
Line (92) = {18, 13};
Line (96) = {16, 15};
Line (98) = {7, 16};
Line (101) = {15, 17};
Line (102) = {17, 18};
Line (107) = {18, 19};
Line (108) = {19, 13};
Line (111) = {21, 12};
Line (113) = {10, 21};
Line (116) = {14, 16};
Line (122) = {22, 44};
Line (123) = {44, 8};
Line (126) = {24, 9};
Line (128) = {8, 24};
Line (132) = {20, 34};
Line (133) = {34, 23};
Line (136) = {28, 11};
Line (138) = {9, 28};
Line (141) = {46, 10};
Line (143) = {11, 46};
Line (147) = {32, 35};
Line (148) = {35, 20};
Line (152) = {13, 25};
Line (153) = {25, 32};
Line (156) = {37, 18};
Line (158) = {17, 37};
Line (161) = {26, 5};
Line (163) = {3, 26};
Line (166) = {26, 27};
Line (167) = {27, 5};
Line (172) = {27, 22};
Line (178) = {34, 6};
Line (183) = {24, 28};
Line (188) = {35, 34};
Line (191) = {21, 14};
Line (198) = {21, 16};
Line (201) = {16, 36};
Line (202) = {36, 15};
Line (206) = {15, 37};
Line (212) = {19, 29};
Line (213) = {29, 13};
Line (216) = {18, 33};
Line (217) = {33, 19};
Line (221) = {52, 3};
Line (223) = {1, 52};
Line (227) = {1, 30};
Line (228) = {30, 52};
Line (231) = {52, 26};
Line (237) = {6, 31};
Line (238) = {31, 2};
Line (241) = {44, 24};
Line (246) = {28, 46};
Line (251) = {37, 33};
Line (257) = {19, 49};
Line (258) = {49, 29};
Line (263) = {31, 1};
Line (266) = {27, 44};
Line (271) = {40, 36};
Line (273) = {16, 40};
Line (276) = {36, 37};
Line (281) = {33, 49};
Line (287) = {6, 41};
Line (288) = {41, 31};
Line (292) = {26, 38};
Line (293) = {38, 27};
Line (297) = {34, 41};
Line (302) = {32, 42};
Line (303) = {42, 35};
Line (306) = {46, 54};
Line (307) = {54, 10};
Line (313) = {21, 40};
Line (318) = {25, 42};
Line (323) = {29, 25};
Line (328) = {31, 30};
Line (333) = {42, 34};
Line (336) = {54, 21};
Line (341) = {45, 37};
Line (343) = {36, 45};
Line (347) = {34, 58};
Line (348) = {58, 41};
Line (351) = {39, 27};
Line (353) = {38, 39};
Line (356) = {39, 44};
Line (361) = {43, 40};
Line (363) = {21, 43};
Line (366) = {43, 36};
Line (371) = {56, 42};
Line (373) = {25, 56};
Line (376) = {50, 33};
Line (378) = {37, 50};
Line (383) = {42, 58};
Line (386) = {43, 47};
Line (387) = {47, 36};
Line (391) = {50, 49};
Line (396) = {48, 46};
Line (398) = {28, 48};
Line (402) = {29, 56};
Line (407) = {31, 51};
Line (408) = {51, 30};
Line (412) = {41, 53};
Line (413) = {53, 31};
Line (417) = {38, 55};
Line (418) = {55, 39};
Line (422) = {39, 63};
Line (423) = {63, 44};
Line (426) = {42, 65};
Line (427) = {65, 58};
Line (433) = {24, 48};
Line (438) = {56, 65};
Line (441) = {59, 54};
Line (443) = {46, 59};
Line (446) = {54, 43};
Line (452) = {49, 56};
Line (458) = {45, 50};
Line (463) = {44, 48};
Line (466) = {57, 47};
Line (468) = {43, 57};
Line (471) = {47, 72};
Line (472) = {72, 36};
Line (477) = {49, 60};
Line (478) = {60, 56};
Line (481) = {86, 50};
Line (483) = {45, 86};
Line (488) = {53, 51};
Line (493) = {63, 48};
Line (496) = {54, 57};
Line (501) = {72, 45};
Line (506) = {72, 86};
Line (512) = {49, 61};
Line (513) = {61, 60};
Line (518) = {51, 52};
Line (521) = {52, 118};
Line (522) = {118, 26};
Line (527) = {41, 62};
Line (528) = {62, 53};
Line (532) = {26, 67};
Line (533) = {67, 38};
Line (536) = {62, 58};
Line (538) = {65, 62};
Line (541) = {48, 59};
Line (546) = {57, 68};
Line (547) = {68, 47};
Line (552) = {60, 64};
Line (553) = {64, 56};
Line (561) = {50, 69};
Line (562) = {69, 49};
Line (566) = {69, 61};
Line (571) = {59, 57};
Line (576) = {68, 72};
Line (581) = {66, 69};
Line (583) = {50, 66};
Line (588) = {118, 67};
Line (591) = {71, 39};
Line (593) = {55, 71};
Line (597) = {65, 81};
Line (598) = {81, 62};
Line (601) = {83, 48};
Line (603) = {63, 83};
Line (606) = {77, 59};
Line (608) = {48, 77};
Line (612) = {61, 70};
Line (613) = {70, 60};
Line (616) = {76, 53};
Line (618) = {62, 76};
Line (622) = {56, 82};
Line (623) = {82, 65};
Line (626) = {83, 77};
Line (632) = {64, 82};
Line (636) = {77, 78};
Line (637) = {78, 59};
Line (641) = {78, 57};
Line (646) = {79, 72};
Line (648) = {68, 79};
Line (653) = {86, 66};
Line (656) = {75, 52};
Line (658) = {51, 75};
Line (661) = {75, 111};
Line (662) = {111, 52};
Line (668) = {111, 118};
Line (673) = {76, 51};
Line (676) = {38, 71};
Line (681) = {71, 107};
Line (682) = {107, 39};
Line (686) = {73, 83};
Line (688) = {63, 73};
Line (691) = {78, 68};
Line (697) = {64, 74};
Line (698) = {74, 82};
Line (702) = {60, 74};
Line (708) = {70, 74};
Line (713) = {67, 71};
Line (717) = {82, 81};
Line (721) = {69, 70};
Line (727) = {51, 80};
Line (728) = {80, 75};
Line (733) = {76, 80};
Line (736) = {96, 76};
Line (738) = {62, 96};
Line (742) = {81, 96};
Line (746) = {102, 79};
Line (748) = {68, 102};
Line (752) = {74, 84};
Line (753) = {84, 82};
Line (757) = {81, 97};
Line (758) = {97, 96};
Line (761) = {107, 63};
Line (766) = {107, 73};
Line (771) = {83, 87};
Line (772) = {87, 77};
Line (776) = {85, 72};
Line (778) = {79, 85};
Line (781) = {91, 94};
Line (782) = {94, 89};
Line (783) = {89, 91};
Line (786) = {91, 92};
Line (787) = {92, 94};
Line (791) = {81, 90};
Line (792) = {90, 97};
Line (798) = {78, 102};
Line (801) = {88, 79};
Line (803) = {102, 88};
Line (806) = {88, 85};
Line (812) = {92, 101};
Line (813) = {101, 94};
Line (818) = {96, 80};
Line (821) = {73, 87};
Line (827) = {82, 90};
Line (831) = {82, 93};
Line (832) = {93, 90};
Line (837) = {84, 93};
Line (841) = {98, 102};
Line (843) = {78, 98};
Line (846) = {95, 94};
Line (848) = {101, 95};
Line (851) = {131, 75};
Line (853) = {80, 131};
Line (857) = {90, 119};
Line (858) = {119, 97};
Line (861) = {87, 78};
Line (866) = {150, 86};
Line (868) = {72, 150};
Line (872) = {86, 114};
Line (873) = {114, 66};
Line (876) = {142, 69};
Line (878) = {66, 142};
Line (881) = {103, 91};
Line (883) = {89, 103};
Line (888) = {95, 89};
Line (891) = {105, 92};
Line (893) = {91, 105};
Line (896) = {105, 99};
Line (897) = {99, 92};
Line (901) = {99, 100};
Line (902) = {100, 92};
Line (906) = {100, 101};
Line (913) = {131, 111};
Line (916) = {112, 80};
Line (918) = {96, 112};
Line (922) = {97, 106};
Line (923) = {106, 96};
Line (926) = {122, 102};
Line (928) = {98, 122};
Line (931) = {87, 113};
Line (932) = {113, 78};
Line (937) = {70, 109};
Line (938) = {109, 74};
Line (941) = {110, 91};
Line (943) = {103, 110};
Line (947) = {95, 104};
Line (948) = {104, 89};
Line (951) = {147, 111};
Line (953) = {131, 147};
Line (956) = {156, 67};
Line (958) = {118, 156};
Line (963) = {106, 112};
Line (968) = {119, 106};
Line (971) = {113, 122};
Line (973) = {98, 113};
Line (982) = {84, 108};
Line (983) = {108, 93};
Line (988) = {85, 150};
Line (993) = {74, 108};
Line (998) = {109, 108};
Line (1001) = {110, 144};
Line (1002) = {144, 91};
Line (1006) = {144, 105};
Line (1013) = {112, 131};
Line (1017) = {106, 134};
Line (1018) = {134, 112};
Line (1023) = {156, 71};
Line (1028) = {150, 114};
Line (1031) = {69, 109};
Line (1037) = {89, 124};
Line (1038) = {124, 103};
Line (1041) = {115, 100};
Line (1043) = {99, 115};
Line (1046) = {100, 116};
Line (1047) = {116, 101};
Line (1051) = {100, 117};
Line (1052) = {117, 116};
Line (1056) = {156, 107};
Line (1062) = {90, 120};
Line (1063) = {120, 119};
Line (1066) = {122, 139};
Line (1067) = {139, 102};
Line (1071) = {139, 88};
Line (1076) = {123, 142};
Line (1078) = {66, 123};
Line (1083) = {104, 124};
Line (1086) = {101, 125};
Line (1087) = {125, 95};
Line (1091) = {101, 126};
Line (1092) = {126, 125};
Line (1097) = {134, 133};
Line (1098) = {133, 112};
Line (1101) = {135, 134};
Line (1102) = {134, 136};
Line (1103) = {136, 135};
Line (1106) = {147, 118};
Line (1112) = {106, 136};
Line (1118) = {120, 106};
Line (1122) = {90, 121};
Line (1123) = {121, 120};
Line (1126) = {165, 139};
Line (1128) = {122, 165};
Line (1131) = {93, 127};
Line (1132) = {127, 90};
Line (1138) = {108, 127};
Line (1141) = {114, 123};
Line (1147) = {103, 128};
Line (1148) = {128, 110};
Line (1151) = {128, 144};
Line (1156) = {209, 99};
Line (1158) = {105, 209};
Line (1161) = {209, 115};
Line (1166) = {115, 117};
Line (1173) = {116, 126};
Line (1176) = {117, 135};
Line (1177) = {135, 116};
Line (1182) = {136, 116};
Line (1187) = {136, 129};
Line (1188) = {129, 116};
Line (1191) = {130, 147};
Line (1193) = {131, 130};
Line (1198) = {135, 133};
Line (1201) = {132, 131};
Line (1203) = {112, 132};
Line (1206) = {177, 118};
Line (1208) = {147, 177};
Line (1213) = {120, 136};
Line (1217) = {121, 148};
Line (1218) = {148, 120};
Line (1221) = {138, 113};
Line (1223) = {87, 138};
Line (1226) = {158, 122};
Line (1228) = {113, 158};
Line (1233) = {158, 165};
Line (1238) = {127, 121};
Line (1241) = {88, 166};
Line (1242) = {166, 85};
Line (1246) = {109, 141};
Line (1247) = {141, 108};
Line (1253) = {124, 128};
Line (1256) = {143, 95};
Line (1258) = {125, 143};
Line (1263) = {129, 126};
Line (1266) = {176, 147};
Line (1268) = {130, 176};
Line (1273) = {132, 130};
Line (1278) = {133, 132};
Line (1281) = {177, 156};
Line (1287) = {120, 155};
Line (1288) = {155, 136};
Line (1291) = {149, 107};
Line (1293) = {156, 149};
Line (1296) = {137, 138};
Line (1297) = {138, 73};
Line (1298) = {73, 137};
Line (1307) = {127, 140};
Line (1308) = {140, 121};
Line (1313) = {166, 150};
Line (1318) = {141, 127};
Line (1323) = {143, 104};
Line (1326) = {117, 145};
Line (1327) = {145, 135};
Line (1333) = {145, 133};
Line (1336) = {164, 133};
Line (1338) = {145, 164};
Line (1341) = {164, 132};
Line (1347) = {136, 146};
Line (1348) = {146, 129};
Line (1353) = {148, 155};
Line (1356) = {149, 73};
Line (1363) = {139, 166};
Line (1366) = {123, 152};
Line (1367) = {152, 142};
Line (1371) = {161, 153};
Line (1372) = {153, 109};
Line (1373) = {109, 161};
Line (1376) = {144, 192};
Line (1377) = {192, 105};
Line (1383) = {192, 209};
Line (1387) = {126, 154};
Line (1388) = {154, 125};
Line (1393) = {164, 130};
Line (1396) = {180, 177};
Line (1398) = {147, 180};
Line (1401) = {157, 148};
Line (1403) = {121, 157};
Line (1407) = {140, 157};
Line (1411) = {138, 158};
Line (1416) = {165, 166};
Line (1421) = {166, 159};
Line (1422) = {159, 150};
Line (1428) = {141, 140};
Line (1431) = {141, 168};
Line (1432) = {168, 140};
Line (1436) = {159, 151};
Line (1437) = {151, 150};
Line (1441) = {151, 114};
Line (1446) = {141, 153};
Line (1447) = {153, 160};
Line (1448) = {160, 141};
Line (1456) = {161, 69};
Line (1458) = {142, 161};
Line (1462) = {124, 171};
Line (1463) = {171, 128};
Line (1467) = {143, 162};
Line (1468) = {162, 104};
Line (1472) = {125, 173};
Line (1473) = {173, 143};
Line (1476) = {115, 145};
Line (1483) = {129, 154};
Line (1486) = {129, 163};
Line (1487) = {163, 154};
Line (1493) = {146, 163};
Line (1498) = {176, 180};
Line (1503) = {155, 146};
Line (1506) = {138, 165};
Line (1511) = {178, 159};
Line (1513) = {166, 178};
Line (1516) = {178, 167};
Line (1517) = {167, 159};
Line (1521) = {179, 183};
Line (1522) = {183, 169};
Line (1523) = {169, 179};
Line (1526) = {183, 170};
Line (1527) = {170, 169};
Line (1533) = {160, 168};
Line (1541) = {172, 144};
Line (1543) = {128, 172};
Line (1546) = {172, 192};
Line (1551) = {154, 174};
Line (1552) = {174, 199};
Line (1553) = {199, 154};
Line (1556) = {175, 193};
Line (1557) = {193, 145};
Line (1558) = {145, 175};
Line (1563) = {193, 164};
Line (1568) = {149, 137};
Line (1571) = {138, 203};
Line (1572) = {203, 165};
Line (1576) = {165, 181};
Line (1577) = {181, 166};
Line (1581) = {181, 178};
Line (1586) = {212, 183};
Line (1587) = {183, 194};
Line (1588) = {194, 212};
Line (1591) = {194, 167};
Line (1593) = {178, 194};
Line (1597) = {194, 179};
Line (1598) = {179, 167};
Line (1606) = {153, 191};
Line (1607) = {191, 160};
Line (1612) = {124, 197};
Line (1613) = {197, 171};
Line (1616) = {171, 172};
Line (1622) = {124, 162};
Line (1623) = {162, 197};
Line (1632) = {163, 174};
Line (1637) = {156, 210};
Line (1638) = {210, 149};
Line (1641) = {182, 157};
Line (1643) = {140, 182};
Line (1647) = {168, 182};
Line (1651) = {184, 170};
Line (1653) = {183, 184};
Line (1656) = {185, 167};
Line (1658) = {179, 185};
Line (1661) = {167, 187};
Line (1662) = {187, 159};
Line (1667) = {184, 186};
Line (1668) = {186, 170};
Line (1671) = {179, 188};
Line (1672) = {188, 185};
Line (1677) = {169, 188};
Line (1683) = {187, 151};
Line (1686) = {169, 189};
Line (1687) = {189, 188};
Line (1692) = {170, 189};
Line (1697) = {186, 189};
Line (1702) = {160, 195};
Line (1703) = {195, 168};
Line (1706) = {151, 190};
Line (1707) = {190, 114};
Line (1712) = {190, 123};
Line (1718) = {154, 173};
Line (1723) = {115, 175};
Line (1727) = {199, 173};
Line (1733) = {193, 130};
Line (1736) = {201, 177};
Line (1738) = {180, 201};
Line (1742) = {155, 200};
Line (1743) = {200, 146};
Line (1748) = {177, 210};
Line (1753) = {157, 155};
Line (1756) = {137, 220};
Line (1757) = {220, 138};
Line (1761) = {220, 203};
Line (1766) = {203, 181};
Line (1773) = {181, 194};
Line (1777) = {212, 184};
Line (1783) = {195, 182};
Line (1788) = {185, 187};
Line (1792) = {160, 196};
Line (1793) = {196, 195};
Line (1796) = {190, 152};
Line (1801) = {207, 153};
Line (1803) = {161, 207};
Line (1806) = {207, 206};
Line (1807) = {206, 191};
Line (1808) = {191, 207};
Line (1816) = {222, 172};
Line (1818) = {171, 222};
Line (1822) = {143, 198};
Line (1823) = {198, 162};
Line (1828) = {173, 198};
Line (1832) = {176, 243};
Line (1833) = {243, 180};
Line (1837) = {130, 243};
Line (1843) = {200, 163};
Line (1847) = {155, 202};
Line (1848) = {202, 200};
Line (1853) = {157, 202};
Line (1856) = {211, 181};
Line (1858) = {203, 211};
Line (1861) = {212, 215};
Line (1862) = {215, 184};
Line (1867) = {195, 214};
Line (1868) = {214, 182};
Line (1871) = {215, 216};
Line (1872) = {216, 184};
Line (1877) = {185, 204};
Line (1878) = {204, 187};
Line (1882) = {196, 214};
Line (1887) = {216, 186};
Line (1893) = {188, 204};
Line (1897) = {216, 206};
Line (1898) = {206, 186};
Line (1902) = {186, 217};
Line (1903) = {217, 189};
Line (1907) = {206, 217};
Line (1912) = {191, 196};
Line (1918) = {207, 217};
Line (1922) = {197, 222};
Line (1927) = {198, 197};
Line (1931) = {172, 209};
Line (1937) = {173, 208};
Line (1938) = {208, 198};
Line (1941) = {209, 175};
Line (1948) = {193, 243};
Line (1953) = {201, 210};
Line (1956) = {149, 233};
Line (1957) = {233, 137};
Line (1961) = {233, 220};
Line (1968) = {220, 211};
Line (1971) = {227, 194};
Line (1973) = {181, 227};
Line (1976) = {236, 182};
Line (1978) = {214, 236};
Line (1981) = {205, 188};
Line (1983) = {189, 205};
Line (1988) = {217, 205};
Line (1991) = {216, 218};
Line (1992) = {218, 206};
Line (1997) = {191, 218};
Line (1998) = {218, 196};
Line (2008) = {210, 233};
Line (2012) = {157, 236};
Line (2013) = {236, 202};
Line (2016) = {211, 227};
Line (2021) = {227, 245};
Line (2022) = {245, 194};
Line (2026) = {245, 213};
Line (2027) = {213, 212};
Line (2028) = {212, 245};
Line (2041) = {237, 216};
Line (2043) = {215, 237};
Line (2046) = {221, 218};
Line (2048) = {216, 221};
Line (2051) = {221, 214};
Line (2053) = {196, 221};
Line (2056) = {230, 223};
Line (2057) = {223, 209};
Line (2058) = {209, 230};
Line (2061) = {223, 175};
Line (2066) = {242, 173};
Line (2068) = {199, 242};
Line (2071) = {224, 193};
Line (2073) = {175, 224};
Line (2077) = {174, 225};
Line (2078) = {225, 199};
Line (2081) = {219, 193};
Line (2083) = {224, 219};
Line (2087) = {201, 232};
Line (2088) = {232, 210};
Line (2092) = {202, 244};
Line (2093) = {244, 200};
Line (2096) = {234, 211};
Line (2098) = {220, 234};
Line (2101) = {234, 226};
Line (2102) = {226, 211};
Line (2106) = {213, 228};
Line (2107) = {228, 215};
Line (2108) = {215, 213};
Line (2116) = {236, 229};
Line (2117) = {229, 228};
Line (2118) = {228, 236};
Line (2122) = {214, 229};
Line (2126) = {228, 237};
Line (2131) = {237, 221};
Line (2136) = {252, 187};
Line (2138) = {204, 252};
Line (2141) = {246, 151};
Line (2143) = {187, 246};
Line (2153) = {161, 217};
Line (2156) = {152, 247};
Line (2157) = {247, 142};
Line (2162) = {197, 241};
Line (2163) = {241, 222};
Line (2168) = {172, 230};
Line (2173) = {242, 208};
Line (2176) = {223, 224};
Line (2182) = {163, 225};
Line (2188) = {219, 243};
Line (2191) = {231, 201};
Line (2193) = {180, 231};
Line (2198) = {233, 234};
Line (2201) = {245, 235};
Line (2202) = {235, 213};
Line (2207) = {236, 213};
Line (2208) = {213, 202};
Line (2211) = {226, 227};
Line (2222) = {229, 237};
Line (2227) = {214, 237};
Line (2236) = {246, 238};
Line (2237) = {238, 151};
Line (2241) = {238, 190};
Line (2246) = {238, 239};
Line (2247) = {239, 190};
Line (2252) = {217, 240};
Line (2253) = {240, 205};
Line (2258) = {161, 240};
Line (2261) = {239, 152};
Line (2266) = {239, 247};
Line (2273) = {198, 241};
Line (2276) = {222, 230};
Line (2283) = {225, 242};
Line (2287) = {163, 248};
Line (2288) = {248, 225};
Line (2293) = {200, 248};
Line (2296) = {231, 232};
Line (2303) = {244, 248};
Line (2306) = {232, 250};
Line (2307) = {250, 210};
Line (2311) = {250, 233};
Line (2316) = {234, 249};
Line (2317) = {249, 226};
Line (2321) = {249, 251};
Line (2322) = {251, 227};
Line (2323) = {227, 249};
Line (2328) = {213, 244};
Line (2331) = {251, 245};
Line (2338) = {205, 204};
Line (2341) = {247, 161};
Line (2346) = {241, 230};
Line (2353) = {208, 241};
Line (2357) = {241, 223};
Line (2362) = {208, 223};
Line (2368) = {225, 208};
Line (2371) = {208, 248};
Line (2372) = {248, 223};
Line (2378) = {244, 223};
Line (2382) = {223, 219};
Line (2393) = {243, 231};
Line (2397) = {219, 231};
Line (2402) = {223, 249};
Line (2403) = {249, 219};
Line (2407) = {249, 231};
Line (2412) = {231, 250};
Line (2417) = {249, 250};
Line (2422) = {244, 249};
Line (2426) = {244, 235};
Line (2427) = {235, 249};
Line (2432) = {235, 251};
Line (2436) = {250, 234};
Line (2463) = {252, 246};
Line (2467) = {204, 240};
Line (2468) = {240, 252};
Line (2472) = {252, 238};
Line (2476) = {252, 247};
Line (2477) = {247, 238};
Line (2482) = {240, 247};
Line Loop (1000005) = {1, 2, 3};
Surface (5) = {1000005};
Line Loop (1000010) = {6, 7, 8};
Surface (10) = {1000010};
Line Loop (1000015) = {-7, 12, -2};
Surface (15) = {1000015};
Line Loop (1000020) = {16, 17, -12};
Surface (20) = {1000020};
Line Loop (1000025) = {21, -6, 23};
Surface (25) = {1000025};
Line Loop (1000030) = {26, 27, -16};
Surface (30) = {1000030};
Line Loop (1000035) = {31, 32, 33};
Surface (35) = {1000035};
Line Loop (1000040) = {36, -21, 38};
Surface (40) = {1000040};
Line Loop (1000045) = {-31, -36, 43};
Surface (45) = {1000045};
Line Loop (1000050) = {46, -43, 48};
Surface (50) = {1000050};
Line Loop (1000055) = {51, 52, -46};
Surface (55) = {1000055};
Line Loop (1000060) = {-26, 57, 58};
Surface (60) = {1000060};
Line Loop (1000065) = {61, 62, -52};
Surface (65) = {1000065};
Line Loop (1000070) = {66, 67, -57};
Surface (70) = {1000070};
Line Loop (1000075) = {-33, 72, 73};
Surface (75) = {1000075};
Line Loop (1000080) = {-73, 77, -66};
Surface (80) = {1000080};
Line Loop (1000085) = {81, 82, -72};
Surface (85) = {1000085};
Line Loop (1000090) = {86, 87, -32};
Surface (90) = {1000090};
Line Loop (1000095) = {91, 92, -82};
Surface (95) = {1000095};
Line Loop (1000100) = {96, -81, 98};
Surface (100) = {1000100};
Line Loop (1000105) = {101, 102, -91};
Surface (105) = {1000105};
Line Loop (1000110) = {-92, 107, 108};
Surface (110) = {1000110};
Line Loop (1000115) = {111, -62, 113};
Surface (115) = {1000115};
Line Loop (1000120) = {116, -98, -87};
Surface (120) = {1000120};
Line Loop (1000125) = {-38, 122, 123};
Surface (125) = {1000125};
Line Loop (1000130) = {126, -48, 128};
Surface (130) = {1000130};
Line Loop (1000135) = {-58, 132, 133};
Surface (135) = {1000135};
Line Loop (1000140) = {136, -51, 138};
Surface (140) = {1000140};
Line Loop (1000145) = {141, -61, 143};
Surface (145) = {1000145};
Line Loop (1000150) = {-67, 147, 148};
Surface (150) = {1000150};
Line Loop (1000155) = {-77, 152, 153};
Surface (155) = {1000155};
Line Loop (1000160) = {156, -102, 158};
Surface (160) = {1000160};
Line Loop (1000165) = {161, -8, 163};
Surface (165) = {1000165};
Line Loop (1000170) = {166, 167, -161};
Surface (170) = {1000170};
Line Loop (1000175) = {-167, 172, -23};
Surface (175) = {1000175};
Line Loop (1000180) = {-27, -133, 178};
Surface (180) = {1000180};
Line Loop (1000185) = {-138, -126, 183};
Surface (185) = {1000185};
Line Loop (1000190) = {-132, -148, 188};
Surface (190) = {1000190};
Line Loop (1000195) = {191, -86, -111};
Surface (195) = {1000195};
Line Loop (1000200) = {-116, -191, 198};
Surface (200) = {1000200};
Line Loop (1000205) = {201, 202, -96};
Surface (205) = {1000205};
Line Loop (1000210) = {206, -158, -101};
Surface (210) = {1000210};
Line Loop (1000215) = {-108, 212, 213};
Surface (215) = {1000215};
Line Loop (1000220) = {216, 217, -107};
Surface (220) = {1000220};
Line Loop (1000225) = {221, -1, 223};
Surface (225) = {1000225};
Line Loop (1000230) = {-223, 227, 228};
Surface (230) = {1000230};
Line Loop (1000235) = {231, -163, -221};
Surface (235) = {1000235};
Line Loop (1000240) = {-17, 237, 238};
Surface (240) = {1000240};
Line Loop (1000245) = {241, -128, -123};
Surface (245) = {1000245};
Line Loop (1000250) = {246, -143, -136};
Surface (250) = {1000250};
Line Loop (1000255) = {251, -216, -156};
Surface (255) = {1000255};
Line Loop (1000260) = {-212, 257, 258};
Surface (260) = {1000260};
Line Loop (1000265) = {-3, -238, 263};
Surface (265) = {1000265};
Line Loop (1000270) = {266, -122, -172};
Surface (270) = {1000270};
Line Loop (1000275) = {271, -201, 273};
Surface (275) = {1000275};
Line Loop (1000280) = {276, -206, -202};
Surface (280) = {1000280};
Line Loop (1000285) = {281, -257, -217};
Surface (285) = {1000285};
Line Loop (1000290) = {-237, 287, 288};
Surface (290) = {1000290};
Line Loop (1000295) = {-166, 292, 293};
Surface (295) = {1000295};
Line Loop (1000300) = {-178, 297, -287};
Surface (300) = {1000300};
Line Loop (1000305) = {-147, 302, 303};
Surface (305) = {1000305};
Line Loop (1000310) = {306, 307, -141};
Surface (310) = {1000310};
Line Loop (1000315) = {-273, -198, 313};
Surface (315) = {1000315};
Line Loop (1000320) = {-302, -153, 318};
Surface (320) = {1000320};
Line Loop (1000325) = {-152, -213, 323};
Surface (325) = {1000325};
Line Loop (1000330) = {-227, -263, 328};
Surface (330) = {1000330};
Line Loop (1000335) = {-188, -303, 333};
Surface (335) = {1000335};
Line Loop (1000340) = {336, -113, -307};
Surface (340) = {1000340};
Line Loop (1000345) = {341, -276, 343};
Surface (345) = {1000345};
Line Loop (1000350) = {-297, 347, 348};
Surface (350) = {1000350};
Line Loop (1000355) = {351, -293, 353};
Surface (355) = {1000355};
Line Loop (1000360) = {356, -266, -351};
Surface (360) = {1000360};
Line Loop (1000365) = {361, -313, 363};
Surface (365) = {1000365};
Line Loop (1000370) = {366, -271, -361};
Surface (370) = {1000370};
Line Loop (1000375) = {371, -318, 373};
Surface (375) = {1000375};
Line Loop (1000380) = {376, -251, 378};
Surface (380) = {1000380};
Line Loop (1000385) = {-347, -333, 383};
Surface (385) = {1000385};
Line Loop (1000390) = {386, 387, -366};
Surface (390) = {1000390};
Line Loop (1000395) = {391, -281, -376};
Surface (395) = {1000395};
Line Loop (1000400) = {396, -246, 398};
Surface (400) = {1000400};
Line Loop (1000405) = {-323, 402, -373};
Surface (405) = {1000405};
Line Loop (1000410) = {-328, 407, 408};
Surface (410) = {1000410};
Line Loop (1000415) = {-288, 412, 413};
Surface (415) = {1000415};
Line Loop (1000420) = {-353, 417, 418};
Surface (420) = {1000420};
Line Loop (1000425) = {-356, 422, 423};
Surface (425) = {1000425};
Line Loop (1000430) = {426, 427, -383};
Surface (430) = {1000430};
Line Loop (1000435) = {-398, -183, 433};
Surface (435) = {1000435};
Line Loop (1000440) = {-426, -371, 438};
Surface (440) = {1000440};
Line Loop (1000445) = {441, -306, 443};
Surface (445) = {1000445};
Line Loop (1000450) = {446, -363, -336};
Surface (450) = {1000450};
Line Loop (1000455) = {-258, 452, -402};
Surface (455) = {1000455};
Line Loop (1000460) = {-378, -341, 458};
Surface (460) = {1000460};
Line Loop (1000465) = {-433, -241, 463};
Surface (465) = {1000465};
Line Loop (1000470) = {466, -386, 468};
Surface (470) = {1000470};
Line Loop (1000475) = {471, 472, -387};
Surface (475) = {1000475};
Line Loop (1000480) = {-452, 477, 478};
Surface (480) = {1000480};
Line Loop (1000485) = {481, -458, 483};
Surface (485) = {1000485};
Line Loop (1000490) = {-407, -413, 488};
Surface (490) = {1000490};
Line Loop (1000495) = {-463, -423, 493};
Surface (495) = {1000495};
Line Loop (1000500) = {496, -468, -446};
Surface (500) = {1000500};
Line Loop (1000505) = {501, -343, -472};
Surface (505) = {1000505};
Line Loop (1000510) = {506, -483, -501};
Surface (510) = {1000510};
Line Loop (1000515) = {-477, 512, 513};
Surface (515) = {1000515};
Line Loop (1000520) = {-228, -408, 518};
Surface (520) = {1000520};
Line Loop (1000525) = {521, 522, -231};
Surface (525) = {1000525};
Line Loop (1000530) = {-412, 527, 528};
Surface (530) = {1000530};
Line Loop (1000535) = {-292, 532, 533};
Surface (535) = {1000535};
Line Loop (1000540) = {536, -427, 538};
Surface (540) = {1000540};
Line Loop (1000545) = {541, -443, -396};
Surface (545) = {1000545};
Line Loop (1000550) = {546, 547, -466};
Surface (550) = {1000550};
Line Loop (1000555) = {-478, 552, 553};
Surface (555) = {1000555};
Line Loop (1000560) = {-527, -348, -536};
Surface (560) = {1000560};
Line Loop (1000565) = {561, 562, -391};
Surface (565) = {1000565};
Line Loop (1000570) = {566, -512, -562};
Surface (570) = {1000570};
Line Loop (1000575) = {571, -496, -441};
Surface (575) = {1000575};
Line Loop (1000580) = {576, -471, -547};
Surface (580) = {1000580};
Line Loop (1000585) = {581, -561, 583};
Surface (585) = {1000585};
Line Loop (1000590) = {-532, -522, 588};
Surface (590) = {1000590};
Line Loop (1000595) = {591, -418, 593};
Surface (595) = {1000595};
Line Loop (1000600) = {-538, 597, 598};
Surface (600) = {1000600};
Line Loop (1000605) = {601, -493, 603};
Surface (605) = {1000605};
Line Loop (1000610) = {606, -541, 608};
Surface (610) = {1000610};
Line Loop (1000615) = {-513, 612, 613};
Surface (615) = {1000615};
Line Loop (1000620) = {616, -528, 618};
Surface (620) = {1000620};
Line Loop (1000625) = {-438, 622, 623};
Surface (625) = {1000625};
Line Loop (1000630) = {626, -608, -601};
Surface (630) = {1000630};
Line Loop (1000635) = {-553, 632, -622};
Surface (635) = {1000635};
Line Loop (1000640) = {636, 637, -606};
Surface (640) = {1000640};
Line Loop (1000645) = {641, -571, -637};
Surface (645) = {1000645};
Line Loop (1000650) = {646, -576, 648};
Surface (650) = {1000650};
Line Loop (1000655) = {-583, -481, 653};
Surface (655) = {1000655};
Line Loop (1000660) = {656, -518, 658};
Surface (660) = {1000660};
Line Loop (1000665) = {661, 662, -656};
Surface (665) = {1000665};
Line Loop (1000670) = {-521, -662, 668};
Surface (670) = {1000670};
Line Loop (1000675) = {-488, -616, 673};
Surface (675) = {1000675};
Line Loop (1000680) = {676, -593, -417};
Surface (680) = {1000680};
Line Loop (1000685) = {681, 682, -591};
Surface (685) = {1000685};
Line Loop (1000690) = {686, -603, 688};
Surface (690) = {1000690};
Line Loop (1000695) = {691, -546, -641};
Surface (695) = {1000695};
Line Loop (1000700) = {-632, 697, 698};
Surface (700) = {1000700};
Line Loop (1000705) = {-552, 702, -697};
Surface (705) = {1000705};
Line Loop (1000710) = {-702, -613, 708};
Surface (710) = {1000710};
Line Loop (1000715) = {-676, -533, 713};
Surface (715) = {1000715};
Line Loop (1000720) = {-623, 717, -597};
Surface (720) = {1000720};
Line Loop (1000725) = {721, -612, -566};
Surface (725) = {1000725};
Line Loop (1000730) = {-658, 727, 728};
Surface (730) = {1000730};
Line Loop (1000735) = {-727, -673, 733};
Surface (735) = {1000735};
Line Loop (1000740) = {736, -618, 738};
Surface (740) = {1000740};
Line Loop (1000745) = {-598, 742, -738};
Surface (745) = {1000745};
Line Loop (1000750) = {746, -648, 748};
Surface (750) = {1000750};
Line Loop (1000755) = {-698, 752, 753};
Surface (755) = {1000755};
Line Loop (1000760) = {-742, 757, 758};
Surface (760) = {1000760};
Line Loop (1000765) = {761, -422, -682};
Surface (765) = {1000765};
Line Loop (1000770) = {766, -688, -761};
Surface (770) = {1000770};
Line Loop (1000775) = {771, 772, -626};
Surface (775) = {1000775};
Line Loop (1000780) = {776, -646, 778};
Surface (780) = {1000780};
Line Loop (1000785) = {781, 782, 783};
Surface (785) = {1000785};
Line Loop (1000790) = {786, 787, -781};
Surface (790) = {1000790};
Line Loop (1000795) = {791, 792, -757};
Surface (795) = {1000795};
Line Loop (1000800) = {-748, -691, 798};
Surface (800) = {1000800};
Line Loop (1000805) = {801, -746, 803};
Surface (805) = {1000805};
Line Loop (1000810) = {806, -778, -801};
Surface (810) = {1000810};
Line Loop (1000815) = {-787, 812, 813};
Surface (815) = {1000815};
Line Loop (1000820) = {-733, -736, 818};
Surface (820) = {1000820};
Line Loop (1000825) = {821, -771, -686};
Surface (825) = {1000825};
Line Loop (1000830) = {-717, 827, -791};
Surface (830) = {1000830};
Line Loop (1000835) = {831, 832, -827};
Surface (835) = {1000835};
Line Loop (1000840) = {-753, 837, -831};
Surface (840) = {1000840};
Line Loop (1000845) = {841, -798, 843};
Surface (845) = {1000845};
Line Loop (1000850) = {846, -813, 848};
Surface (850) = {1000850};
Line Loop (1000855) = {851, -728, 853};
Surface (855) = {1000855};
Line Loop (1000860) = {-792, 857, 858};
Surface (860) = {1000860};
Line Loop (1000865) = {861, -636, -772};
Surface (865) = {1000865};
Line Loop (1000870) = {866, -506, 868};
Surface (870) = {1000870};
Line Loop (1000875) = {-653, 872, 873};
Surface (875) = {1000875};
Line Loop (1000880) = {876, -581, 878};
Surface (880) = {1000880};
Line Loop (1000885) = {881, -783, 883};
Surface (885) = {1000885};
Line Loop (1000890) = {-782, -846, 888};
Surface (890) = {1000890};
Line Loop (1000895) = {891, -786, 893};
Surface (895) = {1000895};
Line Loop (1000900) = {896, 897, -891};
Surface (900) = {1000900};
Line Loop (1000905) = {901, 902, -897};
Surface (905) = {1000905};
Line Loop (1000910) = {906, -812, -902};
Surface (910) = {1000910};
Line Loop (1000915) = {-661, -851, 913};
Surface (915) = {1000915};
Line Loop (1000920) = {916, -818, 918};
Surface (920) = {1000920};
Line Loop (1000925) = {-758, 922, 923};
Surface (925) = {1000925};
Line Loop (1000930) = {926, -841, 928};
Surface (930) = {1000930};
Line Loop (1000935) = {931, 932, -861};
Surface (935) = {1000935};
Line Loop (1000940) = {-708, 937, 938};
Surface (940) = {1000940};
Line Loop (1000945) = {941, -881, 943};
Surface (945) = {1000945};
Line Loop (1000950) = {-888, 947, 948};
Surface (950) = {1000950};
Line Loop (1000955) = {951, -913, 953};
Surface (955) = {1000955};
Line Loop (1000960) = {956, -588, 958};
Surface (960) = {1000960};
Line Loop (1000965) = {-918, -923, 963};
Surface (965) = {1000965};
Line Loop (1000970) = {-922, -858, 968};
Surface (970) = {1000970};
Line Loop (1000975) = {971, -928, 973};
Surface (975) = {1000975};
Line Loop (1000980) = {-973, -843, -932};
Surface (980) = {1000980};
Line Loop (1000985) = {-837, 982, 983};
Surface (985) = {1000985};
Line Loop (1000990) = {-868, -776, 988};
Surface (990) = {1000990};
Line Loop (1000995) = {-982, -752, 993};
Surface (995) = {1000995};
Line Loop (1001000) = {-993, -938, 998};
Surface (1000) = {1001000};
Line Loop (1001005) = {1001, 1002, -941};
Surface (1005) = {1001005};
Line Loop (1001010) = {1006, -893, -1002};
Surface (1010) = {1001010};
Line Loop (1001015) = {-853, -916, 1013};
Surface (1015) = {1001015};
Line Loop (1001020) = {-963, 1017, 1018};
Surface (1020) = {1001020};
Line Loop (1001025) = {-713, -956, 1023};
Surface (1025) = {1001025};
Line Loop (1001030) = {-872, -866, 1028};
Surface (1030) = {1001030};
Line Loop (1001035) = {1031, -937, -721};
Surface (1035) = {1001035};
Line Loop (1001040) = {-883, 1037, 1038};
Surface (1040) = {1001040};
Line Loop (1001045) = {1041, -901, 1043};
Surface (1045) = {1001045};
Line Loop (1001050) = {1046, 1047, -906};
Surface (1050) = {1001050};
Line Loop (1001055) = {1051, 1052, -1046};
Surface (1055) = {1001055};
Line Loop (1001060) = {1056, -681, -1023};
Surface (1060) = {1001060};
Line Loop (1001065) = {-857, 1062, 1063};
Surface (1065) = {1001065};
Line Loop (1001070) = {1066, 1067, -926};
Surface (1070) = {1001070};
Line Loop (1001075) = {1071, -803, -1067};
Surface (1075) = {1001075};
Line Loop (1001080) = {1076, -878, 1078};
Surface (1080) = {1001080};
Line Loop (1001085) = {-1037, -948, 1083};
Surface (1085) = {1001085};
Line Loop (1001090) = {1086, 1087, -848};
Surface (1090) = {1001090};
Line Loop (1001095) = {1091, 1092, -1086};
Surface (1095) = {1001095};
Line Loop (1001100) = {-1018, 1097, 1098};
Surface (1100) = {1001100};
Line Loop (1001105) = {1101, 1102, 1103};
Surface (1105) = {1001105};
Line Loop (1001110) = {1106, -668, -951};
Surface (1110) = {1001110};
Line Loop (1001115) = {-1017, 1112, -1102};
Surface (1115) = {1001115};
Line Loop (1001120) = {-968, -1063, 1118};
Surface (1120) = {1001120};
Line Loop (1001125) = {-1062, 1122, 1123};
Surface (1125) = {1001125};
Line Loop (1001130) = {1126, -1066, 1128};
Surface (1130) = {1001130};
Line Loop (1001135) = {1131, 1132, -832};
Surface (1135) = {1001135};
Line Loop (1001140) = {-1131, -983, 1138};
Surface (1140) = {1001140};
Line Loop (1001145) = {1141, -1078, -873};
Surface (1145) = {1001145};
Line Loop (1001150) = {-943, 1147, 1148};
Surface (1150) = {1001150};
Line Loop (1001155) = {1151, -1001, -1148};
Surface (1155) = {1001155};
Line Loop (1001160) = {1156, -896, 1158};
Surface (1160) = {1001160};
Line Loop (1001165) = {1161, -1043, -1156};
Surface (1165) = {1001165};
Line Loop (1001170) = {1166, -1051, -1041};
Surface (1170) = {1001170};
Line Loop (1001175) = {-1091, -1047, 1173};
Surface (1175) = {1001175};
Line Loop (1001180) = {1176, 1177, -1052};
Surface (1180) = {1001180};
Line Loop (1001185) = {-1103, 1182, -1177};
Surface (1185) = {1001185};
Line Loop (1001190) = {-1182, 1187, 1188};
Surface (1190) = {1001190};
Line Loop (1001195) = {1191, -953, 1193};
Surface (1195) = {1001195};
Line Loop (1001200) = {-1097, -1101, 1198};
Surface (1200) = {1001200};
Line Loop (1001205) = {1201, -1013, 1203};
Surface (1205) = {1001205};
Line Loop (1001210) = {1206, -1106, 1208};
Surface (1210) = {1001210};
Line Loop (1001215) = {-1112, -1118, 1213};
Surface (1215) = {1001215};
Line Loop (1001220) = {-1123, 1217, 1218};
Surface (1220) = {1001220};
Line Loop (1001225) = {1221, -931, 1223};
Surface (1225) = {1001225};
Line Loop (1001230) = {1226, -971, 1228};
Surface (1230) = {1001230};
Line Loop (1001235) = {-1128, -1226, 1233};
Surface (1235) = {1001235};
Line Loop (1001240) = {-1122, -1132, 1238};
Surface (1240) = {1001240};
Line Loop (1001245) = {1241, 1242, -806};
Surface (1245) = {1001245};
Line Loop (1001250) = {1246, 1247, -998};
Surface (1250) = {1001250};
Line Loop (1001255) = {-1147, -1038, 1253};
Surface (1255) = {1001255};
Line Loop (1001260) = {1256, -1087, 1258};
Surface (1260) = {1001260};
Line Loop (1001265) = {-1173, -1188, 1263};
Surface (1265) = {1001265};
Line Loop (1001270) = {1266, -1191, 1268};
Surface (1270) = {1001270};
Line Loop (1001275) = {-1193, -1201, 1273};
Surface (1275) = {1001275};
Line Loop (1001280) = {-1203, -1098, 1278};
Surface (1280) = {1001280};
Line Loop (1001285) = {1281, -958, -1206};
Surface (1285) = {1001285};
Line Loop (1001290) = {-1213, 1287, 1288};
Surface (1290) = {1001290};
Line Loop (1001295) = {1291, -1056, 1293};
Surface (1295) = {1001295};
Line Loop (1001300) = {1296, 1297, 1298};
Surface (1300) = {1001300};
Line Loop (1001305) = {-1223, -821, -1297};
Surface (1305) = {1001305};
Line Loop (1001310) = {-1238, 1307, 1308};
Surface (1310) = {1001310};
Line Loop (1001315) = {-988, -1242, 1313};
Surface (1315) = {1001315};
Line Loop (1001320) = {-1138, -1247, 1318};
Surface (1320) = {1001320};
Line Loop (1001325) = {-947, -1256, 1323};
Surface (1325) = {1001325};
Line Loop (1001330) = {1326, 1327, -1176};
Surface (1330) = {1001330};
Line Loop (1001335) = {-1198, -1327, 1333};
Surface (1335) = {1001335};
Line Loop (1001340) = {1336, -1333, 1338};
Surface (1340) = {1001340};
Line Loop (1001345) = {1341, -1278, -1336};
Surface (1345) = {1001345};
Line Loop (1001350) = {-1187, 1347, 1348};
Surface (1350) = {1001350};
Line Loop (1001355) = {-1287, -1218, 1353};
Surface (1355) = {1001355};
Line Loop (1001360) = {1356, -766, -1291};
Surface (1360) = {1001360};
Line Loop (1001365) = {-1241, -1071, 1363};
Surface (1365) = {1001365};
Line Loop (1001370) = {1366, 1367, -1076};
Surface (1370) = {1001370};
Line Loop (1001375) = {1371, 1372, 1373};
Surface (1375) = {1001375};
Line Loop (1001380) = {1376, 1377, -1006};
Surface (1380) = {1001380};
Line Loop (1001385) = {-1158, -1377, 1383};
Surface (1385) = {1001385};
Line Loop (1001390) = {-1092, 1387, 1388};
Surface (1390) = {1001390};
Line Loop (1001395) = {-1273, -1341, 1393};
Surface (1395) = {1001395};
Line Loop (1001400) = {1396, -1208, 1398};
Surface (1400) = {1001400};
Line Loop (1001405) = {1401, -1217, 1403};
Surface (1405) = {1001405};
Line Loop (1001410) = {-1308, 1407, -1403};
Surface (1410) = {1001410};
Line Loop (1001415) = {1411, -1228, -1221};
Surface (1415) = {1001415};
Line Loop (1001420) = {1416, -1363, -1126};
Surface (1420) = {1001420};
Line Loop (1001425) = {1421, 1422, -1313};
Surface (1425) = {1001425};
Line Loop (1001430) = {-1307, -1318, 1428};
Surface (1430) = {1001430};
Line Loop (1001435) = {1431, 1432, -1428};
Surface (1435) = {1001435};
Line Loop (1001440) = {1436, 1437, -1422};
Surface (1440) = {1001440};
Line Loop (1001445) = {1441, -1028, -1437};
Surface (1445) = {1001445};
Line Loop (1001450) = {1446, 1447, 1448};
Surface (1450) = {1001450};
Line Loop (1001455) = {-1446, -1246, -1372};
Surface (1455) = {1001455};
Line Loop (1001460) = {1456, -876, 1458};
Surface (1460) = {1001460};
Line Loop (1001465) = {-1253, 1462, 1463};
Surface (1465) = {1001465};
Line Loop (1001470) = {-1323, 1467, 1468};
Surface (1470) = {1001470};
Line Loop (1001475) = {-1258, 1472, 1473};
Surface (1475) = {1001475};
Line Loop (1001480) = {1476, -1326, -1166};
Surface (1480) = {1001480};
Line Loop (1001485) = {-1387, -1263, 1483};
Surface (1485) = {1001485};
Line Loop (1001490) = {1486, 1487, -1483};
Surface (1490) = {1001490};
Line Loop (1001495) = {-1486, -1348, 1493};
Surface (1495) = {1001495};
Line Loop (1001500) = {-1398, -1266, 1498};
Surface (1500) = {1001500};
Line Loop (1001505) = {-1347, -1288, 1503};
Surface (1505) = {1001505};
Line Loop (1001510) = {1506, -1233, -1411};
Surface (1510) = {1001510};
Line Loop (1001515) = {1511, -1421, 1513};
Surface (1515) = {1001515};
Line Loop (1001520) = {1516, 1517, -1511};
Surface (1520) = {1001520};
Line Loop (1001525) = {1521, 1522, 1523};
Surface (1525) = {1001525};
Line Loop (1001530) = {1526, 1527, -1522};
Surface (1530) = {1001530};
Line Loop (1001535) = {-1431, -1448, 1533};
Surface (1535) = {1001535};
Line Loop (1001540) = {-1031, -1456, -1373};
Surface (1540) = {1001540};
Line Loop (1001545) = {1541, -1151, 1543};
Surface (1545) = {1001545};
Line Loop (1001550) = {1546, -1376, -1541};
Surface (1550) = {1001550};
Line Loop (1001555) = {1551, 1552, 1553};
Surface (1555) = {1001555};
Line Loop (1001560) = {1556, 1557, 1558};
Surface (1560) = {1001560};
Line Loop (1001565) = {-1338, -1557, 1563};
Surface (1565) = {1001565};
Line Loop (1001570) = {-1298, -1356, 1568};
Surface (1570) = {1001570};
Line Loop (1001575) = {1571, 1572, -1506};
Surface (1575) = {1001575};
Line Loop (1001580) = {1576, 1577, -1416};
Surface (1580) = {1001580};
Line Loop (1001585) = {1581, -1513, -1577};
Surface (1585) = {1001585};
Line Loop (1001590) = {1586, 1587, 1588};
Surface (1590) = {1001590};
Line Loop (1001595) = {1591, -1516, 1593};
Surface (1595) = {1001595};
Line Loop (1001600) = {-1591, 1597, 1598};
Surface (1600) = {1001600};
Line Loop (1001605) = {-1587, -1521, -1597};
Surface (1605) = {1001605};
Line Loop (1001610) = {1606, 1607, -1447};
Surface (1610) = {1001610};
Line Loop (1001615) = {-1462, 1612, 1613};
Surface (1615) = {1001615};
Line Loop (1001620) = {1616, -1543, -1463};
Surface (1620) = {1001620};
Line Loop (1001625) = {-1612, 1622, 1623};
Surface (1625) = {1001625};
Line Loop (1001630) = {-1083, -1468, -1622};
Surface (1630) = {1001630};
Line Loop (1001635) = {-1487, 1632, -1551};
Surface (1635) = {1001635};
Line Loop (1001640) = {-1293, 1637, 1638};
Surface (1640) = {1001640};
Line Loop (1001645) = {1641, -1407, 1643};
Surface (1645) = {1001645};
Line Loop (1001650) = {-1432, 1647, -1643};
Surface (1650) = {1001650};
Line Loop (1001655) = {1651, -1526, 1653};
Surface (1655) = {1001655};
Line Loop (1001660) = {1656, -1598, 1658};
Surface (1660) = {1001660};
Line Loop (1001665) = {1661, 1662, -1517};
Surface (1665) = {1001665};
Line Loop (1001670) = {-1651, 1667, 1668};
Surface (1670) = {1001670};
Line Loop (1001675) = {1671, 1672, -1658};
Surface (1675) = {1001675};
Line Loop (1001680) = {-1523, 1677, -1671};
Surface (1680) = {1001680};
Line Loop (1001685) = {-1436, -1662, 1683};
Surface (1685) = {1001685};
Line Loop (1001690) = {1686, 1687, -1677};
Surface (1690) = {1001690};
Line Loop (1001695) = {-1527, 1692, -1686};
Surface (1695) = {1001695};
Line Loop (1001700) = {-1668, 1697, -1692};
Surface (1700) = {1001700};
Line Loop (1001705) = {-1533, 1702, 1703};
Surface (1705) = {1001705};
Line Loop (1001710) = {1706, 1707, -1441};
Surface (1710) = {1001710};
Line Loop (1001715) = {-1707, 1712, -1141};
Surface (1715) = {1001715};
Line Loop (1001720) = {-1472, -1388, 1718};
Surface (1720) = {1001720};
Line Loop (1001725) = {-1558, -1476, 1723};
Surface (1725) = {1001725};
Line Loop (1001730) = {-1553, 1727, -1718};
Surface (1730) = {1001730};
Line Loop (1001735) = {-1393, -1563, 1733};
Surface (1735) = {1001735};
Line Loop (1001740) = {1736, -1396, 1738};
Surface (1740) = {1001740};
Line Loop (1001745) = {-1503, 1742, 1743};
Surface (1745) = {1001745};
Line Loop (1001750) = {-1637, -1281, 1748};
Surface (1750) = {1001750};
Line Loop (1001755) = {-1353, -1401, 1753};
Surface (1755) = {1001755};
Line Loop (1001760) = {1756, 1757, -1296};
Surface (1760) = {1001760};
Line Loop (1001765) = {1761, -1571, -1757};
Surface (1765) = {1001765};
Line Loop (1001770) = {1766, -1576, -1572};
Surface (1770) = {1001770};
Line Loop (1001775) = {-1593, -1581, 1773};
Surface (1775) = {1001775};
Line Loop (1001780) = {-1586, 1777, -1653};
Surface (1780) = {1001780};
Line Loop (1001785) = {-1647, -1703, 1783};
Surface (1785) = {1001785};
Line Loop (1001790) = {-1661, -1656, 1788};
Surface (1790) = {1001790};
Line Loop (1001795) = {-1702, 1792, 1793};
Surface (1795) = {1001795};
Line Loop (1001800) = {1796, -1366, -1712};
Surface (1800) = {1001800};
Line Loop (1001805) = {1801, -1371, 1803};
Surface (1805) = {1001805};
Line Loop (1001810) = {1806, 1807, 1808};
Surface (1810) = {1001810};
Line Loop (1001815) = {-1808, -1606, -1801};
Surface (1815) = {1001815};
Line Loop (1001820) = {1816, -1616, 1818};
Surface (1820) = {1001820};
Line Loop (1001825) = {-1467, 1822, 1823};
Surface (1825) = {1001825};
Line Loop (1001830) = {-1822, -1473, 1828};
Surface (1830) = {1001830};
Line Loop (1001835) = {-1498, 1832, 1833};
Surface (1835) = {1001835};
Line Loop (1001840) = {-1268, 1837, -1832};
Surface (1840) = {1001840};
Line Loop (1001845) = {-1493, -1743, 1843};
Surface (1845) = {1001845};
Line Loop (1001850) = {-1742, 1847, 1848};
Surface (1850) = {1001850};
Line Loop (1001855) = {-1847, -1753, 1853};
Surface (1855) = {1001855};
Line Loop (1001860) = {1856, -1766, 1858};
Surface (1860) = {1001860};
Line Loop (1001865) = {1861, 1862, -1777};
Surface (1865) = {1001865};
Line Loop (1001870) = {-1783, 1867, 1868};
Surface (1870) = {1001870};
Line Loop (1001875) = {1871, 1872, -1862};
Surface (1875) = {1001875};
Line Loop (1001880) = {-1788, 1877, 1878};
Surface (1880) = {1001880};
Line Loop (1001885) = {-1793, 1882, -1867};
Surface (1885) = {1001885};
Line Loop (1001890) = {-1872, 1887, -1667};
Surface (1890) = {1001890};
Line Loop (1001895) = {-1877, -1672, 1893};
Surface (1895) = {1001895};
Line Loop (1001900) = {-1887, 1897, 1898};
Surface (1900) = {1001900};
Line Loop (1001905) = {-1697, 1902, 1903};
Surface (1905) = {1001905};
Line Loop (1001910) = {-1898, 1907, -1902};
Surface (1910) = {1001910};
Line Loop (1001915) = {-1607, 1912, -1792};
Surface (1915) = {1001915};
Line Loop (1001920) = {-1907, -1806, 1918};
Surface (1920) = {1001920};
Line Loop (1001925) = {-1613, 1922, -1818};
Surface (1925) = {1001925};
Line Loop (1001930) = {-1823, 1927, -1623};
Surface (1930) = {1001930};
Line Loop (1001935) = {1931, -1383, -1546};
Surface (1935) = {1001935};
Line Loop (1001940) = {-1828, 1937, 1938};
Surface (1940) = {1001940};
Line Loop (1001945) = {1941, -1723, -1161};
Surface (1945) = {1001945};
Line Loop (1001950) = {-1837, -1733, 1948};
Surface (1950) = {1001950};
Line Loop (1001955) = {-1748, -1736, 1953};
Surface (1955) = {1001955};
Line Loop (1001960) = {1956, 1957, -1568};
Surface (1960) = {1001960};
Line Loop (1001965) = {1961, -1756, -1957};
Surface (1965) = {1001965};
Line Loop (1001970) = {-1858, -1761, 1968};
Surface (1970) = {1001970};
Line Loop (1001975) = {1971, -1773, 1973};
Surface (1975) = {1001975};
Line Loop (1001980) = {1976, -1868, 1978};
Surface (1980) = {1001980};
Line Loop (1001985) = {1981, -1687, 1983};
Surface (1985) = {1001985};
Line Loop (1001990) = {-1983, -1903, 1988};
Surface (1990) = {1001990};
Line Loop (1001995) = {1991, 1992, -1897};
Surface (1995) = {1001995};
Line Loop (1002000) = {-1912, 1997, 1998};
Surface (2000) = {1002000};
Line Loop (1002005) = {-1992, -1997, -1807};
Surface (2005) = {1002005};
Line Loop (1002010) = {-1956, -1638, 2008};
Surface (2010) = {1002010};
Line Loop (1002015) = {-1853, 2012, 2013};
Surface (2015) = {1002015};
Line Loop (1002020) = {2016, -1973, -1856};
Surface (2020) = {1002020};
Line Loop (1002025) = {2021, 2022, -1971};
Surface (2025) = {1002025};
Line Loop (1002030) = {2026, 2027, 2028};
Surface (2030) = {1002030};
Line Loop (1002035) = {-2012, -1641, -1976};
Surface (2035) = {1002035};
Line Loop (1002040) = {-2028, -1588, -2022};
Surface (2040) = {1002040};
Line Loop (1002045) = {2041, -1871, 2043};
Surface (2045) = {1002045};
Line Loop (1002050) = {2046, -1991, 2048};
Surface (2050) = {1002050};
Line Loop (1002055) = {2051, -1882, 2053};
Surface (2055) = {1002055};
Line Loop (1002060) = {2056, 2057, 2058};
Surface (2060) = {1002060};
Line Loop (1002065) = {2061, -1941, -2057};
Surface (2065) = {1002065};
Line Loop (1002070) = {2066, -1727, 2068};
Surface (2070) = {1002070};
Line Loop (1002075) = {2071, -1556, 2073};
Surface (2075) = {1002075};
Line Loop (1002080) = {-1552, 2077, 2078};
Surface (2080) = {1002080};
Line Loop (1002085) = {2081, -2071, 2083};
Surface (2085) = {1002085};
Line Loop (1002090) = {-1953, 2087, 2088};
Surface (2090) = {1002090};
Line Loop (1002095) = {-1848, 2092, 2093};
Surface (2095) = {1002095};
Line Loop (1002100) = {2096, -1968, 2098};
Surface (2100) = {1002100};
Line Loop (1002105) = {2101, 2102, -2096};
Surface (2105) = {1002105};
Line Loop (1002110) = {2106, 2107, 2108};
Surface (2110) = {1002110};
Line Loop (1002115) = {-2108, -1861, -2027};
Surface (2115) = {1002115};
Line Loop (1002120) = {2116, 2117, 2118};
Surface (2120) = {1002120};
Line Loop (1002125) = {-1978, 2122, -2116};
Surface (2125) = {1002125};
Line Loop (1002130) = {2126, -2043, -2107};
Surface (2130) = {1002130};
Line Loop (1002135) = {2131, -2048, -2041};
Surface (2135) = {1002135};
Line Loop (1002140) = {2136, -1878, 2138};
Surface (2140) = {1002140};
Line Loop (1002145) = {2141, -1683, 2143};
Surface (2145) = {1002145};
Line Loop (1002150) = {-2053, -1998, -2046};
Surface (2150) = {1002150};
Line Loop (1002155) = {-1918, -1803, 2153};
Surface (2155) = {1002155};
Line Loop (1002160) = {2156, 2157, -1367};
Surface (2160) = {1002160};
Line Loop (1002165) = {-1922, 2162, 2163};
Surface (2165) = {1002165};
Line Loop (1002170) = {-2058, -1931, 2168};
Surface (2170) = {1002170};
Line Loop (1002175) = {-1937, -2066, 2173};
Surface (2175) = {1002175};
Line Loop (1002180) = {2176, -2073, -2061};
Surface (2180) = {1002180};
Line Loop (1002185) = {-1632, 2182, -2077};
Surface (2185) = {1002185};
Line Loop (1002190) = {-1948, -2081, 2188};
Surface (2190) = {1002190};
Line Loop (1002195) = {2191, -1738, 2193};
Surface (2195) = {1002195};
Line Loop (1002200) = {-2098, -1961, 2198};
Surface (2200) = {1002200};
Line Loop (1002205) = {2201, 2202, -2026};
Surface (2205) = {1002205};
Line Loop (1002210) = {-2013, 2207, 2208};
Surface (2210) = {1002210};
Line Loop (1002215) = {2211, -2016, -2102};
Surface (2215) = {1002215};
Line Loop (1002220) = {-2207, -2118, -2106};
Surface (2220) = {1002220};
Line Loop (1002225) = {-2117, 2222, -2126};
Surface (2225) = {1002225};
Line Loop (1002230) = {-2122, 2227, -2222};
Surface (2230) = {1002230};
Line Loop (1002235) = {-2227, -2051, -2131};
Surface (2235) = {1002235};
Line Loop (1002240) = {2236, 2237, -2141};
Surface (2240) = {1002240};
Line Loop (1002245) = {2241, -1706, -2237};
Surface (2245) = {1002245};
Line Loop (1002250) = {2246, 2247, -2241};
Surface (2250) = {1002250};
Line Loop (1002255) = {-1988, 2252, 2253};
Surface (2255) = {1002255};
Line Loop (1002260) = {-2252, -2153, 2258};
Surface (2260) = {1002260};
Line Loop (1002265) = {2261, -1796, -2247};
Surface (2265) = {1002265};
Line Loop (1002270) = {2266, -2156, -2261};
Surface (2270) = {1002270};
Line Loop (1002275) = {-2162, -1927, 2273};
Surface (2275) = {1002275};
Line Loop (1002280) = {2276, -2168, -1816};
Surface (2280) = {1002280};
Line Loop (1002285) = {-2068, -2078, 2283};
Surface (2285) = {1002285};
Line Loop (1002290) = {-2182, 2287, 2288};
Surface (2290) = {1002290};
Line Loop (1002295) = {-2287, -1843, 2293};
Surface (2295) = {1002295};
Line Loop (1002300) = {2296, -2087, -2191};
Surface (2300) = {1002300};
Line Loop (1002305) = {-2293, -2093, 2303};
Surface (2305) = {1002305};
Line Loop (1002310) = {2306, 2307, -2088};
Surface (2310) = {1002310};
Line Loop (1002315) = {2311, -2008, -2307};
Surface (2315) = {1002315};
Line Loop (1002320) = {2316, 2317, -2101};
Surface (2320) = {1002320};
Line Loop (1002325) = {2321, 2322, 2323};
Surface (2325) = {1002325};
Line Loop (1002330) = {-2092, -2208, 2328};
Surface (2330) = {1002330};
Line Loop (1002335) = {2331, -2021, -2322};
Surface (2335) = {1002335};
Line Loop (1002340) = {-1893, -1981, 2338};
Surface (2340) = {1002340};
Line Loop (1002345) = {2341, -1458, -2157};
Surface (2345) = {1002345};
Line Loop (1002350) = {2346, -2276, -2163};
Surface (2350) = {1002350};
Line Loop (1002355) = {-2273, -1938, 2353};
Surface (2355) = {1002355};
Line Loop (1002360) = {-2346, 2357, -2056};
Surface (2360) = {1002360};
Line Loop (1002365) = {-2353, 2362, -2357};
Surface (2365) = {1002365};
Line Loop (1002370) = {-2173, -2283, 2368};
Surface (2370) = {1002370};
Line Loop (1002375) = {2371, 2372, -2362};
Surface (2375) = {1002375};
Line Loop (1002380) = {-2372, -2303, 2378};
Surface (2380) = {1002380};
Line Loop (1002385) = {-2176, 2382, -2083};
Surface (2385) = {1002385};
Line Loop (1002390) = {-2368, -2288, -2371};
Surface (2390) = {1002390};
Line Loop (1002395) = {-2193, -1833, 2393};
Surface (2395) = {1002395};
Line Loop (1002400) = {-2188, 2397, -2393};
Surface (2400) = {1002400};
Line Loop (1002405) = {-2382, 2402, 2403};
Surface (2405) = {1002405};
Line Loop (1002410) = {-2403, 2407, -2397};
Surface (2410) = {1002410};
Line Loop (1002415) = {-2296, 2412, -2306};
Surface (2415) = {1002415};
Line Loop (1002420) = {-2407, 2417, -2412};
Surface (2420) = {1002420};
Line Loop (1002425) = {-2378, 2422, -2402};
Surface (2425) = {1002425};
Line Loop (1002430) = {2426, 2427, -2422};
Surface (2430) = {1002430};
Line Loop (1002435) = {-2427, 2432, -2321};
Surface (2435) = {1002435};
Line Loop (1002440) = {2436, -2198, -2311};
Surface (2440) = {1002440};
Line Loop (1002445) = {-2417, -2316, -2436};
Surface (2445) = {1002445};
Line Loop (1002450) = {-2201, -2331, -2432};
Surface (2450) = {1002450};
Line Loop (1002455) = {-2426, -2328, -2202};
Surface (2455) = {1002455};
Line Loop (1002460) = {-2323, -2211, -2317};
Surface (2460) = {1002460};
Line Loop (1002465) = {-2143, -2136, 2463};
Surface (2465) = {1002465};
Line Loop (1002470) = {-2138, 2467, 2468};
Surface (2470) = {1002470};
Line Loop (1002475) = {-2463, 2472, -2236};
Surface (2475) = {1002475};
Line Loop (1002480) = {2476, 2477, -2472};
Surface (2480) = {1002480};
Line Loop (1002485) = {-2468, 2482, -2476};
Surface (2485) = {1002485};
Line Loop (1002490) = {-2338, -2253, -2467};
Surface (2490) = {1002490};
Line Loop (1002495) = {-2477, -2266, -2246};
Surface (2495) = {1002495};
Line Loop (1002500) = {-2258, -2341, -2482};
Surface (2500) = {1002500};
Surface Loop (1010001) = {5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 105, 110, 115, 120, 125, 130, 135, 140, 145, 150, 155,
160, 165, 170, 175, 180, 185, 190, 195, 200, 205, 210, 215, 220, 225, 230, 235, 240, 245, 250, 255, 260, 265, 270, 275, 280, 285, 290, 295, 300, 305, 310, 315,
320, 325, 330, 335, 340, 345, 350, 355, 360, 365, 370, 375, 380, 385, 390, 395, 400, 405, 410, 415, 420, 425, 430, 435, 440, 445, 450, 455, 460, 465, 470, 475,
480, 485, 490, 495, 500, 505, 510, 515, 520, 525, 530, 535, 540, 545, 550, 555, 560, 565, 570, 575, 580, 585, 590, 595, 600, 605, 610, 615, 620, 625, 630, 635,
640, 645, 650, 655, 660, 665, 670, 675, 680, 685, 690, 695, 700, 705, 710, 715, 720, 725, 730, 735, 740, 745, 750, 755, 760, 765, 770, 775, 780, 785, 790, 795,
800, 805, 810, 815, 820, 825, 830, 835, 840, 845, 850, 855, 860, 865, 870, 875, 880, 885, 890, 895, 900, 905, 910, 915, 920, 925, 930, 935, 940, 945, 950, 955,
960, 965, 970, 975, 980, 985, 990, 995, 1000, 1005, 1010, 1015, 1020, 1025, 1030, 1035, 1040, 1045, 1050, 1055, 1060, 1065, 1070, 1075, 1080, 1085, 1090,
1095, 1100, 1105, 1110, 1115, 1120, 1125, 1130, 1135, 1140, 1145, 1150, 1155, 1160, 1165, 1170, 1175, 1180, 1185, 1190, 1195, 1200, 1205, 1210, 1215,
1220, 1225, 1230, 1235, 1240, 1245, 1250, 1255, 1260, 1265, 1270, 1275, 1280, 1285, 1290, 1295, 1300, 1305, 1310, 1315, 1320, 1325, 1330, 1335, 1340,
1345, 1350, 1355, 1360, 1365, 1370, 1375, 1380, 1385, 1390, 1395, 1400, 1405, 1410, 1415, 1420, 1425, 1430, 1435, 1440, 1445, 1450, 1455, 1460, 1465,
1470, 1475, 1480, 1485, 1490, 1495, 1500, 1505, 1510, 1515, 1520, 1525, 1530, 1535, 1540, 1545, 1550, 1555, 1560, 1565, 1570, 1575, 1580, 1585, 1590,
1595, 1600, 1605, 1610, 1615, 1620, 1625, 1630, 1635, 1640, 1645, 1650, 1655, 1660, 1665, 1670, 1675, 1680, 1685, 1690, 1695, 1700, 1705, 1710, 1715,
1720, 1725, 1730, 1735, 1740, 1745, 1750, 1755, 1760, 1765, 1770, 1775, 1780, 1785, 1790, 1795, 1800, 1805, 1810, 1815, 1820, 1825, 1830, 1835, 1840,
1845, 1850, 1855, 1860, 1865, 1870, 1875, 1880, 1885, 1890, 1895, 1900, 1905, 1910, 1915, 1920, 1925, 1930, 1935, 1940, 1945, 1950, 1955, 1960, 1965,
1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005, 2010, 2015, 2020, 2025, 2030, 2035, 2040, 2045, 2050, 2055, 2060, 2065, 2070, 2075, 2080, 2085, 2090,
2095, 2100, 2105, 2110, 2115, 2120, 2125, 2130, 2135, 2140, 2145, 2150, 2155, 2160, 2165, 2170, 2175, 2180, 2185, 2190, 2195, 2200, 2205, 2210, 2215,
2220, 2225, 2230, 2235, 2240, 2245, 2250, 2255, 2260, 2265, 2270, 2275, 2280, 2285, 2290, 2295, 2300, 2305, 2310, 2315, 2320, 2325, 2330, 2335, 2340,
2345, 2350, 2355, 2360, 2365, 2370, 2375, 2380, 2385, 2390, 2395, 2400, 2405, 2410, 2415, 2420, 2425, 2430, 2435, 2440, 2445, 2450, 2455, 2460, 2465,
2470, 2475, 2480, 2485, 2490, 2495, 2500};
Volume (10001) = {1010001};
Physical Volume (10002) = {10001};

