/*
  Copyright (c) 2007-2014 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

#include "compat.h"
#include "xdr-common.h"
#include "xdr-nfs3.h"

#if defined(__GNUC__)
#if __GNUC__ >= 4
#if !defined(__clang__)
#if !defined(__NetBSD__)
#pragma GCC diagnostic ignored "-Wunused-but-set-variable"
#pragma GCC diagnostic ignored "-Wunused-variable"
#endif
#else
#pragma clang diagnostic ignored "-Wunused-variable"
#pragma clang diagnostic ignored "-Wunused-value"
#endif
#endif
#endif

/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "../../../rpc/xdr/src/rpc-common-xdr.h"

bool_t
xdr_auth_glusterfs_parms_v2 (XDR *xdrs, auth_glusterfs_parms_v2 *objp)
{
	register int32_t *buf;


	if (xdrs->x_op == XDR_ENCODE) {
		buf = XDR_INLINE (xdrs, 3 * BYTES_PER_XDR_UNIT);
		if (buf == NULL) {
			 if (!xdr_int (xdrs, &objp->pid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->uid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->gid))
				 return FALSE;

		} else {
		IXDR_PUT_LONG(buf, objp->pid);
		IXDR_PUT_U_LONG(buf, objp->uid);
		IXDR_PUT_U_LONG(buf, objp->gid);
		}
		 if (!xdr_array (xdrs, (char **)&objp->groups.groups_val, (u_int *) &objp->groups.groups_len, ~0,
			sizeof (u_int), (xdrproc_t) xdr_u_int))
			 return FALSE;
		 if (!xdr_bytes (xdrs, (char **)&objp->lk_owner.lk_owner_val, (u_int *) &objp->lk_owner.lk_owner_len, ~0))
			 return FALSE;
		return TRUE;
	} else if (xdrs->x_op == XDR_DECODE) {
		buf = XDR_INLINE (xdrs, 3 * BYTES_PER_XDR_UNIT);
		if (buf == NULL) {
			 if (!xdr_int (xdrs, &objp->pid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->uid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->gid))
				 return FALSE;

		} else {
		objp->pid = IXDR_GET_LONG(buf);
		objp->uid = IXDR_GET_U_LONG(buf);
		objp->gid = IXDR_GET_U_LONG(buf);
		}
		 if (!xdr_array (xdrs, (char **)&objp->groups.groups_val, (u_int *) &objp->groups.groups_len, ~0,
			sizeof (u_int), (xdrproc_t) xdr_u_int))
			 return FALSE;
		 if (!xdr_bytes (xdrs, (char **)&objp->lk_owner.lk_owner_val, (u_int *) &objp->lk_owner.lk_owner_len, ~0))
			 return FALSE;
	 return TRUE;
	}

	 if (!xdr_int (xdrs, &objp->pid))
		 return FALSE;
	 if (!xdr_u_int (xdrs, &objp->uid))
		 return FALSE;
	 if (!xdr_u_int (xdrs, &objp->gid))
		 return FALSE;
	 if (!xdr_array (xdrs, (char **)&objp->groups.groups_val, (u_int *) &objp->groups.groups_len, ~0,
		sizeof (u_int), (xdrproc_t) xdr_u_int))
		 return FALSE;
	 if (!xdr_bytes (xdrs, (char **)&objp->lk_owner.lk_owner_val, (u_int *) &objp->lk_owner.lk_owner_len, ~0))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_auth_glusterfs_parms (XDR *xdrs, auth_glusterfs_parms *objp)
{
	register int32_t *buf;

	int i;

	if (xdrs->x_op == XDR_ENCODE) {
		 if (!xdr_u_quad_t (xdrs, &objp->lk_owner))
			 return FALSE;
		buf = XDR_INLINE (xdrs, (4 +  16 )* BYTES_PER_XDR_UNIT);
		if (buf == NULL) {
			 if (!xdr_u_int (xdrs, &objp->pid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->uid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->gid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->ngrps))
				 return FALSE;
			 if (!xdr_vector (xdrs, (char *)objp->groups, 16,
				sizeof (u_int), (xdrproc_t) xdr_u_int))
				 return FALSE;
		} else {
			IXDR_PUT_U_LONG(buf, objp->pid);
			IXDR_PUT_U_LONG(buf, objp->uid);
			IXDR_PUT_U_LONG(buf, objp->gid);
			IXDR_PUT_U_LONG(buf, objp->ngrps);
			{
				register u_int *genp;

				for (i = 0, genp = objp->groups;
					i < 16; ++i) {
					IXDR_PUT_U_LONG(buf, *genp++);
				}
			}
		}
		return TRUE;
	} else if (xdrs->x_op == XDR_DECODE) {
		 if (!xdr_u_quad_t (xdrs, &objp->lk_owner))
			 return FALSE;
		buf = XDR_INLINE (xdrs, (4 +  16 )* BYTES_PER_XDR_UNIT);
		if (buf == NULL) {
			 if (!xdr_u_int (xdrs, &objp->pid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->uid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->gid))
				 return FALSE;
			 if (!xdr_u_int (xdrs, &objp->ngrps))
				 return FALSE;
			 if (!xdr_vector (xdrs, (char *)objp->groups, 16,
				sizeof (u_int), (xdrproc_t) xdr_u_int))
				 return FALSE;
		} else {
			objp->pid = IXDR_GET_U_LONG(buf);
			objp->uid = IXDR_GET_U_LONG(buf);
			objp->gid = IXDR_GET_U_LONG(buf);
			objp->ngrps = IXDR_GET_U_LONG(buf);
			{
				register u_int *genp;

				for (i = 0, genp = objp->groups;
					i < 16; ++i) {
					*genp++ = IXDR_GET_U_LONG(buf);
				}
			}
		}
	 return TRUE;
	}

	 if (!xdr_u_quad_t (xdrs, &objp->lk_owner))
		 return FALSE;
	 if (!xdr_u_int (xdrs, &objp->pid))
		 return FALSE;
	 if (!xdr_u_int (xdrs, &objp->uid))
		 return FALSE;
	 if (!xdr_u_int (xdrs, &objp->gid))
		 return FALSE;
	 if (!xdr_u_int (xdrs, &objp->ngrps))
		 return FALSE;
	 if (!xdr_vector (xdrs, (char *)objp->groups, 16,
		sizeof (u_int), (xdrproc_t) xdr_u_int))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_gf_dump_req (XDR *xdrs, gf_dump_req *objp)
{
	register int32_t *buf;

	 if (!xdr_u_quad_t (xdrs, &objp->gfs_id))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_gf_prog_detail (XDR *xdrs, gf_prog_detail *objp)
{
	register int32_t *buf;

	 if (!xdr_string (xdrs, &objp->progname, ~0))
		 return FALSE;
	 if (!xdr_u_quad_t (xdrs, &objp->prognum))
		 return FALSE;
	 if (!xdr_u_quad_t (xdrs, &objp->progver))
		 return FALSE;
	 if (!xdr_pointer (xdrs, (char **)&objp->next, sizeof (gf_prog_detail), (xdrproc_t) xdr_gf_prog_detail))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_gf_dump_rsp (XDR *xdrs, gf_dump_rsp *objp)
{
	register int32_t *buf;

	 if (!xdr_u_quad_t (xdrs, &objp->gfs_id))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->op_ret))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->op_errno))
		 return FALSE;
	 if (!xdr_pointer (xdrs, (char **)&objp->prog, sizeof (gf_prog_detail), (xdrproc_t) xdr_gf_prog_detail))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_gf_common_rsp (XDR *xdrs, gf_common_rsp *objp)
{
	register int32_t *buf;

	 if (!xdr_int (xdrs, &objp->op_ret))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->op_errno))
		 return FALSE;
	 if (!xdr_bytes (xdrs, (char **)&objp->xdata.xdata_val, (u_int *) &objp->xdata.xdata_len, ~0))
		 return FALSE;
	return TRUE;
}
