
from math import sin

import gobject

import glitch, glitch.gtk
from glitch.limbo.lights import LightSwitch, AmbientLight, DiffuseLight
from glitch.limbo.material import Material
from glitch.limbo.objects import Cube
from glitch.limbo.spread import Spread

def tick():
    global t

    for i, cube in enumerate(cubes):
        cube.y = 0.1 + 3 * sin((-t + (i * 5.0)) / 15.0)

    t += 1
    camera.refresh()
    return True

if __name__ == '__main__':
    cubes = [glitch.Scale(children=[
        Material(r=1, children=[
            Cube()])]) for x in xrange(10)]
    camera = glitch.gtk.GtkCamera(eye=[0, 2, 6], ref=[0, 0, -1], children=[
        LightSwitch(children=[
            AmbientLight(intensity=0.4, children=[
                DiffuseLight(y=5, children=[
                    glitch.Translate(x=-5, children=[
                        Spread(x=1.1, children=cubes)])])])])])

    t = 0
    gobject.timeout_add(1000/30, tick)

    camera.run()
