
<!DOCTYPE html>
<html lang="en-US">

  <!--
   | Theme based on GitHub Pages slate theme
   |
   | @see https://github.com/pages-themes/slate
   | @see https://github.com/pages-themes/slate/blob/master/LICENSE
  -->

  <head>
    <meta charset='utf-8'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,maximum-scale=2">
    <link rel="stylesheet" type="text/css" media="screen" href="/assets/slate-style.css?v=a185c0dde883863779be4856421ba0b2390f44a4">

    <title>gerbv - A Free/Open Source Gerber Viewer</title>
    <meta name="description" content="Gerbv is a viewer for Gerber RS-274X files, Excellon drill files, and CSV pick-and-place files." />
  </head>

  <body>

    <!-- HEADER -->
    <div id="header_wrap" class="outer">
        <header class="inner">

          <a id="forkme_banner" href="https://github.com/gerbv/gerbv">View on GitHub</a>

          <img src="assets/gerbv.svg" style="float: left; box-shadow: none; border: none; padding-right: 2em" />
          <h1 id="project_title">gerbv</h1>
          <h2 id="project_tagline">A Free/Open Source Gerber Viewer</h2>

          <section id="downloads">
            <a class="zip_download_link" href="https://github.com/gerbv/gerbv/zipball/main">Download this project as a .zip file</a>
            <a class="tar_download_link" href="https://github.com/gerbv/gerbv/tarball/main">Download this project as a tar.gz file</a>
          </section>

        </header>
    </div>

    <!-- MAIN CONTENT -->
    <div id="main_content_wrap" class="outer">
      <section id="main_content" class="inner">

        <h2 id="overview">Overview</h2>

       <ul>
         <li>Gerbv is a viewer for Gerber RS-274X files, Excellon drill files, and CSV pick-and-place files.</li>
         <li>Gerbv is a native Linux application, and it runs on many common UNIX platforms. A Windows version is also available.</li>
         <li>Gerbv is <a href="http://www.gnu.org/philosophy/free-sw.html">free</a> / <a href="http://www.opensource.org/docs/osd">open-source</a> software.</li>
         <li>The core functionality of gerbv is located in a separate library (<a href="doc">libgerbv</a>), allowing developers to include Gerber parsing/editing/exporting/rendering into other programs</li>
         <li>Gerbv was originally developed as one of the utilities affiliated with the <a href="http://www.geda-project.org/">gEDA project</a>, an umbrella organization dedicated to producing free software tools for electronic design.</li>
       </ul>


       <h2 id="download">Download</h2>

       <p>Official releases are published on <a href="https://github.com/gerbv/gerbv/releases">GitHub Releases</a>. Nevertheless, you can download the latest binaries for various platforms here. Be aware however that they are not manually verified!</p>

       <table style="width: 100%">
         <tr>
           <th>OS</th>
           <th>Build date</th>
           <th>Source</th>
           <th>Download</th>
         </tr>
         <tr>
           <td style="vertical-align: middle"><img src="assets/Fedora_icon_(2021).svg" alt="Fedora 35" title="Fedora 35" style="height: 100px; box-shadow: none; border: none" /></td>
           <td style="vertical-align: middle">include(ci/Fedora 35.RELEASE_DATE)</td>
           <td style="vertical-align: middle"><code><a href="https://github.com/gerbv/gerbv/tree/include(ci/Fedora 35.RELEASE_COMMIT)">include(ci/Fedora 35.RELEASE_COMMIT_SHORT)</a></code></td>
           <td style="vertical-align: middle"><a class="tar_download_link" href="ci/include(ci/Fedora 35.RELEASE_FILENAME)">Download Fedora 35 binaries</a></td>
         </tr>
         <tr>
           <td style="vertical-align: middle"><img src="assets/cof_orange_hex.png" alt="Ubuntu 20.04" title="Ubuntu 20.04" style="height: 100px; box-shadow: none; border: none" /></td>
           <td style="vertical-align: middle">include(ci/Ubuntu 20.04.RELEASE_DATE)</td>
           <td style="vertical-align: middle"><code><a href="https://github.com/gerbv/gerbv/tree/include(ci/Ubuntu 20.04.RELEASE_COMMIT)">include(ci/Ubuntu 20.04.RELEASE_COMMIT_SHORT)</a></code></td>
           <td style="vertical-align: middle"><a class="tar_download_link" href="ci/include(ci/Ubuntu 20.04.RELEASE_FILENAME)">Download Ubuntu 20.04 binaries</a></td>
         </tr>
         <tr>
           <td style="vertical-align: middle"><img src="assets/Windows_10_Logo.png" alt="Windows amd64" title="Windows amd64" style="height: 100px; box-shadow: none; border: none" /></td>
           <td style="vertical-align: middle">include(ci/Windows amd64.RELEASE_DATE)</td>
           <td style="vertical-align: middle"><code><a href="https://github.com/gerbv/gerbv/tree/include(ci/Windows amd64.RELEASE_COMMIT)">include(ci/Windows amd64.RELEASE_COMMIT_SHORT)</a></code></td>
           <td style="vertical-align: middle"><a class="zip_download_link" href="ci/include(ci/Windows amd64.RELEASE_FILENAME)">Download Windows amd64 binaries</a></td>
         </tr>
       </table>

      </section>
    </div>

    <!-- FOOTER  -->
    <div id="footer_wrap" class="outer">
      <footer class="inner">

        <p class="copyright">Slate theme maintained by <a href="https://github.com/pages-themes">pages-themes</a></p>
      </footer>
    </div>
  </body>
</html>

