;; Copyright (C) 2002-2023 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.
;;
;; DFA-based pipeline description for 5400
(define_automaton "vr54")
(define_cpu_unit "vr54_dp0"     "vr54")
(define_cpu_unit "vr54_dp1"     "vr54")
(define_cpu_unit "vr54_mem"     "vr54")
(define_cpu_unit "vr54_mac"     "vr54")

;;
;; The ordering of the instruction-execution-path/resource-usage
;; descriptions (also known as reservation RTL) is roughly ordered
;; based on the define attribute RTL for the "type" classification.
;; When modifying, remember that the first test that matches is the
;; reservation used!
;;

(define_insn_reservation "ir_vr54_unknown" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "unknown,atomic,syncloop"))
  "vr54_dp0+vr54_dp1+vr54_mem+vr54_mac")

;; Assume prediction fails.
(define_insn_reservation "ir_vr54_branch" 3
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "branch,jump,call"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_load" 2
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "load,fpload,fpidxload"))
  "vr54_mem")

(define_insn_reservation "ir_vr54_store" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "store"))
  "vr54_mem")

(define_insn_reservation "ir_vr54_fstore" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fpstore,fpidxstore"))
  "vr54_mem")


;; This reservation is for conditional move based on integer
;; or floating point CC.
(define_insn_reservation "ir_vr54_condmove" 4
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "condmove"))
  "vr54_dp0|vr54_dp1")

;; Move to/from FPU registers
(define_insn_reservation "ir_vr54_xfer" 2
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "mfc,mtc"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_hilo" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "mthi,mtlo,mfhi,mflo"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_arith" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "arith,shift,signext,slt,clz,const,logical,move,nop,trap"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_imul_si" 3
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "imul,imul3")
            (eq_attr "mode" "SI")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_imul_di" 4
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "imul,imul3")
            (eq_attr "mode" "DI")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_imadd_si" 3
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "imul,imul3"))
  "vr54_mac")

(define_insn_reservation "ir_vr54_idiv_si" 42
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "idiv")
            (eq_attr "mode" "SI")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_idiv_di" 74
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "idiv")
            (eq_attr "mode" "DI")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fadd" 4
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fadd"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fmul_sf" 5
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fmul")
            (eq_attr "mode" "SF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fmul_df" 6
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fmul")
            (eq_attr "mode" "DF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fmadd_sf" 9
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fmadd")
            (eq_attr "mode" "SF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fmadd_df" 10
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fmadd")
            (eq_attr "mode" "DF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fdiv_sf" 42
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt")
            (eq_attr "mode" "SF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fdiv_df" 72
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt")
            (eq_attr "mode" "DF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fabs" 2
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fabs,fneg,fmove"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fcmp" 2
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fcmp"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fcvt" 6
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fcvt"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_frsqrt_sf" 61
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "frsqrt")
            (eq_attr "mode" "SF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_frsqrt_df" 121
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "frsqrt")
            (eq_attr "mode" "DF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_multi" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "multi"))
  "vr54_dp0+vr54_dp1+vr54_mem+vr54_mac")
