/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#include <draw_text.h>

void draw_text( char *text, 
		SDL_Surface *surface,
		TTF_Font *font, 
		Uint32 fore_color, 
		int x, int y 
		)
{
  static SDL_Rect rect;
  static SDL_Surface *tmp = NULL;
  static SDL_Color color;

  // error checking
  if ( ( ! surface ) || ( ! font ) || ( ! text ) ||
       ( x < 0 ) || ( y < 0 ) || ( x >= surface->w ) || ( y >= surface->h ) 
       )
    return;

  COLOR2SDL( color, fore_color );

  rect.x = x; 
  rect.y = y;

  tmp = TTF_RenderText_Blended( font, text, color );
  SDL_BlitSurface( tmp, NULL, surface, &rect );
  SDL_FreeSurface( tmp );
}



void draw_text_shadow( char *text, 
		       SDL_Surface *surface,
		       TTF_Font *font, 
		       Uint32 fore_color, 
		       Uint32 shadow_color, 
		       int x, int y,
		       int sh_x, int sh_y
		       )
{
  draw_text( text, surface, font, shadow_color, x + sh_x, y + sh_y );
  draw_text( text, surface, font, fore_color, x, y );
}  
