/*
 * Copyright (c) 1999 Global Technology Associates, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef _KGZ_H_
#define _KGZ_H_

#include <sys/types.h>

/*
 * KGZ definitions: kgzip(8) output.
 */

/* Values for ident[]. */
#define KGZ_ID0 		'K'
#define KGZ_ID1 		'G'
#define KGZ_ID2 		'Z'
#define KGZ_ID3 		'\0'

/* KGZ header. */
struct kgz_hdr {
    char	ident[4];	/* identification */
    uint32_t	dload;		/* decoded image load address */
    uint32_t	dsize;		/* decoded image size */
    uint32_t	isize;		/* image size in memory */
    uint32_t	entry;		/* program entry point */
    uint32_t	nsize;		/* encoded image size */
};

extern struct kgz_hdr kgz;	/* header */
extern uint8_t kgz_ndata[];	/* encoded image */

#endif /* !_KGZ_H_ */
