/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.util.CollectionUtil;

public class UnnecessaryConversionTemporary
extends AbstractRule {
    private boolean inPrimaryExpressionContext;
    private ASTPrimaryExpression primary;
    private boolean usingPrimitiveWrapperAllocation;
    private static final Set<String> primitiveWrappers = CollectionUtil.asSet(new String[]{"Integer", "Boolean", "Double", "Long", "Short", "Byte", "Float"});

    public Object visit(ASTPrimaryExpression node, Object data) {
        if (node.jjtGetNumChildren() == 0 || node.jjtGetChild(0).jjtGetNumChildren() == 0 || !(node.jjtGetChild(0).jjtGetChild(0) instanceof ASTAllocationExpression)) {
            return super.visit(node, data);
        }
        this.inPrimaryExpressionContext = true;
        this.primary = node;
        super.visit(node, data);
        this.inPrimaryExpressionContext = false;
        this.usingPrimitiveWrapperAllocation = false;
        return data;
    }

    public Object visit(ASTAllocationExpression node, Object data) {
        if (!this.inPrimaryExpressionContext || !(node.jjtGetChild(0) instanceof ASTClassOrInterfaceType)) {
            return super.visit(node, data);
        }
        if (!primitiveWrappers.contains(((SimpleNode)node.jjtGetChild(0)).getImage())) {
            return super.visit(node, data);
        }
        this.usingPrimitiveWrapperAllocation = true;
        return super.visit(node, data);
    }

    public Object visit(ASTPrimarySuffix node, Object data) {
        if (this.inPrimaryExpressionContext && this.usingPrimitiveWrapperAllocation && node.hasImageEqualTo("toString") && node.jjtGetParent() == this.primary) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }
}

