/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file sendsms.c
 * \brief Send SMS dialog and yaps interaction
 */

#include <ffgtk.h>

enum {
	CONTACT_NAME,
	CONTACT_NUMBER
};


/**
 * \brief SMS dialog window response callback
 * \param psDialog dialog window pointer
 * \param nResponse response id
 * \param pUserData file name
 */
void smsDialogResponse( GtkDialog *psDialog, gint nResponse, gpointer pUserData ) {
	gchar *pnNumber = NULL;
	GtkWidget *psNumberEntry = g_object_get_data( G_OBJECT( psDialog ), "number_entry" );
	GtkWidget *psTextView = g_object_get_data( G_OBJECT( psDialog ), "textview" );
	GtkTextBuffer *psBuffer = NULL;
	GtkTextIter sStart, sEnd;
	gchar *pnText = NULL;
	gchar *pnYapsText = NULL;

	psBuffer = gtk_text_view_get_buffer( GTK_TEXT_VIEW( psTextView ) );
	gtk_text_buffer_get_bounds( GTK_TEXT_BUFFER( psBuffer ), &sStart, &sEnd );
	
	pnText = gtk_text_buffer_get_text( psBuffer, &sStart, &sEnd, TRUE );

	if ( psNumberEntry != NULL && gtk_entry_get_text( GTK_ENTRY( psNumberEntry ) ) != NULL ) {
		pnNumber = g_strdup( gtk_entry_get_text( GTK_ENTRY( psNumberEntry ) ) );
	}

	gtk_widget_destroy( GTK_WIDGET( psDialog ) );

	switch ( nResponse ) {
		case 2:
			if ( pnNumber != NULL ) {
				gchar *apnArgs[ 4 ];
				gchar *pnFixNumber = fixNumber( pnNumber );
				pnYapsText = g_strdup_printf( "\"%s\"", pnText );
				gchar *pnLocal = g_convert( pnYapsText, -1, "ISO-8859-1", "UTF-8", NULL, NULL, NULL );
				Debug( KERN_INFO, "Send SMS!!\n" );
				Debug( KERN_INFO, "Text: %s\n", pnLocal );

				apnArgs[ 0 ] = "yaps";
				apnArgs[ 1 ] = pnFixNumber;
				apnArgs[ 2 ] = pnLocal;
				apnArgs[ 3 ] = NULL;

				if ( g_spawn_sync( NULL, apnArgs, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, NULL ) == FALSE ) {
					Debug( KERN_WARNING, "Error occurred: %d (%s)\n", errno, strerror( errno ) );
				}
				g_free( pnLocal );
				g_free( pnFixNumber );
				g_free( pnYapsText );
			}
			break;
		default:
			break;
	}

	if ( pnNumber != NULL ) {
		g_free( pnNumber );
	}

	g_free( pnText );
}

/**
 * \brief Open addressbook in dial mode
 * \param psWidget button widget
 * \param pUserData UNUSED
 */
static void smsAddressBook( GtkWidget *psWidget, gpointer pUserData ) {
	GtkWidget *psDialog = AddressBook( 1 );

	g_object_set_data( G_OBJECT( psDialog ), "parent", pUserData );
}

/**
 * \brief Send SMS dialog
 */
void sendSmsDialog( void ) {
	GtkBuilder *psBuilder = NULL;
	GError *psError = NULL;
	GtkWidget *psDialog = NULL;
	GtkListStore *psModel = NULL;
	GtkTreeIter sIter;
	GtkEntryCompletion *psCompletion = NULL;
	GtkWidget *psNameEntry = NULL;
	GtkWidget *psNumberEntry;
	GtkWidget *psBookButton = NULL;
	GtkWidget *psTextView = NULL;
	GList *psList = psPersonsList;
	gchar *pnUiFile;

	psBuilder = gtk_builder_new();
	pnUiFile = getUiFile( "sendsms.ui" );
	if ( gtk_builder_add_from_file( psBuilder, pnUiFile, &psError ) == 0 ) {
	    Debug( KERN_WARNING, "Error: %s\n", psError -> message );
	    g_error_free( psError );
		g_free( pnUiFile );
	    return;
	}
	g_free( pnUiFile );

	psDialog = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psSendSmsDialog" ) );

	psNameEntry = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psNameEntry" ) );
	g_object_set_data( G_OBJECT( psDialog ), "name_entry", psNameEntry );

	psNumberEntry = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psNumberEntry" ) );
	g_object_set_data( G_OBJECT( psDialog ), "number_entry", psNumberEntry );

	psTextView = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psTextView" ) );
	g_object_set_data( G_OBJECT( psDialog ), "textview", psTextView );
	
	psCompletion = gtk_entry_completion_new();
	gtk_entry_completion_set_text_column( psCompletion, CONTACT_NAME );
	gtk_entry_set_completion( GTK_ENTRY( psNameEntry ), psCompletion );

	psModel = gtk_list_store_new( 1, G_TYPE_STRING );
	while ( psList != NULL ) {
		struct sPerson *psPerson = psList -> data;

		if ( psPerson != NULL ) {
			gtk_list_store_append( psModel, &sIter );
			gtk_list_store_set( psModel, &sIter, CONTACT_NAME, psPerson -> pnDisplayName, -1 ); 
		}

		psList = psList -> next;
	}
	gtk_entry_completion_set_model( psCompletion, GTK_TREE_MODEL( psModel ) );
	g_signal_connect( G_OBJECT( psCompletion ), "match-selected", G_CALLBACK( dialNameMatchSelect ), psNumberEntry );

	psBookButton = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psAddressBookButton" ) );
	g_signal_connect( G_OBJECT( psBookButton ), "clicked", G_CALLBACK( smsAddressBook ), psDialog );

	g_signal_connect( G_OBJECT( psDialog ), "response", G_CALLBACK( smsDialogResponse ), NULL );

	gtk_builder_connect_signals( psBuilder, NULL );

	g_object_unref( G_OBJECT( psBuilder ) );

	gtk_widget_show_all( psDialog );
}
