/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file faxbox.c
 * \brief Contains all function needed for fax box support
 */

#include <ffgtk.h>

/**
 * \brief Fax box open callback
 * \param psModel tree model
 * \param psPath tree path
 */
void faxBoxOpen( GtkTreeModel *psModel, GtkTreePath *psPath ) {
	GtkTreeIter sSelectedIter;
	GValue sDateTime = { 0 };
	GValue sNumber = { 0 };
	gchar *pnStorePath = NULL;
	gchar *pnFile = NULL;

	if ( gtk_tree_model_get_iter( psModel, &sSelectedIter, psPath ) ) {
		gtk_tree_model_get_value( psModel, &sSelectedIter, 1, &sDateTime );
		gtk_tree_model_get_value( psModel, &sSelectedIter, 5, &sNumber );

		/* Build file name */
		pnFile = g_strdup_printf( "%s_Telefax.%s.pdf", g_value_get_string( &sDateTime ), g_value_get_string( &sNumber ) );
		pnFile[ 8 ] = '_';
		pnFile[ 11 ] = '.';

		Debug( KERN_DEBUG, "open file: [%s]\n", pnFile );
		if ( routerLoadFaxFile( getActiveProfile(), pnFile ) == 0 ) {
			pnStorePath = g_strdup_printf( "%s/ffgtk-%s/fax.pdf", g_get_tmp_dir(), g_get_user_name() );
			if ( pnStorePath != NULL ) {
				osExecute( pnStorePath );
				g_free( pnStorePath );
			}
		}
		
		g_value_unset( &sNumber );
		g_value_unset( &sDateTime );

		g_free( pnFile );
	}
}

/**
 * \brief Fax box delete callback
 * \param psModel tree model
 * \param psPath tree path
 */
void faxBoxDelete( GtkTreeModel *psModel, GtkTreePath *psPath ) {
	GtkTreeIter sSelectedIter;
	GValue sDateTime = { 0 };
	GValue sNumber = { 0 };
	gchar *pnFile = NULL;

	if ( gtk_tree_model_get_iter( psModel, &sSelectedIter, psPath ) ) {
		gtk_tree_model_get_value( psModel, &sSelectedIter, 1, &sDateTime );
		gtk_tree_model_get_value( psModel, &sSelectedIter, 5, &sNumber );

		/* Build file name */
		pnFile = g_strdup_printf( "%s_Telefax.%s.pdf", g_value_get_string( &sDateTime ), g_value_get_string( &sNumber ) );
		pnFile[ 8 ] = '_';
		pnFile[ 11 ] = '.';

		Debug( KERN_DEBUG, "deleting file: [%s]\n", pnFile );

		routerDeleteFaxFile( getActiveProfile(), pnFile );

		g_free( pnFile );

		g_value_unset( &sNumber );
		g_value_unset( &sDateTime );
	}
}
