/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file about-dialog.c
 * \brief About dialog
 */

#include <ffgtk.h>

/**
 * \brief URL Hook - Open url
 * \param psAbout about dialog
 * \param pnUrl website-url
 * \param pData UNUSED
 */
void urlHook( GtkAboutDialog *psAbout, const char *pnUrl, gpointer pData ) {
	Debug( KERN_DEBUG, "URL: %s\n", pnUrl );
	osExecute( pnUrl );
}

/**
 * \brief EMail Hook - Open email application
 * \param psAbout about dialog
 * \param pnMail mail-address
 * \param pData UNUSED
 */
void emailHook( GtkAboutDialog *psAbout, const char *pnMail, gpointer pData ) {
	gchar *pnUri = g_strdup_printf( "mailto:%s", pnMail );

	Debug( KERN_DEBUG, "eMail: %s\n", pnUri );
	osExecute( pnUri );

	g_free( pnUri );
}

static void aboutResponse( GtkWidget *psWidget, gpointer pUserData ) {
	gtk_widget_destroy( psWidget );
}

/**
 * \brief About dialog
 */
void aboutDialog( void ) {
	static GdkPixbuf *psAboutLogo = NULL;
	GtkWidget *psDialog = NULL;;
	const gchar *apnAuthors[] = {
		"Jan-Michael Brummer <jan.brummer@tabos.org>",
		"",
		"Patches by:",
		"Christian von Behren <admin@grizzlysoft.de>",
		"Whoopie",
		"Michael Burkhard",
		"Bastian Kleineidam",
		"Louis Lagendijk",
		"Marco Schuh",
		NULL
	};
	const gchar *apnDocumenters[] = {
		"Jan-Michael Brummer <jan.brummer@tabos.org>",
		NULL
	};
	char *pnTranslators =
		"Jan-Michael Brummer <jan.brummer@tabos.org>\n"
		"Louis Lagendijk";
	char anVersion[ 256 ];

	if ( psAboutLogo == NULL ) {
		gchar *pnAboutFile = g_build_filename( getDirectory( PKGDATADIR ), "ffgtk.png", NULL );
		psAboutLogo = gdk_pixbuf_new_from_file( pnAboutFile, NULL );
		g_free( pnAboutFile );
	}

	snprintf( anVersion, sizeof( anVersion ), "%s\n%s", PACKAGE_VERSION, anSvnRevision );

#ifdef G_OS_WIN32
#if GTK_CHECK_VERSION(3,0,0)
#else
	gtk_about_dialog_set_url_hook( urlHook, NULL, NULL );
	gtk_about_dialog_set_email_hook( emailHook, NULL, NULL );
#endif
#endif

	/* create about dialog */
	psDialog = gtk_about_dialog_new();

	gtk_about_dialog_set_program_name( GTK_ABOUT_DIALOG( psDialog ), PACKAGE_NAME );
	gtk_about_dialog_set_logo( GTK_ABOUT_DIALOG( psDialog ), psAboutLogo );
	//gtk_about_dialog_set_version( GTK_ABOUT_DIALOG( psDialog ), anVersion );
	gtk_about_dialog_set_version( GTK_ABOUT_DIALOG( psDialog ), PACKAGE_VERSION );
	gtk_about_dialog_set_copyright( GTK_ABOUT_DIALOG( psDialog ), "(C) 2008-2012, Jan-Michael Brummer <jan.brummer@tabos.org>" );
	gtk_about_dialog_set_comments( GTK_ABOUT_DIALOG( psDialog ), _( "FRITZ!Box Fax-Software and Call-Monitor\nDedicated to my father" ) );
	gtk_about_dialog_set_license( GTK_ABOUT_DIALOG( psDialog ), _( "This program is free software; you can redistribute it and/or modify it under the terms of the GNU "
	        "General Public License Version 2 as published by the Free Software Foundation\n\n"
			"This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; "
	        "without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. "
	        "See the GNU General Public License for more details.\n\n"
			"You should have received a copy of the GNU General Public License along with this program; "
	        "if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, "
	        "MA 02110-1301, USA" ) );
	gtk_about_dialog_set_wrap_license( GTK_ABOUT_DIALOG( psDialog ), TRUE );
	gtk_about_dialog_set_authors( GTK_ABOUT_DIALOG( psDialog ), apnAuthors );
	gtk_about_dialog_set_documenters( GTK_ABOUT_DIALOG( psDialog ), apnDocumenters );
	gtk_about_dialog_set_translator_credits( GTK_ABOUT_DIALOG( psDialog ), g_locale_to_utf8( pnTranslators, -1, 0, 0, 0 ) );
	gtk_about_dialog_set_website( GTK_ABOUT_DIALOG( psDialog ), PACKAGE_BUGREPORT );
	g_signal_connect( G_OBJECT( psDialog ), "response", G_CALLBACK( aboutResponse ), psDialog );

	gtk_window_set_position( GTK_WINDOW( psDialog ), GTK_WIN_POS_CENTER );
	gtk_dialog_run( GTK_DIALOG( psDialog ) );
}
