*           rr_diff_umetric.F
*
*           Rick Romea
*           Jan. 24, 2000
*
*     Computes the zonal momentum diffusive metric term  
*     Units :     cm/s/s
*     MOM2 Grid:  U   
*
*******************************************************************

      SUBROUTINE RR_diff_umetric_init(id)
	IMPLICIT NONE
      INCLUDE 'ferret_cmn/EF_Util.cmn'
      INTEGER id

      CALL ef_set_desc             (id,
     .'Zonal momentum diffusive metric (cm/s^2); MOM2 U Grid')
      CALL ef_set_num_args         (id, 2)
      CALL ef_set_axis_inheritance (id, IMPLIED_BY_ARGS, 
     .                                  IMPLIED_BY_ARGS, 
     .                                  IMPLIED_BY_ARGS, 
     .                                  IMPLIED_BY_ARGS)
      CALL ef_set_piecemeal_ok     (id, NO, NO, YES, YES)

      ! Define first argument (U)

      CALL ef_set_arg_name         (id, ARG1, 'U')
      CALL ef_set_arg_desc         (id, ARG1,
     . 'Zonal velocity, on the MOM2 U Grid. ')
      CALL ef_set_arg_unit         (id, ARG1, 'cm/sec')
      CALL ef_set_arg_type         (id, ARG1, FLOAT_ARG)
      CALL ef_set_axis_influence   (id, ARG1, YES, YES, YES, YES)

      ! Define second argument (V)

      CALL ef_set_arg_name         (id, ARG2, 'V')
      CALL ef_set_arg_desc         (id, ARG2,
     . 'Meridional velocity, on the MOM2 U Grid. ')
      CALL ef_set_arg_unit         (id, ARG2, 'cm/sec')
      CALL ef_set_arg_type         (id, ARG2, FLOAT_ARG)
      CALL ef_set_axis_influence   (id, ARG2,YES,YES,YES,YES)
      CALL ef_set_axis_extend      (id, ARG2, X_AXIS,-1,+1)
      END


      SUBROUTINE RR_diff_umetric_compute(id, arg_1, arg_2, result)
	IMPLICIT NONE
      INCLUDE 'ferret_cmn/EF_Util.cmn'
      INCLUDE 'ferret_cmn/EF_mem_subsc.cmn'

      INTEGER        id

      REAL           bad_flag(EF_MAX_ARGS)
      REAL           bad_flag_result

      REAL           arg_1 (mem1lox:mem1hix, mem1loy:mem1hiy, 
     .                      mem1loz:mem1hiz, mem1lot:mem1hit)
      REAL           arg_2 (mem2lox:mem2hix, mem2loy:mem2hiy, 
     .                      mem2loz:mem2hiz, mem2lot:mem2hit)
      REAL           result (memreslox:memreshix,memresloy:memreshiy,
     .                       memresloz:memreshiz,memreslot:memreshit)

      INTEGER        res_lo_ss (4)
      INTEGER        res_hi_ss (4)
      INTEGER        res_incr  (4)

      INTEGER        arg_lo_ss (4,EF_MAX_ARGS)
      INTEGER        arg_hi_ss (4,EF_MAX_ARGS)
      INTEGER        arg_incr  (4,EF_MAX_ARGS)

      INTEGER        i,  j,  k,  l
      INTEGER        i1, j1, k1, l1
      INTEGER        i2, j2, k2, l2

      INTEGER        ilat,iLon
      CHARACTER *16  ax_name(4)
      CHARACTER *16  ax_units(4)
      LOGICAL        backward(4)
      LOGICAL        modulo(4)
      LOGICAL        regular(4)

      REAL dxt, dxmetr,csu,sine,tng,am3,am4,a3,a4

      REAL*8         xU(1024)
      REAL*8         yU(1024)

      INCLUDE 'rr_parameters.h'

C**********************************************************

c MOM2 CODE:

c     csu     = cosine of "u" grid point latitude
c     dxt     = longitudinal width of "t" grid box at the equator (cm)
c     amix    = am

c      DIFF_metric(i,k,j,n) = am3(j)*u(i,k,j,n) + am4(j,n)*dxmetr(i)
c     &                    *(u(i+1,k,j,3-n) - u(i-1,k,j,3-n))

c      am3(j)   =  amix*(1-tng(j)*tng(j))/(radius**2)
c      am4(j,1) = -amix*2*sine(j)/(radius*csu(j)*csu(j))
c      am4(j,2) = -am4(j,1)
     
c      tng(j)   = sine(j)/csu(j)
c      sine(j)  = sin(phi(j))
c      dxmetr(i) = 1 / (dxt(i) + dxt(i+1))

C***************************************************


      dxt(iLon)    = SNGL(xU(iLon)-xU(iLon-1))*Longitude_to_cm
      dxmetr(iLon) = 1. / (dxt(iLon) + dxt(iLon+1))

      csu(iLat)  = cos(SNGL(yU(iLat)) * Degrees_to_radians) 
      sine(iLat) = sin(SNGL(yU(iLat)) * Degrees_to_radians)
      tng(iLat)  = sine(iLat)/csu(iLat)
      am3(iLat)  =  am*(1-tng(iLat)*tng(iLat))/(RR_radius**2)
      am4(iLat)  = -am*2.*sine(iLat)/(RR_radius*csu(iLat)*csu(iLat))

      ! Get axis data

      CALL ef_get_res_subscripts (id, res_lo_ss, res_hi_ss, res_incr)
      CALL ef_get_arg_subscripts (id, arg_lo_ss, arg_hi_ss, arg_incr)
      CALL ef_get_bad_flags      (id, bad_flag,  bad_flag_result)
      CALL ef_get_coordinates    (id, ARG1, X_AXIS, 
     .                            arg_lo_ss(X_AXIS,ARG1),
     .                            arg_hi_ss(X_AXIS,ARG1), xU)
      CALL ef_get_coordinates    (id, ARG1, Y_AXIS, 
     .                            arg_lo_ss(Y_AXIS,ARG1),
     .                            arg_hi_ss(Y_AXIS,ARG1), YU)

      ! Check axis units:  bail out if not lat and lon.

      CALL ef_get_axis_info  (id, ARG1, ax_name, ax_units, 
     .                                backward, modulo, regular) 
      IF     ( ax_units(1) .NE. 'deg'       .AND.
     .         ax_units(1) .NE. 'degrees_E'       .AND.
     .         ax_units(1) .NE. 'longitude' .AND.
     .         ax_units(1) .NE. 'Longitude' .AND. 
     .         ax_units(1) .NE. 'LONGITUDE' ) THEN
        WRITE (6,*)'Longitude axis units =', ax_units(1) 
        !CALL ef_bail_out(id,'Longitude axis must be in degrees')
      ENDIF

      IF     ( ax_units(2) .NE. 'deg'       .AND.
     .         ax_units(2) .NE. 'degrees_N'       .AND.
     .         ax_units(2) .NE. 'latitude'  .AND.
     .         ax_units(2) .NE. 'Latitude'  .AND. 
     .         ax_units(2) .NE. 'LATITUDE' ) THEN
        WRITE (6,*)'Latitude axis units =', ax_units(2) 
        !CALL ef_bail_out(id,'Latitude axis must be in degrees')
      ENDIF

      l1 = arg_lo_ss(T_AXIS,ARG1) 
      l2 = arg_lo_ss(T_AXIS,ARG2) 
      DO l = res_lo_ss(T_AXIS), res_hi_ss(T_AXIS)
         
         k1 = arg_lo_ss(Z_AXIS,ARG1)
         k2 = arg_lo_ss(Z_AXIS,ARG2)
         DO k = res_lo_ss(Z_AXIS), res_hi_ss(Z_AXIS)

            ilat = 1  
            j1 = arg_lo_ss(Y_AXIS,ARG1)
            j2 = arg_lo_ss(Y_AXIS,ARG2)
            DO j = res_lo_ss(Y_AXIS), res_hi_ss(Y_AXIS)
               
               a3 = am3(iLat)
               a4 = am4(iLat)

               iLon = 1
               i1 = arg_lo_ss(X_AXIS,ARG1)
               i2 = arg_lo_ss(X_AXIS,ARG2)
               DO i = res_lo_ss(X_AXIS), res_hi_ss(X_AXIS)

                  IF (arg_1(i1,  j1,k1,l1) .EQ. bad_flag(ARG1) .OR.
     .                arg_2(i2+1,j2,k2,l2) .EQ. bad_flag(ARG2) .OR.
     .                arg_2(i2-1,j2,k2,l2) .EQ. bad_flag(ARG2) .OR.
     .                arg_2(i2,  j2,k2,l2) .EQ. bad_flag(ARG2) )THEN
                     result(i,j,k,l) = bad_flag_result
                  ELSE
                     result(i,j,k,l) = ( 
     .                    a3*arg_1(i1,j1,k1,l1)
     .                  + a4*dxmetr(iLon)
     .                     *(arg_2(i2+1,j2,k2,l2)-
     .                       arg_2(i2-1,j2,k2,l2)) 
     .                              ) * sec_per_month
                  ENDIF

                  iLon = iLon + 1
                  i1 = i1 + arg_incr(X_AXIS,ARG1)
                  i2 = i2 + arg_incr(X_AXIS,ARG2)
               ENDDO

               iLat = iLat + 1
               j1 = j1 + arg_incr(Y_AXIS,ARG1)
               j2 = j2 + arg_incr(Y_AXIS,ARG2)
            ENDDO               

            k1 = k1 + arg_incr(Z_AXIS,ARG1)
            k2 = k2 + arg_incr(Z_AXIS,ARG2)
         ENDDO

         l1 = l1 + arg_incr(T_AXIS,ARG1)
         l2 = l2 + arg_incr(T_AXIS,ARG2)
      ENDDO

      END











